/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.util.Err;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class ObjectWriter
extends Thread {
    private InputStream inputStream;
    private PipedOutputStream outputStream;
    private int size = 0;
    private int lastOffset;
    private LinkedList<byte[]> buffer;
    private int buffSize = 1024;

    public ObjectWriter(Object obj) throws IOException {
        Writer writer = new Writer(obj);
        InputStream is = writer.getInputStream();
        writer.start();
        boolean over = false;
        this.buffer = new LinkedList();
        int space = this.buffSize;
        int writeOffset = 0;
        byte[] lastBuff = new byte[this.buffSize];
        while (!over) {
            int read = is.read(lastBuff, writeOffset, space);
            if (read == -1) {
                this.lastOffset = writeOffset;
                this.buffer.addLast(lastBuff);
                over = true;
                continue;
            }
            this.size += read;
            if ((space -= read) == 0) {
                this.buffer.addLast(lastBuff);
                space = this.buffSize;
                writeOffset = 0;
                lastBuff = new byte[this.buffSize];
                continue;
            }
            writeOffset += read;
        }
        this.outputStream = new PipedOutputStream();
        this.inputStream = new PipedInputStream(this.outputStream);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void run() {
        try {
            Iterator buffIter = this.buffer.iterator();
            while (buffIter.hasNext()) {
                byte[] currentBuff = (byte[])buffIter.next();
                if (buffIter.hasNext()) {
                    this.outputStream.write(currentBuff, 0, this.buffSize);
                    continue;
                }
                this.outputStream.write(currentBuff, 0, this.lastOffset);
            }
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.toString());
        }
    }

    private class Writer
    extends Thread {
        private Object _object;
        private InputStream _inputStream;
        private PipedOutputStream _outputStream;

        public Writer(Object _obj) {
            this._object = _obj;
            this._outputStream = new PipedOutputStream();
            try {
                this._inputStream = new PipedInputStream(this._outputStream);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(Err.getPrintWriter());
            }
        }

        public InputStream getInputStream() {
            return this._inputStream;
        }

        @Override
        public void run() {
            try {
                ObjectOutputStream _oos = new ObjectOutputStream(this._outputStream);
                _oos.writeObject(this._object);
                _oos.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace(Err.getPrintWriter());
            }
        }
    }
}

