/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.creole.AbstractResource;
import gate.creole.Plugin;
import java.beans.Introspector;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GateClassLoader
extends URLClassLoader {
    protected static final Logger log = Logger.getLogger(GateClassLoader.class);
    private static final boolean DEBUG = false;
    private String id = null;
    private boolean isolated = false;
    Map<String, GateClassLoader> childClassLoaders = new LinkedHashMap<String, GateClassLoader>();

    public GateClassLoader(String name) {
        super(new URL[0]);
        this.id = name;
    }

    public GateClassLoader(String name, ClassLoader parent) {
        super(new URL[0], parent);
        this.id = name;
    }

    public GateClassLoader(String name, URL[] urls) {
        super(urls);
        this.id = name;
    }

    public GateClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.id = name;
    }

    public GateClassLoader(String name, URL[] urls, ClassLoader parent, boolean isolated) {
        super(urls, parent);
        this.id = name;
        this.isolated = isolated;
    }

    public String getID() {
        return this.id;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public String toString() {
        return "Classloader ID: " + this.id;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        LinkedHashSet<GateClassLoader> children;
        URL result = null;
        result = super.getResource(name);
        if (result != null) {
            return result;
        }
        if (this.getParent() == null) {
            result = Gate.getClassLoader().findResource(name);
            if (result != null) {
                return result;
            }
            result = Gate.getClassLoader().getParent().getResource(name);
            if (result != null) {
                return result;
            }
        }
        Map<String, GateClassLoader> map = this.childClassLoaders;
        synchronized (map) {
            children = new LinkedHashSet<GateClassLoader>(this.childClassLoaders.values());
        }
        for (GateClassLoader cl : children) {
            if (cl.isIsolated() || (result = cl.getResource(name)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false, false, new HashSet<GateClassLoader>());
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false, new HashSet<GateClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String name, boolean resolve, boolean localOnly, Set<GateClassLoader> visited) throws ClassNotFoundException {
        Class<?> previous = this.findLoadedClass(name);
        if (previous != null) {
            return previous;
        }
        visited.add(this);
        if (!this.equals(Gate.getClassLoader())) {
            try {
                Class<?> found2 = Gate.getClassLoader().getParent().loadClass(name);
                URL url = this.findResource(name.replace('.', '/') + ".class");
                if (url != null) {
                    log.warn((Object)(name + " is available via both the system classpath and a plugin; the plugin (" + this.getID() + ") classes will be ignored"));
                }
                return found2;
            }
            catch (ClassNotFoundException found2) {
                // empty catch block
            }
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException found2) {
            if (this.getParent() != null && this.getParent() instanceof GateClassLoader) {
                visited.add((GateClassLoader)this.getParent());
            }
            if (!localOnly) {
                LinkedHashSet<GateClassLoader> children;
                if (this.getParent() == null) {
                    try {
                        return Gate.getClassLoader().loadClass(name, resolve, false, visited);
                    }
                    catch (ClassNotFoundException found2) {
                        // empty catch block
                    }
                }
                Map<String, GateClassLoader> map = this.childClassLoaders;
                synchronized (map) {
                    children = new LinkedHashSet<GateClassLoader>(this.childClassLoaders.values());
                }
                children.removeAll(visited);
                for (GateClassLoader cl : children) {
                    try {
                        if (cl.isIsolated()) continue;
                        return cl.loadClass(name, resolve, true, visited);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    public Class<?> defineGateClass(String name, byte[] bytes, int offset, int len) {
        return super.defineClass(name, bytes, offset, len);
    }

    public void resolveGateClass(Class<?> c) {
        super.resolveClass(c);
    }

    public Class<?> findExistingClass(String name) {
        return this.findLoadedClass(name);
    }

    public GateClassLoader getDisposableClassLoader(String id) {
        return this.getDisposableClassLoader(id, null, false);
    }

    public GateClassLoader getDisposableClassLoader(String id, boolean isolated) {
        return this.getDisposableClassLoader(id, null, isolated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GateClassLoader getDisposableClassLoader(String id, ClassLoader parent, boolean isolated) {
        GateClassLoader gcl = null;
        Map<String, GateClassLoader> map = this.childClassLoaders;
        synchronized (map) {
            gcl = this.childClassLoaders.get(id);
            if (gcl == null) {
                gcl = new GateClassLoader(id, new URL[0], parent, isolated);
                this.childClassLoaders.put(id, gcl);
            }
        }
        return gcl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetClassLoader(String id) {
        GateClassLoader gcl;
        Map<String, GateClassLoader> map = this.childClassLoaders;
        synchronized (map) {
            gcl = this.childClassLoaders.remove(id);
        }
        if (gcl != null && !gcl.isIsolated()) {
            Introspector.flushCaches();
            AbstractResource.flushBeanInfoCache();
        }
    }

    public void forgetClassLoader(GateClassLoader classloader) {
        if (classloader != null) {
            this.forgetClassLoader(classloader.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetClassLoader(String id, Plugin dInfo) {
        if (dInfo == null) {
            this.forgetClassLoader(id);
            return;
        }
        GateClassLoader classloader = null;
        Map<String, GateClassLoader> map = this.childClassLoaders;
        synchronized (map) {
            classloader = this.childClassLoaders.remove(id);
        }
        if (classloader != null && !classloader.isIsolated()) {
            for (Gate.ResourceInfo rInfo : dInfo.getResourceInfoList()) {
                try {
                    Class<?> c = classloader.loadClass(rInfo.getResourceClassName());
                    if (c == null) continue;
                    Introspector.flushFromCaches(c);
                    AbstractResource.forgetBeanInfo(c);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String resource) throws IOException {
        LinkedHashSet<GateClassLoader> children;
        if (this.childClassLoaders.isEmpty()) {
            return super.getResources(resource);
        }
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        urls.addAll(Collections.list(super.getResources(resource)));
        Map<String, GateClassLoader> map = this.childClassLoaders;
        synchronized (map) {
            children = new LinkedHashSet<GateClassLoader>(this.childClassLoaders.values());
        }
        for (GateClassLoader cl : children) {
            if (cl.isIsolated()) continue;
            urls.addAll(Collections.list(cl.getResources(resource)));
        }
        return Collections.enumeration(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GateClassLoader> getChildren() {
        Map<String, GateClassLoader> map = this.childClassLoaders;
        synchronized (map) {
            return new ArrayList<GateClassLoader>(this.childClassLoaders.values());
        }
    }
}

