/*
 * Decompiled with CFR 0.152.
 */
package gate.resources.img.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class RemoveIcon
implements Icon {
    int width;
    int height;
    boolean disabled = false;

    private static Color getColor(int red, int green, int blue, int alpha, boolean disabled) {
        if (!disabled) {
            return new Color(red, green, blue, alpha);
        }
        int gray = (int)((0.3f * (float)red + 0.59f * (float)green + 0.11f * (float)blue) / 3.0f);
        gray = Math.min(255, Math.max(0, gray));
        int percent = 50;
        gray = 255 - (255 - gray) * (100 - percent) / 100;
        return new Color(gray, gray, gray, alpha);
    }

    public static void paint(Graphics2D g, boolean disabled) {
        AlphaComposite origAlphaComposite;
        GeneralPath shape = null;
        Paint paint = null;
        BasicStroke stroke = null;
        Area clip = null;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        Shape clip_ = g.getClip();
        AffineTransform defaultTransform_ = g.getTransform();
        float alpha__0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0 = g.getClip();
        AffineTransform defaultTransform__0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        clip = new Area(g.getClip());
        clip.intersect(new Area(new Rectangle2D.Double(0.0, 0.0, 48.0, 48.0)));
        g.setClip(clip);
        float alpha__0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0 = g.getClip();
        AffineTransform defaultTransform__0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        float alpha__0_0_0 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 1.0f));
        Shape clip__0_0_0 = g.getClip();
        AffineTransform defaultTransform__0_0_0 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = RemoveIcon.getColor(117, 161, 208, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(27.514357, 28.359472);
        shape.lineTo(39.633446, 28.475542);
        shape.lineTo(39.633446, 21.480219);
        shape.lineTo(27.523285, 21.480219);
        shape.lineTo(20.502546, 21.462362);
        shape.lineTo(8.54417, 21.489147);
        shape.lineTo(8.508456, 28.457685);
        shape.lineTo(20.511475, 28.475542);
        shape.lineTo(27.514357, 28.359472);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = RemoveIcon.getColor(52, 101, 164, 255, disabled);
        stroke = new BasicStroke(1.0000004f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(27.514357, 28.359472);
        shape.lineTo(39.633446, 28.475542);
        shape.lineTo(39.633446, 21.480219);
        shape.lineTo(27.523285, 21.480219);
        shape.lineTo(20.502546, 21.462362);
        shape.lineTo(8.54417, 21.489147);
        shape.lineTo(8.508456, 28.457685);
        shape.lineTo(20.511475, 28.475542);
        shape.lineTo(27.514357, 28.359472);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_0;
        g.setTransform(defaultTransform__0_0_0);
        g.setClip(clip__0_0_0);
        float alpha__0_0_1 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.40860215f));
        Shape clip__0_0_1 = g.getClip();
        AffineTransform defaultTransform__0_0_1 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = new LinearGradientPaint(new Point2D.Double(34.89284896850586, 36.42298889160156), new Point2D.Double(45.918697357177734, 48.54798889160156), new float[]{0.0f, 1.0f}, new Color[]{RemoveIcon.getColor(114, 159, 207, 255, disabled), RemoveIcon.getColor(81, 135, 214, 255, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -18.01785f, -13.57119f));
        shape = new GeneralPath();
        shape.moveTo(38.57943, 27.484114);
        shape.lineTo(38.588356, 22.47531);
        shape.lineTo(9.526787, 22.493166);
        shape.lineTo(9.5, 27.466255);
        shape.lineTo(38.57943, 27.484114);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        paint = new LinearGradientPaint(new Point2D.Double(16.874998092651367, 22.85179901123047), new Point2D.Double(27.900846481323242, 34.9768f), new float[]{0.0f, 1.0f}, new Color[]{RemoveIcon.getColor(255, 255, 255, 255, disabled), RemoveIcon.getColor(255, 255, 255, 87, disabled)}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        stroke = new BasicStroke(1.0000006f, 0, 0, 4.0f, null, 0.0f);
        shape = new GeneralPath();
        shape.moveTo(38.57943, 27.484114);
        shape.lineTo(38.588356, 22.47531);
        shape.lineTo(9.526787, 22.493166);
        shape.lineTo(9.5, 27.466255);
        shape.lineTo(38.57943, 27.484114);
        shape.closePath();
        g.setPaint(paint);
        g.setStroke(stroke);
        g.draw(shape);
        origAlpha = alpha__0_0_1;
        g.setTransform(defaultTransform__0_0_1);
        g.setClip(clip__0_0_1);
        float alpha__0_0_2 = origAlpha;
        g.setComposite(AlphaComposite.getInstance(3, origAlpha *= 0.31182796f));
        Shape clip__0_0_2 = g.getClip();
        AffineTransform defaultTransform__0_0_2 = g.getTransform();
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        paint = RemoveIcon.getColor(255, 255, 255, 255, disabled);
        shape = new GeneralPath();
        shape.moveTo(9.0, 25.0);
        shape.curveTo(9.0, 26.9375, 39.125, 24.0625, 39.125, 25.0);
        shape.lineTo(39.125, 22.0);
        shape.lineTo(9.0, 22.0);
        shape.lineTo(9.0, 25.0);
        shape.closePath();
        g.setPaint(paint);
        g.fill(shape);
        origAlpha = alpha__0_0_2;
        g.setTransform(defaultTransform__0_0_2);
        g.setClip(clip__0_0_2);
        origAlpha = alpha__0_0;
        g.setTransform(defaultTransform__0_0);
        g.setClip(clip__0_0);
        origAlpha = alpha__0;
        g.setTransform(defaultTransform__0);
        g.setClip(clip__0);
        g.setTransform(defaultTransform_);
        g.setClip(clip_);
    }

    public Image getImage() {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static int getOrigX() {
        return 9;
    }

    public static int getOrigY() {
        return 21;
    }

    public static int getOrigWidth() {
        return 48;
    }

    public static int getOrigHeight() {
        return 48;
    }

    public RemoveIcon() {
        this(RemoveIcon.getOrigWidth(), RemoveIcon.getOrigHeight(), false);
    }

    public RemoveIcon(boolean disabled) {
        this(RemoveIcon.getOrigWidth(), RemoveIcon.getOrigHeight(), disabled);
    }

    public RemoveIcon(Dimension size) {
        this(size.width, size.height, false);
    }

    public RemoveIcon(Dimension size, boolean disabled) {
        this(size.width, size.height, disabled);
    }

    public RemoveIcon(int width, int height) {
        this(width, height, false);
    }

    public RemoveIcon(int width, int height, boolean disabled) {
        this.width = width;
        this.height = height;
        this.disabled = disabled;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.translate(x, y);
        Area clip = new Area(new Rectangle(0, 0, this.width, this.height));
        if (g2d.getClip() != null) {
            clip.intersect(new Area(g2d.getClip()));
        }
        g2d.setClip(clip);
        double coef1 = (double)this.width / (double)RemoveIcon.getOrigWidth();
        double coef2 = (double)this.height / (double)RemoveIcon.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.scale(coef, coef);
        RemoveIcon.paint(g2d, this.disabled);
        g2d.dispose();
    }
}

