/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.gui.ParameterDisjunction;
import gate.gui.ResourceParametersEditor;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

@CreoleResource(name="Initialisation Parameters", guiType=GuiType.LARGE, resourceDisplayed="gate.Resource", mainViewer=true)
public class PRViewer
extends AbstractVisualResource {
    protected ResourceParametersEditor editor;

    @Override
    public Resource init() throws ResourceInstantiationException {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        return this;
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        this.setLayout(new BorderLayout());
        this.editor = new ResourceParametersEditor();
        this.editor.setEditable(false);
        this.editor.setAutoResizeMode(3);
        JScrollPane scroller = new JScrollPane(this.editor);
        scroller.setAlignmentX(0.0f);
        scroller.setAlignmentY(0.0f);
        this.add((Component)scroller, "Center");
    }

    protected void initListeners() {
        this.editor.addMouseListener(new MouseAdapter(){

            private void handleMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = PRViewer.this.editor.rowAtPoint(e.getPoint());
                    int col = PRViewer.this.editor.columnAtPoint(e.getPoint());
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new CopyValueAction(row, col));
                    popup.show(PRViewer.this.editor, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.handleMouseEvent(e);
            }
        });
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.editor.cleanup();
    }

    @Override
    public void setTarget(Object target) {
        if (target == null) {
            return;
        }
        if (!(target instanceof Resource)) {
            throw new GateRuntimeException(this.getClass().getName() + " can only be used to display " + Resource.class.getName() + "\n" + target.getClass().getName() + " is not a " + Resource.class.getName() + "!");
        }
        Resource pr = (Resource)target;
        ResourceData rData = (ResourceData)Gate.getCreoleRegister().get(pr.getClass().getName());
        if (rData != null) {
            this.editor.init(pr, rData.getParameterList().getInitimeParameters());
        } else {
            this.editor.init(pr, null);
        }
        this.editor.removeCreoleListenerLink();
    }

    protected class CopyValueAction
    extends AbstractAction {
        private int row;
        private int column;

        public CopyValueAction(int row, int column) {
            super("Copy value");
            this.putValue("ShortDescription", "Copies the value of the cell to the clipboard.");
            this.row = row;
            this.column = column;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object value = PRViewer.this.editor.getValueAt(this.row, this.column);
            String valStr = value instanceof ParameterDisjunction ? ((ParameterDisjunction)value).getName() : (value instanceof Boolean ? ((Boolean)value != false ? "Required parameter" : "Optional parameter") : value.toString());
            StringSelection data = new StringSelection(valStr);
            clipboard.setContents(data, data);
        }
    }
}

