/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.corpora.SerialCorpusImpl;
import gate.creole.AbstractVisualResource;
import gate.creole.annic.Hit;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.Searcher;
import gate.creole.annic.lucene.QueryParser;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.AnnotationSetsView;
import gate.gui.docview.AnnotationStack;
import gate.gui.docview.TextualDocumentView;
import gate.persist.LuceneDataStoreImpl;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.swing.BlockingGlassPane;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.ExtensionFileFilter;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

@CreoleResource(name="Lucene Datastore Searcher", guiType=GuiType.LARGE, resourceDisplayed="gate.creole.annic.SearchableDataStore", comment="GUI allowing to write a query with a JAPE derived syntax for querying\n a Lucene Datastore and display the results with a stacked view of the\n annotations and their values.", helpURL="http://gate.ac.uk/userguide/chap:annic")
public class LuceneDataStoreSearchGUI
extends AbstractVisualResource
implements DatastoreListener {
    private Object target;
    private List<Hit> results;
    private Map<String, List<String>> allAnnotTypesAndFeaturesFromDatastore;
    private Map<String, Set<String>> populatedAnnotationTypesAndFeatures;
    private XJTable resultTable;
    private ResultTableModel resultTableModel;
    private JButton configureStackViewButton;
    private XJTable globalStatisticsTable;
    private XJTable oneRowStatisticsTable;
    private Comparator<Integer> integerComparator;
    private Collator stringCollator;
    private JSplitPane bottomSplitPane;
    private JTabbedPane statisticsTabbedPane;
    private QueryTextArea queryTextArea;
    private JComboBox<String> corpusToSearchIn;
    private JComboBox<String> annotationSetsToSearchIn;
    private List<Object> corpusIds;
    private String[] annotationSetIDsFromDataStore;
    private JSlider numberOfResultsSlider;
    private JSlider contextSizeSlider;
    private JLabel titleResults;
    private JButton nextResults;
    private int pageOfResults;
    int noOfResults;
    private AnnotationStack centerPanel;
    private ExecuteQueryAction executeQueryAction;
    private NextResultsAction nextResultsAction;
    private ExportResultsAction exportResultsAction;
    private ConfigureStackViewFrame configureStackViewFrame;
    String[] columnNames = new String[]{"Display", "Shortcut", "Annotation type", "Feature", "Crop"};
    private static final int DISPLAY = 0;
    private static final int SHORTCUT = 1;
    private static final int ANNOTATION_TYPE = 2;
    private static final int FEATURE = 3;
    private static final int CROP = 4;
    private static final int maxStackRows = 100;
    private int numStackRows = 0;
    private String[][] stackRows = new String[101][this.columnNames.length];
    private ConfigureStackViewTableModel configureStackViewTableModel;
    private DefaultTableModel oneRowStatisticsTableModel;
    private DefaultTableModel globalStatisticsTableModel;
    private Vector<String> oneRowStatisticsTableToolTips;
    private Searcher searcher;
    private boolean errorOnLastQuery;

    @Override
    public Resource init() {
        this.results = new ArrayList<Hit>();
        this.allAnnotTypesAndFeaturesFromDatastore = new HashMap<String, List<String>>();
        this.corpusIds = new ArrayList<Object>();
        this.populatedAnnotationTypesAndFeatures = new HashMap<String, Set<String>>();
        this.noOfResults = 0;
        for (int row = 0; row <= 100; ++row) {
            this.stackRows[row][0] = "true";
            this.stackRows[row][1] = "";
            this.stackRows[row][2] = "";
            this.stackRows[row][3] = "";
            this.stackRows[row][4] = "Crop end";
        }
        String prefix = LuceneDataStoreSearchGUI.class.getName() + ".";
        if (Gate.getUserConfig().containsKey(prefix + "rows")) {
            Map<String, String> map = Gate.getUserConfig().getMap(prefix + "rows");
            for (int row = 0; row < 100 && map.containsKey(this.columnNames[0] + '_' + row); ++row) {
                for (int col = 0; col < this.columnNames.length; ++col) {
                    this.stackRows[row][col] = map.get(this.columnNames[col] + '_' + row);
                }
                ++this.numStackRows;
            }
        }
        this.initGui();
        this.updateViews();
        this.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
            }
        });
        return this;
    }

    @Override
    public void cleanup() {
        this.configureStackViewFrame.dispose();
    }

    protected void initGui() {
        this.setLayout(new BorderLayout());
        this.stringCollator = Collator.getInstance();
        this.stringCollator.setStrength(2);
        Comparator<String> lastWordComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return LuceneDataStoreSearchGUI.this.stringCollator.compare(o1.substring(o1.trim().lastIndexOf(32) + 1), o2.substring(o2.trim().lastIndexOf(32) + 1));
            }
        };
        this.integerComparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.compareTo(o2);
            }
        };
        this.configureStackViewFrame = new ConfigureStackViewFrame("Stack view configuration");
        this.configureStackViewFrame.setIconImage(((ImageIcon)MainFrame.getIcon("WindowNew")).getImage());
        this.configureStackViewFrame.setLocationRelativeTo(this);
        this.configureStackViewFrame.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "close row manager");
        this.configureStackViewFrame.getRootPane().getActionMap().put("close row manager", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(false);
            }
        });
        this.configureStackViewFrame.validate();
        this.configureStackViewFrame.setSize(200, 300);
        this.configureStackViewFrame.pack();
        MainFrame.getInstance().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LuceneDataStoreSearchGUI.this.configureStackViewFrame.dispose();
            }
        });
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setOpaque(false);
        topPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 3));
        GridBagConstraints gbc = new GridBagConstraints();
        this.queryTextArea = new QueryTextArea();
        this.queryTextArea.setToolTipText("<html>Enter a query to search the datastore.<br><small>'{' or '.' activate auto-completion.<br>Ctrl+Enter add a new line.</small></html>");
        this.queryTextArea.setLineWrap(true);
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 4);
        topPanel.add((Component)new JScrollPane(this.queryTextArea), gbc);
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = -1;
        topPanel.add((Component)new JLabel("Corpus: "), gbc);
        this.corpusToSearchIn = new JComboBox();
        this.corpusToSearchIn.addItem("Entire datastore");
        this.corpusToSearchIn.setPrototypeDisplayValue("Entire datastore");
        this.corpusToSearchIn.setToolTipText("Select the corpus to search in.");
        if (this.target == null || this.target instanceof Searcher) {
            this.corpusToSearchIn.setEnabled(false);
        }
        this.corpusToSearchIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ie) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LuceneDataStoreSearchGUI.this.updateAnnotationSetsList();
                    }
                });
            }
        });
        topPanel.add(this.corpusToSearchIn, gbc);
        topPanel.add(Box.createHorizontalStrut(4), gbc);
        topPanel.add((Component)new JLabel("Annotation set: "), gbc);
        this.annotationSetsToSearchIn = new JComboBox();
        this.annotationSetsToSearchIn.setPrototypeDisplayValue("Combined sets");
        this.annotationSetsToSearchIn.setToolTipText("Select the annotation set to search in.");
        this.annotationSetsToSearchIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ie) {
                LuceneDataStoreSearchGUI.this.updateAnnotationTypesList();
            }
        });
        topPanel.add(this.annotationSetsToSearchIn, gbc);
        topPanel.add(Box.createHorizontalStrut(4), gbc);
        RefreshAnnotationSetsAndFeaturesAction refreshAction = new RefreshAnnotationSetsAndFeaturesAction();
        ButtonBorder refreshTF = new ButtonBorder(new Color(240, 240, 240), new Insets(4, 2, 4, 3), false);
        refreshTF.setAction(refreshAction);
        topPanel.add((Component)refreshTF, gbc);
        gbc.gridy = 1;
        JLabel noOfResultsLabel = new JLabel("Results: ");
        topPanel.add((Component)noOfResultsLabel, gbc);
        this.numberOfResultsSlider = new JSlider(1, 1100, 50);
        this.numberOfResultsSlider.setToolTipText("50 results per page");
        this.numberOfResultsSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() > LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getMaximum() - 100) {
                    LuceneDataStoreSearchGUI.this.numberOfResultsSlider.setToolTipText("Retrieve all results.");
                    LuceneDataStoreSearchGUI.this.nextResults.setText("Retrieve all results.");
                    LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                } else {
                    LuceneDataStoreSearchGUI.this.numberOfResultsSlider.setToolTipText("Retrieve " + LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() + " results per page.");
                    LuceneDataStoreSearchGUI.this.nextResults.setText("Next page of " + LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() + " results");
                    if (LuceneDataStoreSearchGUI.this.searcher.getHits().length == LuceneDataStoreSearchGUI.this.noOfResults) {
                        LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(true);
                    }
                }
                ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(LuceneDataStoreSearchGUI.this.numberOfResultsSlider, 503, 0L, 0, 0, 0, 0, false));
            }
        });
        this.numberOfResultsSlider.addMouseListener(new MouseAdapter(){
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            int initialDelay;
            int reshowDelay;
            int dismissDelay;
            boolean enabled;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.initialDelay = this.toolTipManager.getInitialDelay();
                this.reshowDelay = this.toolTipManager.getReshowDelay();
                this.dismissDelay = this.toolTipManager.getDismissDelay();
                this.enabled = this.toolTipManager.isEnabled();
                this.toolTipManager.setInitialDelay(0);
                this.toolTipManager.setReshowDelay(0);
                this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
                this.toolTipManager.setEnabled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.toolTipManager.setInitialDelay(this.initialDelay);
                this.toolTipManager.setReshowDelay(this.reshowDelay);
                this.toolTipManager.setDismissDelay(this.dismissDelay);
                this.toolTipManager.setEnabled(this.enabled);
            }
        });
        gbc.insets = new Insets(5, 0, 0, 0);
        topPanel.add((Component)this.numberOfResultsSlider, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        topPanel.add(Box.createHorizontalStrut(4), gbc);
        JLabel contextWindowLabel = new JLabel("Context size: ");
        topPanel.add((Component)contextWindowLabel, gbc);
        this.contextSizeSlider = new JSlider(1, 50, 5);
        this.contextSizeSlider.setToolTipText("Display 5 tokens of context in the results.");
        this.contextSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LuceneDataStoreSearchGUI.this.contextSizeSlider.setToolTipText("Display " + LuceneDataStoreSearchGUI.this.contextSizeSlider.getValue() + " tokens of context in the results.");
                ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(LuceneDataStoreSearchGUI.this.contextSizeSlider, 503, 0L, 0, 0, 0, 0, false));
            }
        });
        this.contextSizeSlider.addMouseListener(new MouseAdapter(){
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            int initialDelay;
            int reshowDelay;
            int dismissDelay;
            boolean enabled;

            @Override
            public void mouseEntered(MouseEvent e) {
                this.initialDelay = this.toolTipManager.getInitialDelay();
                this.reshowDelay = this.toolTipManager.getReshowDelay();
                this.dismissDelay = this.toolTipManager.getDismissDelay();
                this.enabled = this.toolTipManager.isEnabled();
                this.toolTipManager.setInitialDelay(0);
                this.toolTipManager.setReshowDelay(0);
                this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
                this.toolTipManager.setEnabled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.toolTipManager.setInitialDelay(this.initialDelay);
                this.toolTipManager.setReshowDelay(this.reshowDelay);
                this.toolTipManager.setDismissDelay(this.dismissDelay);
                this.toolTipManager.setEnabled(this.enabled);
            }
        });
        gbc.insets = new Insets(5, 0, 0, 0);
        topPanel.add((Component)this.contextSizeSlider, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridy = 2;
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.executeQueryAction = new ExecuteQueryAction();
        ButtonBorder executeQuery = new ButtonBorder(new Color(240, 240, 240), new Insets(0, 2, 0, 3), false);
        executeQuery.setAction(this.executeQueryAction);
        panel.add(executeQuery);
        ClearQueryAction clearQueryAction = new ClearQueryAction();
        ButtonBorder clearQueryTF = new ButtonBorder(new Color(240, 240, 240), new Insets(4, 2, 4, 3), false);
        clearQueryTF.setAction(clearQueryAction);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(clearQueryTF);
        this.nextResultsAction = new NextResultsAction();
        this.nextResultsAction.setEnabled(false);
        this.nextResults = new ButtonBorder(new Color(240, 240, 240), new Insets(0, 0, 0, 3), false);
        this.nextResults.setAction(this.nextResultsAction);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.nextResults);
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        topPanel.add((Component)panel, gbc);
        this.centerPanel = new AnnotationStack(150, 30);
        this.configureStackViewButton = new ButtonBorder(new Color(250, 250, 250), new Insets(0, 0, 0, 3), true);
        this.configureStackViewButton.setHorizontalAlignment(2);
        this.configureStackViewButton.setAction(new ConfigureStackViewAction());
        JPanel bottomLeftPanel = new JPanel(new GridBagLayout());
        bottomLeftPanel.setOpaque(false);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        panel = new JPanel();
        panel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.titleResults = new JLabel("Results");
        this.titleResults.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        panel.add(this.titleResults);
        panel.add(Box.createHorizontalStrut(5), gbc);
        this.exportResultsAction = new ExportResultsAction();
        this.exportResultsAction.setEnabled(false);
        ButtonBorder exportToHTML = new ButtonBorder(new Color(240, 240, 240), new Insets(0, 0, 0, 3), false);
        exportToHTML.setAction(this.exportResultsAction);
        panel.add((Component)exportToHTML, gbc);
        bottomLeftPanel.add((Component)panel, gbc);
        this.resultTableModel = new ResultTableModel();
        this.resultTable = new XJTable(this.resultTableModel);
        this.resultTable.setDefaultRenderer(String.class, new ResultTableCellRenderer());
        this.resultTable.setEnableHidingColumns(true);
        this.resultTable.addMouseListener(new MouseAdapter(){
            private JPopupMenu mousePopup;
            JMenuItem menuItem;

            @Override
            public void mousePressed(MouseEvent e) {
                int row = LuceneDataStoreSearchGUI.this.resultTable.rowAtPoint(e.getPoint());
                if (e.isPopupTrigger() && !LuceneDataStoreSearchGUI.this.resultTable.isRowSelected(row)) {
                    LuceneDataStoreSearchGUI.this.resultTable.getSelectionModel().setSelectionInterval(row, row);
                }
                if (e.isPopupTrigger()) {
                    this.createPopup();
                    this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.createPopup();
                    this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            private void createPopup() {
                this.mousePopup = new JPopupMenu();
                this.menuItem = new JMenuItem("Remove the selected result" + (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRowCount() > 1 ? "s" : ""));
                this.mousePopup.add(this.menuItem);
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int i;
                        int[] rows = LuceneDataStoreSearchGUI.this.resultTable.getSelectedRows();
                        for (i = 0; i < rows.length; ++i) {
                            rows[i] = LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(rows[i]);
                        }
                        Arrays.sort(rows);
                        for (i = rows.length - 1; i >= 0; --i) {
                            LuceneDataStoreSearchGUI.this.results.remove(rows[i]);
                        }
                        LuceneDataStoreSearchGUI.this.resultTable.clearSelection();
                        LuceneDataStoreSearchGUI.this.resultTableModel.fireTableDataChanged();
                        mousePopup.setVisible(false);
                    }
                });
                if (LuceneDataStoreSearchGUI.this.target instanceof LuceneDataStoreImpl && SwingUtilities.getRoot(LuceneDataStoreSearchGUI.this) instanceof MainFrame) {
                    this.menuItem = new JMenuItem("Open the selected document" + (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRowCount() > 1 ? "s" : ""));
                    this.menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            HashSet<gate.creole.annic.Pattern> patterns = new HashSet<gate.creole.annic.Pattern>();
                            HashSet<String> documentIds = new HashSet<String>();
                            for (int rowView : LuceneDataStoreSearchGUI.this.resultTable.getSelectedRows()) {
                                int rowModel = LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(rowView);
                                gate.creole.annic.Pattern pattern = (gate.creole.annic.Pattern)LuceneDataStoreSearchGUI.this.results.get(rowModel);
                                if (documentIds.contains(pattern.getDocumentID())) continue;
                                patterns.add(pattern);
                                documentIds.add(pattern.getDocumentID());
                            }
                            if (patterns.size() > 10) {
                                Object[] possibleValues = new Object[]{"Open the " + patterns.size() + " documents", "Don't open"};
                                int selectedValue = JOptionPane.showOptionDialog(LuceneDataStoreSearchGUI.this, "Do you want to open " + patterns.size() + " documents in the central tabbed pane ?", "Warning", -1, 3, null, possibleValues, possibleValues[1]);
                                if (selectedValue == 1 || selectedValue == -1) {
                                    return;
                                }
                            }
                            Object object = patterns.iterator();
                            while (object.hasNext()) {
                                Document doc;
                                final gate.creole.annic.Pattern pattern = (gate.creole.annic.Pattern)object.next();
                                FeatureMap features = Factory.newFeatureMap();
                                features.put("DataStore", LuceneDataStoreSearchGUI.this.target);
                                features.put("LRPersistenceId", pattern.getDocumentID());
                                try {
                                    doc = (Document)Factory.createResource("gate.corpora.DocumentImpl", features);
                                }
                                catch (GateException e) {
                                    e.printStackTrace();
                                    return;
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MainFrame.getInstance().select(doc);
                                    }
                                });
                                if (patterns.size() != 1) continue;
                                Date timeToRun = new Date(System.currentTimeMillis() + 2000L);
                                Timer timer = new Timer("Annic show document timer", true);
                                timer.schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        LuceneDataStoreSearchGUI.this.showResultInDocument(doc, pattern);
                                    }
                                }, timeToRun);
                            }
                        }
                    });
                    this.mousePopup.add(this.menuItem);
                }
            }
        });
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LuceneDataStoreSearchGUI.this.updateStackView();
                }
            }
        });
        this.resultTable.setColumnSelectionAllowed(false);
        this.resultTable.setRowSelectionAllowed(true);
        this.resultTable.setSortable(true);
        this.resultTable.setComparator(0, lastWordComparator);
        this.resultTable.setComparator(1, this.stringCollator);
        this.resultTable.setComparator(2, this.stringCollator);
        JScrollPane tableScrollPane = new JScrollPane(this.resultTable, 20, 30);
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        bottomLeftPanel.add((Component)tableScrollPane, gbc);
        this.statisticsTabbedPane = new JTabbedPane();
        this.globalStatisticsTable = new XJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.globalStatisticsTableModel = new DefaultTableModel(new Object[]{"Annotation Type", "Count"}, 0);
        this.globalStatisticsTable.setModel(this.globalStatisticsTableModel);
        this.globalStatisticsTable.setComparator(0, this.stringCollator);
        this.globalStatisticsTable.setComparator(1, this.integerComparator);
        this.globalStatisticsTable.setSortedColumn(1);
        this.globalStatisticsTable.setAscending(false);
        this.globalStatisticsTable.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    this.updateQuery();
                }
            }

            private void updateQuery() {
                int caretPosition = LuceneDataStoreSearchGUI.this.queryTextArea.getCaretPosition();
                String query = LuceneDataStoreSearchGUI.this.queryTextArea.getText();
                String type = (String)LuceneDataStoreSearchGUI.this.globalStatisticsTable.getValueAt(LuceneDataStoreSearchGUI.this.globalStatisticsTable.getSelectedRow(), LuceneDataStoreSearchGUI.this.globalStatisticsTable.convertColumnIndexToView(0));
                String queryMiddle = "{" + type + "}";
                String queryLeft = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? query.substring(0, caretPosition) : query.substring(0, LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart());
                String queryRight = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? query.substring(caretPosition, query.length()) : query.substring(LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd(), query.length());
                LuceneDataStoreSearchGUI.this.queryTextArea.setText(queryLeft + queryMiddle + queryRight);
            }
        });
        this.statisticsTabbedPane.addTab("Global", null, new JScrollPane(this.globalStatisticsTable), "Global statistics on the Corpus and Annotation Set selected.");
        this.statisticsTabbedPane.addMouseListener(new MouseAdapter(){
            private JPopupMenu mousePopup;
            JMenuItem menuItem;

            @Override
            public void mousePressed(MouseEvent e) {
                int tabIndex = LuceneDataStoreSearchGUI.this.statisticsTabbedPane.indexAtLocation(e.getX(), e.getY());
                if (e.isPopupTrigger() && tabIndex > 0) {
                    this.createPopup(tabIndex);
                    this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int tabIndex = LuceneDataStoreSearchGUI.this.statisticsTabbedPane.indexAtLocation(e.getX(), e.getY());
                if (e.isPopupTrigger() && tabIndex > 0) {
                    this.createPopup(tabIndex);
                    this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            private void createPopup(final int tabIndex) {
                this.mousePopup = new JPopupMenu();
                if (tabIndex == 1) {
                    this.menuItem = new JMenuItem("Clear table");
                    this.menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ie) {
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.setRowCount(0);
                        }
                    });
                } else {
                    this.menuItem = new JMenuItem("Close tab");
                    this.menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ie) {
                            LuceneDataStoreSearchGUI.this.statisticsTabbedPane.remove(tabIndex);
                        }
                    });
                }
                this.mousePopup.add(this.menuItem);
            }
        });
        this.oneRowStatisticsTable = new XJTable(){

            @Override
            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return vColIndex == 2;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component c = super.prepareRenderer(renderer, row, col);
                if (c instanceof JComponent && col != 2) {
                    ((JComponent)c).setToolTipText("<html>" + (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.get(this.rowViewToModel(row)) + "</html>");
                }
                return c;
            }
        };
        this.oneRowStatisticsTableModel = new DefaultTableModel(new Object[]{"Annotation Type/Feature", "Count", ""}, 0);
        this.oneRowStatisticsTable.setModel(this.oneRowStatisticsTableModel);
        class RemoveCellEditorRenderer
        extends AbstractCellEditor
        implements TableCellRenderer,
        TableCellEditor,
        ActionListener {
            private JButton button = new JButton();

            public RemoveCellEditorRenderer() {
                this.button.setHorizontalAlignment(0);
                this.button.setIcon(MainFrame.getIcon("Delete"));
                this.button.setToolTipText("Remove this row.");
                this.button.setContentAreaFilled(false);
                this.button.setBorderPainted(false);
                this.button.setMargin(new Insets(0, 0, 0, 0));
                this.button.addActionListener(this);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                this.button.setSelected(isSelected);
                return this.button;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int editingRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getEditingRow();
                this.fireEditingStopped();
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.removeRow(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowViewToModel(editingRow));
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                this.button.setSelected(isSelected);
                return this.button;
            }
        }
        this.oneRowStatisticsTable.getColumnModel().getColumn(2).setCellEditor(new RemoveCellEditorRenderer());
        this.oneRowStatisticsTable.getColumnModel().getColumn(2).setCellRenderer(new RemoveCellEditorRenderer());
        this.oneRowStatisticsTable.setComparator(0, this.stringCollator);
        this.oneRowStatisticsTable.setComparator(1, this.integerComparator);
        this.statisticsTabbedPane.addTab("One item", null, new JScrollPane(this.oneRowStatisticsTable), "<html>One item statistics.<br>Right-click on an annotation<br>to add statistics here.");
        this.oneRowStatisticsTableToolTips = new Vector();
        this.bottomSplitPane = new JSplitPane(1);
        Dimension minimumSize = new Dimension(0, 0);
        bottomLeftPanel.setMinimumSize(minimumSize);
        this.statisticsTabbedPane.setMinimumSize(minimumSize);
        this.bottomSplitPane.add(bottomLeftPanel);
        this.bottomSplitPane.add(this.statisticsTabbedPane);
        this.bottomSplitPane.setOneTouchExpandable(true);
        this.bottomSplitPane.setResizeWeight(0.75);
        this.bottomSplitPane.setContinuousLayout(true);
        JSplitPane centerBottomSplitPane = new JSplitPane(0);
        centerBottomSplitPane.add(new JScrollPane(this.centerPanel, 20, 30));
        centerBottomSplitPane.add(this.bottomSplitPane);
        centerBottomSplitPane.setResizeWeight(0.5);
        centerBottomSplitPane.setContinuousLayout(true);
        JSplitPane topBottomSplitPane = new JSplitPane(0);
        topBottomSplitPane.add(topPanel);
        topBottomSplitPane.add(centerBottomSplitPane);
        topBottomSplitPane.setContinuousLayout(true);
        this.add((Component)topBottomSplitPane, "Center");
    }

    private void showResultInDocument(final Document doc, final gate.creole.annic.Pattern result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractDocumentView t = null;
                    for (Resource r : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.TextualDocumentView")) {
                        if (!((TextualDocumentView)r).getDocument().getName().equals(doc.getName())) continue;
                        t = (TextualDocumentView)r;
                        break;
                    }
                    if (t != null && t.getOwner() != null) {
                        t.getOwner().setRightView(0);
                        try {
                            ((TextualDocumentView)t).getTextView().scrollRectToVisible(((TextualDocumentView)t).getTextView().modelToView(result.getRightContextEndOffset()));
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                            return;
                        }
                        ((TextualDocumentView)t).getTextView().select(result.getLeftContextStartOffset(), result.getRightContextEndOffset());
                        ((TextualDocumentView)t).getTextView().requestFocus();
                    }
                    for (Resource r : Gate.getCreoleRegister().getAllInstances("gate.gui.docview.AnnotationSetsView")) {
                        AnnotationSetsView asv = (AnnotationSetsView)r;
                        if (asv == null || !asv.isActive() || !asv.getDocument().getName().equals(doc.getName())) continue;
                        for (int row = 0; row < LuceneDataStoreSearchGUI.this.numStackRows; ++row) {
                            String type;
                            if (LuceneDataStoreSearchGUI.this.stackRows[row][0].equals("false") || (type = LuceneDataStoreSearchGUI.this.stackRows[row][2]).equals("Token")) continue;
                            String asn = result.getAnnotationSetName();
                            if (asn.equals("<null>") && doc.getAnnotations().getAllTypes().contains(type)) {
                                asv.setTypeSelected(null, type, true);
                                continue;
                            }
                            if (!doc.getAnnotationSetNames().contains(asn) || !doc.getAnnotations(asn).getAllTypes().contains(type)) continue;
                            asv.setTypeSelected(asn, type, true);
                        }
                        break;
                    }
                }
                catch (GateException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void updateViews() {
        if (this.searcher != null) {
            Collections.addAll(this.results, this.searcher.getHits());
            this.resultTableModel.fireTableDataChanged();
        }
        if (this.results.size() > 0) {
            String query = this.queryTextArea.getText().trim();
            if (query.length() > 0 && !this.results.isEmpty()) {
                int row;
                do {
                    row = this.findStackRow(0, "one time");
                    this.deleteStackRow(row);
                } while (row >= 0);
                Matcher matcher = Pattern.compile("\\{([^\\{\\}=,.]+)(?:(?:\\.([^=]+)==\"([^\\}\"]+)\")|(?:==([^\\}]+)))?(?:, ?([^\\{\\}=,.]+)(?:(?:\\.([^=]+)==\"([^\\}\"]+)\")|(?:==([^\\}]+)))?)?\\}").matcher(query);
                while (matcher.find()) {
                    for (int i = 0; i <= 4; i += 4) {
                        String type = null;
                        String feature = null;
                        row = -1;
                        if (matcher.group(1 + i) != null && matcher.group(2 + i) == null && matcher.group(3 + i) == null && matcher.group(4 + i) == null) {
                            type = matcher.group(1 + i);
                            feature = "";
                            row = this.findStackRow(2, type, 3, feature);
                        } else if (matcher.group(1 + i) != null && matcher.group(2 + i) == null && matcher.group(3 + i) == null) {
                            String shortcut = matcher.group(1 + i);
                            row = this.findStackRow(1, shortcut);
                        } else if (matcher.group(1 + i) != null && matcher.group(2 + i) != null && matcher.group(4 + i) == null) {
                            type = matcher.group(1 + i);
                            feature = matcher.group(2 + i);
                            row = this.findStackRow(2, type, 3, feature);
                        }
                        if (row >= 0) {
                            this.stackRows[row][0] = "true";
                            continue;
                        }
                        if (type == null || feature == null || this.numStackRows >= 100) continue;
                        this.stackRows[this.numStackRows][0] = "one time";
                        this.stackRows[this.numStackRows][1] = "";
                        this.stackRows[this.numStackRows][2] = type;
                        this.stackRows[this.numStackRows][3] = feature;
                        this.stackRows[this.numStackRows][4] = "Crop end";
                        ++this.numStackRows;
                    }
                }
                this.configureStackViewTableModel.fireTableDataChanged();
            }
            this.exportResultsAction.setEnabled(true);
            if (this.numberOfResultsSlider.getValue() <= this.numberOfResultsSlider.getMaximum() - 100) {
                this.nextResultsAction.setEnabled(true);
            }
            if (this.searcher.getHits().length < this.noOfResults) {
                this.nextResultsAction.setEnabled(false);
            }
            this.resultTable.setRowSelectionInterval(0, 0);
            this.resultTable.scrollRectToVisible(this.resultTable.getCellRect(0, 0, true));
        } else if (this.queryTextArea.getText().trim().length() < 1) {
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JTextArea("Have a look at the statistics table at the bottom right\nfor the most frequent annotations.\n\nEnter a query in the text area at the top and press Enter.\n\nFor example: {Person} to retrieve Person annotations."), new GridBagConstraints());
            this.centerPanel.updateUI();
            this.nextResultsAction.setEnabled(false);
            this.exportResultsAction.setEnabled(false);
        } else {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.gridy = -1;
            if (this.errorOnLastQuery) {
                this.errorOnLastQuery = false;
            } else {
                this.centerPanel.removeAll();
                this.centerPanel.add((Component)new JTextArea("No result found for your query."), gbc);
                if (!this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") || !this.annotationSetsToSearchIn.getSelectedItem().equals("All sets")) {
                    gbc.insets = new Insets(20, 0, 0, 0);
                    this.centerPanel.add((Component)new JTextArea("Consider increasing the number of documents to search in selecting \"Entire datastore\" as corpus\n and \"All sets\" as annotation set in the drop-down lists."), gbc);
                }
            }
            gbc.insets = new Insets(20, 0, 0, 0);
            this.centerPanel.add((Component)new JTextArea("Try one of these types of query:\n- word (each word must match a Token)\n- {AnnotationType}\n- {AnnotationType==\"text\"}\n- {AnnotationType.feature==\"value\"}\n- {AnnotationType, AnnotationType}\n- ({A}\u2223{B}) (means A or B)\n- ({A})+n (means one and up to n occurrences)\n- ({A})*n (means zero or up to n occurrences)\n"), gbc);
            this.centerPanel.updateUI();
            this.exportResultsAction.setEnabled(false);
            this.nextResultsAction.setEnabled(false);
        }
    }

    protected void updateStackView() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        if (this.resultTable.getSelectedRow() == -1) {
            this.centerPanel.removeAll();
            if (this.resultTable.getRowCount() > 0) {
                this.centerPanel.add((Component)new JLabel("Select a row in the results table below."), gbc);
            } else if (this.numberOfResultsSlider.getValue() > this.numberOfResultsSlider.getMaximum() - 100) {
                this.centerPanel.add((Component)new JLabel("Retrieving all results..."), gbc);
            } else {
                this.centerPanel.add((Component)new JLabel("Retrieving " + this.numberOfResultsSlider.getValue() + " results..."), gbc);
            }
            this.centerPanel.validate();
            this.centerPanel.repaint();
            return;
        }
        gate.creole.annic.Pattern result = (gate.creole.annic.Pattern)this.results.get(this.resultTable.rowViewToModel(this.resultTable.getSelectionModel().getLeadSelectionIndex()));
        this.centerPanel.setText(result.getPatternText());
        this.centerPanel.setExpressionStartOffset(result.getStartOffset());
        this.centerPanel.setExpressionEndOffset(result.getEndOffset());
        this.centerPanel.setContextBeforeSize(result.getStartOffset() - result.getLeftContextStartOffset());
        this.centerPanel.setContextAfterSize(result.getRightContextEndOffset() - result.getEndOffset());
        this.centerPanel.setLastRowButton(this.configureStackViewButton);
        this.centerPanel.setTextMouseListener(new TextMouseListener());
        this.centerPanel.setHeaderMouseListener(new HeaderMouseListener());
        this.centerPanel.setAnnotationMouseListener(new AnnotationMouseListener());
        this.centerPanel.clearAllRows();
        for (int row = 0; row < this.numStackRows; ++row) {
            if (this.stackRows[row][0].equals("false")) continue;
            String type = this.stackRows[row][2];
            String feature = this.stackRows[row][3];
            String shortcut = this.stackRows[row][1];
            ButtonBorder removeRowButton = new ButtonBorder(new Color(250, 250, 250), new Insets(0, 3, 0, 3), true);
            removeRowButton.setIcon(MainFrame.getIcon("Remove"));
            removeRowButton.setToolTipText("Hide this row.");
            final String typeFinal = type;
            final String featureFinal = feature;
            removeRowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ie) {
                    int row = LuceneDataStoreSearchGUI.this.findStackRow(2, typeFinal, 3, featureFinal);
                    if (row >= 0) {
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[row][0] = "false";
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                    }
                    LuceneDataStoreSearchGUI.this.updateStackView();
                }
            });
            int crop = this.stackRows[row][4].equals("Crop start") ? 0 : (this.stackRows[row][4].equals("Crop end") ? 2 : 1);
            this.centerPanel.addRow(null, type, feature, removeRowButton, shortcut, crop);
            PatternAnnotation[] annotations = result.getPatternAnnotations(type);
            if (annotations == null || annotations.length <= 0) continue;
            for (PatternAnnotation annotation : annotations) {
                FeatureMap features = Factory.newFeatureMap();
                features.putAll(annotation.getFeatures());
                this.centerPanel.addAnnotation(annotation.getStartOffset(), annotation.getEndOffset(), annotation.getType(), features);
            }
        }
        this.centerPanel.drawStack();
    }

    protected void updateAnnotationSetsList() {
        String corpusName = this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)this.corpusIds.get(this.corpusToSearchIn.getSelectedIndex() - 1);
        TreeSet<Object> ts = new TreeSet<Object>(this.stringCollator);
        ts.addAll(this.getAnnotationSetNames(corpusName));
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>(ts.toArray(new String[ts.size()]));
        dcbm.insertElementAt("All sets", 0);
        this.annotationSetsToSearchIn.setModel(dcbm);
        this.annotationSetsToSearchIn.setSelectedItem("All sets");
        TreeSet<Object> types = new TreeSet<Object>(this.stringCollator);
        types.addAll(this.getTypesAndFeatures(null, null).keySet());
        JComboBox<String> annotTypesBox = new JComboBox<String>();
        annotTypesBox.setMaximumRowCount(10);
        annotTypesBox.setModel(new DefaultComboBoxModel<String>(types.toArray(new String[types.size()])));
        DefaultCellEditor cellEditor = new DefaultCellEditor(annotTypesBox);
        cellEditor.setClickCountToStart(0);
        this.configureStackViewFrame.getTable().getColumnModel().getColumn(2).setCellEditor(cellEditor);
    }

    protected void updateAnnotationTypesList() {
        String corpusName = this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)this.corpusIds.get(this.corpusToSearchIn.getSelectedIndex() - 1);
        String annotationSetName = this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)this.annotationSetsToSearchIn.getSelectedItem();
        this.populatedAnnotationTypesAndFeatures = this.getTypesAndFeatures(corpusName, annotationSetName);
        int countTotal = 0;
        try {
            TreeSet<Object> ts = new TreeSet<Object>(this.stringCollator);
            ts.addAll(this.populatedAnnotationTypesAndFeatures.keySet());
            this.globalStatisticsTableModel.setRowCount(0);
            for (String string : ts) {
                int count = this.searcher.freq(corpusName, annotationSetName, string);
                this.globalStatisticsTableModel.addRow(new Object[]{string, count});
                countTotal += count;
            }
        }
        catch (SearchException se) {
            se.printStackTrace();
            return;
        }
        if (countTotal == 0) {
            this.centerPanel.removeAll();
            this.centerPanel.add((Component)new JLabel("<html>There is no annotation for the moment for the selected corpus and annotation set.<br><br>Select another corpus or annotation set or wait for the end of the automatic indexation."), new GridBagConstraints());
        }
    }

    protected Set<String> getAnnotationSetNames(String corpusName) {
        HashSet<String> toReturn = new HashSet<String>();
        if (corpusName == null) {
            for (String aSet : this.annotationSetIDsFromDataStore) {
                aSet = aSet.substring(aSet.indexOf(59) + 1);
                toReturn.add(aSet);
            }
        } else {
            for (String aSet : this.annotationSetIDsFromDataStore) {
                if (!aSet.startsWith(corpusName + ";")) continue;
                aSet = aSet.substring(aSet.indexOf(59) + 1);
                toReturn.add(aSet);
            }
        }
        return toReturn;
    }

    protected Map<String, Set<String>> getTypesAndFeatures(String corpusName, String annotationSetName) {
        HashMap<String, Set<String>> toReturn = new HashMap<String, Set<String>>();
        if (corpusName == null && annotationSetName == null) {
            for (String type : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                String annotation = type.substring(type.lastIndexOf(59) + 1);
                Set<String> features = toReturn.get(annotation);
                if (features == null) {
                    features = new HashSet<String>();
                    toReturn.put(annotation, features);
                }
                features.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(type));
            }
        } else if (corpusName == null) {
            for (String type : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                String annotation = type.substring(type.indexOf(59) + 1);
                if (!annotation.startsWith(annotationSetName + ";")) continue;
                Set<String> features = toReturn.get(annotation = annotation.substring(annotation.indexOf(59) + 1));
                if (features == null) {
                    features = new HashSet<String>();
                    toReturn.put(annotation, features);
                }
                features.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(type));
            }
        } else if (annotationSetName == null) {
            for (String type : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                if (!type.startsWith(corpusName + ";")) continue;
                String annotation = type.substring(type.lastIndexOf(59) + 1);
                Set<String> features = toReturn.get(annotation);
                if (features == null) {
                    features = new HashSet<String>();
                    toReturn.put(annotation, features);
                }
                features.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(type));
            }
        } else {
            for (String type : this.allAnnotTypesAndFeaturesFromDatastore.keySet()) {
                if (!type.startsWith(corpusName + ";" + annotationSetName + ";")) continue;
                String annotation = type.substring(type.lastIndexOf(59) + 1);
                Set<String> features = toReturn.get(annotation);
                if (features == null) {
                    features = new HashSet<String>();
                    toReturn.put(annotation, features);
                }
                features.addAll((Collection<String>)this.allAnnotTypesAndFeaturesFromDatastore.get(type));
            }
        }
        return toReturn;
    }

    protected int findStackRow(Object ... parameters) {
        if (parameters.length % 2 != 0) {
            return -2;
        }
        for (int num = 0; num < parameters.length; num += 2) {
            if (parameters[num] == null || parameters[num + 1] == null) {
                return -2;
            }
            try {
                if (Integer.parseInt(parameters[num].toString()) < 0 || Integer.parseInt(parameters[num].toString()) > this.columnNames.length - 1) {
                    return -2;
                }
            }
            catch (NumberFormatException nfe) {
                return -2;
            }
            if (parameters[num + 1] instanceof String) continue;
            return -2;
        }
        for (int row = 0; row < this.numStackRows; ++row) {
            int numParametersSatisfied = 0;
            for (int num = 0; num < parameters.length; num += 2) {
                if (!this.stackRows[row][Integer.parseInt(parameters[num].toString())].equals(parameters[num + 1])) continue;
                ++numParametersSatisfied;
            }
            if (numParametersSatisfied != parameters.length / 2) continue;
            return row;
        }
        return -1;
    }

    protected boolean deleteStackRow(int row) {
        if (row < 0 || row > this.numStackRows) {
            return false;
        }
        for (int row2 = row; row2 < this.numStackRows; ++row2) {
            System.arraycopy(this.stackRows[row2 + 1], 0, this.stackRows[row2], 0, this.columnNames.length);
        }
        this.stackRows[this.numStackRows][0] = "true";
        this.stackRows[this.numStackRows][1] = "";
        this.stackRows[this.numStackRows][2] = "";
        this.stackRows[this.numStackRows][3] = "";
        this.stackRows[this.numStackRows][4] = "Crop end";
        --this.numStackRows;
        return true;
    }

    protected void saveStackViewConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int row = 0; row < this.numStackRows; ++row) {
            for (int col = 0; col < this.columnNames.length; ++col) {
                map.put(this.columnNames[col] + '_' + row, this.stackRows[row][col]);
            }
        }
        Gate.getUserConfig().put((Object)(LuceneDataStoreSearchGUI.class.getName() + ".rows"), Strings.toString(map));
    }

    @Override
    public void setTarget(Object target) {
        if (!(target instanceof LuceneDataStoreImpl) && !(target instanceof Searcher)) {
            throw new IllegalArgumentException("The GATE LuceneDataStoreSearchGUI can only be used with a GATE LuceneDataStores!\n" + target.getClass().toString() + " is not a GATE LuceneDataStore or an object of Searcher!");
        }
        this.target = target;
        if (target instanceof LuceneDataStoreImpl) {
            ((LuceneDataStoreImpl)target).addDatastoreListener(this);
            this.corpusToSearchIn.setEnabled(true);
            this.searcher = ((LuceneDataStoreImpl)target).getSearcher();
            this.updateSetsTypesAndFeatures();
            try {
                List<String> corpusPIds = ((LuceneDataStoreImpl)target).getLrIds(SerialCorpusImpl.class.getName());
                if (this.corpusIds != null) {
                    for (String corpusPId : corpusPIds) {
                        String name = ((LuceneDataStoreImpl)target).getLrName(corpusPId);
                        this.corpusIds.add(corpusPId);
                        ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).addElement(name);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LuceneDataStoreSearchGUI.this.corpusToSearchIn.updateUI();
                        LuceneDataStoreSearchGUI.this.corpusToSearchIn.setSelectedItem("Entire datastore");
                    }
                });
            }
            catch (PersistenceException e) {
                System.out.println("Couldn't find any available corpusIds.");
                throw new GateRuntimeException(e);
            }
        }
        this.searcher = (Searcher)target;
        this.corpusToSearchIn.setEnabled(false);
        try {
            this.annotationSetIDsFromDataStore = this.searcher.getIndexedAnnotationSetNames();
            this.allAnnotTypesAndFeaturesFromDatastore = this.searcher.getAnnotationTypesMap();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LuceneDataStoreSearchGUI.this.updateAnnotationSetsList();
                }
            });
        }
        catch (SearchException e) {
            throw new GateRuntimeException(e);
        }
    }

    @Override
    public void resourceAdopted(DatastoreEvent de) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent de) {
        Resource resource = de.getResource();
        if (resource instanceof Corpus) {
            Object id = de.getResourceID();
            int index = this.corpusIds.indexOf(id);
            if (index < 0) {
                return;
            }
            ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).removeElementAt(++index);
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent de) {
        Object id;
        Resource resource = de.getResource();
        if (resource instanceof Corpus && !this.corpusIds.contains(id = de.getResourceID())) {
            this.corpusIds.add(id);
            ((DefaultComboBoxModel)this.corpusToSearchIn.getModel()).addElement(resource.getName());
        }
    }

    protected void updateSetsTypesAndFeatures() {
        try {
            this.annotationSetIDsFromDataStore = this.searcher.getIndexedAnnotationSetNames();
            this.allAnnotTypesAndFeaturesFromDatastore = this.searcher.getAnnotationTypesMap();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LuceneDataStoreSearchGUI.this.updateAnnotationSetsList();
                }
            });
        }
        catch (SearchException se) {
            throw new GateRuntimeException(se);
        }
    }

    protected class ButtonBorder
    extends JButton {
        public ButtonBorder(Color highlight, Insets insets, final boolean showBorderWhenInactive) {
            final CompoundBorder borderDarker = new CompoundBorder(new EtchedBorder(1, highlight, highlight.darker()), new EmptyBorder(insets));
            final CompoundBorder borderDarkerDarker = new CompoundBorder(new EtchedBorder(1, highlight, highlight.darker().darker()), new EmptyBorder(insets));
            this.setBorder(borderDarker);
            this.setBorderPainted(showBorderWhenInactive);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setBorder(borderDarkerDarker);
                    button.setBorderPainted(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setBorder(borderDarker);
                    button.setBorderPainted(showBorderWhenInactive);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setContentAreaFilled(true);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setContentAreaFilled(false);
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setBorder(borderDarkerDarker);
                    button.setBorderPainted(true);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    JButton button = (JButton)e.getComponent();
                    button.setBorder(borderDarker);
                    button.setBorderPainted(showBorderWhenInactive);
                }
            });
        }
    }

    protected class QueryTextArea
    extends JTextArea
    implements DocumentListener,
    MouseListener {
        private static final String ENTER_ACTION = "enter";
        private static final String NEW_LINE = "new line";
        private static final String CANCEL_ACTION = "cancel";
        private static final String DOWN_ACTION = "down";
        private static final String UP_ACTION = "up";
        private static final String UNDO_ACTION = "undo";
        private static final String REDO_ACTION = "redo";
        private static final String NEXT_RESULT = "next result";
        private static final String PREVIOUS_RESULT = "previous result";
        protected DefaultListModel<String> queryListModel;
        protected JList<String> queryList;
        protected JWindow queryPopupWindow;
        protected JPopupMenu mousePopup;
        protected UndoManager undo;
        protected UndoAction undoAction;
        protected RedoAction redoAction;
        protected int start;
        protected int end;
        protected int mode;
        protected static final int INSERT = 0;
        protected static final int POPUP_TYPES = 1;
        protected static final int POPUP_FEATURES = 2;
        protected static final int PROGRAMMATIC = 3;

        public QueryTextArea() {
            this.getDocument().addDocumentListener(this);
            this.addMouseListener(this);
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    QueryTextArea.this.queryPopupWindow.dispose();
                }
            });
            InputMap im = this.getInputMap(0);
            InputMap imw = this.getInputMap(2);
            ActionMap am = this.getActionMap();
            im.put(KeyStroke.getKeyStroke("ENTER"), ENTER_ACTION);
            am.put(ENTER_ACTION, new EnterAction());
            im.put(KeyStroke.getKeyStroke("control ENTER"), NEW_LINE);
            am.put(NEW_LINE, new NewLineAction());
            imw.put(KeyStroke.getKeyStroke("ESCAPE"), CANCEL_ACTION);
            am.put(CANCEL_ACTION, new CancelAction());
            im.put(KeyStroke.getKeyStroke("DOWN"), DOWN_ACTION);
            am.put(DOWN_ACTION, new DownAction());
            im.put(KeyStroke.getKeyStroke("UP"), UP_ACTION);
            am.put(UP_ACTION, new UpAction());
            this.undoAction = new UndoAction();
            im.put(KeyStroke.getKeyStroke("control Z"), UNDO_ACTION);
            am.put(UNDO_ACTION, this.undoAction);
            this.redoAction = new RedoAction();
            im.put(KeyStroke.getKeyStroke("control Y"), REDO_ACTION);
            am.put(REDO_ACTION, this.redoAction);
            im.put(KeyStroke.getKeyStroke("alt DOWN"), NEXT_RESULT);
            am.put(NEXT_RESULT, new NextResultAction());
            im.put(KeyStroke.getKeyStroke("alt UP"), PREVIOUS_RESULT);
            am.put(PREVIOUS_RESULT, new PreviousResultAction());
            this.queryListModel = new DefaultListModel();
            this.queryList = new JList<String>(this.queryListModel);
            this.queryList.setSelectionMode(0);
            this.queryList.setBackground(Color.WHITE);
            this.queryList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        new EnterAction().actionPerformed(null);
                    }
                }
            });
            this.queryPopupWindow = new JWindow();
            this.queryPopupWindow.add(new JScrollPane(this.queryList));
            this.mousePopup = new JPopupMenu();
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 1)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 2)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 3)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 4)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(0, 5)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 2)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 3)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 4)));
            this.mousePopup.add(new JMenuItem(new MultiplierAction(1, 5)));
            this.undo = new UndoManager();
            this.getDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    QueryTextArea.this.undo.addEdit(e.getEdit());
                    QueryTextArea.this.undoAction.updateUndoState();
                    QueryTextArea.this.redoAction.updateRedoState();
                }
            });
            this.start = 0;
            this.end = 0;
            this.mode = 0;
            this.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    if (!(QueryTextArea.this.mode != 1 && QueryTextArea.this.mode != 2 || QueryTextArea.this.getCaretPosition() >= QueryTextArea.this.start && QueryTextArea.this.getCaretPosition() <= QueryTextArea.this.end + 1)) {
                        QueryTextArea.this.cleanup();
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            block6: {
                int pos;
                block7: {
                    if (this.mode == 3 || this.mode == 0) {
                        return;
                    }
                    pos = ev.getOffset();
                    if (ev.getLength() != 1 || pos < this.start || pos > this.end) {
                        this.cleanup();
                        return;
                    }
                    if (this.mode != 1) break block7;
                    this.end = pos;
                    String type = this.getText().substring(this.start, this.end);
                    if (!type.matches("[a-zA-Z0-9]+")) {
                        return;
                    }
                    for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                        if (!this.startsWithIgnoreCase(this.queryList.getModel().getElementAt(i), type)) continue;
                        this.queryPopupWindow.setVisible(true);
                        this.queryList.setSelectedIndex(i);
                        this.queryList.ensureIndexIsVisible(i);
                        break block6;
                    }
                    break block6;
                }
                if (this.mode != 2) break block6;
                this.end = pos;
                String feature = this.getText().substring(this.start, this.end);
                if (!feature.matches("[a-zA-Z0-9]+")) {
                    return;
                }
                for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                    if (!this.startsWithIgnoreCase(this.queryList.getModel().getElementAt(i), feature)) continue;
                    this.queryPopupWindow.setVisible(true);
                    this.queryList.setSelectedIndex(i);
                    this.queryList.ensureIndexIsVisible(i);
                    break;
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            String nextChar;
            if (this.mode == 3) {
                return;
            }
            int pos = ev.getOffset();
            if (ev.getLength() != 1) {
                this.cleanup();
                return;
            }
            String typedChar = Character.toString(this.getText().charAt(pos));
            String previousChar = pos > 0 ? Character.toString(this.getText().charAt(pos - 1)) : "";
            String string = nextChar = pos + 1 < this.getText().length() ? Character.toString(this.getText().charAt(pos + 1)) : "";
            if ((typedChar.equals("{") && !previousChar.equals("\\") || typedChar.equals(",") && nextChar.equals("}")) && this.mode == 0) {
                this.mode = 1;
                this.start = pos + 1;
                this.end = pos + 1;
                SwingUtilities.invokeLater(new PopupTypeTask());
            } else if (typedChar.equals(".") && this.mode == 0) {
                this.mode = 2;
                this.start = pos + 1;
                this.end = pos + 1;
                SwingUtilities.invokeLater(new PopupFeatureTask());
            } else if (typedChar.matches("[a-zA-Z0-9]") && this.mode == 1) {
                this.end = pos;
                String type = this.getText().substring(this.start, this.end + 1);
                boolean found = false;
                if (type.matches("[a-zA-Z0-9]+")) {
                    for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                        if (!this.startsWithIgnoreCase(this.queryList.getModel().getElementAt(i), type)) continue;
                        this.queryPopupWindow.setVisible(true);
                        this.queryList.setSelectedIndex(i);
                        this.queryList.ensureIndexIsVisible(i);
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.queryPopupWindow.setVisible(false);
                }
            } else if (typedChar.matches("[a-zA-Z0-9]") && this.mode == 2) {
                this.end = pos;
                String feature = this.getText().substring(this.start, this.end + 1);
                boolean found = false;
                if (feature.matches("[a-zA-Z0-9]+")) {
                    for (int i = 0; i < this.queryList.getModel().getSize(); ++i) {
                        if (!this.startsWithIgnoreCase(this.queryList.getModel().getElementAt(i), feature)) continue;
                        this.queryPopupWindow.setVisible(true);
                        this.queryList.setSelectedIndex(i);
                        this.queryList.ensureIndexIsVisible(i);
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.queryPopupWindow.setVisible(false);
                }
            }
        }

        private boolean startsWithIgnoreCase(String str1, String str2) {
            return str1.toUpperCase().startsWith(str2.toUpperCase());
        }

        private void cleanup() {
            this.mode = 0;
            this.queryPopupWindow.setVisible(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopup(e);
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopup(e);
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void createPopup(MouseEvent e) {
            if (!(this.getSelectedText() != null && QueryParser.isValidQuery(this.getSelectedText()) || this.getDocument().getLength() <= 3)) {
                int positionclicked = this.viewToModel(e.getPoint());
                if (positionclicked >= this.getDocument().getLength()) {
                    positionclicked = this.getDocument().getLength() - 1;
                }
                int start = this.getText().substring(0, positionclicked + 1).lastIndexOf("{");
                int end = this.getText().substring(positionclicked, this.getDocument().getLength()).indexOf("}") + positionclicked;
                if (start != -1 && end != -1 && QueryParser.isValidQuery(this.getText().substring(start, end + 1))) {
                    this.setSelectionStart(start);
                    this.setSelectionEnd(end + 1);
                }
            }
        }

        private class RedoAction
        extends AbstractAction {
            public RedoAction() {
                super("Redo");
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QueryTextArea.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
                this.updateRedoState();
                QueryTextArea.this.undoAction.updateUndoState();
            }

            protected void updateRedoState() {
                if (QueryTextArea.this.undo.canRedo()) {
                    this.setEnabled(true);
                    this.putValue("Name", QueryTextArea.this.undo.getRedoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", "Redo");
                }
            }
        }

        private class UndoAction
        extends AbstractAction {
            public UndoAction() {
                super("Undo");
                this.setEnabled(false);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    QueryTextArea.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
                this.updateUndoState();
                QueryTextArea.this.redoAction.updateRedoState();
            }

            protected void updateUndoState() {
                if (QueryTextArea.this.undo.canUndo()) {
                    this.setEnabled(true);
                    this.putValue("Name", QueryTextArea.this.undo.getUndoPresentationName());
                } else {
                    this.setEnabled(false);
                    this.putValue("Name", "Undo");
                }
            }
        }

        private class NewLineAction
        extends AbstractAction {
            private NewLineAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    QueryTextArea.this.getDocument().insertString(QueryTextArea.this.getCaretPosition(), "\n", null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }

        private class NextResultAction
        extends AbstractAction {
            private NextResultAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1 < LuceneDataStoreSearchGUI.this.resultTable.getRowCount()) {
                    LuceneDataStoreSearchGUI.this.resultTable.setRowSelectionInterval(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1, LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1);
                    LuceneDataStoreSearchGUI.this.resultTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.resultTable.getCellRect(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() + 1, 0, true));
                }
            }
        }

        private class PreviousResultAction
        extends AbstractAction {
            private PreviousResultAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() > 0) {
                    LuceneDataStoreSearchGUI.this.resultTable.setRowSelectionInterval(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() - 1, LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() - 1);
                    LuceneDataStoreSearchGUI.this.resultTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.resultTable.getCellRect(LuceneDataStoreSearchGUI.this.resultTable.getSelectedRow() - 1, 0, true));
                }
            }
        }

        private class UpAction
        extends AbstractAction {
            private UpAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                int index;
                if (QueryTextArea.this.mode == 1) {
                    int index2 = QueryTextArea.this.queryList.getSelectedIndex();
                    if (index2 > 0) {
                        QueryTextArea.this.queryList.setSelectedIndex(index2 - 1);
                        QueryTextArea.this.queryList.ensureIndexIsVisible(index2 - 1);
                    }
                } else if (QueryTextArea.this.mode == 2 && (index = QueryTextArea.this.queryList.getSelectedIndex()) > 0) {
                    QueryTextArea.this.queryList.setSelectedIndex(index - 1);
                    QueryTextArea.this.queryList.ensureIndexIsVisible(index - 1);
                }
            }
        }

        private class DownAction
        extends AbstractAction {
            private DownAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                int index;
                if (QueryTextArea.this.mode == 1) {
                    int index2 = QueryTextArea.this.queryList.getSelectedIndex();
                    if (index2 + 1 < QueryTextArea.this.queryList.getModel().getSize()) {
                        QueryTextArea.this.queryList.setSelectedIndex(index2 + 1);
                        QueryTextArea.this.queryList.ensureIndexIsVisible(index2 + 1);
                    }
                } else if (QueryTextArea.this.mode == 2 && (index = QueryTextArea.this.queryList.getSelectedIndex()) + 1 < QueryTextArea.this.queryList.getModel().getSize()) {
                    QueryTextArea.this.queryList.setSelectedIndex(index + 1);
                    QueryTextArea.this.queryList.ensureIndexIsVisible(index + 1);
                }
            }
        }

        private class CancelAction
        extends AbstractAction {
            private CancelAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                QueryTextArea.this.cleanup();
            }
        }

        private class EnterAction
        extends AbstractAction {
            private EnterAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                String selection = QueryTextArea.this.queryList.getSelectedValue();
                if (QueryTextArea.this.mode == 1) {
                    if (selection == null) {
                        return;
                    }
                    QueryTextArea.this.mode = 3;
                    try {
                        if (QueryTextArea.this.end < QueryTextArea.this.getDocument().getLength()) {
                            QueryTextArea.this.getDocument().remove(QueryTextArea.this.start, QueryTextArea.this.end - QueryTextArea.this.start + 1);
                        }
                        QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start, selection, null);
                        if (QueryTextArea.this.getText().charAt(QueryTextArea.this.start - 1) != ',') {
                            QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start + selection.length(), "}", null);
                            QueryTextArea.this.setCaretPosition(QueryTextArea.this.getCaretPosition() - 1);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else if (QueryTextArea.this.mode == 2) {
                    if (selection == null) {
                        return;
                    }
                    QueryTextArea.this.mode = 3;
                    try {
                        if (QueryTextArea.this.end < QueryTextArea.this.getDocument().getLength() && QueryTextArea.this.getText().charAt(QueryTextArea.this.end) != '}') {
                            QueryTextArea.this.getDocument().remove(QueryTextArea.this.start, QueryTextArea.this.end - QueryTextArea.this.start + 1);
                        }
                        QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start, selection, null);
                        QueryTextArea.this.getDocument().insertString(QueryTextArea.this.start + selection.length(), "==\"\"", null);
                        QueryTextArea.this.setCaretPosition(QueryTextArea.this.getCaretPosition() - 1);
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else {
                    LuceneDataStoreSearchGUI.this.executeQueryAction.actionPerformed(null);
                }
                QueryTextArea.this.cleanup();
            }
        }

        private class PopupFeatureTask
        implements Runnable {
            private PopupFeatureTask() {
            }

            @Override
            public void run() {
                int index = Math.max(QueryTextArea.this.getText().substring(0, QueryTextArea.this.end - 1).lastIndexOf("{"), Math.max(QueryTextArea.this.getText().substring(0, QueryTextArea.this.end - 1).lastIndexOf(","), QueryTextArea.this.getText().substring(0, QueryTextArea.this.end - 1).lastIndexOf(", ") + 1));
                String type = QueryTextArea.this.getText().substring(index + 1, QueryTextArea.this.end - 1);
                if (!LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.containsKey(type)) {
                    QueryTextArea.this.cleanup();
                    return;
                }
                try {
                    TreeSet<Object> features = new TreeSet<Object>(LuceneDataStoreSearchGUI.this.stringCollator);
                    features.addAll((Collection)LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.get(type));
                    QueryTextArea.this.queryListModel.clear();
                    for (String string : features) {
                        QueryTextArea.this.queryListModel.addElement(string);
                    }
                    QueryTextArea.this.queryList.setVisibleRowCount(Math.min(12, features.size()));
                    Rectangle dotRect = QueryTextArea.this.modelToView(QueryTextArea.this.getCaret().getDot());
                    QueryTextArea.this.queryPopupWindow.setLocation(QueryTextArea.this.getLocationOnScreen().x + (int)dotRect.getMaxX(), QueryTextArea.this.getLocationOnScreen().y + (int)dotRect.getMaxY());
                    QueryTextArea.this.queryPopupWindow.pack();
                    QueryTextArea.this.queryPopupWindow.setVisible(true);
                    if (QueryTextArea.this.queryListModel.getSize() == 1) {
                        QueryTextArea.this.queryList.setSelectedIndex(0);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }

        private class PopupTypeTask
        implements Runnable {
            private PopupTypeTask() {
            }

            @Override
            public void run() {
                try {
                    TreeSet<Object> types = new TreeSet<Object>(LuceneDataStoreSearchGUI.this.stringCollator);
                    types.addAll(LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.keySet());
                    if (types.isEmpty()) {
                        types.add("No annotation type found !");
                    }
                    QueryTextArea.this.queryListModel.clear();
                    for (String string : types) {
                        QueryTextArea.this.queryListModel.addElement(string);
                    }
                    QueryTextArea.this.queryList.setVisibleRowCount(Math.min(12, types.size()));
                    Rectangle dotRect = QueryTextArea.this.modelToView(QueryTextArea.this.getCaret().getDot());
                    QueryTextArea.this.queryPopupWindow.setLocation(QueryTextArea.this.getLocationOnScreen().x + (int)dotRect.getMaxX(), QueryTextArea.this.getLocationOnScreen().y + (int)dotRect.getMaxY());
                    QueryTextArea.this.queryPopupWindow.pack();
                    QueryTextArea.this.queryPopupWindow.setVisible(true);
                    if (QueryTextArea.this.queryListModel.getSize() == 1) {
                        QueryTextArea.this.queryList.setSelectedIndex(0);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }

        private class MultiplierAction
        extends AbstractAction {
            int from;
            int upto;

            public MultiplierAction(int from, int upto) {
                super(from + " to " + upto + " time" + (upto == 1 ? "" : "s"));
                this.from = from;
                this.upto = upto;
            }

            @Override
            public void actionPerformed(ActionEvent ie) {
                try {
                    QueryTextArea.this.getDocument().insertString(QueryTextArea.this.getSelectionStart(), "(", null);
                    QueryTextArea.this.getDocument().insertString(QueryTextArea.this.getSelectionEnd(), ")" + (this.from == 0 ? "*" : "+") + this.upto, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected class ConfigureStackViewTableModel
    extends AbstractTableModel {
        private final int REMOVE;

        protected ConfigureStackViewTableModel() {
            this.REMOVE = LuceneDataStoreSearchGUI.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return Math.min(LuceneDataStoreSearchGUI.this.numStackRows + 1, 101);
        }

        @Override
        public int getColumnCount() {
            return LuceneDataStoreSearchGUI.this.columnNames.length + 1;
        }

        @Override
        public String getColumnName(int col) {
            return col == this.REMOVE ? "Add/Remove" : LuceneDataStoreSearchGUI.this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == this.REMOVE) {
                return null;
            }
            return LuceneDataStoreSearchGUI.this.stackRows[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == this.REMOVE) {
                return;
            }
            String valueString = value instanceof String ? (String)value : "value should be a String";
            if (col == 1 && !valueString.equals("")) {
                if (LuceneDataStoreSearchGUI.this.getTypesAndFeatures(null, null).keySet().contains(valueString)) {
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "A Shortcut cannot have the same name as an Annotation type.", "Alert", 0);
                    return;
                }
                int row2 = LuceneDataStoreSearchGUI.this.findStackRow(1, valueString);
                if (row2 >= 0 && row2 != row) {
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "A Shortcut with the same name already exists.", "Alert", 0);
                    return;
                }
            }
            String previousValue = valueString;
            ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[row][col] = valueString;
            if (!LuceneDataStoreSearchGUI.this.stackRows[row][1].equals("")) {
                if (LuceneDataStoreSearchGUI.this.stackRows[row][2].equals("") || LuceneDataStoreSearchGUI.this.stackRows[row][3].equals("")) {
                    LuceneDataStoreSearchGUI.this.configureStackViewFrame.getTable().getColumnModel().getColumn(col).getCellEditor().cancelCellEditing();
                    this.fireTableCellUpdated(row, col);
                    ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[row][col] = previousValue;
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "A Shortcut need to have a Feature.\nChoose a Feature or delete the Shortcut value.", "Alert", 0);
                    return;
                }
                int row2 = LuceneDataStoreSearchGUI.this.findStackRow(2, LuceneDataStoreSearchGUI.this.stackRows[row][2], 3, LuceneDataStoreSearchGUI.this.stackRows[row][3]);
                if (row2 >= 0 && row2 != row && !LuceneDataStoreSearchGUI.this.stackRows[row2][1].equals("")) {
                    LuceneDataStoreSearchGUI.this.configureStackViewFrame.getTable().getColumnModel().getColumn(col).getCellEditor().cancelCellEditing();
                    ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[row][col] = previousValue;
                    this.fireTableCellUpdated(row, col);
                    JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "You can only have one Shortcut for a couple (Annotation type, Feature).", "Alert", 0);
                    return;
                }
            }
            if (LuceneDataStoreSearchGUI.this.stackRows[row][0].equals("one time")) {
                ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[row][0] = "true";
            }
            ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[row][col] = valueString;
            this.fireTableRowsUpdated(row, row);
            LuceneDataStoreSearchGUI.this.updateStackView();
            LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
        }
    }

    protected class ConfigureStackViewFrame
    extends JFrame {
        private final int REMOVE;
        private JTable configureStackViewTable;

        public ConfigureStackViewFrame(String title) {
            super(title);
            this.REMOVE = LuceneDataStoreSearchGUI.this.columnNames.length;
            this.setLayout(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(20, 31);
            scrollPane.getViewport().setOpaque(true);
            LuceneDataStoreSearchGUI.this.configureStackViewTableModel = new ConfigureStackViewTableModel();
            this.configureStackViewTable = new XJTable(LuceneDataStoreSearchGUI.this.configureStackViewTableModel);
            ((XJTable)this.configureStackViewTable).setSortable(false);
            this.configureStackViewTable.setCellSelectionEnabled(true);
            String[] s = new String[]{"Crop middle", "Crop start", "Crop end"};
            JComboBox<String> cropBox = new JComboBox<String>(s);
            this.configureStackViewTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                    JCheckBox checkBox = new JCheckBox();
                    checkBox.setHorizontalAlignment(0);
                    checkBox.setToolTipText("Tick to display this row in central section.");
                    checkBox.setSelected(!table.getValueAt(row, col).equals("false"));
                    return checkBox;
                }
            });
            final class DisplayCellEditor
            extends AbstractCellEditor
            implements TableCellEditor,
            ActionListener {
                JCheckBox checkBox = new JCheckBox();

                public DisplayCellEditor() {
                    this.checkBox.setHorizontalAlignment(0);
                    this.checkBox.addActionListener(this);
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    return false;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireEditingStopped();
                }

                @Override
                public Object getCellEditorValue() {
                    return this.checkBox.isSelected() ? "true" : "false";
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                    this.checkBox.setSelected(!table.getValueAt(row, col).equals("false"));
                    return this.checkBox;
                }
            }
            this.configureStackViewTable.getColumnModel().getColumn(0).setCellEditor(new DisplayCellEditor());
            this.configureStackViewTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                    Component c = super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, col);
                    if (c instanceof JComponent) {
                        ((JComponent)c).setToolTipText("Shortcut can be used in queries instead of \"AnnotationType.Feature\".");
                    }
                    c.setBackground(UIManager.getColor("CheckBox.background"));
                    return c;
                }
            });
            DefaultCellEditor cellEditor = new DefaultCellEditor(new JTextField());
            cellEditor.setClickCountToStart(0);
            this.configureStackViewTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
            this.configureStackViewTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                    String[] s = new String[]{LuceneDataStoreSearchGUI.this.stackRows[row][2]};
                    return new JComboBox<String>(s);
                }
            });
            final class FeatureCellEditor
            extends AbstractCellEditor
            implements TableCellEditor,
            ActionListener {
                private JComboBox<String> featuresBox = new JComboBox();

                public FeatureCellEditor() {
                    this.featuresBox.setMaximumRowCount(10);
                    this.featuresBox.addActionListener(this);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireEditingStopped();
                }

                @Override
                public Object getCellEditorValue() {
                    return this.featuresBox.getSelectedItem() == null ? "" : this.featuresBox.getSelectedItem();
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                    TreeSet<Object> ts = new TreeSet<Object>(LuceneDataStoreSearchGUI.this.stringCollator);
                    if (LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.containsKey(ConfigureStackViewFrame.this.configureStackViewTable.getValueAt(row, 2))) {
                        ts.addAll((Collection)LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.get(ConfigureStackViewFrame.this.configureStackViewTable.getValueAt(row, 2)));
                    }
                    DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>(ts.toArray(new String[ts.size()]));
                    dcbm.insertElementAt("", 0);
                    this.featuresBox.setModel(dcbm);
                    this.featuresBox.setSelectedItem(ts.contains(ConfigureStackViewFrame.this.configureStackViewTable.getValueAt(row, col)) ? ConfigureStackViewFrame.this.configureStackViewTable.getValueAt(row, col) : "");
                    return this.featuresBox;
                }
            }
            this.configureStackViewTable.getColumnModel().getColumn(3).setCellEditor(new FeatureCellEditor());
            this.configureStackViewTable.getColumnModel().getColumn(3).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                    String[] s = new String[]{LuceneDataStoreSearchGUI.this.stackRows[row][3]};
                    return new JComboBox<String>(s);
                }
            });
            cellEditor = new DefaultCellEditor(cropBox);
            cellEditor.setClickCountToStart(0);
            this.configureStackViewTable.getColumnModel().getColumn(4).setCellEditor(cellEditor);
            this.configureStackViewTable.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                    String[] s = new String[]{LuceneDataStoreSearchGUI.this.stackRows[row][4]};
                    return new JComboBox<String>(s);
                }
            });
            final class AddRemoveCellEditorRenderer
            extends AbstractCellEditor
            implements TableCellRenderer,
            TableCellEditor,
            ActionListener {
                private JButton button = new JButton();

                public AddRemoveCellEditorRenderer() {
                    this.button.setHorizontalAlignment(0);
                    this.button.addActionListener(this);
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
                    if (row == LuceneDataStoreSearchGUI.this.numStackRows) {
                        this.button.setIcon(MainFrame.getIcon("Add"));
                        this.button.setToolTipText("Click to add this line.");
                    } else {
                        this.button.setIcon(MainFrame.getIcon("Delete"));
                        this.button.setToolTipText("Click to remove this line.");
                    }
                    this.button.setSelected(isSelected);
                    return this.button;
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    return false;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ConfigureStackViewFrame.this.configureStackViewTable.getEditingRow();
                    this.fireEditingStopped();
                    if (row == LuceneDataStoreSearchGUI.this.numStackRows) {
                        if (LuceneDataStoreSearchGUI.this.stackRows[row][2] != null && !LuceneDataStoreSearchGUI.this.stackRows[row][2].equals("")) {
                            if (LuceneDataStoreSearchGUI.this.numStackRows == 100) {
                                JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "The number of rows is limited to 100.", "Alert", 0);
                            } else {
                                LuceneDataStoreSearchGUI.this.numStackRows++;
                                LuceneDataStoreSearchGUI.this.configureStackViewTableModel.fireTableRowsInserted(row, row + 1);
                                LuceneDataStoreSearchGUI.this.updateStackView();
                                LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                            }
                        } else {
                            JOptionPane.showMessageDialog(LuceneDataStoreSearchGUI.this.configureStackViewFrame, "Fill at least the Annotation type column.", "Alert", 0);
                        }
                    } else {
                        LuceneDataStoreSearchGUI.this.deleteStackRow(row);
                        LuceneDataStoreSearchGUI.this.configureStackViewTableModel.fireTableDataChanged();
                        LuceneDataStoreSearchGUI.this.updateStackView();
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                    }
                }

                @Override
                public Object getCellEditorValue() {
                    return null;
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                    this.button.setIcon(MainFrame.getIcon(row == LuceneDataStoreSearchGUI.this.numStackRows ? "Add" : "Delete"));
                    return this.button;
                }
            }
            this.configureStackViewTable.getColumnModel().getColumn(this.REMOVE).setCellEditor(new AddRemoveCellEditorRenderer());
            this.configureStackViewTable.getColumnModel().getColumn(this.REMOVE).setCellRenderer(new AddRemoveCellEditorRenderer());
            scrollPane.setViewportView(this.configureStackViewTable);
            this.add((Component)scrollPane, "Center");
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(false);
                }
            });
            JButton moveRowUpButton = new JButton("Move row up");
            moveRowUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConfigureStackViewFrame.this.configureStackViewTable.getRowCount() < 2) {
                        return;
                    }
                    final int selectedRow = ConfigureStackViewFrame.this.configureStackViewTable.getSelectedRow();
                    int lastRow = ConfigureStackViewFrame.this.configureStackViewTable.getRowCount() - 2;
                    if (selectedRow > 0 && selectedRow <= lastRow) {
                        String[] stackRow = LuceneDataStoreSearchGUI.this.stackRows[selectedRow - 1];
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[selectedRow - 1] = LuceneDataStoreSearchGUI.this.stackRows[selectedRow];
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[selectedRow] = stackRow;
                        LuceneDataStoreSearchGUI.this.configureStackViewTableModel.fireTableDataChanged();
                        LuceneDataStoreSearchGUI.this.updateStackView();
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ConfigureStackViewFrame.this.configureStackViewTable.changeSelection(selectedRow - 1, 1, false, false);
                                ConfigureStackViewFrame.this.configureStackViewTable.requestFocusInWindow();
                            }
                        });
                    }
                }
            });
            JButton moveRowDownButton = new JButton("Move row down");
            moveRowDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ConfigureStackViewFrame.this.configureStackViewTable.getRowCount() < 2) {
                        return;
                    }
                    final int selectedRow = ConfigureStackViewFrame.this.configureStackViewTable.getSelectedRow();
                    int lastRow = ConfigureStackViewFrame.this.configureStackViewTable.getRowCount() - 2;
                    if (selectedRow >= 0 && selectedRow < lastRow) {
                        String[] stackRow = LuceneDataStoreSearchGUI.this.stackRows[selectedRow + 1];
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[selectedRow + 1] = LuceneDataStoreSearchGUI.this.stackRows[selectedRow];
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[selectedRow] = stackRow;
                        LuceneDataStoreSearchGUI.this.configureStackViewTableModel.fireTableDataChanged();
                        LuceneDataStoreSearchGUI.this.updateStackView();
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ConfigureStackViewFrame.this.configureStackViewTable.changeSelection(selectedRow + 1, 1, false, false);
                                ConfigureStackViewFrame.this.configureStackViewTable.requestFocusInWindow();
                            }
                        });
                    }
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(closeButton);
            buttonPanel.add(moveRowUpButton);
            buttonPanel.add(moveRowDownButton);
            this.add((Component)buttonPanel, "South");
        }

        public JTable getTable() {
            return this.configureStackViewTable;
        }
    }

    protected class ResultTableModel
    extends AbstractTableModel {
        public static final int MAX_COL_WIDTH = 40;
        public static final int LEFT_CONTEXT_COLUMN = 0;
        public static final int RESULT_COLUMN = 1;
        public static final int RIGHT_CONTEXT_COLUMN = 2;
        public static final int FEATURES_COLUMN = 3;
        public static final int QUERY_COLUMN = 4;
        public static final int DOCUMENT_COLUMN = 5;
        public static final int SET_COLUMN = 6;
        public static final int COLUMN_COUNT = 7;
        protected Map<String, String> featureByTypeMap = new HashMap<String, String>();

        @Override
        public int getRowCount() {
            return LuceneDataStoreSearchGUI.this.results.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Left context";
                }
                case 1: {
                    return "Match";
                }
                case 2: {
                    return "Right context";
                }
                case 3: {
                    return "Features";
                }
                case 4: {
                    return "Query";
                }
                case 5: {
                    return "Document";
                }
                case 6: {
                    return "Annotation set";
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            gate.creole.annic.Pattern result = (gate.creole.annic.Pattern)LuceneDataStoreSearchGUI.this.results.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return result.getPatternText(result.getLeftContextStartOffset(), result.getStartOffset()).replaceAll("[\n ]+", " ");
                }
                case 1: {
                    return result.getPatternText(result.getStartOffset(), result.getEndOffset());
                }
                case 2: {
                    return result.getPatternText(result.getEndOffset(), result.getRightContextEndOffset()).replaceAll("[\n ]+", " ");
                }
                case 3: {
                    StringBuffer buffer = new StringBuffer();
                    for (Map.Entry<String, String> featureType : this.featureByTypeMap.entrySet()) {
                        String type = featureType.getKey();
                        String feature = featureType.getValue();
                        List<PatternAnnotation> annotations = result.getPatternAnnotations(result.getStartOffset(), result.getEndOffset());
                        buffer.append(type).append('.').append(feature).append('=');
                        for (PatternAnnotation annotation : annotations) {
                            if (!annotation.getType().equals(type) || annotation.getFeature(feature) == null) continue;
                            buffer.append(annotation.getFeatures().get(feature)).append(", ");
                        }
                        if (buffer.length() <= 2) continue;
                        if (buffer.codePointAt(buffer.length() - 2) == 44) {
                            buffer.delete(buffer.length() - 2, buffer.length());
                            buffer.append("; ");
                            continue;
                        }
                        if (buffer.codePointAt(buffer.length() - 1) != 61) continue;
                        buffer.delete(buffer.length() - type.length() - feature.length() - 2, buffer.length());
                    }
                    if (buffer.length() > 2) {
                        buffer.delete(buffer.length() - 2, buffer.length());
                    }
                    return buffer.toString();
                }
                case 4: {
                    return result.getQueryString();
                }
                case 5: {
                    return result.getDocumentID();
                }
                case 6: {
                    return result.getAnnotationSetName();
                }
            }
            return Object.class;
        }

        @Override
        public void fireTableDataChanged() {
            this.featureByTypeMap.clear();
            for (int row = 0; row < LuceneDataStoreSearchGUI.this.numStackRows; ++row) {
                if (LuceneDataStoreSearchGUI.this.stackRows[row][0].equals("false") || LuceneDataStoreSearchGUI.this.stackRows[row][3].equals("")) continue;
                String feature = LuceneDataStoreSearchGUI.this.stackRows[row][3];
                String type = LuceneDataStoreSearchGUI.this.stackRows[row][2];
                this.featureByTypeMap.put(type, feature);
            }
            super.fireTableDataChanged();
        }
    }

    protected class ResultTableCellRenderer
    extends DefaultTableCellRenderer {
        protected ResultTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text = (String)value;
            if (text == null) {
                text = "";
            }
            int colModel = LuceneDataStoreSearchGUI.this.resultTable.convertColumnIndexToModel(column);
            switch (colModel) {
                case 1: 
                case 3: {
                    if (text.length() > 40) {
                        text = text.substring(0, 20) + "..." + text.substring(text.length() - 20);
                    }
                    text = text.replaceAll("(?:\r?\n)|\r", " ");
                    text = text.replaceAll("\t", " ");
                    break;
                }
            }
            Component component = super.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            if (!(component instanceof JLabel)) {
                return component;
            }
            JLabel label = (JLabel)component;
            label.setHorizontalAlignment(2);
            String tip = null;
            switch (colModel) {
                case 0: {
                    label.setHorizontalAlignment(4);
                    break;
                }
                case 1: 
                case 3: {
                    String string = tip = value != null ? (String)value : "";
                    if (tip.length() > 40) {
                        if (tip.length() > 1000) {
                            tip = tip.substring(0, 500) + "<br>...<br>" + tip.substring(tip.length() - 500);
                        }
                        tip = tip.replaceAll("\\s*\n\\s*", "<br>");
                        tip = tip.replaceAll("\\s+", " ");
                        tip = "<html><table width=\"" + (tip.length() > 150 ? "500" : "100%") + "\" border=\"0\" cellspacing=\"0\"><tr><td>" + tip + "</td></tr></table></html>";
                    }
                    if (colModel != 1) break;
                    label.setHorizontalAlignment(0);
                    break;
                }
            }
            label.setToolTipText(tip);
            return label;
        }
    }

    protected class HeaderMouseListener
    extends AnnotationStack.StackMouseListener {
        String type;
        String feature;
        String description;
        String toolTip;
        String descriptionTemplate;
        String toolTipTemplate;
        JPopupMenu mousePopup;
        JMenuItem menuItem;
        XJTable table;
        JWindow popupWindow;
        int row;
        final String corpusID;
        final String annotationSetID;
        final String corpusName;
        final String annotationSetName;
        boolean isTooltipSet;

        public HeaderMouseListener() {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.isTooltipSet = false;
        }

        public HeaderMouseListener(String type, String feature) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.isTooltipSet = false;
            this.type = type;
            this.feature = feature;
            this.descriptionTemplate = type + "." + feature + " (kind)";
            this.toolTipTemplate = "Statistics in kind<br>on Corpus: " + this.corpusName + "<br>and Annotation Set: " + this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString();
            this.init();
        }

        public HeaderMouseListener(String type) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.isTooltipSet = false;
            this.type = type;
            this.descriptionTemplate = type + " (kind)";
            this.toolTipTemplate = "Statistics in kind<br>on Corpus: " + this.corpusName + "<br>and Annotation Set: " + this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString();
            this.init();
        }

        void init() {
            LuceneDataStoreSearchGUI.this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    if (HeaderMouseListener.this.popupWindow != null) {
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
            this.row = LuceneDataStoreSearchGUI.this.findStackRow(2, this.type, 3, this.feature == null ? "" : this.feature);
        }

        @Override
        public MouseInputAdapter createListener(String ... parameters) {
            switch (parameters.length) {
                case 1: {
                    return new HeaderMouseListener(parameters[0]);
                }
                case 2: {
                    return new HeaderMouseListener(parameters[0], parameters[1]);
                }
            }
            return null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (!this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel label = (JLabel)component;
                String shortcut = "";
                if (this.feature != null) {
                    int row = LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(LuceneDataStoreSearchGUI.this.resultTable.getSelectionModel().getLeadSelectionIndex());
                    if (!LuceneDataStoreSearchGUI.this.stackRows[row][1].equals("")) {
                        shortcut = "Shortcut for " + this.type + "." + this.feature + ".<br>";
                    }
                }
                label.setToolTipText("<html>" + shortcut + "Double click to choose annotation feature.<br>Right click to get statistics.</html>");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.popupWindow != null && this.popupWindow.isVisible()) {
                this.popupWindow.dispose();
                return;
            }
            if (e.getButton() != 1 || e.getClickCount() != 2) {
                return;
            }
            TreeSet<String> features = new TreeSet<String>();
            if (LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.containsKey(this.type)) {
                features.addAll((Collection)LuceneDataStoreSearchGUI.this.populatedAnnotationTypesAndFeatures.get(this.type));
            }
            features.add(" ");
            final JList<String> list = new JList<String>(features.toArray(new String[features.size()]));
            list.setVisibleRowCount(Math.min(8, features.size()));
            list.setSelectionMode(0);
            list.setBackground(Color.WHITE);
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        String newFeature = (String)list.getSelectedValue();
                        if (newFeature.equals(" ")) {
                            newFeature = "";
                        }
                        ((LuceneDataStoreSearchGUI)LuceneDataStoreSearchGUI.this).stackRows[HeaderMouseListener.this.row][3] = newFeature;
                        LuceneDataStoreSearchGUI.this.saveStackViewConfiguration();
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                        LuceneDataStoreSearchGUI.this.updateStackView();
                    }
                }
            });
            this.popupWindow = new JWindow();
            this.popupWindow.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        HeaderMouseListener.this.popupWindow.setVisible(false);
                        HeaderMouseListener.this.popupWindow.dispose();
                    }
                }
            });
            this.popupWindow.add(new JScrollPane(list));
            Component component = e.getComponent();
            this.popupWindow.setBounds(component.getLocationOnScreen().x, component.getLocationOnScreen().y + component.getHeight(), component.getWidth(), Math.min(8 * component.getHeight(), features.size() * component.getHeight()));
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String newFeature = LuceneDataStoreSearchGUI.this.stackRows[HeaderMouseListener.this.row][3];
                    if (newFeature.equals("")) {
                        newFeature = " ";
                    }
                    list.setSelectedValue(newFeature, true);
                    HeaderMouseListener.this.popupWindow.requestFocusInWindow();
                }
            });
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopup(e);
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.createPopup(e);
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private int checkStatistics() {
            boolean found = false;
            int numRow = 0;
            for (int row = 0; row < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount(); ++row) {
                String oldDescription = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(row, 0);
                String oldToolTip = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.get(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowViewToModel(numRow));
                if (oldDescription.equals(this.description) && oldToolTip.equals(this.toolTip)) {
                    found = true;
                    break;
                }
                ++numRow;
            }
            return found ? numRow : -1;
        }

        private void addStatistics(String kind, int count, int numRow, MouseEvent e) {
            JLabel label = (JLabel)e.getComponent();
            if (!label.getToolTipText().contains(kind)) {
                String toolTip = label.getToolTipText();
                toolTip = toolTip.replaceAll("</?html>", "");
                toolTip = kind + " = " + count + "<br>" + toolTip;
                toolTip = "<html>" + toolTip + "</html>";
                label.setToolTipText(toolTip);
            }
            if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() < 0.9) {
                LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(1);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.setRowSelectionInterval(numRow, numRow);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getCellRect(numRow, 0, true));
            } else {
                JToolTip tip = label.createToolTip();
                tip.setTipText(kind + " = " + count);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                final Popup tipWindow = popupFactory.getPopup(label, tip, e.getX() + e.getComponent().getLocationOnScreen().x, e.getY() + e.getComponent().getLocationOnScreen().y);
                tipWindow.show();
                Date timeToRun = new Date(System.currentTimeMillis() + 2000L);
                Timer timer = new Timer("Annic statistics hide tooltip timer", true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        tipWindow.hide();
                    }
                }, timeToRun);
            }
        }

        private void createPopup(final MouseEvent e) {
            this.mousePopup = new JPopupMenu();
            if (this.type != null && this.feature != null) {
                this.menuItem = new JMenuItem("Occurrences in datastore");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "datastore");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "datastore");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(HeaderMouseListener.this.corpusID, HeaderMouseListener.this.annotationSetID, HeaderMouseListener.this.type, HeaderMouseListener.this.feature);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("datastore", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "matches");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, null, true, false);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "contexts");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "contexts");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, null, false, true);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("contexts", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches+contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "mch+ctxt");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches+contexts");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, null, true, true);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches+contexts", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.mousePopup.addSeparator();
                this.menuItem = new JMenuItem("All values from matches");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        Map<String, Integer> freqs;
                        try {
                            freqs = LuceneDataStoreSearchGUI.this.searcher.freqForAllValues(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, true, false);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        DefaultTableModel model = new DefaultTableModel();
                        model.addColumn(HeaderMouseListener.this.type + '.' + HeaderMouseListener.this.feature + " (matches)");
                        model.addColumn("Count");
                        for (Map.Entry<String, Integer> map : freqs.entrySet()) {
                            model.addRow(new Object[]{map.getKey(), map.getValue()});
                        }
                        HeaderMouseListener.this.table = new XJTable(){

                            @Override
                            public boolean isCellEditable(int rowIndex, int vColIndex) {
                                return false;
                            }
                        };
                        HeaderMouseListener.this.table.setModel(model);
                        HeaderMouseListener.this.table.setComparator(0, LuceneDataStoreSearchGUI.this.stringCollator);
                        HeaderMouseListener.this.table.setComparator(1, LuceneDataStoreSearchGUI.this.integerComparator);
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.addTab(String.valueOf(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1), null, new JScrollPane(HeaderMouseListener.this.table), "<html>Statistics in matches<br>on Corpus: " + HeaderMouseListener.this.corpusName + "<br>and Annotation Set: " + HeaderMouseListener.this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString() + "</html>");
                        if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() > 0.75) {
                            LuceneDataStoreSearchGUI.this.bottomSplitPane.setDividerLocation(0.66);
                        }
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("All values from contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        Map<String, Integer> freqs;
                        try {
                            freqs = LuceneDataStoreSearchGUI.this.searcher.freqForAllValues(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, false, true);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        DefaultTableModel model = new DefaultTableModel();
                        model.addColumn(HeaderMouseListener.this.type + '.' + HeaderMouseListener.this.feature + " (contexts)");
                        model.addColumn("Count");
                        for (Map.Entry<String, Integer> map : freqs.entrySet()) {
                            model.addRow(new Object[]{map.getKey(), map.getValue()});
                        }
                        HeaderMouseListener.this.table = new XJTable(){

                            @Override
                            public boolean isCellEditable(int rowIndex, int vColIndex) {
                                return false;
                            }
                        };
                        HeaderMouseListener.this.table.setModel(model);
                        HeaderMouseListener.this.table.setComparator(0, LuceneDataStoreSearchGUI.this.stringCollator);
                        HeaderMouseListener.this.table.setComparator(1, LuceneDataStoreSearchGUI.this.integerComparator);
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.addTab(String.valueOf(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1), null, new JScrollPane(HeaderMouseListener.this.table), "<html>Statistics in contexts<br>on Corpus: " + HeaderMouseListener.this.corpusName + "<br>and Annotation Set: " + HeaderMouseListener.this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString() + "</html>");
                        if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() > 0.75) {
                            LuceneDataStoreSearchGUI.this.bottomSplitPane.setDividerLocation(0.66);
                        }
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("All values from matches+contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        Map<String, Integer> freqs;
                        try {
                            freqs = LuceneDataStoreSearchGUI.this.searcher.freqForAllValues(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, HeaderMouseListener.this.feature, true, true);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        DefaultTableModel model = new DefaultTableModel();
                        model.addColumn(HeaderMouseListener.this.type + '.' + HeaderMouseListener.this.feature + " (mch+ctxt)");
                        model.addColumn("Count");
                        for (Map.Entry<String, Integer> map : freqs.entrySet()) {
                            model.addRow(new Object[]{map.getKey(), map.getValue()});
                        }
                        HeaderMouseListener.this.table = new XJTable(){

                            @Override
                            public boolean isCellEditable(int rowIndex, int vColIndex) {
                                return false;
                            }
                        };
                        HeaderMouseListener.this.table.setModel(model);
                        HeaderMouseListener.this.table.setComparator(0, LuceneDataStoreSearchGUI.this.stringCollator);
                        HeaderMouseListener.this.table.setComparator(1, LuceneDataStoreSearchGUI.this.integerComparator);
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.addTab(String.valueOf(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1), null, new JScrollPane(HeaderMouseListener.this.table), "<html>Statistics in matches+contexts<br>on Corpus: " + HeaderMouseListener.this.corpusName + "<br>and Annotation Set: " + HeaderMouseListener.this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString() + "</html>");
                        if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() > 0.75) {
                            LuceneDataStoreSearchGUI.this.bottomSplitPane.setDividerLocation(0.66);
                        }
                        LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(LuceneDataStoreSearchGUI.this.statisticsTabbedPane.getTabCount() - 1);
                    }
                });
                this.mousePopup.add(this.menuItem);
            } else {
                this.menuItem = new JMenuItem("Occurrences in datastore");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "datastore");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "datastore");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(HeaderMouseListener.this.corpusID, HeaderMouseListener.this.annotationSetID, HeaderMouseListener.this.type);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("datastore", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "matches");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, true, false);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "contexts");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "contexts");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, false, true);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("contexts", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
                this.menuItem = new JMenuItem("Occurrences in matches+contexts");
                this.menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ie) {
                        int count;
                        HeaderMouseListener.this.description = HeaderMouseListener.this.descriptionTemplate.replaceFirst("kind", "mch+ctxt");
                        HeaderMouseListener.this.toolTip = HeaderMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches+contexts");
                        int numRow = HeaderMouseListener.this.checkStatistics();
                        if (numRow == -1) {
                            try {
                                count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, HeaderMouseListener.this.type, true, true);
                            }
                            catch (SearchException se) {
                                se.printStackTrace();
                                return;
                            }
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{HeaderMouseListener.this.description, count, ""});
                            LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(HeaderMouseListener.this.toolTip);
                            numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                        } else {
                            count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                        }
                        HeaderMouseListener.this.addStatistics("matches+contexts", count, numRow, e);
                    }
                });
                this.mousePopup.add(this.menuItem);
            }
        }
    }

    protected class AnnotationMouseListener
    extends AnnotationStack.StackMouseListener {
        String type;
        String feature;
        String text;
        String description;
        String toolTip;
        String descriptionTemplate;
        String toolTipTemplate;
        JPopupMenu mousePopup;
        JMenuItem menuItem;
        final String corpusID;
        final String annotationSetID;
        final String corpusName;
        final String annotationSetName;
        ToolTipManager toolTipManager;
        int dismissDelay;
        int initialDelay;
        int reshowDelay;
        boolean enabled;
        boolean isTooltipSet;

        public AnnotationMouseListener() {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.isTooltipSet = false;
        }

        public AnnotationMouseListener(String type, String feature, String text) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.isTooltipSet = false;
            this.type = type;
            this.feature = feature;
            this.text = text;
            String value = text.replace("\\s", "").length() > 20 ? text.replace("\\s", "").substring(0, 20) + "..." : text.replace("\\s", "");
            this.descriptionTemplate = type + "." + feature + "==\"" + value + "\" (kind)";
            this.toolTipTemplate = "Statistics in kind<br>on Corpus: " + this.corpusName + "<br>and Annotation Set: " + this.annotationSetName + "<br>for the query: " + ((Hit)LuceneDataStoreSearchGUI.this.results.get(0)).getQueryString();
        }

        public AnnotationMouseListener(String type) {
            this.corpusID = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
            this.annotationSetID = LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets") ? null : (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.corpusName = (String)LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem();
            this.annotationSetName = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
            this.toolTipManager = ToolTipManager.sharedInstance();
            this.isTooltipSet = false;
            this.type = type;
        }

        @Override
        public MouseInputAdapter createListener(String ... parameters) {
            switch (parameters.length) {
                case 3: {
                    return new AnnotationMouseListener(parameters[1]);
                }
                case 5: {
                    return new AnnotationMouseListener(parameters[1], parameters[2], parameters[3]);
                }
            }
            return null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.dismissDelay = this.toolTipManager.getDismissDelay();
            this.initialDelay = this.toolTipManager.getInitialDelay();
            this.reshowDelay = this.toolTipManager.getReshowDelay();
            this.enabled = this.toolTipManager.isEnabled();
            Component component = e.getComponent();
            if (this.feature != null && !this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel label = (JLabel)component;
                String toolTip = label.getToolTipText();
                toolTip = toolTip == null || toolTip.equals("") ? "" : toolTip.replaceAll("</?html>", "") + "<br>";
                toolTip = "<html>" + toolTip + "Right click to get statistics.</html>";
                label.setToolTipText(toolTip);
            }
            this.toolTipManager.setDismissDelay(Integer.MAX_VALUE);
            this.toolTipManager.setInitialDelay(0);
            this.toolTipManager.setReshowDelay(0);
            this.toolTipManager.setEnabled(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.toolTipManager.setDismissDelay(this.dismissDelay);
            this.toolTipManager.setInitialDelay(this.initialDelay);
            this.toolTipManager.setReshowDelay(this.reshowDelay);
            this.toolTipManager.setEnabled(this.enabled);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && this.type != null && this.feature != null) {
                this.createPopup(e);
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            } else if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.updateQuery();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && this.type != null && this.feature != null) {
                this.createPopup(e);
                this.mousePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void updateQuery() {
            int row;
            int caretPosition = LuceneDataStoreSearchGUI.this.queryTextArea.getCaretPosition();
            String query = LuceneDataStoreSearchGUI.this.queryTextArea.getText();
            String queryMiddle = this.type != null && this.feature != null ? ((row = LuceneDataStoreSearchGUI.this.findStackRow(2, this.type, 3, this.feature)) >= 0 && !LuceneDataStoreSearchGUI.this.stackRows[row][1].equals("") ? "{" + LuceneDataStoreSearchGUI.this.stackRows[row][1] + "==\"" + this.text + "\"}" : "{" + this.type + "." + this.feature + "==\"" + this.text + "\"}") : (this.type != null ? "{" + this.type + "}" : this.text);
            String queryLeft = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? query.substring(0, caretPosition) : query.substring(0, LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart());
            String queryRight = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? query.substring(caretPosition, query.length()) : query.substring(LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd(), query.length());
            LuceneDataStoreSearchGUI.this.queryTextArea.setText(queryLeft + queryMiddle + queryRight);
        }

        private int checkStatistics() {
            boolean found = false;
            int numRow = 0;
            for (int row = 0; row < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount(); ++row) {
                String oldDescription = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(row, 0);
                String oldToolTip = (String)LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.get(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowViewToModel(numRow));
                if (oldDescription.equals(this.description) && oldToolTip.equals(this.toolTip)) {
                    found = true;
                    break;
                }
                ++numRow;
            }
            return found ? numRow : -1;
        }

        private void addStatistics(String kind, int count, int numRow, MouseEvent e) {
            JLabel label = (JLabel)e.getComponent();
            if (!label.getToolTipText().contains(kind)) {
                String toolTip = label.getToolTipText();
                toolTip = toolTip.replaceAll("</?html>", "");
                toolTip = kind + " = " + count + "<br>" + toolTip;
                toolTip = "<html>" + toolTip + "</html>";
                label.setToolTipText(toolTip);
            }
            if ((double)LuceneDataStoreSearchGUI.this.bottomSplitPane.getDividerLocation() / LuceneDataStoreSearchGUI.this.bottomSplitPane.getSize().getWidth() < 0.9) {
                LuceneDataStoreSearchGUI.this.statisticsTabbedPane.setSelectedIndex(1);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.setRowSelectionInterval(numRow, numRow);
                LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.scrollRectToVisible(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getCellRect(numRow, 0, true));
            } else {
                JToolTip tip = label.createToolTip();
                tip.setTipText(kind + " = " + count);
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                final Popup tipWindow = popupFactory.getPopup(label, tip, e.getX() + e.getComponent().getLocationOnScreen().x, e.getY() + e.getComponent().getLocationOnScreen().y);
                tipWindow.show();
                Date timeToRun = new Date(System.currentTimeMillis() + 2000L);
                Timer timer = new Timer("Annic statistics hide tooltip timer", true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        tipWindow.hide();
                    }
                }, timeToRun);
            }
        }

        private void createPopup(final MouseEvent e) {
            this.mousePopup = new JPopupMenu();
            this.menuItem = new JMenuItem("Occurrences in datastore");
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ie) {
                    int count;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "datastore");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "datastore");
                    int numRow = AnnotationMouseListener.this.checkStatistics();
                    if (numRow == -1) {
                        try {
                            count = LuceneDataStoreSearchGUI.this.searcher.freq(AnnotationMouseListener.this.corpusID, AnnotationMouseListener.this.annotationSetID, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, count, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("datastore", count, numRow, e);
                }
            });
            this.mousePopup.add(this.menuItem);
            this.menuItem = new JMenuItem("Occurrences in matches");
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ie) {
                    int count;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "matches");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches");
                    int numRow = AnnotationMouseListener.this.checkStatistics();
                    if (numRow == -1) {
                        try {
                            count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text, true, false);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, count, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("matches", count, numRow, e);
                }
            });
            this.mousePopup.add(this.menuItem);
            this.menuItem = new JMenuItem("Occurrences in contexts");
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ie) {
                    int count;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "contexts");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "contexts");
                    int numRow = AnnotationMouseListener.this.checkStatistics();
                    if (numRow == -1) {
                        try {
                            count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text, false, true);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, count, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("contexts", count, numRow, e);
                }
            });
            this.mousePopup.add(this.menuItem);
            this.menuItem = new JMenuItem("Occurrences in matches+contexts");
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ie) {
                    int count;
                    AnnotationMouseListener.this.description = AnnotationMouseListener.this.descriptionTemplate.replaceFirst("kind", "mch+ctxt");
                    AnnotationMouseListener.this.toolTip = AnnotationMouseListener.this.toolTipTemplate.replaceFirst("kind", "matches+contexts");
                    int numRow = AnnotationMouseListener.this.checkStatistics();
                    if (numRow == -1) {
                        try {
                            count = LuceneDataStoreSearchGUI.this.searcher.freq(LuceneDataStoreSearchGUI.this.results, AnnotationMouseListener.this.type, AnnotationMouseListener.this.feature, AnnotationMouseListener.this.text, true, true);
                        }
                        catch (SearchException se) {
                            se.printStackTrace();
                            return;
                        }
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableModel.addRow(new Object[]{AnnotationMouseListener.this.description, count, ""});
                        LuceneDataStoreSearchGUI.this.oneRowStatisticsTableToolTips.add(AnnotationMouseListener.this.toolTip);
                        numRow = LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.rowModelToView(LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount() - 1);
                    } else {
                        count = (Integer)LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(numRow, 1);
                    }
                    AnnotationMouseListener.this.addStatistics("matches+contexts", count, numRow, e);
                }
            });
            this.mousePopup.add(this.menuItem);
        }
    }

    public class TextMouseListener
    extends AnnotationStack.StackMouseListener {
        String text;
        boolean isTooltipSet = false;

        public TextMouseListener() {
        }

        public TextMouseListener(String text) {
            this.text = text;
        }

        @Override
        public MouseInputAdapter createListener(String ... parameters) {
            return new TextMouseListener(parameters[0]);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (!me.isPopupTrigger() && me.getButton() == 1 && me.getClickCount() == 2) {
                int caretPosition = LuceneDataStoreSearchGUI.this.queryTextArea.getCaretPosition();
                String query = LuceneDataStoreSearchGUI.this.queryTextArea.getText();
                String queryMiddle = this.text;
                String queryLeft = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? query.substring(0, caretPosition) : query.substring(0, LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart());
                String queryRight = LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionStart() == LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd() ? query.substring(caretPosition, query.length()) : query.substring(LuceneDataStoreSearchGUI.this.queryTextArea.getSelectionEnd(), query.length());
                LuceneDataStoreSearchGUI.this.queryTextArea.setText(queryLeft + queryMiddle + queryRight);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (!this.isTooltipSet && component instanceof JLabel) {
                this.isTooltipSet = true;
                JLabel label = (JLabel)component;
                gate.creole.annic.Pattern result = (gate.creole.annic.Pattern)LuceneDataStoreSearchGUI.this.results.get(LuceneDataStoreSearchGUI.this.resultTable.rowViewToModel(LuceneDataStoreSearchGUI.this.resultTable.getSelectionModel().getLeadSelectionIndex()));
                label.setToolTipText("The query that matched this expression was: " + result.getQueryString() + ".");
            }
        }
    }

    protected class ConfigureStackViewAction
    extends AbstractAction {
        public ConfigureStackViewAction() {
            super("Configure", MainFrame.getIcon("Add"));
            super.putValue("ShortDescription", "Configure the view");
            super.putValue("MnemonicKey", 37);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(false);
            LuceneDataStoreSearchGUI.this.configureStackViewFrame.setVisible(true);
        }
    }

    protected class NextResultsAction
    extends AbstractAction {
        public NextResultsAction() {
            super("Next page of " + LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() + " results", MainFrame.getIcon("crystal-clear-action-loopnone"));
            super.putValue("ShortDescription", "Show next page of results.");
            super.putValue("MnemonicKey", 39);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            final BlockingGlassPane blockingGlassPane = new BlockingGlassPane();
            LuceneDataStoreSearchGUI.this.getRootPane().setGlassPane(blockingGlassPane);
            blockingGlassPane.block(true);
            if (LuceneDataStoreSearchGUI.this.results.size() > 0) {
                LuceneDataStoreSearchGUI.this.results.clear();
                LuceneDataStoreSearchGUI.this.resultTableModel.fireTableDataChanged();
            } else {
                LuceneDataStoreSearchGUI.this.updateStackView();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LuceneDataStoreSearchGUI.this.noOfResults = LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue();
                    try {
                        LuceneDataStoreSearchGUI.this.searcher.next(LuceneDataStoreSearchGUI.this.noOfResults);
                        LuceneDataStoreSearchGUI.this.updateViews();
                    }
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                            LuceneDataStoreSearchGUI.this.updateViews();
                        }
                        catch (Throwable throwable) {
                            LuceneDataStoreSearchGUI.this.updateViews();
                            LuceneDataStoreSearchGUI.this.pageOfResults++;
                            LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                            if (LuceneDataStoreSearchGUI.this.searcher.getHits().length < LuceneDataStoreSearchGUI.this.noOfResults) {
                                LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                            }
                            LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    blockingGlassPane.block(false);
                                }
                            });
                            throw throwable;
                        }
                        LuceneDataStoreSearchGUI.this.pageOfResults++;
                        LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                        if (LuceneDataStoreSearchGUI.this.searcher.getHits().length < LuceneDataStoreSearchGUI.this.noOfResults) {
                            LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                        }
                        LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    LuceneDataStoreSearchGUI.this.pageOfResults++;
                    LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                    if (LuceneDataStoreSearchGUI.this.searcher.getHits().length < LuceneDataStoreSearchGUI.this.noOfResults) {
                        LuceneDataStoreSearchGUI.this.nextResultsAction.setEnabled(false);
                    }
                    LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    protected class RefreshAnnotationSetsAndFeaturesAction
    extends AbstractAction {
        public RefreshAnnotationSetsAndFeaturesAction() {
            super("", MainFrame.getIcon("Refresh"));
            super.putValue("ShortDescription", "Reloads annotations types.");
            super.putValue("MnemonicKey", 116);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            final BlockingGlassPane blockingGlassPane = new BlockingGlassPane();
            LuceneDataStoreSearchGUI.this.getRootPane().setGlassPane(blockingGlassPane);
            blockingGlassPane.block(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        LuceneDataStoreSearchGUI.this.updateSetsTypesAndFeatures();
                    }
                    catch (Exception e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    blockingGlassPane.block(false);
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    protected class ExecuteQueryAction
    extends AbstractAction {
        public ExecuteQueryAction() {
            super("Search", MainFrame.getIcon("Search"));
            super.putValue("ShortDescription", "Execute the query.");
            super.putValue("MnemonicKey", 10);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            final BlockingGlassPane blockingGlassPane = new BlockingGlassPane();
            LuceneDataStoreSearchGUI.this.getRootPane().setGlassPane(blockingGlassPane);
            blockingGlassPane.block(true);
            if (LuceneDataStoreSearchGUI.this.results.size() > 0) {
                LuceneDataStoreSearchGUI.this.results.clear();
                LuceneDataStoreSearchGUI.this.resultTableModel.fireTableDataChanged();
            } else {
                LuceneDataStoreSearchGUI.this.updateStackView();
            }
            Map<String, Object> parameters = LuceneDataStoreSearchGUI.this.searcher.getParameters();
            if (parameters == null) {
                parameters = new HashMap<String, Object>();
            }
            if (LuceneDataStoreSearchGUI.this.target instanceof LuceneDataStoreImpl) {
                String corpus2SearchIn = LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem().equals("Entire datastore") ? null : (String)LuceneDataStoreSearchGUI.this.corpusIds.get(LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedIndex() - 1);
                parameters.put("CORPUS_ID", corpus2SearchIn);
            }
            LuceneDataStoreSearchGUI.this.noOfResults = LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue() > LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getMaximum() - 100 ? -1 : Integer.valueOf(LuceneDataStoreSearchGUI.this.numberOfResultsSlider.getValue());
            int contextWindow = LuceneDataStoreSearchGUI.this.contextSizeSlider.getValue();
            String query = LuceneDataStoreSearchGUI.this.queryTextArea.getText().trim();
            Pattern pattern = Pattern.compile("[\\{, ]([^\\{=]+)==");
            Matcher matcher = pattern.matcher(query);
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.end(1);
                int row = LuceneDataStoreSearchGUI.this.findStackRow(1, matcher.group(1));
                if (row < 0) continue;
                query = query.substring(0, matcher.start(1)) + LuceneDataStoreSearchGUI.this.stackRows[row][2] + "." + LuceneDataStoreSearchGUI.this.stackRows[row][3] + query.substring(matcher.end(1));
                matcher = pattern.matcher(query);
            }
            parameters.put("CONTEXT_WINDOW", contextWindow);
            if (LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem().equals("All sets")) {
                parameters.remove("ANNOTATION_SET_ID");
            } else {
                String annotationSet = (String)LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem();
                parameters.put("ANNOTATION_SET_ID", annotationSet);
            }
            final String queryF = query;
            final Map<String, Object> parametersF = parameters;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    try {
                        if (LuceneDataStoreSearchGUI.this.searcher.search(queryF, parametersF)) {
                            LuceneDataStoreSearchGUI.this.searcher.next(LuceneDataStoreSearchGUI.this.noOfResults);
                        }
                        LuceneDataStoreSearchGUI.this.updateViews();
                    }
                    catch (SearchException se) {
                        String[] message;
                        GridBagConstraints gbc;
                        block9: {
                            LuceneDataStoreSearchGUI.this.errorOnLastQuery = true;
                            gbc = new GridBagConstraints();
                            gbc.gridwidth = 0;
                            LuceneDataStoreSearchGUI.this.centerPanel.removeAll();
                            message = se.getMessage().split("\\n");
                            if (message.length != 1) break block9;
                            se.printStackTrace();
                            LuceneDataStoreSearchGUI.this.updateViews();
                            LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                            LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                            LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    blockingGlassPane.block(false);
                                }
                            });
                            return;
                        }
                        JTextArea jta = new JTextArea(message[1]);
                        jta.setForeground(Color.RED);
                        LuceneDataStoreSearchGUI.this.centerPanel.add((Component)jta, gbc);
                        jta = new JTextArea(message[2]);
                        if (message.length > 3) {
                            jta.setText(message[2] + "\n" + message[3]);
                        }
                        jta.setFont(new Font("Monospaced", 0, 12));
                        LuceneDataStoreSearchGUI.this.centerPanel.add((Component)jta, gbc);
                        LuceneDataStoreSearchGUI.this.updateViews();
                        LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                        LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                        LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LuceneDataStoreSearchGUI.this.updateViews();
                        {
                            catch (Throwable throwable) {
                                LuceneDataStoreSearchGUI.this.updateViews();
                                LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                                LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                                LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                throw throwable;
                            }
                        }
                        LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                        LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                        LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    LuceneDataStoreSearchGUI.this.pageOfResults = 1;
                    LuceneDataStoreSearchGUI.this.titleResults.setText("Page " + LuceneDataStoreSearchGUI.this.pageOfResults + " (" + LuceneDataStoreSearchGUI.this.searcher.getHits().length + " results)");
                    LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    protected class ClearQueryAction
    extends AbstractAction {
        public ClearQueryAction() {
            super("Clear", MainFrame.getIcon("Delete"));
            super.putValue("ShortDescription", "Clear the query text box.");
            super.putValue("MnemonicKey", 8);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LuceneDataStoreSearchGUI.this.queryTextArea.setText("");
            LuceneDataStoreSearchGUI.this.queryTextArea.requestFocusInWindow();
        }
    }

    protected class ExportResultsAction
    extends AbstractAction {
        public ExportResultsAction() {
            super("Export", MainFrame.getIcon("Download"));
            super.putValue("ShortDescription", "Export results and statistics to a HTML file.");
            super.putValue("MnemonicKey", 69);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            XJFileChooser fileChooser = MainFrame.getFileChooser() != null ? MainFrame.getFileChooser() : new XJFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setDialogTitle("Choose a file to export the results");
            fileChooser.setFileSelectionMode(0);
            ExtensionFileFilter filter = new ExtensionFileFilter("HTML files", "html");
            fileChooser.addChoosableFileFilter(filter);
            String location = LuceneDataStoreSearchGUI.this.target instanceof SerialDataStore ? '-' + ((SerialDataStore)LuceneDataStoreSearchGUI.this.target).getStorageDir().getName() : "";
            String fileName = "Datastore" + location + ".html";
            fileChooser.setFileName(fileName);
            fileChooser.setResource(LuceneDataStoreSearchGUI.class.getName());
            int res = fileChooser.showSaveDialog(LuceneDataStoreSearchGUI.this);
            if (res != 0) {
                return;
            }
            File saveFile = fileChooser.getSelectedFile();
            BufferedWriter bw = null;
            try {
                int col;
                int row;
                int col2;
                String nl = Strings.getNl();
                bw = new BufferedWriter(new FileWriter(saveFile));
                bw.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"" + nl);
                bw.write("\"http://www.w3.org/TR/html4/loose.dtd\">" + nl);
                bw.write("<HTML><HEAD><TITLE>Annic Results and Statistics</TITLE>" + nl);
                bw.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">" + nl);
                bw.write("</HEAD><BODY>" + nl + nl);
                bw.write("<H1 align=\"center\">Annic Results and Statistics</H1>" + nl);
                bw.write("<H2>Parameters</H2>" + nl);
                bw.write("<UL><LI>Corpus: <B>" + LuceneDataStoreSearchGUI.this.corpusToSearchIn.getSelectedItem() + "</B></LI>" + nl);
                bw.write("<LI>Annotation set: <B>" + LuceneDataStoreSearchGUI.this.annotationSetsToSearchIn.getSelectedItem() + "</B></LI>" + nl);
                bw.write("<LI>Query Issued: <B>" + LuceneDataStoreSearchGUI.this.searcher.getQuery() + "</B></LI>");
                bw.write("<LI>Context Window: <B>" + LuceneDataStoreSearchGUI.this.searcher.getParameters().get("CONTEXT_WINDOW") + "</B></LI>" + nl);
                bw.write("</UL>" + nl + nl);
                bw.write("<H2>Results</H2>" + nl);
                bw.write("<TABLE border=\"1\"><TBODY>" + nl);
                bw.write("<TR>");
                for (col2 = 0; col2 < LuceneDataStoreSearchGUI.this.resultTable.getColumnCount(); ++col2) {
                    bw.write("<TH>" + LuceneDataStoreSearchGUI.this.resultTable.getColumnName(col2) + "</TH>" + nl);
                }
                bw.write("</TR>" + nl);
                for (row = 0; row < LuceneDataStoreSearchGUI.this.resultTable.getRowCount(); ++row) {
                    bw.write("<TR>");
                    for (col = 0; col < LuceneDataStoreSearchGUI.this.resultTable.getColumnCount(); ++col) {
                        bw.write("<TD>" + ((String)LuceneDataStoreSearchGUI.this.resultTable.getValueAt(row, col)).replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;") + "</TD>" + nl);
                    }
                    bw.write("</TR>" + nl);
                }
                bw.write("</TBODY></TABLE>" + nl + nl);
                bw.write("<H2>Global Statistics</H2>");
                bw.write("<TABLE border=\"1\"><TBODY>" + nl);
                bw.write("<TR>");
                for (col2 = 0; col2 < LuceneDataStoreSearchGUI.this.globalStatisticsTable.getColumnCount(); ++col2) {
                    bw.write("<TH>" + LuceneDataStoreSearchGUI.this.globalStatisticsTable.getColumnName(col2) + "</TH>" + nl);
                }
                bw.write("</TR>" + nl);
                for (row = 0; row < LuceneDataStoreSearchGUI.this.globalStatisticsTable.getRowCount(); ++row) {
                    bw.write("<TR>");
                    for (col = 0; col < LuceneDataStoreSearchGUI.this.globalStatisticsTable.getColumnCount(); ++col) {
                        bw.write("<TD>" + LuceneDataStoreSearchGUI.this.globalStatisticsTable.getValueAt(row, col) + "</TD>" + nl);
                    }
                    bw.write("</TR>" + nl);
                }
                bw.write("</TBODY></TABLE>" + nl + nl);
                bw.write("<H2>One item Statistics</H2>" + nl);
                bw.write("<TABLE border=\"1\"><TBODY>" + nl);
                bw.write("<TR>");
                for (col2 = 0; col2 < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getColumnCount() - 1; ++col2) {
                    bw.write("<TH>" + LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getColumnName(col2) + "</TH>" + nl);
                }
                bw.write("</TR>" + nl);
                for (row = 0; row < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getRowCount(); ++row) {
                    bw.write("<TR>");
                    for (col = 0; col < LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getColumnCount() - 1; ++col) {
                        bw.write("<TD>" + LuceneDataStoreSearchGUI.this.oneRowStatisticsTable.getValueAt(row, col) + "</TD>" + nl);
                    }
                    bw.write("</TR>" + nl);
                }
                bw.write("</TBODY></TABLE>" + nl + nl);
                bw.write("<P><BR></P><HR>" + nl);
                bw.write("</BODY>" + nl);
                bw.write("</HTML>");
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

