/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.AnnotationSchema;
import gate.creole.FeatureSchema;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.FeatureMapListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.ResizableVisualResource;
import gate.swing.XJTable;
import gate.util.FeatureBearer;
import gate.util.GateRuntimeException;
import gate.util.ObjectComparator;
import gate.util.Strings;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

@CreoleResource(name="Resource Features", guiType=GuiType.SMALL, resourceDisplayed="gate.util.FeatureBearer")
public class FeaturesSchemaEditor
extends XJTable
implements ResizableVisualResource,
FeatureMapListener {
    FeatureMap targetFeatures;
    FeatureBearer target;
    Feature emptyFeature;
    AnnotationSchema schema;
    FeaturesTableModel featuresModel;
    List<Feature> featureList;
    FeatureEditorRenderer featureEditorRenderer;
    FeaturesSchemaEditor instance = this;
    private static final int COLUMNS = 4;
    private static final int ICON_COL = 0;
    private static final int NAME_COL = 1;
    private static final int VALUE_COL = 2;
    private static final int DELETE_COL = 3;
    private static final Color REQUIRED_WRONG = Color.RED;
    private static final Color OPTIONAL_WRONG = Color.ORANGE;
    protected FeatureMap features;
    protected Handle handle;

    public void setTargetFeatures(FeatureMap features) {
        if (this.targetFeatures != null) {
            this.targetFeatures.removeFeatureMapListener(this);
        }
        this.targetFeatures = features;
        this.populate();
        if (this.targetFeatures != null) {
            this.targetFeatures.addFeatureMapListener(this);
        }
    }

    @Override
    public void cleanup() {
        if (this.targetFeatures != null) {
            this.targetFeatures.removeFeatureMapListener(this);
            this.targetFeatures = null;
        }
        this.target = null;
        this.schema = null;
    }

    @Override
    public void setTarget(Object target) {
        this.target = (FeatureBearer)target;
        this.setTargetFeatures(this.target.getFeatures());
    }

    public void setSchema(AnnotationSchema schema) {
        this.schema = schema;
        this.featuresModel.fireTableRowsUpdated(0, this.featureList.size() - 1);
    }

    @Override
    public void featureMapUpdated() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FeaturesSchemaEditor.this.populate();
            }
        });
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        this.featureList = new ArrayList<Feature>();
        this.emptyFeature = new Feature("", null);
        this.featureList.add(this.emptyFeature);
        this.initGUI();
        return this;
    }

    protected void initGUI() {
        this.featuresModel = new FeaturesTableModel();
        this.setModel(this.featuresModel);
        this.setTableHeader(null);
        this.setSortable(false);
        this.setAutoResizeMode(0);
        this.setShowGrid(false);
        this.setBackground(this.getBackground());
        this.setIntercellSpacing(new Dimension(2, 2));
        this.setTabSkipUneditableCell(true);
        this.setEditCellAsSoonAsFocus(true);
        this.featureEditorRenderer = new FeatureEditorRenderer();
        this.getColumnModel().getColumn(0).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(1).setCellEditor(this.featureEditorRenderer);
        this.getColumnModel().getColumn(2).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(2).setCellEditor(this.featureEditorRenderer);
        this.getColumnModel().getColumn(3).setCellRenderer(this.featureEditorRenderer);
        this.getColumnModel().getColumn(3).setCellEditor(this.featureEditorRenderer);
        this.setSurrendersFocusOnKeystroke(true);
        this.setFocusCycleRoot(true);
        HashSet<AWTKeyStroke> keySet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        keySet.remove(KeyStroke.getKeyStroke("control TAB"));
        this.setFocusTraversalKeys(0, keySet);
        keySet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(1));
        keySet.remove(KeyStroke.getKeyStroke("shift control TAB"));
        this.setFocusTraversalKeys(1, keySet);
        keySet.clear();
        keySet.add(KeyStroke.getKeyStroke("control TAB"));
        this.setFocusTraversalKeys(2, keySet);
        keySet.clear();
        keySet.add(KeyStroke.getKeyStroke("shift control TAB"));
        this.setFocusTraversalKeys(3, keySet);
    }

    protected void populate() {
        this.featureList.clear();
        HashSet<Object> fNames = new HashSet<Object>();
        if (this.targetFeatures != null) {
            fNames.addAll(this.targetFeatures.keySet());
            if (this.schema != null && this.schema.getFeatureSchemaSet() != null) {
                for (FeatureSchema featureSchema : this.schema.getFeatureSchemaSet()) {
                    fNames.add(featureSchema.getFeatureName());
                }
            }
            ArrayList featureNames = new ArrayList(fNames);
            Collections.sort(featureNames);
            for (Object featureName : featureNames) {
                String name = (String)featureName;
                Object value = this.targetFeatures.get(name);
                this.featureList.add(new Feature(name, value));
            }
        }
        if (!this.featureList.contains(this.emptyFeature)) {
            this.featureList.add(this.emptyFeature);
        }
        this.featuresModel.fireTableDataChanged();
    }

    @Override
    public FeatureMap getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(FeatureMap features) {
        this.features = features;
    }

    @Override
    public void setHandle(Handle handle) {
        this.handle = handle;
    }

    @Override
    public Object getParameterValue(String paramaterName) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, paramaterName);
    }

    @Override
    public void setParameterValue(String paramaterName, Object parameterValue) throws ResourceInstantiationException {
        BeanInfo resBeanInf = null;
        try {
            resBeanInf = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception e) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + e);
        }
        AbstractResource.setParameterValue(this, resBeanInf, paramaterName, parameterValue);
    }

    @Override
    public void setParameterValues(FeatureMap parameters) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, parameters);
    }

    protected class FeatureEditorRenderer
    extends DefaultCellEditor
    implements TableCellRenderer {
        JLabel requiredIconLabel;
        JLabel optionalIconLabel;
        JLabel nonSchemaIconLabel;
        JComboBox editorCombo;
        JComboBox rendererCombo;
        JButton deleteButton;
        ObjectComparator defaultComparator;
        Color defaultBackground;

        @Override
        public boolean stopCellEditing() {
            this.editorCombo.setSelectedItem(this.editorCombo.getEditor().getItem());
            return super.stopCellEditing();
        }

        public FeatureEditorRenderer() {
            super(new JComboBox());
            this.defaultComparator = new ObjectComparator();
            this.editorCombo = (JComboBox)this.editorComponent;
            this.editorCombo.setModel(new DefaultComboBoxModel());
            this.editorCombo.setEditable(true);
            this.editorCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FeatureEditorRenderer.this.stopCellEditing();
                }
            });
            this.defaultBackground = this.editorCombo.getEditor().getEditorComponent().getBackground();
            this.rendererCombo = new JComboBox(){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.rendererCombo.setModel(new DefaultComboBoxModel());
            this.rendererCombo.setEditable(true);
            this.rendererCombo.setOpaque(false);
            this.requiredIconLabel = new JLabel(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.requiredIconLabel.setIcon(MainFrame.getIcon("r"));
            this.requiredIconLabel.setOpaque(false);
            this.requiredIconLabel.setToolTipText("Required feature");
            this.optionalIconLabel = new JLabel(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.optionalIconLabel.setIcon(MainFrame.getIcon("o"));
            this.optionalIconLabel.setOpaque(false);
            this.optionalIconLabel.setToolTipText("Optional feature");
            this.nonSchemaIconLabel = new JLabel(MainFrame.getIcon("c")){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.nonSchemaIconLabel.setToolTipText("Custom feature");
            this.nonSchemaIconLabel.setOpaque(false);
            this.deleteButton = new JButton(MainFrame.getIcon("delete"));
            this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
            this.deleteButton.setToolTipText("Delete");
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = FeaturesSchemaEditor.this.getEditingRow();
                    if (row < 0) {
                        return;
                    }
                    Feature feature = FeaturesSchemaEditor.this.featureList.get(row);
                    if (feature == FeaturesSchemaEditor.this.emptyFeature) {
                        feature.value = null;
                    } else {
                        FeaturesSchemaEditor.this.featureList.remove(row);
                        FeaturesSchemaEditor.this.targetFeatures.remove(feature.name);
                        FeaturesSchemaEditor.this.featuresModel.fireTableRowsDeleted(row, row);
                    }
                }
            });
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(row);
            switch (column) {
                case 0: {
                    return feature.isSchemaFeature() ? (feature.isRequired() ? this.requiredIconLabel : this.optionalIconLabel) : this.nonSchemaIconLabel;
                }
                case 1: {
                    this.prepareCombo(this.rendererCombo, row, column);
                    this.rendererCombo.getPreferredSize();
                    return this.rendererCombo;
                }
                case 2: {
                    this.prepareCombo(this.rendererCombo, row, column);
                    return this.rendererCombo;
                }
                case 3: {
                    return this.deleteButton;
                }
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            switch (column) {
                case 1: {
                    this.prepareCombo(this.editorCombo, row, column);
                    return this.editorCombo;
                }
                case 2: {
                    this.prepareCombo(this.editorCombo, row, column);
                    return this.editorCombo;
                }
                case 3: {
                    return this.deleteButton;
                }
            }
            return null;
        }

        protected void prepareCombo(JComboBox combo, int row, int column) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(row);
            DefaultComboBoxModel comboModel = (DefaultComboBoxModel)combo.getModel();
            comboModel.removeAllElements();
            switch (column) {
                case 1: {
                    ArrayList<String> fNames = new ArrayList<String>();
                    if (FeaturesSchemaEditor.this.schema != null && FeaturesSchemaEditor.this.schema.getFeatureSchemaSet() != null) {
                        Iterator<FeatureSchema> fSchemaIter = FeaturesSchemaEditor.this.schema.getFeatureSchemaSet().iterator();
                        while (fSchemaIter.hasNext()) {
                            fNames.add(fSchemaIter.next().getFeatureName());
                        }
                    }
                    if (!fNames.contains(feature.name)) {
                        fNames.add(feature.name);
                    }
                    Collections.sort(fNames);
                    Iterator nameIter = fNames.iterator();
                    while (nameIter.hasNext()) {
                        comboModel.addElement(nameIter.next());
                    }
                    combo.getEditor().getEditorComponent().setBackground(this.defaultBackground);
                    combo.setSelectedItem(feature.name);
                    break;
                }
                case 2: {
                    Set<Object> permValues;
                    ArrayList<Object> fValues = new ArrayList<Object>();
                    if (feature.isSchemaFeature() && (permValues = FeaturesSchemaEditor.this.schema.getFeatureSchema(feature.name).getPermittedValues()) != null) {
                        fValues.addAll(permValues);
                    }
                    if (!fValues.contains(feature.value)) {
                        fValues.add(feature.value);
                    }
                    Collections.sort(fValues, this.defaultComparator);
                    Iterator valIter = fValues.iterator();
                    while (valIter.hasNext()) {
                        comboModel.addElement(valIter.next());
                    }
                    combo.getEditor().getEditorComponent().setBackground(feature.isCorrect() ? this.defaultBackground : (feature.isRequired() ? REQUIRED_WRONG : OPTIONAL_WRONG));
                    combo.setSelectedItem(feature.value);
                    break;
                }
            }
        }
    }

    protected class FeaturesTableModel
    extends AbstractTableModel {
        protected FeaturesTableModel() {
        }

        @Override
        public int getRowCount() {
            return FeaturesSchemaEditor.this.featureList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(row);
            switch (column) {
                case 1: {
                    return feature.name;
                }
                case 2: {
                    return feature.value;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 1 || columnIndex == 3;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Feature feature = FeaturesSchemaEditor.this.featureList.get(rowIndex);
            if (feature == null) {
                return;
            }
            if (FeaturesSchemaEditor.this.targetFeatures == null) {
                FeaturesSchemaEditor.this.targetFeatures = Factory.newFeatureMap();
                FeaturesSchemaEditor.this.target.setFeatures(FeaturesSchemaEditor.this.targetFeatures);
                FeaturesSchemaEditor.this.setTargetFeatures(FeaturesSchemaEditor.this.targetFeatures);
            }
            switch (columnIndex) {
                case 2: {
                    if (feature.value != null && feature.value.equals(aValue)) {
                        return;
                    }
                    feature.value = aValue;
                    if (feature.name == null || feature.name.length() <= 0) break;
                    FeaturesSchemaEditor.this.targetFeatures.removeFeatureMapListener(FeaturesSchemaEditor.this.instance);
                    FeaturesSchemaEditor.this.targetFeatures.put(feature.name, aValue);
                    FeaturesSchemaEditor.this.targetFeatures.addFeatureMapListener(FeaturesSchemaEditor.this.instance);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FeaturesSchemaEditor.this.editCellAt(FeaturesSchemaEditor.this.getRowCount() - 1, 1);
                        }
                    });
                    break;
                }
                case 1: {
                    int newRow;
                    if (feature.name.equals(aValue)) {
                        return;
                    }
                    FeaturesSchemaEditor.this.targetFeatures.remove(feature.name);
                    feature.name = (String)aValue;
                    FeaturesSchemaEditor.this.targetFeatures.put(feature.name, feature.value);
                    if (feature == FeaturesSchemaEditor.this.emptyFeature) {
                        FeaturesSchemaEditor.this.emptyFeature = new Feature("", null);
                    }
                    FeaturesSchemaEditor.this.populate();
                    for (newRow = 0; newRow < FeaturesSchemaEditor.this.getRowCount() && !FeaturesSchemaEditor.this.getValueAt(newRow, 1).equals(feature.name); ++newRow) {
                    }
                    final int newRowF = newRow;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FeaturesSchemaEditor.this.editCellAt(newRowF, 2);
                        }
                    });
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new GateRuntimeException("Non editable cell!");
                }
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Value";
                }
                case 3: {
                    return "";
                }
            }
            return null;
        }
    }

    protected class Feature {
        String name;
        Object value;

        public Feature(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        boolean isSchemaFeature() {
            return FeaturesSchemaEditor.this.schema != null && FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name) != null;
        }

        boolean isCorrect() {
            if (FeaturesSchemaEditor.this.schema == null) {
                return true;
            }
            FeatureSchema fSchema = FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name);
            return fSchema == null || fSchema.getPermittedValues() == null || fSchema.getPermittedValues().contains(this.value);
        }

        boolean isRequired() {
            if (FeaturesSchemaEditor.this.schema == null) {
                return false;
            }
            FeatureSchema fSchema = FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name);
            return fSchema != null && fSchema.isRequired();
        }

        Object getDefaultValue() {
            if (FeaturesSchemaEditor.this.schema == null) {
                return null;
            }
            FeatureSchema fSchema = FeaturesSchemaEditor.this.schema.getFeatureSchema(this.name);
            return fSchema == null ? null : fSchema.getFeatureValue();
        }
    }
}

