/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.ontology;

import gate.creole.ontology.InvalidURIException;
import gate.creole.ontology.OBNodeID;
import gate.creole.ontology.ONodeID;
import gate.creole.ontology.OURI;

@Deprecated
public class URI
implements OURI,
ONodeID,
OBNodeID {
    protected String namespace;
    protected String aResourceName;
    protected String uri;
    protected boolean isAnonymousResource;

    public URI(String uri, boolean isAnonymousResource) throws InvalidURIException {
        this.isAnonymousResource = isAnonymousResource;
        if (!this.isAnonymousResource) {
            int index = uri.lastIndexOf(35);
            if (index < 0) {
                index = uri.lastIndexOf(47);
                if (index < 0) {
                    throw new InvalidURIException("Invalid URI :" + uri);
                }
                if (index + 2 > uri.length()) {
                    throw new InvalidURIException("Invalid URI :" + uri);
                }
                this.uri = uri;
                this.namespace = "";
                this.aResourceName = uri.substring(index + 1, uri.length());
            } else {
                this.uri = uri;
                this.namespace = uri.substring(0, index + 1);
                this.aResourceName = uri.substring(index + 1, uri.length());
            }
        } else {
            this.uri = uri;
            this.namespace = "";
            this.aResourceName = "[" + uri + "]";
        }
    }

    @Override
    public String getNameSpace() {
        return this.namespace;
    }

    @Override
    public String getResourceName() {
        return this.aResourceName;
    }

    @Override
    public String toString() {
        return this.uri;
    }

    @Override
    public boolean isAnonymousResource() {
        return this.isAnonymousResource;
    }

    @Override
    public int compareTo(ONodeID other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof URI) {
            return this.uri.equals(((URI)other).uri);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public String toTurtle() {
        if (this.isAnonymousResource()) {
            if (this.uri.startsWith("_:")) {
                return this.uri;
            }
            return "_:" + this.uri;
        }
        return "<" + this.uri + ">";
    }

    @Override
    public void validate() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public String toDisplayString() {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public String toASCIIString() {
        throw new UnsupportedOperationException("Method not implemented");
    }
}

