/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.PhraseQuery;
import gate.creole.annic.apache.lucene.search.TermQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatsCalculator {
    public static int freq(IndexSearcher searcher, String corpusToSearchIn, String annotationSetToSearchIn, String annotationType, String featureName, String value) throws SearchException {
        try {
            corpusToSearchIn = corpusToSearchIn == null || corpusToSearchIn.trim().length() == 0 ? null : corpusToSearchIn.trim();
            String string = annotationSetToSearchIn = annotationSetToSearchIn == null || annotationSetToSearchIn.trim().length() == 0 ? null : annotationSetToSearchIn.trim();
            if (annotationType == null) {
                throw new SearchException("Annotation Type cannot be null");
            }
            Term term = null;
            if (featureName == null && value == null) {
                term = new Term("contents", annotationType, "*");
            } else if (featureName != null && value == null) {
                term = new Term("contents", annotationType + "." + featureName, "**");
            } else {
                if (featureName == null) {
                    throw new SearchException("FeatureName cannot be null");
                }
                term = new Term("contents", value, annotationType + "." + featureName);
            }
            TermQuery tq = new TermQuery(term);
            boolean useBooleanQuery = false;
            BooleanQuery bq = new BooleanQuery();
            if (corpusToSearchIn != null) {
                PhraseQuery cq = new PhraseQuery();
                cq.add(new Term("CORPUS_ID", corpusToSearchIn), 0, true);
                bq.add(cq, true, false);
                useBooleanQuery = true;
            }
            if (annotationSetToSearchIn != null) {
                PhraseQuery aq = new PhraseQuery();
                aq.add(new Term("ANNOTATION_SET_ID", annotationSetToSearchIn), 0, true);
                bq.add(aq, true, false);
                useBooleanQuery = true;
            }
            Hits corpusHits = null;
            if (useBooleanQuery) {
                bq.add(tq, true, false);
                corpusHits = searcher.search(bq);
            } else {
                corpusHits = searcher.search(tq);
            }
            ArrayList[] firstTermPositions = searcher.getFirstTermPositions();
            if (firstTermPositions[0].size() == 0) {
                int n = 0;
                return n;
            }
            int size = 0;
            for (int hitIndex = 0; hitIndex < corpusHits.length(); ++hitIndex) {
                int index = firstTermPositions[0].indexOf(new Integer(corpusHits.id(hitIndex)));
                Integer freq = (Integer)firstTermPositions[4].get(index);
                size += freq.intValue();
            }
            int n = size;
            return n;
        }
        catch (IOException ioe) {
            throw new SearchException(ioe);
        }
        finally {
            searcher.initializeTermPositions();
        }
    }

    public static int freq(IndexSearcher searcher, String corpusToSearchIn, String annotationSetToSearchIn, String annotationType) throws SearchException {
        return StatsCalculator.freq(searcher, corpusToSearchIn, annotationSetToSearchIn, annotationType, null, null);
    }

    public static int freq(IndexSearcher searcher, String corpusToSearchIn, String annotationSetToSearchIn, String annotationType, String featureName) throws SearchException {
        return StatsCalculator.freq(searcher, corpusToSearchIn, annotationSetToSearchIn, annotationType, featureName, null);
    }

    public static int freq(List<Hit> patternsToSearchIn, String annotationType, String feature, String value, boolean inMatchedSpan, boolean inContext) throws SearchException {
        if (patternsToSearchIn == null || patternsToSearchIn.isEmpty()) {
            return 0;
        }
        if (!inMatchedSpan && !inContext) {
            throw new SearchException("Both inMatchedSpan and inContext cannot be set to false");
        }
        int count = 0;
        for (Hit aResult1 : patternsToSearchIn) {
            Pattern aResult = (Pattern)aResult1;
            List<Object> annots = new ArrayList();
            if (inMatchedSpan && !inContext) {
                annots = aResult.getPatternAnnotations(aResult.getStartOffset(), aResult.getEndOffset());
            } else if (!inMatchedSpan && inContext) {
                annots = aResult.getPatternAnnotations(aResult.getLeftContextStartOffset(), aResult.getStartOffset());
                annots.addAll(aResult.getPatternAnnotations(aResult.getEndOffset(), aResult.getRightContextEndOffset()));
            } else {
                annots = Arrays.asList(aResult.getPatternAnnotations());
            }
            if (annots.isEmpty()) continue;
            List<PatternAnnotation> subAnnots = null;
            subAnnots = value == null ? StatsCalculator.getPatternAnnotations(annots, annotationType, feature) : StatsCalculator.getPatternAnnotations(annots, annotationType, feature, value);
            count += subAnnots.size();
        }
        return count;
    }

    public static int freq(List<Hit> patternsToSearchIn, String annotationType, boolean inMatchedSpan, boolean inContext) throws SearchException {
        if (patternsToSearchIn == null || patternsToSearchIn.isEmpty()) {
            return 0;
        }
        if (!inMatchedSpan && !inContext) {
            throw new SearchException("Both inMatchedSpan and inContext cannot be set to false");
        }
        int count = 0;
        for (Hit aResult1 : patternsToSearchIn) {
            Pattern aResult = (Pattern)aResult1;
            List<Object> annots = new ArrayList();
            if (inMatchedSpan && !inContext) {
                annots = aResult.getPatternAnnotations(aResult.getStartOffset(), aResult.getEndOffset());
            } else if (!inMatchedSpan && inContext) {
                annots = aResult.getPatternAnnotations(aResult.getLeftContextStartOffset(), aResult.getStartOffset());
                annots.addAll(aResult.getPatternAnnotations(aResult.getEndOffset(), aResult.getRightContextEndOffset()));
            } else {
                annots = Arrays.asList(aResult.getPatternAnnotations());
            }
            if (annots.isEmpty()) continue;
            List<PatternAnnotation> subAnnots = StatsCalculator.getPatternAnnotations(annots, annotationType);
            count += subAnnots.size();
        }
        return count;
    }

    public static Map<String, Integer> freqForAllValues(List<Hit> patternsToSearchIn, String annotationType, String feature, boolean inMatchedSpan, boolean inContext) throws SearchException {
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        if (patternsToSearchIn == null || patternsToSearchIn.isEmpty()) {
            return toReturn;
        }
        if (!inMatchedSpan && !inContext) {
            throw new SearchException("Both inMatchedSpan and inContext cannot be set to false");
        }
        for (Hit aResult1 : patternsToSearchIn) {
            Pattern aResult = (Pattern)aResult1;
            List<Object> annots = new ArrayList();
            if (inMatchedSpan && !inContext) {
                annots = aResult.getPatternAnnotations(aResult.getStartOffset(), aResult.getEndOffset());
            } else if (!inMatchedSpan && inContext) {
                annots = aResult.getPatternAnnotations(aResult.getLeftContextStartOffset(), aResult.getStartOffset());
                annots.addAll(aResult.getPatternAnnotations(aResult.getEndOffset(), aResult.getRightContextEndOffset()));
            } else {
                annots = Arrays.asList(aResult.getPatternAnnotations());
            }
            if (annots.isEmpty()) continue;
            List<PatternAnnotation> subAnnots = StatsCalculator.getPatternAnnotations(annots, annotationType, feature);
            for (PatternAnnotation pa : subAnnots) {
                String uniqueKey = pa.getFeatures().get(feature);
                Integer counter = (Integer)toReturn.get(uniqueKey);
                if (counter == null) {
                    counter = 1;
                    toReturn.put(uniqueKey, counter);
                    continue;
                }
                counter = counter + 1;
                toReturn.put(uniqueKey, counter);
            }
        }
        return toReturn;
    }

    private static List<PatternAnnotation> getPatternAnnotations(List<PatternAnnotation> annotations, String type, String feature, String value) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            Map<String, String> features;
            PatternAnnotation ga1 = annotations.get(i);
            if (!ga1.getType().equals(type) || (features = ga1.getFeatures()) == null || !features.keySet().contains(feature) || !features.get(feature).equals(value)) continue;
            annots.add(ga1);
        }
        return annots;
    }

    private static List<PatternAnnotation> getPatternAnnotations(List<PatternAnnotation> annotations, String type, String feature) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            Map<String, String> features;
            PatternAnnotation ga1 = annotations.get(i);
            if (!ga1.getType().equals(type) || (features = ga1.getFeatures()) == null || !features.keySet().contains(feature)) continue;
            annots.add(ga1);
        }
        return annots;
    }

    private static List<PatternAnnotation> getPatternAnnotations(List<PatternAnnotation> annotations, String type) {
        ArrayList<PatternAnnotation> annots = new ArrayList<PatternAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            PatternAnnotation ga1 = annotations.get(i);
            if (!ga1.getType().equals(type)) continue;
            annots.add(ga1);
        }
        return annots;
    }
}

