/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.RAMFile;

class RAMInputStream
extends InputStream
implements Cloneable {
    private RAMFile file;
    private int pointer = 0;

    public RAMInputStream(RAMFile f) {
        this.file = f;
        this.length = this.file.length;
    }

    @Override
    public void readInternal(byte[] dest, int destOffset, int len) {
        int bytesToCopy;
        int start = this.pointer;
        for (int remainder = len; remainder != 0; remainder -= bytesToCopy) {
            int bufferNumber = start / 1024;
            int bufferOffset = start % 1024;
            int bytesInBuffer = 1024 - bufferOffset;
            bytesToCopy = bytesInBuffer >= remainder ? remainder : bytesInBuffer;
            byte[] buffer = (byte[])this.file.buffers.elementAt(bufferNumber);
            System.arraycopy(buffer, bufferOffset, dest, destOffset, bytesToCopy);
            destOffset += bytesToCopy;
            start += bytesToCopy;
        }
        this.pointer += len;
    }

    @Override
    public void close() {
    }

    @Override
    public void seekInternal(long pos) {
        this.pointer = (int)pos;
    }
}

