/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.DocumentExporter;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ParameterList;
import gate.creole.metadata.Sharable;
import gate.util.AbstractFeatureBearer;
import gate.util.GateException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ResourceData
extends AbstractFeatureBearer {
    private static final long serialVersionUID = -1275311260404979762L;
    protected static final boolean DEBUG = false;
    protected static final String DEFAULT_LR_ICON = "lr";
    protected static final String DEFAULT_PR_ICON = "pr";
    protected static final String DEFAULT_EXPORTER_ICON = "DocumentExporter";
    protected static final String DEFAULT_OTHER_ICON = "application";
    private int refCount = 1;
    protected String name;
    protected String icon;
    protected List<Resource> instantiationStack = new CopyOnWriteArrayList<Resource>();
    protected List<Resource> unmodifiableInstantiationStack = Collections.unmodifiableList(this.instantiationStack);
    protected String className;
    protected String interfaceName;
    protected Class<? extends Resource> resourceClass;
    protected String jarFileName;
    protected URL jarFileUrl;
    protected String xmlFileName;
    protected URL xmlFileUrl;
    protected String comment;
    protected String helpURL;
    protected ParameterList parameterList = new ParameterList();
    protected boolean autoLoading;
    protected boolean priv = false;
    protected boolean tool = false;
    protected String validityMessage = "";
    public static final int NULL_GUI = 0;
    public static final int LARGE_GUI = 1;
    public static final int SMALL_GUI = 2;
    protected int guiType = 0;
    protected boolean isMainView = false;
    protected String resourceDisplayed = null;
    protected String annotationTypeDisplayed = null;
    protected Collection<String> sharableProperties = new HashSet<String>();

    public int getReferenceCount() {
        return this.refCount;
    }

    public int reduceReferenceCount() {
        return --this.refCount;
    }

    public int increaseReferenceCount() {
        return ++this.refCount;
    }

    public String toString() {
        int noInst = this.instantiationStack == null ? 0 : this.instantiationStack.size();
        return "ResourceDataImpl, name=" + this.name + "; className=" + this.className + "; jarFileName=" + this.jarFileName + "; jarFileUrl=" + this.jarFileUrl + "; xmlFileName=" + this.xmlFileName + "; xmlFileUrl=" + this.xmlFileUrl + "; isAutoLoading=" + this.autoLoading + "; numberInstances=" + noInst + "; isPrivate=" + this.priv + "; isTool=" + this.tool + "; validityMessage=" + this.validityMessage + "; interfaceName=" + this.interfaceName + "; guiType=" + this.guiType + "; mainViewer=" + this.isMainView + "; resourceDisplayed=" + this.resourceDisplayed + "; annotationTypeDisplayed=" + this.annotationTypeDisplayed + "; parameterList=" + this.parameterList + "; features=" + this.features;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.name.equals(((ResourceData)other).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        if (this.icon == null) {
            this.icon = this.guessIcon();
        }
        return this.icon;
    }

    protected String guessIcon() {
        if (this.className == null) {
            return DEFAULT_OTHER_ICON;
        }
        if (this.resourceClass == null) {
            return DEFAULT_OTHER_ICON;
        }
        if (LanguageResource.class.isAssignableFrom(this.resourceClass)) {
            return DEFAULT_LR_ICON;
        }
        if (ProcessingResource.class.isAssignableFrom(this.resourceClass)) {
            return DEFAULT_PR_ICON;
        }
        if (DocumentExporter.class.isAssignableFrom(this.resourceClass)) {
            return DEFAULT_EXPORTER_ICON;
        }
        return DEFAULT_OTHER_ICON;
    }

    public List<Resource> getInstantiations() {
        return this.unmodifiableInstantiationStack;
    }

    public void addInstantiation(Resource resource) {
        this.instantiationStack.add(0, resource);
    }

    public boolean removeInstantiation(Resource resource) {
        return this.instantiationStack.remove(resource);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setResourceClass(Class<? extends Resource> resourceClass) {
        this.resourceClass = resourceClass;
    }

    public Class<? extends Resource> getResourceClass() throws ClassNotFoundException {
        if (this.resourceClass == null) {
            this.resourceClass = this.getResourceClassLoader().loadClass(this.className).asSubclass(Resource.class);
        }
        return this.resourceClass;
    }

    public ClassLoader getResourceClassLoader() {
        return Gate.getClassLoader().getDisposableClassLoader(this.xmlFileUrl.toExternalForm());
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileUrl(URL jarFileUrl) {
        this.jarFileUrl = jarFileUrl;
    }

    public URL getJarFileUrl() {
        return this.jarFileUrl;
    }

    public void setXmlFileUrl(URL xmlFileUrl) {
        this.xmlFileUrl = xmlFileUrl;
    }

    public URL getXmlFileUrl() {
        return this.xmlFileUrl;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setAutoLoading(boolean autoLoading) {
        this.autoLoading = autoLoading;
    }

    public boolean isAutoLoading() {
        return this.autoLoading;
    }

    public void setPrivate(boolean priv) {
        this.priv = priv;
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public void setTool(boolean tool) {
        this.tool = tool;
    }

    public boolean isTool() {
        return this.tool;
    }

    public boolean isValid() {
        boolean valid = true;
        this.validityMessage = "";
        if (this.getClassName() == null || this.getClassName().length() == 0) {
            this.validityMessage = this.validityMessage + "No class name provided for the resource!";
            valid = false;
        }
        if (this.getName() == null || this.getName().length() == 0) {
            this.setName(this.className.substring(this.className.lastIndexOf(46) + 1));
        }
        return valid;
    }

    public String getValidityMessage() {
        return this.validityMessage;
    }

    public void setGuiType(int aGuiType) {
        this.guiType = aGuiType;
    }

    public int getGuiType() {
        return this.guiType;
    }

    public void setIsMainView(boolean mainView) {
        this.isMainView = mainView;
    }

    public boolean isMainView() {
        return this.isMainView;
    }

    public void setResourceDisplayed(String aResourceDisplayed) {
        this.resourceDisplayed = aResourceDisplayed;
    }

    public String getResourceDisplayed() {
        return this.resourceDisplayed;
    }

    public void setAnnotationTypeDisplayed(String anAnnotationTypeDisplayed) {
        this.annotationTypeDisplayed = anAnnotationTypeDisplayed;
    }

    public String getAnnotationTypeDisplayed() {
        return this.annotationTypeDisplayed;
    }

    public Collection<String> getSharableProperties() {
        return this.sharableProperties;
    }

    public void init() throws Exception {
        this.determineSharableProperties(this.getResourceClass(), new HashSet<String>());
    }

    private void determineSharableProperties(Class<?> cls, Collection<String> hiddenPropertyNames) throws GateException {
        Sharable sharableAnnot;
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(cls);
        }
        catch (IntrospectionException e) {
            throw new GateException("Failed to introspect " + cls, e);
        }
        for (Method method : cls.getDeclaredMethods()) {
            sharableAnnot = method.getAnnotation(Sharable.class);
            if (sharableAnnot == null) continue;
            PropertyDescriptor propDescriptor = null;
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!method.equals(pd.getWriteMethod())) continue;
                propDescriptor = pd;
                break;
            }
            if (propDescriptor == null) {
                throw new GateException("@Sharable annotation found on " + method + ", but only Java Bean property setters may have this annotation.");
            }
            if (propDescriptor.getReadMethod() == null) {
                throw new GateException("@Sharable annotation found on " + method + ", but no matching getter was found.");
            }
            String propName = propDescriptor.getName();
            if (!sharableAnnot.value()) {
                hiddenPropertyNames.add(propName);
                continue;
            }
            if (hiddenPropertyNames.contains(propName)) continue;
            this.sharableProperties.add(propName);
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            sharableAnnot = ((Field)accessibleObject).getAnnotation(Sharable.class);
            if (sharableAnnot == null) continue;
            String propName = ((Field)accessibleObject).getName();
            PropertyDescriptor propDescriptor = null;
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!propName.equals(pd.getName())) continue;
                propDescriptor = pd;
                break;
            }
            if (propDescriptor == null || propDescriptor.getReadMethod() == null || propDescriptor.getWriteMethod() == null) {
                throw new GateException("@Sharable annotation found on " + accessibleObject + " without matching Java Bean getter and setter.");
            }
            if (!sharableAnnot.value()) {
                hiddenPropertyNames.add(propName);
                continue;
            }
            if (hiddenPropertyNames.contains(propName)) continue;
            this.sharableProperties.add(propName);
        }
        if (cls.getSuperclass() != null) {
            this.determineSharableProperties(cls.getSuperclass(), hiddenPropertyNames);
        }
        for (AnnotatedElement annotatedElement : cls.getInterfaces()) {
            this.determineSharableProperties((Class<?>)annotatedElement, hiddenPropertyNames);
        }
    }
}

