/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.CreoleRegister;
import gate.DataStoreRegister;
import gate.Executable;
import gate.Factory;
import gate.FeatureMap;
import gate.GateConstants;
import gate.Resource;
import gate.config.ConfigDataProcessor;
import gate.creole.CreoleRegisterImpl;
import gate.creole.Plugin;
import gate.creole.ir.IREngine;
import gate.event.CreoleListener;
import gate.gui.creole.manager.PluginUpdateManager;
import gate.util.Benchmark;
import gate.util.Files;
import gate.util.GateClassLoader;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import gate.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Gate
implements GateConstants {
    protected static final Logger log = Logger.getLogger(Gate.class);
    public static final int STRINGBUFFER_SIZE = 1024;
    public static final int HASH_STH_SIZE = 4;
    public static final String URI = "http://www.gate.ac.uk";
    protected static final String MIN_JDK_VERSION = "1.8";
    protected static final String ENABLE_BENCHMARKING_FEATURE_NAME = "gate.enable.benchmark";
    private static boolean sandboxed = true;
    protected static boolean initFinished = false;
    private static boolean netConnected = false;
    private static int lastSym;
    private static Set<String> registeredIREngines;
    private static GateClassLoader classLoader;
    private static CreoleRegister creoleRegister;
    private static DataStoreRegister dataStoreRegister;
    private static Executable currentExecutable;
    private static OptionsMap userConfig;
    private static OptionsMap originalUserConfig;
    private static String userConfigElement;
    private static String nl;
    private static String emptyConfigFile;
    protected static File gateHome;
    private static File siteConfigFile;
    private static File userConfigFile;
    protected static File pluginsHome;
    protected static URL builtinCreoleDir;
    protected static File userSessionFile;
    private static Set<Plugin> knownPlugins;
    protected static List<Plugin> autoloadPlugins;
    private static boolean useXMLSerialization;
    private static final Map<String, EventListener> listeners;

    public static boolean isSandboxed() {
        return sandboxed;
    }

    public static void runInSandbox(boolean sandboxed) {
        if (initFinished) {
            throw new IllegalStateException("Sandbox status cannot be changed after GATE has been initialised!");
        }
        Gate.sandboxed = sandboxed;
    }

    public static String getMinJdkVersion() {
        return MIN_JDK_VERSION;
    }

    public static void init() throws GateException {
        if (!sandboxed) {
            Gate.initLocalPaths();
        }
        if (System.getProperty(ENABLE_BENCHMARKING_FEATURE_NAME) != null && System.getProperty(ENABLE_BENCHMARKING_FEATURE_NAME).equalsIgnoreCase("true")) {
            Benchmark.setBenchmarkingEnabled(true);
        }
        if (builtinCreoleDir == null) {
            String builtinCreoleDirPropertyValue = System.getProperty("gate.builtin.creole.dir");
            if (builtinCreoleDirPropertyValue == null) {
                builtinCreoleDir = Files.getGateResource("/creole/");
            } else {
                String builtinCreoleDirPath = builtinCreoleDirPropertyValue;
                if (!builtinCreoleDirPath.endsWith("/")) {
                    builtinCreoleDirPath = builtinCreoleDirPath + "/";
                }
                try {
                    builtinCreoleDir = new URL(builtinCreoleDirPath);
                }
                catch (MalformedURLException mue) {
                    throw new GateRuntimeException("gate.builtin.creole.dir value \"" + builtinCreoleDirPropertyValue + "\" could not be parsed as either a URL or a file path.");
                }
                log.info((Object)("Using " + builtinCreoleDir + " as built-in CREOLE directory URL"));
            }
        }
        lastSym = 0;
        if (classLoader == null) {
            classLoader = new GateClassLoader("Top-Level GATE ClassLoader", Gate.class.getClassLoader());
        }
        if (creoleRegister == null) {
            creoleRegister = new CreoleRegisterImpl();
        }
        if (knownPlugins == null) {
            knownPlugins = new HashSet<Plugin>();
        }
        if (autoloadPlugins == null) {
            autoloadPlugins = new ArrayList<Plugin>();
        }
        Gate.initCreoleRegister();
        Gate.initDataStoreRegister();
        if (!sandboxed) {
            Gate.initConfigData();
        }
        if (!sandboxed) {
            Gate.initCreoleRepositories();
        }
        dataStoreRegister.addCreoleListener(creoleRegister);
        Factory.addCreoleListener(creoleRegister);
        if (System.getProperty("java.version").compareTo(MIN_JDK_VERSION) < 0) {
            throw new GateException("GATE requires JDK 1.8 or newer");
        }
        initFinished = true;
    }

    public static boolean isInitialised() {
        return initFinished;
    }

    protected static void initLocalPaths() {
        if (userConfigFile == null) {
            String userConfigStr = System.getProperty("gate.user.config");
            userConfigFile = userConfigStr != null && userConfigStr.length() > 0 ? new File(userConfigStr) : new File(Gate.getDefaultUserConfigFileName());
        }
        log.info((Object)("Using " + userConfigFile + " as user configuration file"));
        if (userSessionFile == null) {
            String userSessionStr = System.getProperty("gate.user.session");
            userSessionFile = userSessionStr != null && userSessionStr.length() > 0 ? new File(userSessionStr) : new File(Gate.getDefaultUserSessionFileName());
        }
        log.info((Object)("Using " + userSessionFile + " as user session file"));
    }

    protected static void initCreoleRepositories() {
        String pluginPath = Gate.getUserConfig().getString("Load_plugin_path");
        String prop = System.getProperty("load.plugin.path");
        if (prop != null && prop.length() > 0) {
            pluginPath = prop;
        }
        if (pluginPath == null || pluginPath.length() == 0) {
            return;
        }
        StringTokenizer strTok = new StringTokenizer(pluginPath, ";", false);
        while (strTok.hasMoreTokens()) {
            String aDir = strTok.nextToken();
            try {
                URL aPluginURL = new URL(aDir);
                Plugin.Directory plugin = new Plugin.Directory(aPluginURL);
                Gate.addAutoloadPlugin(plugin);
            }
            catch (MalformedURLException mue) {
                log.error((Object)("Cannot load " + aDir + " CREOLE repository."), (Throwable)mue);
            }
            try {
                Iterator<Plugin> loadPluginsIter = Gate.getAutoloadPlugins().iterator();
                while (loadPluginsIter.hasNext()) {
                    Gate.getCreoleRegister().registerPlugin(loadPluginsIter.next());
                }
            }
            catch (GateException ge) {
                log.error((Object)("Cannot load " + aDir + " CREOLE repository."), (Throwable)ge);
            }
        }
    }

    public static void initCreoleRegister() throws GateException {
        creoleRegister.registerBuiltins();
    }

    public static void initDataStoreRegister() {
        dataStoreRegister = new DataStoreRegister();
    }

    public static void initConfigData() throws GateException {
        FileInputStream configStream;
        URL configURL;
        ConfigDataProcessor configProcessor = new ConfigDataProcessor();
        if (siteConfigFile != null && siteConfigFile.exists()) {
            try {
                configURL = siteConfigFile.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                throw new GateRuntimeException(mue);
            }
            try {
                configStream = new FileInputStream(siteConfigFile);
                configProcessor.parseConfigFile(configStream, configURL);
            }
            catch (IOException e) {
                throw new GateException("Couldn't open site configuration file: " + configURL + " " + e);
            }
        }
        if (userConfigFile != null && userConfigFile.exists()) {
            try {
                configURL = userConfigFile.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                throw new GateRuntimeException(mue);
            }
            try {
                configStream = new FileInputStream(userConfigFile);
                configProcessor.parseConfigFile(configStream, configURL);
            }
            catch (IOException e) {
                throw new GateException("Couldn't open user configuration file: " + configURL + " " + e);
            }
        }
        originalUserConfig.putAll(userConfig);
    }

    public static void registerIREngine(String className) throws GateException, ClassNotFoundException {
        Class<?> aClass = Class.forName(className, true, Gate.getClassLoader());
        if (!IREngine.class.isAssignableFrom(aClass)) {
            throw new GateException(className + " does not implement the " + IREngine.class.getName() + " interface!");
        }
        registeredIREngines.add(className);
    }

    public static boolean unregisterIREngine(String className) {
        return registeredIREngines.remove(className);
    }

    public static Set<String> getRegisteredIREngines() {
        return Collections.unmodifiableSet(registeredIREngines);
    }

    public static File getGateHome() {
        return gateHome;
    }

    public static boolean isGateType(String classname) {
        boolean res = Gate.getCreoleRegister().containsKey(classname);
        if (!res) {
            try {
                Class<?> aClass = Class.forName(classname, true, Gate.getClassLoader());
                res = Resource.class.isAssignableFrom(aClass);
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }
        return res;
    }

    public static boolean getHiddenAttribute(FeatureMap fm) {
        if (fm == null) {
            return false;
        }
        Object value = fm.get("gate.HIDDEN");
        return value != null && value instanceof String && ((String)value).equals("true");
    }

    public static void setHiddenAttribute(FeatureMap fm, boolean hidden) {
        if (hidden) {
            fm.put("gate.HIDDEN", "true");
        } else {
            fm.remove("gate.HIDDEN");
        }
    }

    public static synchronized void addCreoleListener(CreoleListener l) {
        creoleRegister.addCreoleListener(l);
    }

    public static GateClassLoader getClassLoader() {
        return classLoader;
    }

    public static CreoleRegister getCreoleRegister() {
        return creoleRegister;
    }

    public static DataStoreRegister getDataStoreRegister() {
        return dataStoreRegister;
    }

    public static synchronized void setExecutable(Executable executable) {
        if (executable == null) {
            currentExecutable = executable;
        } else {
            while (Gate.getExecutable() != null) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    throw new GateRuntimeException(ie.toString());
                }
            }
            currentExecutable = executable;
        }
    }

    public static synchronized Executable getExecutable() {
        return currentExecutable;
    }

    public static synchronized String genSym() {
        StringBuffer buff = new StringBuffer(Integer.toHexString(lastSym++).toUpperCase());
        for (int i = buff.length(); i <= 4; ++i) {
            buff.insert(0, '0');
        }
        return buff.toString();
    }

    public static String getUserConfigElement() {
        return userConfigElement;
    }

    public static File getSiteConfigFile() {
        String gateConfigProperty;
        if (siteConfigFile == null && (gateConfigProperty = System.getProperty("gate.config")) != null) {
            siteConfigFile = new File(gateConfigProperty);
        }
        return siteConfigFile;
    }

    public static void setSiteConfigFile(File siteConfigFile) {
        Gate.siteConfigFile = siteConfigFile;
    }

    public static String getEmptyConfigFile() {
        return emptyConfigFile;
    }

    public static OptionsMap getUserConfig() {
        return userConfig;
    }

    public static OptionsMap getOriginalUserConfig() {
        return originalUserConfig;
    }

    public static void writeUserConfig() throws GateException {
        if (sandboxed) {
            return;
        }
        File configFile = Gate.getUserConfigFile();
        try {
            if (!configFile.exists()) {
                FileOutputStream fos = new FileOutputStream(configFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                writer.write(emptyConfigFile);
                writer.close();
            }
            Files.updateXmlElement(configFile, userConfigElement, userConfig.getStringMap());
        }
        catch (IOException e) {
            throw new GateException("problem writing user gate.xml: " + nl + e.toString());
        }
    }

    public static String getDefaultUserConfigFileName() {
        String filePrefix = "";
        if (Gate.runningOnUnix()) {
            filePrefix = ".";
        }
        String userConfigName = System.getProperty("user.home") + Strings.getFileSep() + filePrefix + "gate.xml";
        return userConfigName;
    }

    public static String getDefaultUserSessionFileName() {
        String filePrefix = "";
        if (Gate.runningOnUnix()) {
            filePrefix = ".";
        }
        String userSessionName = System.getProperty("user.home") + Strings.getFileSep() + filePrefix + "gate.session";
        return userSessionName;
    }

    public static boolean runningOnUnix() {
        return Strings.getFileSep().equals("/");
    }

    public static boolean runningOnMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    public static Set<Plugin> getKnownPlugins() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        plugins.addAll(knownPlugins);
        plugins.addAll(PluginUpdateManager.getDefaultPlugins());
        return plugins;
    }

    public static void addKnownPlugin(Plugin plugin) {
        if (knownPlugins.contains(plugin)) {
            return;
        }
        if (PluginUpdateManager.getDefaultPlugins().contains(plugin)) {
            return;
        }
        knownPlugins.add(plugin);
    }

    public static URL normaliseCreoleUrl(URL url) {
        String separator;
        String urlName = url.toExternalForm();
        if (urlName.endsWith(separator = "/")) {
            return url;
        }
        urlName = urlName + separator;
        try {
            return new URL(urlName);
        }
        catch (MalformedURLException mue) {
            throw new GateRuntimeException(mue);
        }
    }

    public static List<Plugin> getAutoloadPlugins() {
        return autoloadPlugins;
    }

    public static void addAutoloadPlugin(Plugin plugin) {
        if (autoloadPlugins.contains(plugin)) {
            return;
        }
        Gate.addKnownPlugin(plugin);
        autoloadPlugins.add(plugin);
    }

    public static Set<Plugin> getPlugins(String resourceClassName) {
        HashSet<Plugin> dirs = new HashSet<Plugin>();
        for (Plugin plugin : knownPlugins) {
            for (ResourceInfo rInfo : plugin.getResourceInfoList()) {
                if (!rInfo.resourceClassName.equals(resourceClassName)) continue;
                dirs.add(plugin);
            }
        }
        return dirs;
    }

    public static void removeKnownPlugin(Plugin plugin) {
        knownPlugins.remove(plugin);
        autoloadPlugins.remove(plugin);
        creoleRegister.unregisterPlugin(plugin);
    }

    public static void removeAutoloadPlugin(Plugin plugin) {
        autoloadPlugins.remove(plugin);
    }

    public static void setGateHome(File gateHome) {
        if (Gate.gateHome != null) {
            throw new IllegalStateException("gateHome has already been set");
        }
        Gate.gateHome = gateHome;
    }

    public static void setPluginsHome(File pluginsHome) {
        if (Gate.pluginsHome != null) {
            throw new IllegalStateException("pluginsHome has already been set");
        }
        Gate.pluginsHome = pluginsHome;
    }

    public static File getPluginsHome() {
        return pluginsHome;
    }

    public static void setUserConfigFile(File userConfigFile) {
        if (Gate.userConfigFile != null) {
            throw new IllegalStateException("userConfigFile has already been set");
        }
        Gate.userConfigFile = userConfigFile;
    }

    public static File getUserConfigFile() {
        return userConfigFile;
    }

    public static void setBuiltinCreoleDir(URL builtinCreoleDir) {
        if (Gate.builtinCreoleDir != null) {
            throw new IllegalStateException("builtinCreoleDir has already been set");
        }
        Gate.builtinCreoleDir = builtinCreoleDir;
    }

    public static URL getBuiltinCreoleDir() {
        return builtinCreoleDir;
    }

    public static void setUserSessionFile(File newUserSessionFile) {
        if (userSessionFile != null) {
            throw new IllegalStateException("userSessionFile has already been set");
        }
        userSessionFile = newUserSessionFile;
    }

    public static File getUserSessionFile() {
        return userSessionFile;
    }

    public static void setUseXMLSerialization(boolean useXMLSerialization) {
        Gate.useXMLSerialization = useXMLSerialization;
    }

    public static boolean getUseXMLSerialization() {
        return useXMLSerialization;
    }

    public static Map<String, EventListener> getListeners() {
        return listeners;
    }

    static {
        registeredIREngines = new HashSet<String>();
        classLoader = null;
        creoleRegister = null;
        dataStoreRegister = null;
        userConfig = new OptionsMap();
        originalUserConfig = new OptionsMap();
        userConfigElement = "GATECONFIG";
        nl = Strings.getNl();
        emptyConfigFile = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + nl + "<!-- " + "gate.xml" + ": GATE configuration data -->" + nl + "<GATE>" + nl + "" + nl + "<!-- NOTE: the next element may be overwritten by the GUI!!! -->" + nl + "<" + userConfigElement + "/>" + nl + "" + nl + "</GATE>" + nl;
        useXMLSerialization = true;
        listeners = new HashMap<String, EventListener>();
    }

    public static class ResourceInfo {
        protected String resourceClassName;
        protected String resourceName;
        protected String resourceComment;

        public ResourceInfo(String name, String className, String comment) {
            this.resourceClassName = className;
            this.resourceName = name;
            this.resourceComment = comment;
        }

        public String toString() {
            return this.resourceName + " (" + this.resourceClassName + ")";
        }

        public String getResourceClassName() {
            return this.resourceClassName;
        }

        public String getResourceComment() {
            return this.resourceComment;
        }

        public void setResourceComment(String resourceComment) {
            this.resourceComment = resourceComment;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }
    }
}

