/*
 * Decompiled with CFR 0.152.
 */
package gate.xml;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.DocumentFormat;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.DocumentImpl;
import gate.corpora.TestDocument;
import gate.creole.SerialAnalyserController;
import gate.util.Files;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestXml
extends TestCase {
    private static final boolean DEBUG = false;
    private static String workingEncoding = "UTF-8";

    public TestXml(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void testGateDocumentToAndFromXmlWithDifferentKindOfFormats() throws Exception {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        URL uRL = null;
        uRL = Gate.getUrl("tests/xml/xces.xml");
        TestXml.assertTrue((String)"Coudn't create a URL object for tests/xml/xces.xml ", (uRL != null ? 1 : 0) != 0);
        linkedList.add(uRL);
        linkedList2.add(" an XML document ");
        uRL = Gate.getUrl("tests/xml/Sentence.xml");
        TestXml.assertTrue((String)"Coudn't create a URL object for tests/xml/Sentence.xml", (uRL != null ? 1 : 0) != 0);
        linkedList.add(uRL);
        linkedList2.add(" an XML document ");
        uRL = Gate.getUrl("tests/html/test1.htm");
        TestXml.assertTrue((String)"Coudn't create a URL object for tests/html/test.htm", (uRL != null ? 1 : 0) != 0);
        linkedList.add(uRL);
        linkedList2.add(" an HTML document ");
        uRL = Gate.getUrl("tests/rtf/Sample.rtf");
        TestXml.assertTrue((String)"Coudn't create a URL object for defg ", (uRL != null ? 1 : 0) != 0);
        linkedList.add(uRL);
        linkedList2.add(" a RTF document ");
        uRL = Gate.getUrl("tests/email/test2.eml");
        TestXml.assertTrue((String)"Coudn't create a URL object for defg ", (uRL != null ? 1 : 0) != 0);
        linkedList.add(uRL);
        linkedList2.add(" an EMAIL document ");
        Iterator iterator = linkedList.iterator();
        Iterator iterator2 = linkedList2.iterator();
        while (iterator.hasNext()) {
            this.runCompleteTestWithAFormat((URL)iterator.next(), (String)iterator2.next());
        }
    }

    private void runCompleteTestWithAFormat(URL uRL, String string) throws Exception {
        Document document = null;
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        featureMap.put("markupAware", "false");
        document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        TestXml.assertTrue((String)("Coudn't create a GATE document instance for " + uRL.toString() + " Can't continue."), (document != null ? 1 : 0) != 0);
        DocumentFormat documentFormat = null;
        documentFormat = DocumentFormat.getDocumentFormat(document, document.getSourceUrl());
        TestXml.assertTrue((String)("Fail to recognize " + uRL.toString() + " as being " + string + " !"), (documentFormat != null ? 1 : 0) != 0);
        documentFormat.unpackMarkup(document);
        TestDocument.verifyNodeIdConsistency(document);
        this.verifyAnnotationIDGenerator(document);
        long l = document.getContent().size();
        int n = document.getAnnotations().size();
        File file = null;
        file = Files.writeTempFile(document.toXml(), workingEncoding);
        TestXml.assertTrue((String)"The temp GATE XML file is null. Can't continue.", (file != null ? 1 : 0) != 0);
        Document document2 = null;
        document2 = Factory.newDocument(file.toURI().toURL(), workingEncoding);
        TestXml.assertTrue((String)("Coudn't create a GATE document instance for " + file.toURI().toURL().toString() + " Can't continue."), (document2 != null ? 1 : 0) != 0);
        DocumentFormat documentFormat2 = null;
        documentFormat2 = DocumentFormat.getDocumentFormat(document2, document2.getSourceUrl());
        TestXml.assertTrue((String)("Fail to recognize " + file.toURI().toURL().toString() + " as being a GATE XML document !"), (documentFormat2 != null ? 1 : 0) != 0);
        documentFormat2.unpackMarkup(document2);
        TestDocument.verifyNodeIdConsistency(document2);
        long l2 = document.getContent().size();
        int n2 = document.getAnnotations().size();
        TestXml.assertTrue((String)"Exporting as GATE XML resulted in document content size lost. Something went wrong.", (l == l2 ? 1 : 0) != 0);
        TestXml.assertTrue((String)("Exporting as GATE XML resulted in annotation lost. No. of annotations missing =  " + Math.abs(n - n2)), (n == n2 ? 1 : 0) != 0);
        this.verifyAnnotationIDGenerator(document2);
        file.delete();
    }

    public void testUnpackMarkup() throws Exception {
        Object var1_1 = null;
        Document document = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        hashMap.put("S", "\n");
        hashMap.put("s", "\n");
        document = Factory.newDocument(Gate.getUrl("tests/xml/xces.xml"), workingEncoding);
        AnnotationSet annotationSet = document.getAnnotations("Original markups");
        TestXml.assertEquals((String)("For " + document.getSourceUrl() + " the number of annotations" + " should be:758"), (int)758, (int)annotationSet.size());
        TestDocument.verifyNodeIdConsistency(document);
        this.verifyAnnotationIDGenerator(document);
    }

    public void testAnnotationConsistencyForSaveAsXml() throws Exception {
        String string = Files.getGateResourceAsString("gate.ac.uk/tests/xml/gateTestSaveAsXML.xml");
        Document document = Factory.newDocument(string);
        this.verifyAnnotationIDGenerator(document);
        SerialAnalyserController serialAnalyserController = (SerialAnalyserController)PersistenceManager.loadObjectFromFile(new File(new File(Gate.getPluginsHome(), "ANNIE"), "ANNIE_with_defaults.gapp"));
        TestXml.assertTrue((String)"ANNIE not loaded!", (serialAnalyserController != null ? 1 : 0) != 0);
        Corpus corpus = Factory.newCorpus("test");
        corpus.add(document);
        serialAnalyserController.setCorpus(corpus);
        serialAnalyserController.execute();
        File file = Files.writeTempFile(document.toXml(), workingEncoding);
        System.out.println("Saved to temp file :" + file.toURI().toURL());
        Document document2 = Factory.newDocument(file.toURI().toURL(), workingEncoding);
        this.verifyAnnotationIDGenerator(document2);
        Map map = this.buildID2AnnotMap(document);
        Map map2 = this.buildID2AnnotMap(document2);
        this.verifyIDConsistency(map, map2);
        Map map3 = this.buildMatchesMap(document);
        for (Integer n : map3.keySet()) {
            Annotation annotation = (Annotation)map.get(n);
            TestXml.assertTrue((String)("Couldn't find an original annot with ID=" + n), (annotation != null ? 1 : 0) != 0);
            Annotation annotation2 = (Annotation)map2.get(n);
            TestXml.assertTrue((String)("Couldn't find a reloaded annot with ID=" + n), (annotation2 != null ? 1 : 0) != 0);
            this.compareAnnot(annotation, annotation2);
            List list = (List)map3.get(n);
            for (Integer n2 : list) {
                Annotation annotation3 = (Annotation)map.get(n2);
                TestXml.assertTrue((String)("Couldn't find an original annot with ID=" + n2), (annotation3 != null ? 1 : 0) != 0);
                Annotation annotation4 = (Annotation)map2.get(n2);
                TestXml.assertTrue((String)("Couldn't find a reloaded annot with ID=" + n2), (annotation4 != null ? 1 : 0) != 0);
                this.compareAnnot(annotation3, annotation4);
            }
        }
        file.delete();
    }

    private Map buildMatchesMap(Document document) {
        HashMap hashMap = new HashMap();
        AnnotationSet annotationSet = document.getAnnotations();
        this.helperBuildMatchesMap(annotationSet, hashMap);
        if (document.getNamedAnnotationSets() != null) {
            Iterator<AnnotationSet> iterator = document.getNamedAnnotationSets().values().iterator();
            while (iterator.hasNext()) {
                this.helperBuildMatchesMap(iterator.next(), hashMap);
            }
        }
        return hashMap;
    }

    private void helperBuildMatchesMap(AnnotationSet annotationSet, Map map) {
        for (Annotation annotation : annotationSet) {
            List list;
            FeatureMap featureMap = annotation.getFeatures();
            if (featureMap == null || (list = (List)featureMap.get("matches")) == null) continue;
            Integer n = annotation.getId();
            map.put(n, list);
        }
    }

    protected void verifyAnnotationIDGenerator(Document document) {
        Map map = this.buildID2AnnotMap(document);
        if (map == null || map.isEmpty()) {
            return;
        }
        Set set = map.keySet();
        TreeSet treeSet = new TreeSet(set);
        Integer n = (Integer)treeSet.last();
        Integer n2 = ((DocumentImpl)document).getNextAnnotationId();
        TestXml.assertTrue((String)("Annotation ID generator[" + n2 + "] on document [" + document.getSourceUrl() + "] was equal or less than the MAX Annotation ID[" + n + "] on the document." + " This may lead to Annotation ID conflicts."), (n2 > n ? 1 : 0) != 0);
    }

    private void verifyIDConsistency(Map map, Map map2) {
        TestXml.assertEquals((String)"Found a different number of annot in both documents.", (int)map.keySet().size(), (int)map2.keySet().size());
        for (Integer n : map.keySet()) {
            Annotation annotation = (Annotation)map.get(n);
            Annotation annotation2 = (Annotation)map2.get(n);
            TestXml.assertTrue((String)("Annotation with ID=" + n + " was not found in the reloaded document."), (annotation2 != null ? 1 : 0) != 0);
            this.compareAnnot(annotation, annotation2);
        }
    }

    private void compareAnnot(Annotation annotation, Annotation annotation2) {
        TestXml.assertTrue((String)"Found original and reloaded annot without the same ID!", (boolean)annotation.getId().equals(annotation2.getId()));
        TestXml.assertTrue((String)("Found original and reloaded annot without the same TYPE!\nOriginal was [" + annotation.getType() + "] and reloaded was [" + annotation2.getType() + "]."), (boolean)annotation.getType().equals(annotation2.getType()));
        TestXml.assertTrue((String)"Found original and reloaded annot without the same START offset!", (boolean)annotation.getStartNode().getOffset().equals(annotation2.getStartNode().getOffset()));
        TestXml.assertTrue((String)"Found original and reloaded annot without the same END offset!", (boolean)annotation.getEndNode().getOffset().equals(annotation2.getEndNode().getOffset()));
    }

    private Map addAnnotSet2Map(AnnotationSet annotationSet, Map map) {
        for (Annotation annotation : annotationSet) {
            Integer n = annotation.getId();
            TestXml.assertTrue((String)("Found two annotations(one with type = " + annotation.getType() + ")with the same ID=" + n), (!map.keySet().contains(n) ? 1 : 0) != 0);
            map.put(n, annotation);
        }
        return map;
    }

    private Map buildID2AnnotMap(Document document) {
        HashMap hashMap = new HashMap();
        AnnotationSet annotationSet = document.getAnnotations();
        this.addAnnotSet2Map(annotationSet, hashMap);
        if (document.getNamedAnnotationSets() != null) {
            Iterator<AnnotationSet> iterator = document.getNamedAnnotationSets().values().iterator();
            while (iterator.hasNext()) {
                this.addAnnotSet2Map(iterator.next(), hashMap);
            }
        }
        return hashMap;
    }

    public static Test suite() {
        return new TestSuite(TestXml.class);
    }
}

