/*
 * Decompiled with CFR 0.152.
 */
package gate.xml;

import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.DocumentImpl;
import gate.corpora.TestDocument;
import gate.creole.ResourceInstantiationException;
import gate.util.BomStrippingInputStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestRepositioningInfo
extends TestCase {
    private String testFile = "";
    private Document doc = null;

    public TestRepositioningInfo(String string) {
        super(string);
    }

    protected void setUp() {
        this.testFile = TestDocument.getTestServerName() + "tests/test-inline.xml";
        try {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("sourceUrl", new URL(this.testFile));
            featureMap.put("preserveOriginalContent", new Boolean("true"));
            featureMap.put("collectRepositioningInfo", new Boolean("true"));
            this.doc = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        }
        catch (MalformedURLException malformedURLException) {
            TestRepositioningInfo.fail((String)"Document cannot be created ");
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            TestRepositioningInfo.fail((String)"Resources cannot be created for the test document");
        }
    }

    public void tearDown() throws Exception {
        Factory.deleteResource(this.doc);
    }

    public void testRepositioningInfo() throws Exception {
        String string = ((DocumentImpl)this.doc).getEncoding();
        File file = File.createTempFile("test-inline1", "xml");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
        outputStreamWriter.write(this.doc.toXml(null, true));
        outputStreamWriter.flush();
        outputStreamWriter.close();
        BomStrippingInputStreamReader bomStrippingInputStreamReader = new BomStrippingInputStreamReader(new URL(this.testFile).openStream(), string);
        BomStrippingInputStreamReader bomStrippingInputStreamReader2 = new BomStrippingInputStreamReader((InputStream)new FileInputStream(file), string);
        while (true) {
            int n = ((Reader)bomStrippingInputStreamReader).read();
            int n2 = ((Reader)bomStrippingInputStreamReader2).read();
            if (n < 0 || n2 < 0) {
                TestRepositioningInfo.assertTrue((n < 0 && n2 < 0 ? 1 : 0) != 0);
                ((Reader)bomStrippingInputStreamReader).close();
                ((Reader)bomStrippingInputStreamReader2).close();
                file.delete();
                return;
            }
            TestRepositioningInfo.assertEquals((int)n, (int)n2);
        }
    }

    public static Test suite() {
        return new TestSuite(TestRepositioningInfo.class);
    }
}

