/*
 * Decompiled with CFR 0.152.
 */
package gate.util.web;

import gate.AnnotationSet;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.creole.SerialAnalyserController;
import gate.util.GateException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import javax.servlet.ServletContext;

public class WebAnnie {
    public static final String GATE_INIT_KEY = "gate.init";
    public static final String ANNIE_CONTROLLER_KEY = "annie.controller";
    private SerialAnalyserController annieController;
    private String filePath = "";

    private void initAnnie() throws GateException {
        Serializable serializable;
        Serializable serializable2;
        this.annieController = (SerialAnalyserController)Factory.createResource("gate.creole.SerialAnalyserController", Factory.newFeatureMap(), Factory.newFeatureMap(), "ANNIE_" + Gate.genSym());
        ProcessingResource processingResource = (ProcessingResource)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser", Factory.newFeatureMap());
        this.annieController.add(processingResource);
        ProcessingResource processingResource2 = (ProcessingResource)Factory.createResource("gate.creole.splitter.SentenceSplitter", Factory.newFeatureMap());
        this.annieController.add(processingResource2);
        ProcessingResource processingResource3 = (ProcessingResource)Factory.createResource("gate.creole.POSTagger", Factory.newFeatureMap());
        this.annieController.add(processingResource3);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("encoding", "ISO-8859-1");
        try {
            serializable2 = new URL("jar:file:" + this.filePath + "muse.jar!/muse/resources/gazetteer/lists.def");
            featureMap.put("listsURL", serializable2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        serializable2 = (ProcessingResource)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer", featureMap);
        this.annieController.add((ProcessingResource)serializable2);
        FeatureMap featureMap2 = Factory.newFeatureMap();
        try {
            serializable = new URL("jar:file:" + this.filePath + "muse.jar!/muse/resources/grammar/main/main.jape");
            featureMap2.put("grammarURL", serializable);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        serializable = (ProcessingResource)Factory.createResource("gate.creole.ANNIETransducer", featureMap2);
        this.annieController.add((ProcessingResource)serializable);
        ProcessingResource processingResource4 = (ProcessingResource)Factory.createResource("gate.creole.orthomatcher.OrthoMatcher", Factory.newFeatureMap());
        this.annieController.add(processingResource4);
    }

    public String process(ServletContext servletContext, String string, String[] stringArray) throws GateException, IOException {
        if (servletContext.getAttribute(GATE_INIT_KEY) == null) {
            Gate.setLocalWebServer(false);
            Gate.setNetConnected(false);
            System.setProperty("java.protocol.handler.pkgs", "gate.util.protocols");
            Gate.init();
            servletContext.setAttribute(GATE_INIT_KEY, (Object)"true");
        }
        if (servletContext.getAttribute(ANNIE_CONTROLLER_KEY) == null) {
            this.filePath = servletContext.getInitParameter("muse.path");
            this.initAnnie();
            servletContext.setAttribute(ANNIE_CONTROLLER_KEY, (Object)this.annieController);
        } else {
            this.annieController = (SerialAnalyserController)servletContext.getAttribute(ANNIE_CONTROLLER_KEY);
        }
        Corpus corpus = (Corpus)Factory.createResource("gate.corpora.CorpusImpl");
        URL uRL = new URL(string);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        corpus.add(document);
        this.annieController.setCorpus(corpus);
        this.annieController.execute();
        AnnotationSet annotationSet = document.getAnnotations();
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            AnnotationSet annotationSet2 = annotationSet.get(hashSet);
            string2 = document.toXml(annotationSet2, true);
        } else {
            string2 = document.toXml();
        }
        Factory.deleteResource(document);
        Factory.deleteResource(corpus);
        return string2;
    }
}

