/*
 * Decompiled with CFR 0.152.
 */
package gate.util.spring;

import gate.Gate;
import gate.util.GateException;
import gate.util.spring.ExtraGatePlugin;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Init
implements BeanFactoryAware {
    private static final Logger log = Logger.getLogger(Init.class);
    private List<Resource> plugins;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setGateHome(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setGateHome(resource.getFile());
        }
    }

    public void setPluginsHome(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setPluginsHome(resource.getFile());
        }
    }

    public void setSiteConfigFile(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setSiteConfigFile(resource.getFile());
        }
    }

    public void setUserConfigFile(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setUserConfigFile(resource.getFile());
        }
    }

    public void setBuiltinCreoleDir(Resource resource) throws IOException {
        if (!Gate.isInitialised()) {
            Gate.setBuiltinCreoleDir(resource.getURL());
        }
    }

    public void setPreloadPlugins(List<Resource> list) {
        this.plugins = list;
    }

    public void init() throws Exception {
        Resource resource;
        if (!Gate.isInitialised()) {
            log.info((Object)"Initialising GATE");
            Gate.init();
        } else {
            log.info((Object)"GATE already initialised");
        }
        if (this.plugins != null && !this.plugins.isEmpty()) {
            resource = this.plugins.iterator();
            while (resource.hasNext()) {
                Resource resource2 = (Resource)resource.next();
                log.debug((Object)("Loading preload-plugin " + resource2));
                this.loadPlugin(resource2);
            }
        }
        if (this.beanFactory instanceof ListableBeanFactory) {
            for (Resource resource3 : resource = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), ExtraGatePlugin.class)) {
                Resource resource4 = ((ExtraGatePlugin)this.beanFactory.getBean((String)resource3, ExtraGatePlugin.class)).getLocation();
                if (resource4 == null) continue;
                log.debug((Object)("Loading extra-plugin " + resource4));
                this.loadPlugin(resource4);
            }
        }
    }

    private void loadPlugin(Resource resource) throws GateException, IOException, MalformedURLException {
        File file = null;
        try {
            file = resource.getFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file == null) {
            Gate.getCreoleRegister().registerDirectories(resource.getURL());
        } else {
            Gate.getCreoleRegister().registerDirectories(file.toURI().toURL());
        }
    }
}

