/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.DataStoreRegister;
import gate.Factory;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.gui.MainFrame;
import gate.gui.OkCancelDialog;
import gate.persist.JDBCDataStore;
import gate.persist.PersistenceException;
import gate.security.AccessController;
import gate.security.AccessControllerImpl;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.util.persistence.DSPersistence;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import junit.framework.Assert;

public class JDBCDSPersistence
extends DSPersistence {
    protected String userName;
    protected String userGroup;

    public void extractDataFromSource(Object object) throws PersistenceException {
        if (!(object instanceof JDBCDataStore)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + JDBCDataStore.class.getName() + " objects!\n" + object.getClass().getName() + " is not a " + JDBCDataStore.class.getName());
        }
        super.extractDataFromSource(object);
        JDBCDataStore jDBCDataStore = (JDBCDataStore)object;
        Map map = DataStoreRegister.getSecurityData(jDBCDataStore);
        this.userName = ((User)map.get("user")).getName();
        this.userGroup = ((Group)map.get("group")).getName();
    }

    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        Object object;
        AccessController accessController = null;
        JDBCDataStore jDBCDataStore = null;
        User user = null;
        Group group = null;
        DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
        boolean bl = false;
        Session session = null;
        do {
            block17: {
                try {
                    accessController = new AccessControllerImpl(this.storageUrlString);
                    accessController = Factory.createAccessController(this.storageUrlString);
                    Assert.assertNotNull((Object)accessController);
                    accessController.open();
                    try {
                        Box box = Box.createHorizontalBox();
                        Box box2 = Box.createVerticalBox();
                        box2.add(new JLabel("User name: "));
                        box2.add(new JLabel("Password: "));
                        box2.add(new JLabel("Group: "));
                        box.add(box2);
                        box.add(Box.createHorizontalStrut(20));
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BoxLayout(jPanel, 1));
                        box2 = Box.createVerticalBox();
                        JTextField jTextField = new JTextField(30);
                        jTextField.setText(this.userName);
                        box2.add(jTextField);
                        JPasswordField jPasswordField = new JPasswordField(30);
                        box2.add(jPasswordField);
                        JTextField jTextField2 = new JTextField(30);
                        jTextField2.setText(this.userGroup);
                        box2.add(jTextField2);
                        box.add(box2);
                        if (OkCancelDialog.showDialog(null, box, "Please re-enter login details")) {
                            this.userName = jTextField.getText();
                            object = new String(jPasswordField.getPassword());
                            this.userGroup = jTextField2.getText();
                            if (this.userName.equals("") || ((String)object).equals("") || this.userGroup.equals("")) {
                                JOptionPane.showMessageDialog(null, "You must provide non-empty user name, password and group!", "Login error", 0);
                                bl = false;
                                continue;
                            }
                        } else {
                            try {
                                if (accessController != null) {
                                    accessController.close();
                                }
                                if (jDBCDataStore != null) {
                                    jDBCDataStore.close();
                                }
                            }
                            catch (PersistenceException persistenceException) {
                                JOptionPane.showMessageDialog(MainFrame.getInstance(), "Persistence error!\n " + persistenceException.toString(), "GATE", 0);
                            }
                            throw new PersistenceException("User cancelled!");
                        }
                        group = accessController.findGroup(this.userGroup);
                        user = accessController.findUser(this.userName);
                        session = accessController.login(this.userName, (String)object, group.getID());
                    }
                    catch (SecurityException securityException) {
                        JOptionPane.showMessageDialog(null, "Authentication failed! Incorrect details entred.", "Login error", 0);
                        bl = false;
                        continue;
                    }
                    if (!accessController.isValidSession(session)) {
                        JOptionPane.showMessageDialog(null, "Incorrect session obtained. Probably there is a problem with the database!", "Login error", 0);
                        bl = false;
                    }
                    break block17;
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "User identification error!\n " + securityException.toString(), "GATE", 0);
                    bl = false;
                }
                continue;
            }
            bl = true;
        } while (!bl);
        try {
            jDBCDataStore = (JDBCDataStore)super.createObject();
            try {
                jDBCDataStore.setSession(session);
            }
            catch (SecurityException securityException) {
                throw new PersistenceException(securityException.getMessage());
            }
            object = Factory.newFeatureMap();
            object.put("user", user);
            object.put("group", group);
            DataStoreRegister.addSecurityData(jDBCDataStore, (Map)object);
        }
        catch (PersistenceException persistenceException) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Datastore open error!\n " + persistenceException.toString(), "GATE", 0);
        }
        return jDBCDataStore;
    }
}

