/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.DataStore;
import gate.Factory;
import gate.Gate;
import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.persistence.Persistence;
import gate.util.persistence.PersistenceManager;
import java.net.MalformedURLException;
import java.net.URL;

public class DSPersistence
implements Persistence {
    protected String className;
    protected String storageUrlString;
    protected Object storageUrl;
    static final long serialVersionUID = 5952924943977701708L;

    public void extractDataFromSource(Object object) throws PersistenceException {
        if (!(object instanceof DataStore)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + DataStore.class.getName() + " objects!\n" + object.getClass().getName() + " is not a " + DataStore.class.getName());
        }
        DataStore dataStore = (DataStore)object;
        this.className = dataStore.getClass().getName();
        this.storageUrlString = dataStore.getStorageUrl();
        try {
            this.storageUrl = PersistenceManager.getPersistentRepresentation(new URL(this.storageUrlString));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        if (this.storageUrl != null) {
            this.storageUrlString = ((URL)PersistenceManager.getTransientRepresentation(this.storageUrl)).toExternalForm();
        }
        for (DataStore dataStore : Gate.getDataStoreRegister()) {
            if (!dataStore.getStorageUrl().equals(this.storageUrlString)) continue;
            return dataStore;
        }
        return Factory.openDataStore(this.className, this.storageUrlString);
    }
}

