/*
 * Decompiled with CFR 0.152.
 */
package gate.util.persistence;

import gate.creole.ResourceInstantiationException;
import gate.persist.PersistenceException;
import gate.util.Err;
import gate.util.persistence.Persistence;
import gate.util.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionPersistence
implements Persistence {
    protected List localList;
    protected Class collectionType;
    static final long serialVersionUID = 7908364068699089834L;

    public void extractDataFromSource(Object object) throws PersistenceException {
        if (!(object instanceof Collection)) {
            throw new UnsupportedOperationException(this.getClass().getName() + " can only be used for " + Collection.class.getName() + " objects!\n" + object.getClass().getName() + " is not a " + Collection.class.getName());
        }
        this.collectionType = object.getClass();
        Collection collection = (Collection)object;
        this.localList = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.localList.add(PersistenceManager.getPersistentRepresentation(iterator.next()));
        }
    }

    public Object createObject() throws PersistenceException, ResourceInstantiationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = null;
        try {
            arrayList2 = (ArrayList<Object>)this.collectionType.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList<Object>(this.localList.size());
        }
        for (Object e : this.localList) {
            try {
                arrayList2.add(PersistenceManager.getTransientRepresentation(e));
            }
            catch (PersistenceException persistenceException) {
                arrayList.add(persistenceException.getMessage());
                persistenceException.printStackTrace(Err.getPrintWriter());
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                arrayList.add(resourceInstantiationException.getMessage());
                resourceInstantiationException.printStackTrace(Err.getPrintWriter());
            }
        }
        if (arrayList.size() > 0) {
            throw new PersistenceException("Some resources cannot be restored:\n" + Arrays.toString(arrayList.toArray(new String[arrayList.size()])).replaceAll("[\\]\\[]", "").replaceAll(", ", "\n"));
        }
        return arrayList2;
    }
}

