/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import gate.util.Files;
import gate.util.ant.packager.GappModel;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageGappTask
extends Task {
    public static final Comparator<URL> PATH_COMPARATOR = new Comparator<URL>(){

        @Override
        public int compare(URL uRL, URL uRL2) {
            if (uRL == null) {
                return uRL2 == null ? 0 : -1;
            }
            if (uRL2 == null) {
                return 1;
            }
            return uRL.getPath().compareTo(uRL2.getPath());
        }
    };
    private File destFile;
    private File src;
    private File gateHome;
    private boolean copyPlugins = true;
    private boolean copyResourceDirs = false;
    private List<Path> extraResourcesPaths = new ArrayList<Path>();
    private UnresolvedAction onUnresolved = UnresolvedAction.fail;
    private List<MappingHint> hintTasks = new ArrayList<MappingHint>();
    private Map<URL, String> mappingHints = new LinkedHashMap<URL, String>();

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File file) {
        this.destFile = file;
    }

    public File getSrc() {
        return this.src;
    }

    public void setSrc(File file) {
        this.src = file;
    }

    public File getGateHome() {
        return this.gateHome;
    }

    public void setGateHome(File file) {
        this.gateHome = file;
    }

    public boolean isCopyPlugins() {
        return this.copyPlugins;
    }

    public void setCopyPlugins(boolean bl) {
        this.copyPlugins = bl;
    }

    public boolean isCopyResourceDirs() {
        return this.copyResourceDirs;
    }

    public void setCopyResourceDirs(boolean bl) {
        this.copyResourceDirs = bl;
    }

    public UnresolvedAction getOnUnresolved() {
        return this.onUnresolved;
    }

    public void setOnUnresolved(UnresolvedAction unresolvedAction) {
        this.onUnresolved = unresolvedAction;
    }

    public MappingHint createHint() {
        MappingHint mappingHint = new MappingHint();
        mappingHint.setProject(this.getProject());
        mappingHint.setTaskName(this.getTaskName());
        mappingHint.setLocation(this.getLocation());
        mappingHint.init();
        this.hintTasks.add(mappingHint);
        return mappingHint;
    }

    public void addExtraResourcesPath(Path path) {
        this.extraResourcesPaths.add(path);
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Iterator iOException;
        Iterator iterator2;
        Serializable malformedURLException;
        for (MappingHint object72 : this.hintTasks) {
            object72.perform();
        }
        HashMap hashMap = new HashMap();
        HashMap<URL, URL> hashMap2 = new HashMap<URL, URL>();
        TreeMap<URL, URL> treeMap = new TreeMap<URL, URL>(PATH_COMPARATOR);
        this.log("Packaging gapp file " + this.src);
        GappModel gappModel = null;
        URL uRL = null;
        try {
            malformedURLException = null;
            if (this.gateHome != null) {
                malformedURLException = this.gateHome.toURI().toURL();
            }
            gappModel = new GappModel(this.src.toURI().toURL(), (URL)malformedURLException);
            uRL = this.destFile.toURI().toURL();
            gappModel.setGappFileURL(uRL);
        }
        catch (MalformedURLException malformedURLException2) {
            throw new BuildException("Couldn't convert src or dest file to URL", (Throwable)malformedURLException2, this.getLocation());
        }
        malformedURLException = new TreeSet<URL>(PATH_COMPARATOR);
        malformedURLException.addAll(gappModel.getPluginURLs());
        TreeSet<URL> treeSet = new TreeSet<URL>(PATH_COMPARATOR);
        treeSet.addAll(gappModel.getResourceURLs());
        this.processExtraResourcesPaths(treeSet);
        if (this.mappingHints != null && !this.mappingHints.isEmpty()) {
            iterator2 = treeSet.iterator();
            block26: while (iterator2.hasNext()) {
                iOException = (URL)iterator2.next();
                for (URL uRL2 : this.mappingHints.keySet()) {
                    String string = uRL2.toExternalForm();
                    if (!((URL)((Object)iOException)).equals(uRL2) && (!string.endsWith("/") || !((URL)((Object)iOException)).toExternalForm().startsWith(string))) continue;
                    this.log("Found resource " + iOException + " under mapping hint URL " + uRL2, 3);
                    object3 = this.mappingHints.get(uRL2);
                    object2 = null;
                    if (object3 == null) {
                        this.log("  Converting to absolute URL", 3);
                        object2 = iOException;
                    } else {
                        try {
                            iterator = new URL(uRL, (String)object3);
                            object = PersistenceManager.getRelativePath(uRL2, iOException);
                            object2 = new URL((URL)((Object)iterator), (String)object);
                            hashMap.put(iOException, object2);
                            if (this.copyResourceDirs) {
                                hashMap2.put(new URL((URL)((Object)iOException), "."), new URL((URL)object2, "."));
                            }
                        }
                        catch (MalformedURLException malformedURLException3) {
                            throw new BuildException("Couldn't construct URL relative to " + (String)object3 + " for " + iOException, (Throwable)malformedURLException3, this.getLocation());
                        }
                        this.log("  Relocating to " + object2, 3);
                    }
                    gappModel.updatePathForURL((URL)((Object)iOException), (URL)object2, object3 != null);
                    iterator2.remove();
                    continue block26;
                }
            }
        }
        iterator2 = malformedURLException.iterator();
        while (iterator2.hasNext()) {
            void var10_20;
            void var11_35;
            iOException = (URL)iterator2.next();
            iterator2.remove();
            Object var10_15 = null;
            String string = ((URL)((Object)iOException)).getFile();
            this.log("Processing plugin " + string, 3);
            SortedMap sortedMap = treeMap.headMap((URL)((Object)iOException));
            object3 = null;
            if (!sortedMap.isEmpty()) {
                object3 = sortedMap.lastKey();
            }
            if (object3 != null && ((URL)((Object)iOException)).toExternalForm().startsWith(((URL)object3).toExternalForm())) {
                this.log("  Plugin is located under another plugin " + object3, 3);
                object2 = PersistenceManager.getRelativePath((URL)object3, iOException);
                try {
                    URL uRL3 = new URL(treeMap.get(object3), (String)object2);
                }
                catch (MalformedURLException malformedURLException4) {
                    throw new BuildException("Couldn't construct URL relative to plugins/ for " + iOException, (Throwable)malformedURLException4, this.getLocation());
                }
            }
            boolean bl = false;
            if (string.endsWith("/")) {
                bl = true;
                String string2 = string.substring(string.lastIndexOf(47, string.length() - 2) + 1, string.length() - 1);
            } else {
                String string3 = string.substring(string.lastIndexOf(47) + 1);
            }
            this.log("  Plugin name is " + (String)var11_35, 3);
            try {
                URL uRL4 = new URL(uRL, "plugins/" + (String)var11_35 + (bl ? "/" : ""));
                if (treeMap.containsValue(uRL4)) {
                    URL uRL5;
                    int n = 2;
                    while (treeMap.containsValue(uRL5 = new URL(uRL, "plugins/" + (String)var11_35 + "-" + n++ + (bl ? "/" : "")))) {
                    }
                }
            }
            catch (MalformedURLException malformedURLException5) {
                throw new BuildException("Couldn't construct URL relative to plugins/ for " + iOException, (Throwable)malformedURLException5, this.getLocation());
            }
            this.log("  Relocating to " + var10_20, 3);
            gappModel.updatePathForURL((URL)((Object)iOException), (URL)var10_20, true);
            treeMap.put((URL)((Object)iOException), (URL)var10_20);
            object2 = ((URL)((Object)iOException)).toExternalForm();
            if (!((String)object2).endsWith("/")) {
                object2 = (String)object2 + "/";
            }
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                object = (URL)iterator.next();
                try {
                    if (!((URL)object).toExternalForm().startsWith((String)object2)) continue;
                    iterator.remove();
                    String string4 = PersistenceManager.getRelativePath(iOException, (URL)object);
                    this.log("    Found resource " + object, 3);
                    URL uRL6 = null;
                    uRL6 = new URL((URL)var10_20, string4);
                    this.log("    Relocating to " + uRL6, 3);
                    gappModel.updatePathForURL((URL)object, uRL6, true);
                    hashMap.put(object, uRL6);
                    if (!this.copyResourceDirs) continue;
                    hashMap2.put(new URL((URL)object, "."), new URL(uRL6, "."));
                }
                catch (MalformedURLException malformedURLException6) {
                    throw new BuildException("Couldn't construct URL relative to " + var10_20 + " for " + object, (Throwable)malformedURLException6, this.getLocation());
                }
            }
        }
        if (!treeSet.isEmpty()) {
            switch (this.onUnresolved) {
                case fail: {
                    this.log("There were unresolved resources:", 0);
                    for (URL uRL7 : treeSet) {
                        this.log(uRL7.toExternalForm(), 0);
                    }
                    this.log("Either set onUnresolved=\"absolute|recover\" or add the relevant mapping hints", 0);
                    throw new BuildException("There were unresolved resources", this.getLocation());
                }
                case absolute: {
                    this.log("There were unresolved resources, which have been made absolute", 1);
                    for (URL uRL8 : treeSet) {
                        gappModel.updatePathForURL(uRL8, uRL8, false);
                        this.log(uRL8.toExternalForm(), 3);
                    }
                    break;
                }
                case recover: {
                    iOException = null;
                    try {
                        iOException = new URL(uRL, "application-resources/");
                    }
                    catch (MalformedURLException malformedURLException7) {
                        throw new BuildException("Can't construct URL relative to " + uRL + " for application-resources", (Throwable)malformedURLException7, this.getLocation());
                    }
                    TreeMap<URL, URL> treeMap2 = new TreeMap<URL, URL>(PATH_COMPARATOR);
                    this.log("There were unresolved resources, which have been gathered into " + iOException, 2);
                    for (URL uRL9 : treeSet) {
                        object3 = null;
                        try {
                            object3 = new URL(uRL9, ".");
                        }
                        catch (MalformedURLException malformedURLException8) {
                            throw new BuildException("Can't construct URL to parent directory of " + uRL9, (Throwable)malformedURLException8, this.getLocation());
                        }
                        object2 = this.getUnresolvedResourcesTarget(treeMap2, (URL)((Object)iOException), (URL)object3);
                        iterator = uRL9.getFile();
                        iterator = ((String)((Object)iterator)).substring(((String)((Object)iterator)).lastIndexOf(47) + 1);
                        object = null;
                        try {
                            object = new URL((URL)object2, (String)((Object)iterator));
                        }
                        catch (MalformedURLException malformedURLException9) {
                            throw new BuildException("Can't construct URL relative to " + iOException + " for " + (String)((Object)iterator), (Throwable)malformedURLException9, this.getLocation());
                        }
                        gappModel.updatePathForURL(uRL9, (URL)object, true);
                        hashMap.put(uRL9, object);
                        if (!this.copyResourceDirs) continue;
                        hashMap2.put((URL)object3, (URL)object2);
                    }
                    break;
                }
                default: {
                    throw new BuildException("Unrecognised UnresolvedAction", this.getLocation());
                }
            }
        }
        try {
            this.log("Writing modified gapp to " + this.destFile);
            gappModel.write();
        }
        catch (IOException iOException2) {
            throw new BuildException("Error writing out modified GAPP file", (Throwable)iOException2, this.getLocation());
        }
        if (hashMap.size() > 0) {
            this.log("Copying " + hashMap.size() + " resources");
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            File file = Files.fileFromURL((URL)entry.getKey());
            File file2 = Files.fileFromURL((URL)entry.getValue());
            if (file.isDirectory()) {
                file2.mkdirs();
                continue;
            }
            file2.getParentFile().mkdirs();
            if (!file.isFile()) continue;
            try {
                this.log("Copying " + file + " to " + file2, 3);
                FileUtils.getFileUtils().copyFile(file, file2);
            }
            catch (IOException iOException3) {
                throw new BuildException("Error copying file " + file + " to " + file2, (Throwable)iOException3, this.getLocation());
            }
        }
        if (treeMap.size() > 0) {
            this.log("Copying " + treeMap.size() + " plugins");
            if (this.copyPlugins) {
                this.log("Also copying complete plugin contents", 3);
            }
        }
        this.copyDirectories(treeMap, !this.copyPlugins);
        if (hashMap2.size() > 0) {
            this.log("Copying " + hashMap2.size() + " resource directories");
        }
        this.copyDirectories(hashMap2, false);
    }

    private void processExtraResourcesPaths(Set<URL> set) {
        for (Path path : this.extraResourcesPaths) {
            for (String string : path.list()) {
                File file = new File(string);
                try {
                    set.add(file.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BuildException("Couldn't construct URL for extra resource " + file, (Throwable)malformedURLException, this.getLocation());
                }
            }
        }
    }

    private void copyDirectories(Map<URL, URL> map, boolean bl) {
        for (Map.Entry<URL, URL> entry : map.entrySet()) {
            File file = Files.fileFromURL(entry.getKey());
            if (!file.exists()) {
                return;
            }
            File file2 = Files.fileFromURL(entry.getValue());
            Copy copy = new Copy();
            copy.setProject(this.getProject());
            copy.setLocation(this.getLocation());
            copy.setTaskName(this.getTaskName());
            copy.setTodir(file2);
            file2.mkdirs();
            FileSet fileSet = new FileSet();
            copy.addFileset(fileSet);
            fileSet.setDir(file);
            if (bl) {
                URL uRL;
                PatternSet.NameEntry nameEntry = fileSet.createInclude();
                nameEntry.setName("creole.xml");
                try {
                    uRL = new URL(entry.getKey().toExternalForm() + "/creole.xml");
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BuildException("Error creating URL for creole.xml in plugin " + entry.getKey());
                }
                for (String string : this.getJars(uRL)) {
                    PatternSet.NameEntry nameEntry2 = fileSet.createInclude();
                    nameEntry2.setName(string);
                }
            }
            copy.init();
            copy.perform();
        }
    }

    private Set<String> getJars(URL uRL) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            XPath xPath = XPath.newInstance((String)"//*[translate(local-name(), 'ajr', 'AJR') = 'JAR']");
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(uRL);
            List list = xPath.selectNodes((Object)document);
            for (Element element : list) {
                hashSet.add(element.getTextTrim());
            }
            return hashSet;
        }
        catch (JDOMException jDOMException) {
            throw new BuildException("Error extracting JAR elements from " + uRL, (Throwable)jDOMException, this.getLocation());
        }
        catch (IOException iOException) {
            throw new BuildException("Error loading " + uRL + " to extract JARs", (Throwable)iOException, this.getLocation());
        }
    }

    private URL getUnresolvedResourcesTarget(TreeMap<URL, URL> treeMap, URL uRL, URL uRL2) throws BuildException {
        URL uRL3 = treeMap.get(uRL2);
        try {
            if (uRL3 == null) {
                SortedMap<URL, URL> sortedMap = treeMap.headMap(uRL2);
                URL uRL4 = null;
                if (!sortedMap.isEmpty()) {
                    uRL4 = sortedMap.lastKey();
                }
                if (uRL4 != null && uRL2.toExternalForm().startsWith(uRL4.toExternalForm())) {
                    String string = PersistenceManager.getRelativePath(uRL4, uRL2);
                    uRL3 = new URL(treeMap.get(uRL4), string);
                } else {
                    String string;
                    String string2 = uRL2.getFile();
                    if (string2.endsWith("/")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if ((string = string2.substring(string2.lastIndexOf(47) + 1)).length() == 0) {
                        string = "resources";
                    }
                    if (treeMap.containsValue(uRL3 = new URL(uRL, string + "/"))) {
                        int n = 2;
                        while (treeMap.containsValue(uRL3 = new URL(uRL, string + "-" + n++ + "/"))) {
                        }
                    }
                }
                treeMap.put(uRL2, uRL3);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("Can't construct target URL for directory " + uRL2, (Throwable)malformedURLException, this.getLocation());
        }
        return uRL3;
    }

    public class MappingHint
    extends Property {
        private boolean absolute = false;

        public void setFrom(File file) {
            super.setName(file.getAbsolutePath());
        }

        public void setTo(String string) {
            super.setValue(string);
        }

        public void setAbsolute(boolean bl) {
            if (bl) {
                super.setValue("dummy");
            }
            this.absolute = bl;
        }

        protected void addProperty(String string, String string2) {
            try {
                File file = this.getProject().resolveFile(string);
                if (file.isDirectory() && string2 != null && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                PackageGappTask.this.mappingHints.put(file.toURI().toURL(), this.absolute ? null : string2);
            }
            catch (MalformedURLException malformedURLException) {
                PackageGappTask.this.log("Couldn't interpret \"" + string + "\" as a file path, ignored", 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnresolvedAction {
        fail,
        absolute,
        recover;

    }
}

