/*
 * Decompiled with CFR 0.152.
 */
package gate.util.ant.packager;

import gate.util.Files;
import gate.util.GateRuntimeException;
import gate.util.LuckyException;
import gate.util.persistence.PersistenceManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GappModel {
    private Document gappDocument;
    private URL gappFileURL;
    private URL gateHomeURL;
    private Map<URL, List<Element>> pluginRelpathsMap = new HashMap<URL, List<Element>>();
    private Map<URL, List<Element>> resourceRelpathsMap = new HashMap<URL, List<Element>>();
    private static XPath relativeResourcePathElementsXPath;
    private static XPath relativePluginPathElementsXPath;

    public GappModel(URL uRL) {
        this(uRL, null);
    }

    public GappModel(URL uRL, URL uRL2) {
        Object object;
        if (!"file".equals(uRL.getProtocol())) {
            throw new GateRuntimeException("GAPP URL must be a file: URL");
        }
        if (uRL2 != null && !"file".equals(uRL2.getProtocol())) {
            throw new GateRuntimeException("GATE home URL must be a file: URL");
        }
        this.gappFileURL = uRL;
        this.gateHomeURL = uRL2;
        try {
            object = new SAXBuilder();
            this.gappDocument = object.build(uRL);
        }
        catch (Exception exception) {
            throw new GateRuntimeException("Error parsing GAPP file", exception);
        }
        if (relativeResourcePathElementsXPath == null) {
            try {
                relativeResourcePathElementsXPath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/application//gate.util.persistence.PersistenceManager-URLHolder/urlString[starts-with(., '$relpath$') or starts-with(., '$gatehome$')]");
                relativePluginPathElementsXPath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/urlList//gate.util.persistence.PersistenceManager-URLHolder/urlString[starts-with(., '$relpath$') or starts-with(., '$gatehome$')]");
            }
            catch (JDOMException jDOMException) {
                throw new GateRuntimeException("Error creating XPath expression", jDOMException);
            }
        }
        object = null;
        List list = null;
        try {
            object = relativeResourcePathElementsXPath.selectNodes((Object)this.gappDocument);
            list = relativePluginPathElementsXPath.selectNodes((Object)this.gappDocument);
        }
        catch (JDOMException jDOMException) {
            throw new GateRuntimeException("Error extracting 'relpath' URLs from GAPP file", jDOMException);
        }
        try {
            this.buildRelpathsMap((List<Element>)object, this.resourceRelpathsMap);
            this.buildRelpathsMap(list, this.pluginRelpathsMap);
        }
        catch (MalformedURLException malformedURLException) {
            throw new GateRuntimeException("Error parsing relative paths in GAPP file", malformedURLException);
        }
    }

    private void buildRelpathsMap(List<Element> list, Map<URL, List<Element>> map) throws MalformedURLException {
        for (Element element : list) {
            ArrayList<Element> arrayList;
            String string = element.getText();
            URL uRL = null;
            if (string.startsWith("$gatehome$")) {
                if (this.gateHomeURL == null) {
                    throw new GateRuntimeException("Found a $gatehome$ relative path in GAPP file, but no GATE home URL provided to resolve against");
                }
                arrayList = element.getText().substring("$gatehome$".length());
                uRL = new URL(this.gateHomeURL, (String)((Object)arrayList));
            } else if (string.startsWith("$relpath$")) {
                arrayList = element.getText().substring("$relpath$".length());
                uRL = new URL(this.gappFileURL, (String)((Object)arrayList));
            }
            arrayList = map.get(uRL);
            if (arrayList == null) {
                arrayList = new ArrayList<Element>();
                map.put(uRL, arrayList);
            }
            arrayList.add(element);
        }
    }

    public URL getGappFileURL() {
        return this.gappFileURL;
    }

    public void setGappFileURL(URL uRL) {
        this.gappFileURL = uRL;
    }

    public Document getGappDocument() {
        return this.gappDocument;
    }

    public Set<URL> getPluginURLs() {
        return this.pluginRelpathsMap.keySet();
    }

    public Set<URL> getResourceURLs() {
        return this.resourceRelpathsMap.keySet();
    }

    public void updatePathForURL(URL uRL, URL uRL2, boolean bl) {
        List<Element> list = this.resourceRelpathsMap.get(uRL);
        List<Element> list2 = this.pluginRelpathsMap.get(uRL);
        if (list == null && list2 == null) {
            return;
        }
        String string = bl ? "$relpath$" + PersistenceManager.getRelativePath(this.gappFileURL, uRL2) : uRL2.toExternalForm();
        if (list != null) {
            for (Element element : list) {
                element.setText(string);
            }
        }
        if (list2 != null) {
            for (Element element : list2) {
                element.setText(string);
            }
        }
    }

    public void finish() {
        try {
            XPath xPath = XPath.newInstance((String)"/gate.util.persistence.GateApplication/urlList/localList/gate.util.persistence.PersistenceManager-URLHolder[urlString = following-sibling::gate.util.persistence.PersistenceManager-URLHolder/urlString]");
            List list = xPath.selectNodes((Object)this.gappDocument);
            for (Element element : list) {
                element.getParentElement().removeContent((Content)element);
            }
        }
        catch (JDOMException jDOMException) {
            throw new LuckyException("Error applying XPath expression to remove duplicate plugins", jDOMException);
        }
    }

    public void write() throws IOException {
        this.finish();
        File file = Files.fileFromURL(this.gappFileURL);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getRawFormat());
        xMLOutputter.output(this.gappDocument, (OutputStream)bufferedOutputStream);
    }
}

