/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.corpora.TestDocument;
import gate.util.AnnotationDiffer;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDiffer
extends TestCase {
    private static final boolean DEBUG = false;

    public TestDiffer(String string) {
        super(string);
    }

    public void setUp() {
    }

    public void tearDown() throws Exception {
    }

    public static Test suite() {
        return new TestSuite(TestDiffer.class);
    }

    public void testDiffer() throws Exception {
        Document document = Factory.newDocument(new URL(TestDocument.getTestServerName() + "tests/ft-bt-03-aug-2001.html"), "windows-1252");
        AnnotationSet annotationSet = document.getAnnotations();
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("type", "BAR");
        for (int i = 0; i < 100; ++i) {
            annotationSet.add(new Long(i * 10), new Long((i + 1) * 10), "Foo", featureMap);
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet);
        ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>(annotationSet);
        AnnotationDiffer annotationDiffer = new AnnotationDiffer();
        annotationDiffer.setSignificantFeaturesSet(null);
        annotationDiffer.calculateDiff(arrayList, arrayList2);
        annotationDiffer.sanityCheck();
        double d = annotationDiffer.getPrecisionStrict();
        Assert.assertEquals((String)("Precision Strict: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        d = annotationDiffer.getRecallStrict();
        Assert.assertEquals((String)("Recall Strict: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        d = annotationDiffer.getPrecisionLenient();
        Assert.assertEquals((String)("Precision Lenient: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        d = annotationDiffer.getRecallLenient();
        Assert.assertEquals((String)("Recall Lenient: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        Integer n = annotationSet.add(new Long(2L), new Long(4L), "Foo", featureMap);
        Annotation annotation = annotationSet.get(n);
        arrayList2.add(annotation);
        annotationDiffer.calculateDiff(arrayList, arrayList2);
        annotationDiffer.sanityCheck();
        d = annotationDiffer.getPrecisionStrict();
        Assert.assertEquals((String)("Precision Strict: " + d + " instead of .99!"), (double)0.99, (double)d, (double)0.001);
        d = annotationDiffer.getRecallStrict();
        Assert.assertEquals((String)("Recall Strict: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        d = annotationDiffer.getRecallLenient();
        Assert.assertEquals((String)("Recall Lenient: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        arrayList2.remove(annotation);
        arrayList.add(annotation);
        annotationDiffer.calculateDiff(arrayList, arrayList2);
        annotationDiffer.sanityCheck();
        d = annotationDiffer.getRecallStrict();
        Assert.assertEquals((String)("Recall Strict: " + d + " instead of .99!"), (double)0.99, (double)d, (double)0.001);
        d = annotationDiffer.getPrecisionStrict();
        Assert.assertEquals((String)("Precision Strict: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
        d = annotationDiffer.getPrecisionLenient();
        Assert.assertEquals((String)("Precision Lenient: " + d + " instead of 1!"), (double)1.0, (double)d, (double)0.0);
    }
}

