/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Gate;
import gate.GateConstants;
import gate.util.Err;
import gate.util.GateClassLoader;
import gate.util.GateException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public abstract class Javac
implements GateConstants {
    private static Javac compiler = null;
    private static GateClassLoader classLoader = null;
    public static final String DEFAULT_COMPILER = "gate.util.compilers.Eclipse";

    public static void loadClasses(Map map) throws GateException {
        if (compiler == null) {
            Javac.setCompilerTypeFromUserConfig();
        }
        compiler.compile(map);
    }

    private static void setCompilerTypeFromUserConfig() throws GateException {
        String string;
        if (classLoader == null) {
            classLoader = Gate.getClassLoader();
        }
        if ((string = Gate.getUserConfig().getString("Compiler_type")) == null) {
            string = DEFAULT_COMPILER;
        }
        try {
            compiler = Javac.createCompilerInstance(string);
        }
        catch (GateException gateException) {
            if (DEFAULT_COMPILER.equals(string)) {
                throw gateException;
            }
            string = "gate.util.compilers." + string;
            try {
                compiler = Javac.createCompilerInstance(string);
            }
            catch (GateException gateException2) {
                if (DEFAULT_COMPILER.equals(string)) {
                    throw gateException2;
                }
                Err.prln("Unable to load compiler class " + string + ", falling back to default of " + DEFAULT_COMPILER);
                string = DEFAULT_COMPILER;
                compiler = Javac.createCompilerInstance(string);
            }
        }
    }

    private static Javac createCompilerInstance(String string) throws GateException {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null || !Javac.class.isAssignableFrom(clazz)) {
            throw new GateException("Unable to load Java compiler class " + string);
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (Javac)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GateException("Cannot access Java compiler class " + string, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new GateException("Cannot instantiate Java compiler class " + string, instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GateException("Java compiler class " + string + " does not have a no-argument constructor", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new GateException("Exception when constructing Java compiler of type " + string, invocationTargetException.getCause());
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new GateException("Exception when initializing Java compiler class " + string, exceptionInInitializerError.getCause());
        }
    }

    public abstract void compile(Map var1) throws GateException;
}

