/*
 * Decompiled with CFR 0.152.
 */
package gate.util;

import gate.Annotation;
import gate.util.GateRuntimeException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDiffer {
    public HashSet correctAnnotations;
    public HashSet partiallyCorrectAnnotations;
    public HashSet missingAnnotations;
    public HashSet spuriousAnnotations;
    public static final int CORRECT_TYPE = 0;
    public static final int PARTIALLY_CORRECT_TYPE = 1;
    public static final int MISSING_TYPE = 2;
    public static final int SPURIOUS_TYPE = 3;
    public static final int MISMATCH_TYPE = 4;
    private static final int CORRECT_VALUE = 3;
    private static final int PARTIALLY_CORRECT_VALUE = 2;
    private static final int MISMATCH_VALUE = 1;
    private static final int WRONG_VALUE = 0;
    private Set significantFeaturesSet;
    protected int correctMatches;
    protected int partiallyCorrectMatches;
    protected int missing;
    protected int spurious;
    protected List keyList;
    protected List responseList;
    protected List keyChoices;
    protected List responseChoices;
    protected List possibleChoices;
    protected List finalChoices;

    public AnnotationDiffer(Collection<AnnotationDiffer> collection) {
        this.correctMatches = 0;
        this.partiallyCorrectMatches = 0;
        this.missing = 0;
        this.spurious = 0;
        int n = 0;
        int n2 = 0;
        for (AnnotationDiffer annotationDiffer : collection) {
            this.correctMatches += annotationDiffer.getCorrectMatches();
            this.partiallyCorrectMatches += annotationDiffer.getPartiallyCorrectMatches();
            this.missing += annotationDiffer.getMissing();
            this.spurious += annotationDiffer.getSpurious();
            n += annotationDiffer.getKeysCount();
            n2 += annotationDiffer.getResponsesCount();
        }
        this.keyList = new ArrayList<Object>(Collections.nCopies(n, null));
        this.responseList = new ArrayList<Object>(Collections.nCopies(n2, null));
    }

    public AnnotationDiffer() {
    }

    public List calculateDiff(Collection collection, Collection collection2) {
        Object object;
        int n;
        this.keyList = collection == null || collection.size() == 0 ? new ArrayList() : new ArrayList(collection);
        this.responseList = collection2 == null || collection2.size() == 0 ? new ArrayList() : new ArrayList(collection2);
        if (this.correctAnnotations != null) {
            this.correctAnnotations.clear();
        }
        if (this.partiallyCorrectAnnotations != null) {
            this.partiallyCorrectAnnotations.clear();
        }
        if (this.missingAnnotations != null) {
            this.missingAnnotations.clear();
        }
        if (this.spuriousAnnotations != null) {
            this.spuriousAnnotations.clear();
        }
        this.keyChoices = new ArrayList(this.keyList.size());
        this.keyChoices.addAll(Collections.nCopies(this.keyList.size(), null));
        this.responseChoices = new ArrayList(this.responseList.size());
        this.responseChoices.addAll(Collections.nCopies(this.responseList.size(), null));
        this.possibleChoices = new ArrayList();
        for (n = 0; n < this.keyList.size(); ++n) {
            for (int i = 0; i < this.responseList.size(); ++i) {
                object = (Annotation)this.keyList.get(n);
                Annotation annotation = (Annotation)this.responseList.get(i);
                PairingImpl pairingImpl = null;
                if (object.coextensive(annotation)) {
                    pairingImpl = object.isCompatible(annotation, this.significantFeaturesSet) ? new PairingImpl(n, i, 3) : new PairingImpl(n, i, 1);
                } else if (object.overlaps(annotation)) {
                    pairingImpl = object.isPartiallyCompatible(annotation, this.significantFeaturesSet) ? new PairingImpl(n, i, 2) : new PairingImpl(n, i, 0);
                }
                if (pairingImpl == null) continue;
                this.addPairing(pairingImpl, n, this.keyChoices);
                this.addPairing(pairingImpl, i, this.responseChoices);
                this.possibleChoices.add(pairingImpl);
            }
        }
        Collections.sort(this.possibleChoices, new PairingScoreComparator());
        Collections.reverse(this.possibleChoices);
        this.finalChoices = new ArrayList();
        this.correctMatches = 0;
        this.partiallyCorrectMatches = 0;
        this.missing = 0;
        this.spurious = 0;
        block8: while (!this.possibleChoices.isEmpty()) {
            PairingImpl pairingImpl = (PairingImpl)this.possibleChoices.remove(0);
            pairingImpl.consume();
            this.finalChoices.add(pairingImpl);
            switch (pairingImpl.value) {
                case 3: {
                    if (this.correctAnnotations == null) {
                        this.correctAnnotations = new HashSet();
                    }
                    this.correctAnnotations.add(pairingImpl.getResponse());
                    ++this.correctMatches;
                    pairingImpl.setType(0);
                    continue block8;
                }
                case 2: {
                    if (this.partiallyCorrectAnnotations == null) {
                        this.partiallyCorrectAnnotations = new HashSet();
                    }
                    this.partiallyCorrectAnnotations.add(pairingImpl.getResponse());
                    ++this.partiallyCorrectMatches;
                    pairingImpl.setType(1);
                    continue block8;
                }
                case 1: {
                    if (this.missingAnnotations == null) {
                        this.missingAnnotations = new HashSet();
                    }
                    this.missingAnnotations.add(pairingImpl.getKey());
                    ++this.missing;
                    if (this.spuriousAnnotations == null) {
                        this.spuriousAnnotations = new HashSet();
                    }
                    this.spuriousAnnotations.add(pairingImpl.getResponse());
                    ++this.spurious;
                    pairingImpl.setType(4);
                    continue block8;
                }
                case 0: {
                    if (pairingImpl.getKey() != null) {
                        if (this.missingAnnotations == null) {
                            this.missingAnnotations = new HashSet();
                        }
                        this.missingAnnotations.add(pairingImpl.getKey());
                        ++this.missing;
                        pairingImpl.setType(2);
                    }
                    if (pairingImpl.getResponse() == null) continue block8;
                    if (this.spuriousAnnotations == null) {
                        this.spuriousAnnotations = new HashSet();
                    }
                    this.spuriousAnnotations.add(pairingImpl.getResponse());
                    ++this.spurious;
                    pairingImpl.setType(3);
                    continue block8;
                }
            }
            throw new GateRuntimeException("Invalid pairing type: " + pairingImpl.value);
        }
        for (n = 0; n < this.keyChoices.size(); ++n) {
            List list = (List)this.keyChoices.get(n);
            if (list != null && !list.isEmpty()) continue;
            if (this.missingAnnotations == null) {
                this.missingAnnotations = new HashSet();
            }
            this.missingAnnotations.add((Annotation)this.keyList.get(n));
            object = new PairingImpl(n, -1, 0);
            ((PairingImpl)object).setType(2);
            this.finalChoices.add(object);
            ++this.missing;
        }
        for (n = 0; n < this.responseChoices.size(); ++n) {
            List list = (List)this.responseChoices.get(n);
            if (list != null && !list.isEmpty()) continue;
            if (this.spuriousAnnotations == null) {
                this.spuriousAnnotations = new HashSet();
            }
            this.spuriousAnnotations.add((Annotation)this.responseList.get(n));
            object = new PairingImpl(-1, n, 0);
            ((PairingImpl)object).setType(3);
            this.finalChoices.add(object);
            ++this.spurious;
        }
        return this.finalChoices;
    }

    public double getPrecisionStrict() {
        if (this.responseList.size() == 0) {
            return 1.0;
        }
        return (double)this.correctMatches / (double)this.responseList.size();
    }

    public double getRecallStrict() {
        if (this.keyList.size() == 0) {
            return 1.0;
        }
        return (double)this.correctMatches / (double)this.keyList.size();
    }

    public double getPrecisionLenient() {
        if (this.responseList.size() == 0) {
            return 1.0;
        }
        return ((double)this.correctMatches + (double)this.partiallyCorrectMatches) / (double)this.responseList.size();
    }

    public double getPrecisionAverage() {
        return (this.getPrecisionLenient() + this.getPrecisionStrict()) / 2.0;
    }

    public double getRecallLenient() {
        if (this.keyList.size() == 0) {
            return 1.0;
        }
        return ((double)this.correctMatches + (double)this.partiallyCorrectMatches) / (double)this.keyList.size();
    }

    public double getRecallAverage() {
        return (this.getRecallLenient() + this.getRecallStrict()) / 2.0;
    }

    public double getFMeasureStrict(double d) {
        double d2;
        double d3 = d * d;
        double d4 = this.getPrecisionStrict();
        double d5 = (d3 + 1.0) * d4 * (d2 = this.getRecallStrict()) / (d3 * d4 + d2);
        if (Double.isNaN(d5)) {
            d5 = 0.0;
        }
        return d5;
    }

    public double getFMeasureLenient(double d) {
        double d2;
        double d3 = d * d;
        double d4 = this.getPrecisionLenient();
        double d5 = (d3 + 1.0) * d4 * (d2 = this.getRecallLenient()) / (d3 * d4 + d2);
        if (Double.isNaN(d5)) {
            d5 = 0.0;
        }
        return d5;
    }

    public double getFMeasureAverage(double d) {
        double d2 = (this.getFMeasureLenient(d) + this.getFMeasureStrict(d)) / 2.0;
        return d2;
    }

    public int getCorrectMatches() {
        return this.correctMatches;
    }

    public int getPartiallyCorrectMatches() {
        return this.partiallyCorrectMatches;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getSpurious() {
        return this.spurious;
    }

    public int getFalsePositivesStrict() {
        return this.responseList.size() - this.correctMatches;
    }

    public int getFalsePositivesLenient() {
        return this.responseList.size() - this.correctMatches - this.partiallyCorrectMatches;
    }

    public int getKeysCount() {
        return this.keyList.size();
    }

    public int getResponsesCount() {
        return this.responseList.size();
    }

    public void printMissmatches() {
        List list;
        int n;
        for (PairingImpl pairingImpl : this.finalChoices) {
            switch (pairingImpl.value) {
                case 2: {
                    System.out.println("Missmatch (partially correct):");
                    System.out.println("Key: " + this.keyList.get(pairingImpl.keyIndex).toString());
                    System.out.println("Response: " + this.responseList.get(pairingImpl.responseIndex).toString());
                }
            }
        }
        for (n = 0; n < this.keyChoices.size(); ++n) {
            list = (List)this.keyChoices.get(n);
            if (list != null && !list.isEmpty()) continue;
            System.out.println("Missed Key: " + this.keyList.get(n).toString());
        }
        for (n = 0; n < this.responseChoices.size(); ++n) {
            list = (List)this.responseChoices.get(n);
            if (list != null && !list.isEmpty()) continue;
            System.out.println("Spurious Response: " + this.responseList.get(n).toString());
        }
    }

    void sanityCheck() throws Exception {
        List list;
        PairingImpl pairingImpl;
        for (List list2 : this.keyChoices) {
            if (list2 == null) continue;
            if (list2.size() > 1) {
                throw new Exception("Multiple choices found!");
            }
            if (list2.isEmpty()) continue;
            pairingImpl = (PairingImpl)list2.get(0);
            list = (List)this.responseChoices.get(pairingImpl.responseIndex);
            if (list != null && list.size() == 1 && list.get(0) == pairingImpl) continue;
            throw new Exception("Reciprocity error!");
        }
        for (List list2 : this.responseChoices) {
            if (list2 == null) continue;
            if (list2.size() > 1) {
                throw new Exception("Multiple choices found!");
            }
            if (list2.isEmpty()) continue;
            pairingImpl = (PairingImpl)list2.get(0);
            list = (List)this.keyChoices.get(pairingImpl.keyIndex);
            if (list == null) {
                throw new Exception("Reciprocity error : null!");
            }
            if (list.size() != 1) {
                throw new Exception("Reciprocity error: not 1!");
            }
            if (list.get(0) == pairingImpl) continue;
            throw new Exception("Reciprocity error: different!");
        }
    }

    protected void addPairing(PairingImpl pairingImpl, int n, List list) {
        ArrayList<PairingImpl> arrayList = (ArrayList<PairingImpl>)list.get(n);
        if (arrayList == null) {
            arrayList = new ArrayList<PairingImpl>();
            list.set(n, arrayList);
        }
        arrayList.add(pairingImpl);
    }

    public Set getSignificantFeaturesSet() {
        return this.significantFeaturesSet;
    }

    public void setSignificantFeaturesSet(Set set) {
        this.significantFeaturesSet = set;
    }

    public Set<Annotation> getAnnotationsOfType(int n) {
        switch (n) {
            case 0: {
                return this.correctAnnotations == null ? new HashSet<Annotation>() : this.correctAnnotations;
            }
            case 1: {
                return this.partiallyCorrectAnnotations == null ? new HashSet<Annotation>() : this.partiallyCorrectAnnotations;
            }
            case 3: {
                return this.spuriousAnnotations == null ? new HashSet<Annotation>() : this.spuriousAnnotations;
            }
            case 2: {
                return this.missingAnnotations == null ? new HashSet<Annotation>() : this.missingAnnotations;
            }
        }
        return new HashSet<Annotation>();
    }

    public String getAnnotationType() {
        if (!this.keyList.isEmpty()) {
            return ((Annotation)this.keyList.iterator().next()).getType();
        }
        if (!this.responseList.isEmpty()) {
            return ((Annotation)this.responseList.iterator().next()).getType();
        }
        return "";
    }

    public List<String> getMeasuresRow(Object[] objectArray, String string) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(2);
        numberFormat.setMinimumFractionDigits(2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        arrayList.add(Integer.toString(this.getCorrectMatches()));
        arrayList.add(Integer.toString(this.getMissing()));
        arrayList.add(Integer.toString(this.getSpurious()));
        arrayList.add(Integer.toString(this.getPartiallyCorrectMatches()));
        for (Object object : objectArray) {
            String string2 = (String)object;
            double d = Double.valueOf(string2.substring(1, string2.indexOf(45)));
            if (string2.endsWith("strict")) {
                arrayList.add(numberFormat.format(this.getRecallStrict()));
                arrayList.add(numberFormat.format(this.getPrecisionStrict()));
                arrayList.add(numberFormat.format(this.getFMeasureStrict(d)));
                continue;
            }
            if (string2.endsWith("lenient")) {
                arrayList.add(numberFormat.format(this.getRecallLenient()));
                arrayList.add(numberFormat.format(this.getPrecisionLenient()));
                arrayList.add(numberFormat.format(this.getFMeasureLenient(d)));
                continue;
            }
            if (!string2.endsWith("average")) continue;
            arrayList.add(numberFormat.format(this.getRecallAverage()));
            arrayList.add(numberFormat.format(this.getPrecisionAverage()));
            arrayList.add(numberFormat.format(this.getFMeasureAverage(d)));
        }
        return arrayList;
    }

    public static class PairingOffsetComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            Long l;
            Long l2;
            Pairing pairing = (Pairing)object;
            Pairing pairing2 = (Pairing)object2;
            Annotation annotation = pairing.getKey();
            Annotation annotation2 = pairing2.getKey();
            Annotation annotation3 = pairing.getResponse();
            Annotation annotation4 = pairing2.getResponse();
            Long l3 = l2 = annotation == null ? null : annotation.getStartNode().getOffset();
            if (l2 == null) {
                l2 = annotation3.getStartNode().getOffset();
            }
            Long l4 = l = annotation2 == null ? null : annotation2.getStartNode().getOffset();
            if (l == null) {
                l = annotation4.getStartNode().getOffset();
            }
            if ((n = l2.compareTo(l)) == 0) {
                n = pairing2.getType() - pairing.getType();
            }
            return n;
        }
    }

    protected static class PairingScoreComparator
    implements Comparator {
        protected PairingScoreComparator() {
        }

        public int compare(Object object, Object object2) {
            PairingImpl pairingImpl = (PairingImpl)object;
            PairingImpl pairingImpl2 = (PairingImpl)object2;
            int n = pairingImpl.getScore() - pairingImpl2.getScore();
            if (n == 0) {
                n = pairingImpl.getType() - pairingImpl2.getType();
            }
            if (n == 0) {
                n = (pairingImpl.getKey() == null ? 0 : 1) + (pairingImpl.getResponse() == null ? 0 : 1) + (pairingImpl2.getKey() == null ? 0 : -1) + (pairingImpl2.getResponse() == null ? 0 : -1);
            }
            return n;
        }
    }

    public class PairingImpl
    implements Pairing {
        int keyIndex;
        int responseIndex;
        int type;
        int value;
        int score;
        boolean scoreCalculated;

        PairingImpl(int n, int n2, int n3) {
            this.keyIndex = n;
            this.responseIndex = n2;
            this.value = n3;
            this.scoreCalculated = false;
        }

        public int getScore() {
            if (this.scoreCalculated) {
                return this.score;
            }
            this.calculateScore();
            return this.score;
        }

        public Annotation getKey() {
            return this.keyIndex == -1 ? null : (Annotation)AnnotationDiffer.this.keyList.get(this.keyIndex);
        }

        public Annotation getResponse() {
            return this.responseIndex == -1 ? null : (Annotation)AnnotationDiffer.this.responseList.get(this.responseIndex);
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public void consume() {
            AnnotationDiffer.this.possibleChoices.remove(this);
            List list = (List)AnnotationDiffer.this.keyChoices.get(this.keyIndex);
            list.remove(this);
            AnnotationDiffer.this.possibleChoices.removeAll(list);
            List list2 = (List)AnnotationDiffer.this.responseChoices.get(this.responseIndex);
            list2.remove(this);
            AnnotationDiffer.this.possibleChoices.removeAll(list2);
            Iterator iterator = new ArrayList(list).iterator();
            while (iterator.hasNext()) {
                ((PairingImpl)iterator.next()).remove();
            }
            iterator = new ArrayList(list2).iterator();
            while (iterator.hasNext()) {
                ((PairingImpl)iterator.next()).remove();
            }
            list.add(this);
            list2.add(this);
        }

        protected void remove() {
            List list = (List)AnnotationDiffer.this.keyChoices.get(this.keyIndex);
            list.remove(this);
            List list2 = (List)AnnotationDiffer.this.responseChoices.get(this.responseIndex);
            list2.remove(this);
        }

        void calculateScore() {
            HashSet hashSet = new HashSet();
            hashSet.addAll((List)AnnotationDiffer.this.responseChoices.get(this.responseIndex));
            hashSet.addAll((List)AnnotationDiffer.this.keyChoices.get(this.keyIndex));
            hashSet.remove(this);
            this.score = this.value;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.score -= ((PairingImpl)iterator.next()).value;
            }
            this.scoreCalculated = true;
        }
    }

    public static interface Pairing {
        public Annotation getKey();

        public Annotation getResponse();

        public int getType();
    }
}

