/*
 * Decompiled with CFR 0.152.
 */
package gate.swing;

import gate.util.ObjectComparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XJTable
extends JTable {
    private volatile boolean componentSizedProperly = false;
    private volatile boolean sizingInProgress = false;
    protected SortingModel sortingModel;
    protected ObjectComparator defaultComparator;
    protected int sortedColumn = -1;
    protected boolean ascending = true;
    protected boolean sortable = true;
    protected List<ColumnData> columnData;
    protected HeaderMouseListener headerMouseListener;
    protected List<TableColumn> hiddenColumns;
    private boolean enableHidingColumns = false;
    private boolean tabSkipUneditableCell = false;
    private boolean editCellAsSoonAsFocus = false;
    private Action oldTabAction;
    private Action oldShiftTabAction;

    public XJTable() {
        this(null);
    }

    public XJTable(TableModel tableModel) {
        if (tableModel != null) {
            this.setModel(tableModel);
        }
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public void setModel(TableModel tableModel) {
        this.sortingModel = new SortingModel(tableModel);
        this.componentSizedProperly = false;
        super.setModel(this.sortingModel);
        this.newColumns();
    }

    protected void newColumns() {
        this.columnData = new ArrayList<ColumnData>(this.dataModel.getColumnCount());
        this.hiddenColumns = new ArrayList<TableColumn>();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            this.columnData.add(new ColumnData(i));
        }
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        JTableHeader jTableHeader2 = this.getTableHeader();
        if (jTableHeader2 != null && this.headerMouseListener != null) {
            jTableHeader2.removeMouseListener(this.headerMouseListener);
        }
        super.setTableHeader(jTableHeader);
        if (this.headerMouseListener == null) {
            this.headerMouseListener = new HeaderMouseListener();
        }
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(this.headerMouseListener);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePreferredSize() {
        try {
            int n;
            int n2;
            Serializable serializable;
            if (this.sizingInProgress) {
                return;
            }
            this.sizingInProgress = true;
            int n3 = this.getColumnModel().getColumnCount();
            if (n3 == 0) {
                return;
            }
            if (!this.componentSizedProperly) {
                Serializable serializable2;
                serializable = this.getIntercellSpacing();
                for (n2 = 0; n2 < n3; ++n2) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    boolean bl = false;
                    if (tableCellRenderer == null) {
                        bl = true;
                        serializable2 = this.getTableHeader();
                        if (serializable2 == null) {
                            serializable2 = new JTableHeader();
                        }
                        tableCellRenderer = ((JTableHeader)serializable2).getDefaultRenderer();
                        tableColumn.setHeaderRenderer(tableCellRenderer);
                    }
                    if (tableCellRenderer != null) {
                        serializable2 = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, 0);
                        n = ((Component)serializable2).getMinimumSize().width + serializable.width;
                        if (tableColumn.getMinWidth() != n) {
                            tableColumn.setMinWidth(n);
                        }
                        tableColumn.setPreferredWidth(n);
                    } else {
                        tableColumn.setMinWidth(1);
                        tableColumn.setPreferredWidth(1);
                    }
                    if (!bl) continue;
                    tableColumn.setHeaderRenderer(null);
                }
                for (n2 = 0; n2 < this.getRowCount(); ++n2) {
                    int n4 = 1;
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        int n5;
                        Component component = this.prepareRenderer(this.getCellRenderer(n2, i), n2, i);
                        serializable2 = this.getColumnModel().getColumn(i);
                        n = component.getMinimumSize().width + serializable.width;
                        if (((TableColumn)serializable2).getPreferredWidth() < n) {
                            ((TableColumn)serializable2).setPreferredWidth(n);
                        }
                        if (n4 >= (n5 = component.getPreferredSize().height) + serializable.height) continue;
                        n4 = n5 + serializable.height;
                    }
                    this.setRowHeight(n2, n4);
                }
            }
            if (this.getAutoResizeMode() != 0) {
                int n6;
                int n7;
                serializable = null;
                if (this.getTableHeader() != null) {
                    serializable = this.getTableHeader().getResizingColumn();
                }
                n2 = 0;
                for (n7 = 0; n7 < n3; ++n7) {
                    int n8 = this.getColumnModel().getColumn(n7).getPreferredWidth();
                    if (n8 <= 0) continue;
                    n2 += n8;
                }
                n7 = this.getWidth();
                Container container = this.getParent();
                if (container != null && container instanceof JViewport && (n6 = ((JViewport)container).getExtentSize().width) > n7) {
                    n7 = n6;
                }
                n6 = 0;
                if (n7 > n2) {
                    n6 = n7 - n2;
                    if (this.getAutoResizeMode() == 4) {
                        int n9 = n6 / n3;
                        for (n = 0; n < n3 - 1; ++n) {
                            TableColumn tableColumn = this.getColumnModel().getColumn(n);
                            if (tableColumn == serializable) continue;
                            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n9);
                            n6 -= n9;
                        }
                    }
                    TableColumn tableColumn = this.getColumnModel().getColumn(n3 - 1);
                    tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n6);
                }
            }
        }
        finally {
            this.componentSizedProperly = true;
            this.sizingInProgress = false;
        }
    }

    public void doLayout() {
        this.calculatePreferredSize();
        super.doLayout();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        if (!this.componentSizedProperly) {
            this.calculatePreferredSize();
        }
        return super.getPreferredSize();
    }

    public boolean getScrollableTracksViewportWidth() {
        if (super.getScrollableTracksViewportWidth()) {
            Container container = this.getParent();
            if (container != null && container instanceof JViewport) {
                return ((JViewport)container).getExtentSize().width > this.getPreferredSize().width;
            }
            return true;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        Container container = this.getParent();
        Dimension dimension = this.getPreferredSize();
        return container != null && dimension != null && container instanceof JViewport && container.getHeight() > this.getPreferredSize().height;
    }

    public int rowModelToView(int n) {
        return this.sortingModel.sourceToTarget(n);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isColumnHidden(int n) {
        for (TableColumn tableColumn : this.hiddenColumns) {
            if (tableColumn.getModelIndex() != n) continue;
            return true;
        }
        return false;
    }

    public void hideColumn(int n) {
        int n2 = this.convertColumnIndexToView(n);
        TableColumn tableColumn = this.columnModel.getColumn(n2);
        this.columnModel.removeColumn(tableColumn);
        this.hiddenColumns.add(tableColumn);
    }

    public void showColumn(int n, int n2) {
        for (TableColumn tableColumn : this.hiddenColumns) {
            if (tableColumn.getModelIndex() != n) continue;
            this.columnModel.addColumn(tableColumn);
            this.columnModel.moveColumn(this.columnModel.getColumnCount() - 1, n2);
            this.hiddenColumns.remove(tableColumn);
            break;
        }
    }

    public void setAscending(boolean bl) {
        this.ascending = bl;
    }

    public int rowViewToModel(int n) {
        return this.sortingModel.targetToSource(n);
    }

    public void setEnableHidingColumns(boolean bl) {
        this.enableHidingColumns = bl;
    }

    public boolean isEnableHidingColumns() {
        return this.enableHidingColumns;
    }

    public boolean isEditCellAsSoonAsFocus() {
        return this.editCellAsSoonAsFocus;
    }

    public void setEditCellAsSoonAsFocus(boolean bl) {
        this.editCellAsSoonAsFocus = bl;
    }

    public boolean isTabSkipUneditableCell() {
        return this.tabSkipUneditableCell;
    }

    public void setTabSkipUneditableCell(boolean bl) {
        this.tabSkipUneditableCell = bl;
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("TAB");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("shift TAB");
        if (this.oldTabAction == null) {
            this.oldTabAction = this.getActionMap().get(inputMap.get(keyStroke));
            this.oldShiftTabAction = this.getActionMap().get(inputMap.get(keyStroke2));
        }
        if (bl) {
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2;
                    XJTable.this.oldTabAction.actionPerformed(actionEvent);
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n3 = n2 = jTable.getSelectedRow();
                    int n4 = n = jTable.getSelectedColumn();
                    while (!jTable.isCellEditable(n2, n)) {
                        XJTable.this.oldTabAction.actionPerformed(actionEvent);
                        n2 = jTable.getSelectedRow();
                        n = jTable.getSelectedColumn();
                        if (n2 != n3 || n != n4) continue;
                        break;
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
            AbstractAction abstractAction2 = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2;
                    XJTable.this.oldShiftTabAction.actionPerformed(actionEvent);
                    JTable jTable = (JTable)actionEvent.getSource();
                    int n3 = n2 = jTable.getSelectedRow();
                    int n4 = n = jTable.getSelectedColumn();
                    while (!jTable.isCellEditable(n2, n)) {
                        XJTable.this.oldShiftTabAction.actionPerformed(actionEvent);
                        n2 = jTable.getSelectedRow();
                        n = jTable.getSelectedColumn();
                        if (n2 != n3 || n != n4) continue;
                        break;
                    }
                }
            };
            this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
        } else {
            this.getActionMap().put(inputMap.get(keyStroke), this.oldTabAction);
            this.getActionMap().put(inputMap.get(keyStroke2), this.oldShiftTabAction);
        }
    }

    public void setComparator(int n, Comparator comparator) {
        this.columnData.get((int)n).comparator = comparator;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public void setSortedColumn(int n) {
        this.sortedColumn = n;
    }

    public int getTableRow(int n) {
        return this.sortingModel.sourceToTarget(n);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, bl, bl2);
        if (!bl && !bl2 && this.editCellAsSoonAsFocus && !this.isEditing() && this.isCellEditable(n, n2)) {
            this.editCellAt(n, n2);
        }
    }

    public int rowAtPoint(Point point) {
        if (!this.componentSizedProperly) {
            this.calculatePreferredSize();
        }
        return super.rowAtPoint(point);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent != null && tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() != -1 && tableModelEvent.getLastRow() != Integer.MAX_VALUE) {
            this.handleRowUpdate(tableModelEvent);
        } else {
            super.tableChanged(tableModelEvent);
        }
    }

    private void handleRowUpdate(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        int n;
        int n2 = tableModelEvent.getColumn();
        int n3 = tableModelEvent.getFirstRow();
        int n4 = tableModelEvent.getLastRow();
        if (n2 == -1) {
            n = 0;
            for (int i = 0; i < n3; ++i) {
                n += this.getRowHeight(i);
            }
            rectangle = new Rectangle(0, n, this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            n = this.convertColumnIndexToView(n2);
            rectangle = this.getCellRect(n3, n, true);
        }
        rectangle.height = 0;
        for (n = n3; n <= n4; ++n) {
            rectangle.height += this.getRowHeight(n);
        }
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        super.columnMoved(tableColumnModelEvent);
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.isEditing()) {
            this.cellEditor.stopCellEditing();
        }
        TableColumn tableColumn = null;
        if (this.getTableHeader() != null) {
            tableColumn = this.getTableHeader().getResizingColumn();
        }
        if (tableColumn != null) {
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        super.columnMarginChanged(changeEvent);
    }

    protected class ColumnData {
        int column;
        int columnWidth;
        Comparator comparator;

        public ColumnData(int n) {
            this.column = n;
        }
    }

    protected class HeaderMouseListener
    extends MouseAdapter {
        protected HeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.process(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.process(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.process(mouseEvent);
        }

        protected void process(MouseEvent mouseEvent) {
            final int n = XJTable.this.columnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n != -1) {
                final int n2 = XJTable.this.convertColumnIndexToModel(n);
                if (mouseEvent.isPopupTrigger() && XJTable.this.enableHidingColumns) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (XJTable.this.columnModel.getColumnCount() > 1) {
                        jPopupMenu.add(new AbstractAction("Hide column " + XJTable.this.dataModel.getColumnName(n2)){

                            public void actionPerformed(ActionEvent actionEvent) {
                                XJTable.this.hideColumn(n2);
                            }
                        });
                    }
                    if (XJTable.this.hiddenColumns.size() > 0) {
                        jPopupMenu.addSeparator();
                    }
                    Iterator<TableColumn> iterator = XJTable.this.hiddenColumns.iterator();
                    while (iterator.hasNext()) {
                        TableColumn tableColumn;
                        final TableColumn tableColumn2 = tableColumn = iterator.next();
                        jPopupMenu.add(new AbstractAction("Show column " + XJTable.this.dataModel.getColumnName(tableColumn.getModelIndex())){

                            public void actionPerformed(ActionEvent actionEvent) {
                                XJTable.this.showColumn(tableColumn2.getModelIndex(), n);
                            }
                        });
                    }
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (!mouseEvent.isPopupTrigger() && mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 1 && XJTable.this.sortable && n2 != -1) {
                    XJTable.this.ascending = n2 == XJTable.this.sortedColumn ? !XJTable.this.ascending : true;
                    XJTable.this.sortedColumn = n2;
                    XJTable.this.sortingModel.sort();
                }
            }
        }
    }

    protected class SortingModel
    extends AbstractTableModel
    implements TableModelListener {
        protected int[] sourceToTarget;
        protected int[] targetToSource;
        protected TableModel sourceModel;
        protected ValueHolderComparator compWrapper = new ValueHolderComparator();

        public SortingModel(TableModel tableModel) {
            this.init(tableModel);
        }

        protected void init(TableModel tableModel) {
            if (this.sourceModel != null) {
                this.sourceModel.removeTableModelListener(this);
            }
            this.sourceModel = tableModel;
            int n = tableModel.getRowCount();
            this.sourceToTarget = new int[n];
            this.targetToSource = new int[n];
            for (int i = 0; i < n; ++i) {
                this.sourceToTarget[i] = i;
                this.targetToSource[i] = i;
            }
            tableModel.addTableModelListener(this);
            if (XJTable.this.isSortable() && XJTable.this.sortedColumn == -1) {
                XJTable.this.setSortedColumn(0);
            }
            XJTable.this.componentSizedProperly = false;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getType();
            int n2 = tableModelEvent.getFirstRow();
            int n3 = tableModelEvent.getLastRow();
            int n4 = tableModelEvent.getColumn();
            switch (n) {
                case 0: {
                    if (n2 == -1) {
                        this.init(this.sourceModel);
                        XJTable.this.newColumns();
                        this.fireTableStructureChanged();
                        if (!XJTable.this.isSortable()) break;
                        this.sort();
                        break;
                    }
                    if (n3 == Integer.MAX_VALUE) {
                        this.init(this.sourceModel);
                        if (XJTable.this.isSortable()) {
                            this.sort();
                            break;
                        }
                        XJTable.this.componentSizedProperly = false;
                        this.fireTableDataChanged();
                        break;
                    }
                    if (XJTable.this.isSortable() && (n4 == XJTable.this.sortedColumn || n4 == -1)) {
                        this.sort();
                        break;
                    }
                    XJTable.this.componentSizedProperly = false;
                    this.fireTableChanged(new TableModelEvent(this, this.sourceToTarget(n2), this.sourceToTarget(n3), n4, n));
                    break;
                }
                case 1: {
                    this.init(this.sourceModel);
                    if (n2 != -1 && n2 == n3) {
                        if (XJTable.this.isSortable()) {
                            this.sort();
                            break;
                        }
                        XJTable.this.componentSizedProperly = false;
                        this.fireTableChanged(new TableModelEvent(this, this.sourceToTarget(n2), this.sourceToTarget(n3), n4, n));
                        break;
                    }
                    if (XJTable.this.isSortable()) {
                        this.sort();
                        break;
                    }
                    XJTable.this.componentSizedProperly = false;
                    this.fireTableDataChanged();
                    break;
                }
                case -1: {
                    this.init(this.sourceModel);
                    if (XJTable.this.isSortable()) {
                        this.sort();
                        break;
                    }
                    XJTable.this.componentSizedProperly = false;
                    this.fireTableDataChanged();
                }
            }
        }

        public int getRowCount() {
            return this.sourceToTarget.length;
        }

        public int getColumnCount() {
            return this.sourceModel.getColumnCount();
        }

        public String getColumnName(int n) {
            return this.sourceModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.sourceModel.getColumnClass(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.sourceModel.isCellEditable(this.targetToSource(n), n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.sourceModel.setValueAt(object, this.targetToSource(n), n2);
        }

        public Object getValueAt(int n, int n2) {
            try {
                return this.sourceModel.getValueAt(this.targetToSource(n), n2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        public void sort() {
            try {
                int n;
                if (XJTable.this.sortedColumn >= XJTable.this.columnData.size()) {
                    return;
                }
                int[] nArray = XJTable.this.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = XJTable.this.rowViewToModel(nArray[i]);
                }
                ArrayList<ValueHolder> arrayList = new ArrayList<ValueHolder>(this.sourceModel.getRowCount());
                for (int i = 0; i < this.sourceModel.getRowCount(); ++i) {
                    Object object = this.sourceModel.getValueAt(i, XJTable.this.sortedColumn);
                    arrayList.add(new ValueHolder(object, i));
                }
                Comparator comparator = XJTable.this.columnData.get((int)XJTable.this.sortedColumn).comparator;
                if (comparator == null) {
                    if (XJTable.this.defaultComparator == null) {
                        XJTable.this.defaultComparator = new ObjectComparator();
                    }
                    comparator = XJTable.this.defaultComparator;
                }
                this.compWrapper.setComparator(comparator);
                Collections.sort(arrayList, this.compWrapper);
                for (n = 0; n < arrayList.size(); ++n) {
                    int n2 = n;
                    int n3 = ((ValueHolder)arrayList.get(n)).index;
                    this.sourceToTarget[n3] = n2;
                    this.targetToSource[n2] = n3;
                }
                arrayList.clear();
                XJTable.this.componentSizedProperly = false;
                this.fireTableDataChanged();
                XJTable.this.resizeAndRepaint();
                XJTable.this.clearSelection();
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = XJTable.this.rowModelToView(nArray[n]);
                    if (nArray[n] <= 0 || nArray[n] >= this.getRowCount()) continue;
                    XJTable.this.addRowSelectionInterval(nArray[n], nArray[n]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public int sourceToTarget(int n) {
            return n >= 0 && n < this.sourceToTarget.length ? this.sourceToTarget[n] : -1;
        }

        public int targetToSource(int n) {
            return n >= 0 && n < this.targetToSource.length ? this.targetToSource[n] : -1;
        }

        protected void buildTargetToSourceIndex() {
            this.targetToSource = new int[this.sourceToTarget.length];
            for (int i = 0; i < this.sourceToTarget.length; ++i) {
                this.targetToSource[this.sourceToTarget[i]] = i;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ValueHolderComparator
        implements Comparator<ValueHolder> {
            private Comparator comparator;

            protected ValueHolderComparator() {
            }

            protected Comparator getComparator() {
                return this.comparator;
            }

            protected void setComparator(Comparator comparator) {
                this.comparator = comparator;
            }

            @Override
            public int compare(ValueHolder valueHolder, ValueHolder valueHolder2) {
                return XJTable.this.ascending ? this.comparator.compare(valueHolder.value, valueHolder2.value) : this.comparator.compare(valueHolder.value, valueHolder2.value) * -1;
            }
        }

        protected class ValueHolder {
            private Object value;
            private int index;

            public ValueHolder(Object object, int n) {
                this.value = object;
                this.index = n;
            }
        }
    }
}

