/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.Gate;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateAwareObjectInputStream
extends ObjectInputStream {
    public GateAwareObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(objectStreamClass.getName(), false, Gate.getClassLoader());
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        try {
            return super.resolveProxyClass(stringArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = Class.forName(stringArray[i], false, Gate.getClassLoader());
            }
            return Proxy.getProxyClass(Gate.getClassLoader(), classArray);
        }
    }
}

