/*
 * Decompiled with CFR 0.152.
 */
package gate.persist;

import gate.persist.DBHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ConnectionPool {
    private Vector connections;
    private int size;
    private String url;
    private int connCount;

    public ConnectionPool(int n, String string) {
        this.size = n;
        this.connections = new Vector(this.size);
        this.url = string;
        this.connCount = 0;
    }

    public synchronized Connection get() throws SQLException, ClassNotFoundException {
        int n = this.connections.size();
        if (n > 0) {
            Connection connection = (Connection)this.connections.elementAt(n - 1);
            this.connections.removeElementAt(n - 1);
            return connection;
        }
        if (this.connCount < this.size) {
            Connection connection = DBHelper.connect(this.url);
            ++this.connCount;
            return connection;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            throw new SQLException(" Thread interrupted while waiting to get Connection from ConnectionPool !");
        }
        return this.get();
    }

    public synchronized boolean put(Connection connection) {
        this.connections.addElement(connection);
        this.notify();
        return true;
    }

    public void finalize() {
        for (int i = 0; i < this.connections.size(); ++i) {
            try {
                DBHelper.disconnect((Connection)this.connections.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

