/*
 * Decompiled with CFR 0.152.
 */
package gate.jape.constraint;

import gate.jape.Constraint;
import gate.jape.constraint.AnnotationAccessor;
import gate.jape.constraint.AnnotationFeatureAccessor;
import gate.jape.constraint.CleanStringAccessor;
import gate.jape.constraint.ConstraintPredicate;
import gate.jape.constraint.ContainsPredicate;
import gate.jape.constraint.EqualPredicate;
import gate.jape.constraint.GreaterEqualPredicate;
import gate.jape.constraint.GreaterPredicate;
import gate.jape.constraint.LengthAccessor;
import gate.jape.constraint.LesserEqualPredicate;
import gate.jape.constraint.LesserPredicate;
import gate.jape.constraint.NotEqualPredicate;
import gate.jape.constraint.NotRegExpFindPredicate;
import gate.jape.constraint.NotRegExpMatchPredicate;
import gate.jape.constraint.RegExpFindPredicate;
import gate.jape.constraint.RegExpMatchPredicate;
import gate.jape.constraint.StringAccessor;
import gate.jape.constraint.WithinPredicate;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintFactory {
    protected Map<String, Class<? extends ConstraintPredicate>> operatorImplMap = new HashMap<String, Class<? extends ConstraintPredicate>>();
    protected Map<String, Class<? extends AnnotationAccessor>> metaPropertyMap = new HashMap<String, Class<? extends AnnotationAccessor>>();

    public ConstraintFactory() {
        this.initOperatorMap();
        this.initMetaPropertyMap();
    }

    protected void initOperatorMap() {
        this.addOperator("==", EqualPredicate.class);
        this.addOperator("!=", NotEqualPredicate.class);
        this.addOperator(">", GreaterPredicate.class);
        this.addOperator("<", LesserPredicate.class);
        this.addOperator(">=", GreaterEqualPredicate.class);
        this.addOperator("<=", LesserEqualPredicate.class);
        this.addOperator("=~", RegExpFindPredicate.class);
        this.addOperator("!~", NotRegExpFindPredicate.class);
        this.addOperator("==~", RegExpMatchPredicate.class);
        this.addOperator("!=~", NotRegExpMatchPredicate.class);
        this.addOperator("contains", ContainsPredicate.class);
        this.addOperator("within", WithinPredicate.class);
    }

    protected void initMetaPropertyMap() {
        this.addMetaProperty("string", StringAccessor.class);
        this.addMetaProperty("cleanString", CleanStringAccessor.class);
        this.addMetaProperty("length", LengthAccessor.class);
    }

    public void addOperator(String string, Class<? extends ConstraintPredicate> clazz) {
        this.operatorImplMap.put(string, clazz);
    }

    public void addMetaProperty(String string, Class<? extends AnnotationAccessor> clazz) {
        this.metaPropertyMap.put(string, clazz);
    }

    public Constraint createConstraint(String string) {
        return new Constraint(string);
    }

    public AnnotationAccessor createDefaultAccessor(Object object) {
        return new AnnotationFeatureAccessor(object);
    }

    public AnnotationAccessor createMetaPropertyAccessor(String string) {
        AnnotationAccessor annotationAccessor = null;
        Class<? extends AnnotationAccessor> clazz = this.metaPropertyMap.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("No meta property associated with name: " + string);
        }
        try {
            annotationAccessor = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create accessor for name '" + string + "'", exception);
        }
        return annotationAccessor;
    }

    public ConstraintPredicate createPredicate(String string, Object object) {
        return this.createPredicate(this.createDefaultAccessor(string), object);
    }

    public ConstraintPredicate createPredicate(AnnotationAccessor annotationAccessor, Object object) {
        return this.createPredicate("==", annotationAccessor, object);
    }

    public ConstraintPredicate createPredicate(String string, AnnotationAccessor annotationAccessor, Object object) {
        ConstraintPredicate constraintPredicate = null;
        Class<? extends ConstraintPredicate> clazz = this.operatorImplMap.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("No predicate associated with operator: " + string);
        }
        try {
            constraintPredicate = clazz.newInstance();
            constraintPredicate.setAccessor(annotationAccessor);
            constraintPredicate.setValue(object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create predicate for operator '" + string + "' with accessor '" + annotationAccessor + "' and value '" + object + "'", exception);
        }
        return constraintPredicate;
    }
}

