/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.AnnotationSet;
import gate.Document;
import gate.Gate;
import gate.creole.ontology.Ontology;
import gate.jape.ActionContext;
import gate.jape.JapeConstants;
import gate.jape.JapeException;
import gate.jape.LeftHandSide;
import gate.jape.NonFatalJapeException;
import gate.jape.RhsAction;
import gate.jape.SourceInfo;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import gate.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RightHandSide
implements JapeConstants,
Serializable {
    private static final long serialVersionUID = -4359589687308736378L;
    private static final boolean DEBUG = false;
    private transient Object theActionObject;
    private StringBuffer actionClassString;
    private byte[] actionClassBytes;
    private String actionClassName;
    private static String actionsDirName = "japeactionclasses";
    private String actionClassQualifiedName;
    private String actionClassJavaFileName;
    private String actionClassClassFileName;
    private transient SourceInfo sourceInfo;
    private static AtomicInteger actionClassNumber = new AtomicInteger();
    private Set<String> blockNames;
    private LeftHandSide lhs;
    private static ArrayList tempFiles = new ArrayList();
    private final String nl = Strings.getNl();
    static final boolean debug = false;
    private String phaseName;
    private String ruleName;
    private static Set<StackTraceElement> warnings = new HashSet<StackTraceElement>();

    public String getActionClassString() {
        return this.actionClassString.toString();
    }

    public String getActionClassName() {
        return this.actionClassQualifiedName;
    }

    public RightHandSide(String string, String string2, LeftHandSide leftHandSide, String string3) {
        this.lhs = leftHandSide;
        this.phaseName = string;
        this.ruleName = string2;
        this.actionClassName = new String(string + string2 + "ActionClass" + actionClassNumber.getAndIncrement());
        this.blockNames = new HashSet<String>();
        this.actionClassString = new StringBuffer("// " + this.actionClassName + this.nl + "package " + actionsDirName + "; " + this.nl + string3 + this.nl + "public class " + this.actionClassName + this.nl + "implements java.io.Serializable, RhsAction { " + this.nl + "  private ActionContext ctx;" + this.nl + "  public void setActionContext(ActionContext ac) { ctx = ac; }" + this.nl + "  public ActionContext getActionContext() { return ctx; }" + this.nl + "  public void doit(gate.Document doc, " + this.nl + "                   java.util.Map<java.lang.String, gate.AnnotationSet> bindings, " + this.nl + "                   gate.AnnotationSet annotations, " + this.nl + "                   gate.AnnotationSet inputAS, gate.AnnotationSet outputAS, " + this.nl + "                   gate.creole.ontology.Ontology ontology) throws gate.jape.JapeException {" + this.nl);
        this.actionClassJavaFileName = actionsDirName + File.separator + this.actionClassName.replace('.', File.separatorChar) + ".java";
        this.actionClassQualifiedName = actionsDirName.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.') + "." + this.actionClassName;
        this.actionClassClassFileName = this.actionClassQualifiedName.replace('.', File.separatorChar) + ".class";
        this.sourceInfo = new SourceInfo(this.actionClassQualifiedName, this.phaseName, string2);
    }

    public void addBlock(String string) {
        this.actionClassString.append(this.nl);
        this.actionClassString.append("if (true) {");
        this.actionClassString.append(this.nl);
        this.actionClassString.append(this.sourceInfo.addBlock(this.actionClassString.toString(), string));
        this.actionClassString.append(this.nl);
        this.actionClassString.append("}");
        this.actionClassString.append(this.nl);
    }

    public void addBlock(String string, String string2) {
        if (string == null) {
            this.addBlock(string2);
            return;
        }
        if (this.blockNames.add(string)) {
            this.actionClassString.append("    gate.AnnotationSet " + string + "Annots = bindings.get(\"" + string + "\"); " + this.nl);
        }
        this.actionClassString.append("    if(" + string + "Annots != null && " + string + "Annots.size() != 0) { " + this.nl);
        this.actionClassString.append(this.sourceInfo.addBlock(this.actionClassString.toString(), string2));
        this.actionClassString.append(this.nl + "    }" + this.nl);
    }

    public void createActionClass() throws JapeException {
        this.actionClassString.append("  }" + this.nl + "}" + this.nl);
    }

    public void instantiateActionClass() throws JapeException {
        try {
            this.theActionObject = Gate.getClassLoader().loadClass(this.actionClassQualifiedName).newInstance();
        }
        catch (Exception exception) {
            throw new JapeException("couldn't create instance of action class " + this.actionClassName + ": " + exception.getMessage());
        }
    }

    public static void cleanUp() {
        if (tempFiles.size() == 0) {
            return;
        }
        ListIterator listIterator = tempFiles.listIterator(tempFiles.size() - 1);
        while (listIterator.hasPrevious()) {
            File file = (File)listIterator.previous();
            file.delete();
        }
        tempFiles.clear();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            Class<?> clazz = Gate.getClassLoader().loadClass(this.actionClassQualifiedName);
            objectOutputStream.writeObject(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GateRuntimeException(classNotFoundException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = this.getActionClassName();
        if (Gate.getClassLoader().findExistingClass(string) == null) {
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(string, this.getActionClassString());
                Javac.loadClasses(hashMap);
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception);
            }
        }
    }

    public void transduce(Document document, Map<String, AnnotationSet> map, AnnotationSet annotationSet, final AnnotationSet annotationSet2, Ontology ontology, ActionContext actionContext) throws JapeException {
        if (this.theActionObject == null) {
            this.instantiateActionClass();
        }
        AnnotationSet annotationSet3 = (AnnotationSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{AnnotationSet.class}, new InvocationHandler(){

            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                StackTraceElement stackTraceElement = null;
                int n = -1;
                for (StackTraceElement stackTraceElement2 : new Throwable().getStackTrace()) {
                    if (!stackTraceElement2.getClassName().equals(RightHandSide.this.actionClassQualifiedName)) continue;
                    if (stackTraceElement2.getLineNumber() >= 0 && RightHandSide.this.sourceInfo != null) {
                        stackTraceElement = RightHandSide.this.sourceInfo.getStackTraceElement(stackTraceElement2.getLineNumber());
                        n = stackTraceElement2.getLineNumber();
                        break;
                    }
                    stackTraceElement = new StackTraceElement(RightHandSide.this.getPhaseName(), RightHandSide.this.getRuleName(), null, -1);
                    break;
                }
                if (!warnings.contains(stackTraceElement)) {
                    Err.println(RightHandSide.this.nl + "WARNING: the JAPE 'annotations' parameter has been deprecated. Please use 'inputAS' or 'outputAS' instead.");
                    Err.println(stackTraceElement);
                    if (n >= 0) {
                        Err.println("\t" + RightHandSide.this.sourceInfo.getSource(RightHandSide.this.getActionClassString(), n).trim());
                    }
                    warnings.add(stackTraceElement);
                }
                return method.invoke((Object)annotationSet2, objectArray);
            }
        });
        try {
            ((RhsAction)this.theActionObject).setActionContext(actionContext);
            ((RhsAction)this.theActionObject).doit(document, map, annotationSet3, annotationSet, annotationSet2, ontology);
        }
        catch (NonFatalJapeException nonFatalJapeException) {
            Throwable throwable = nonFatalJapeException.getCause();
            Err.println("A non-fatal JAPE exception occurred while processing document '" + document.getName() + "'.");
            Err.println("The issue occurred during execution of rule '" + this.getRuleName() + "' in phase '" + this.getPhaseName() + "':");
            if (throwable != null) {
                this.sourceInfo.enhanceTheThrowable(throwable);
                throwable.printStackTrace(Err.getPrintWriter());
            } else {
                Err.println("Line number and exception details are not available!");
            }
        }
        catch (Throwable throwable) {
            if (this.sourceInfo != null) {
                this.sourceInfo.enhanceTheThrowable(throwable);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof JapeException) {
                throw (JapeException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new JapeException("Couldn't run RHS action", throwable);
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer(string + "RHS: actionClassName(" + this.actionClassName + "); ");
        stringBuffer.append("actionClassClassFileName(" + string2 + this.actionClassClassFileName + string2);
        stringBuffer.append("actionClassJavaFileName(" + string2 + this.actionClassJavaFileName + string2);
        stringBuffer.append("actionClassQualifiedName(" + string2 + this.actionClassQualifiedName + string2);
        stringBuffer.append("blockNames(" + this.blockNames.toString() + "); ");
        stringBuffer.append(string2 + string + ") RHS." + string2);
        return stringBuffer.toString();
    }

    public String shortDesc() {
        String string = "" + this.actionClassName;
        return string;
    }

    public void setPhaseName(String string) {
        this.phaseName = string;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setRuleName(String string) {
        this.ruleName = string;
    }

    public String getRuleName() {
        return this.ruleName;
    }
}

