/*
 * Decompiled with CFR 0.152.
 */
package gate.jape;

import gate.jape.ConstraintGroup;
import gate.jape.JapeConstants;
import gate.jape.KleeneOperator;
import gate.jape.PatternElement;
import gate.util.Strings;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexPatternElement
extends PatternElement
implements JapeConstants,
Serializable {
    private KleeneOperator kleeneOp = null;
    private String bindingName = null;
    private ConstraintGroup constraintGroup;

    public String getBindingName() {
        return this.bindingName;
    }

    protected Iterator<ComplexPatternElement> getCPEs() {
        return this.constraintGroup.getCPEs();
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, int n, String string) {
        this(constraintGroup, KleeneOperator.Type.getFromJapeConstant(n), string);
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, KleeneOperator.Type type, String string) {
        this(constraintGroup, new KleeneOperator(type), string);
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, KleeneOperator kleeneOperator, String string) {
        if (kleeneOperator == null) {
            kleeneOperator = new KleeneOperator(KleeneOperator.Type.SINGLE);
        }
        this.constraintGroup = constraintGroup;
        this.kleeneOp = kleeneOperator;
        this.bindingName = string;
    }

    public ComplexPatternElement(ConstraintGroup constraintGroup, int n, int n2, String string) {
        this.constraintGroup = constraintGroup;
        this.kleeneOp = new KleeneOperator(n, n2);
        this.bindingName = string;
    }

    @Override
    public Object clone() {
        ComplexPatternElement complexPatternElement = (ComplexPatternElement)super.clone();
        complexPatternElement.constraintGroup = (ConstraintGroup)this.constraintGroup.clone();
        return complexPatternElement;
    }

    @Override
    public void finish() {
        this.constraintGroup.finish();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String string) {
        String string2 = Strings.getNl();
        StringBuffer stringBuffer = new StringBuffer(string + "CPE: bindingName(" + this.bindingName + "); kleeneOp(");
        if (this.kleeneOp != null) {
            stringBuffer.append(this.kleeneOp);
        }
        stringBuffer.append("); constraintGroup(" + string2 + this.constraintGroup.toString(Strings.addPadding(string, 4)) + string2 + string + ") CPE." + string2);
        return stringBuffer.toString();
    }

    public KleeneOperator getKleeneOp() {
        return this.kleeneOp;
    }

    public ConstraintGroup getConstraintGroup() {
        return this.constraintGroup;
    }
}

