/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.wordnet;

import gate.creole.AbstractVisualResource;
import gate.wordnet.LexicalRelation;
import gate.wordnet.Relation;
import gate.wordnet.SemanticRelation;
import gate.wordnet.Synset;
import gate.wordnet.Verb;
import gate.wordnet.VerbFrame;
import gate.wordnet.WordNet;
import gate.wordnet.WordNetException;
import gate.wordnet.WordSense;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class WordNetViewer
extends AbstractVisualResource
implements ActionListener {
    protected JLabel searchLabel = new JLabel();
    protected JTextField searchWordTextField = new JTextField();
    protected JButton searchButton = new JButton();
    protected JTextPane resultPane = new JTextPane();
    protected JLabel searchLabel2 = new JLabel();
    protected JButton nounButton = new JButton();
    protected JButton verbButton = new JButton();
    protected JButton adjectiveButton = new JButton();
    protected JButton adverbButton = new JButton();
    protected JScrollPane scrollPane = new JScrollPane();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected JPopupMenu nounPopup;
    protected JPopupMenu verbPopup;
    protected JPopupMenu adjectivePopup;
    protected JPopupMenu adverbPopup;
    private static final String propertiesFile = "file://D:/Gate/temp/file_properties.xml";
    private WordNet wnMain = null;
    private boolean sentenceFrames = false;
    public static final int SENTENCE_FRAMES = 33001;

    public WordNetViewer() {
        this.searchLabel.setText("Search Word:");
        this.setLayout(this.gridBagLayout1);
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordNetViewer.this.searchButton_actionPerformed(actionEvent);
            }
        });
        this.searchWordTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordNetViewer.this.searchWordTextField_actionPerformed(actionEvent);
            }
        });
        this.searchLabel2.setText("Searches for ... :");
        this.nounButton.setText("Noun");
        this.verbButton.setText("Verb");
        this.adjectiveButton.setText("Adjective");
        this.adverbButton.setText("Adverb");
        this.nounButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordNetViewer.this.nounButton_actionPerformed(actionEvent);
            }
        });
        this.verbButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordNetViewer.this.verbButton_actionPerformed(actionEvent);
            }
        });
        this.adjectiveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordNetViewer.this.adjectiveButton_actionPerformed(actionEvent);
            }
        });
        this.adverbButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordNetViewer.this.adverbButton_actionPerformed(actionEvent);
            }
        });
        this.nounButton.setEnabled(false);
        this.verbButton.setEnabled(false);
        this.adjectiveButton.setEnabled(false);
        this.adverbButton.setEnabled(false);
        this.resultPane.setEditable(false);
        this.scrollPane.getViewport().add(this.resultPane);
        this.add((Component)this.searchLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.searchWordTextField, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 2, 7, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.searchLabel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.searchButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.adjectiveButton, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.verbButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.nounButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.adverbButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void searchButton_actionPerformed(ActionEvent actionEvent) {
        this.actionSearch();
    }

    private void searchWordTextField_actionPerformed(ActionEvent actionEvent) {
        this.actionSearch();
    }

    private void actionSearch() {
        String string = this.searchWordTextField.getText().trim();
        string = string.replace(' ', '_');
        this.searchLabel2.setText("Searches for " + string + ":");
        this.nounButton.setEnabled(false);
        this.verbButton.setEnabled(false);
        this.adjectiveButton.setEnabled(false);
        this.adverbButton.setEnabled(false);
        this.nounPopup = new JPopupMenu();
        this.verbPopup = new JPopupMenu();
        this.adjectivePopup = new JPopupMenu();
        this.adverbPopup = new JPopupMenu();
        StringBuffer stringBuffer = new StringBuffer("");
        this.addToResult(stringBuffer, string, 1003);
        this.addToResult(stringBuffer, string, 1004);
        this.addToResult(stringBuffer, string, 1001);
        this.addToResult(stringBuffer, string, 1002);
        this.resultPane.setText(stringBuffer.toString());
    }

    private void addToResult(StringBuffer stringBuffer, String string, int n) {
        List list = null;
        try {
            this.wnMain.cleanup();
            list = this.wnMain.lookupWord(string, n);
        }
        catch (WordNetException wordNetException) {
            wordNetException.printStackTrace();
        }
        if (list != null && list.size() > 0) {
            String string2 = "";
            switch (n) {
                case 1003: {
                    string2 = "noun";
                    this.nounButton.setEnabled(true);
                    break;
                }
                case 1004: {
                    string2 = "verb";
                    this.verbButton.setEnabled(true);
                    break;
                }
                case 1001: {
                    string2 = "adjective";
                    this.adjectiveButton.setEnabled(true);
                    break;
                }
                case 1002: {
                    string2 = "adverb";
                    this.adverbButton.setEnabled(true);
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append("The ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" has ");
            stringBuffer.append(list.size());
            stringBuffer.append(" senses:");
            stringBuffer.append("\n\n");
            for (int i = 0; i < list.size(); ++i) {
                WordSense wordSense = (WordSense)list.get(i);
                Synset synset = wordSense.getSynset();
                this.addToPopupMenu(wordSense, synset, n, list);
                List list2 = synset.getWordSenses();
                String string3 = this.getWords(list2);
                stringBuffer.append(" " + (i + 1) + ". " + string3 + " -- " + synset.getGloss());
                stringBuffer.append("\n");
            }
        }
    }

    private void addToPopupMenu(WordSense wordSense, Synset synset, int n, List list) {
        List list2 = null;
        try {
            list2 = synset.getSemanticRelations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        List list3 = null;
        try {
            list3 = wordSense.getLexicalRelations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        block10: for (int i = 0; i < list2.size() + list3.size(); ++i) {
            Relation relation = i < list2.size() ? (SemanticRelation)list2.get(i) : (LexicalRelation)list3.get(i - list2.size());
            switch (n) {
                case 1003: {
                    if (this.existInPopup(this.nounPopup, this.getLabel(relation))) continue block10;
                    this.nounPopup.add(new RelationItem(this.getLabel(relation), relation.getType(), list));
                    continue block10;
                }
                case 1004: {
                    if (!this.sentenceFrames) {
                        this.verbPopup.add(new RelationItem("Sentence Frames", 33001, list));
                        this.sentenceFrames = true;
                    }
                    if (this.existInPopup(this.verbPopup, this.getLabel(relation))) continue block10;
                    this.verbPopup.add(new RelationItem(this.getLabel(relation), relation.getType(), list));
                    continue block10;
                }
                case 1001: {
                    if (this.existInPopup(this.adjectivePopup, this.getLabel(relation))) continue block10;
                    this.adjectivePopup.add(new RelationItem(this.getLabel(relation), relation.getType(), list));
                    continue block10;
                }
                case 1002: {
                    if (this.existInPopup(this.adverbPopup, this.getLabel(relation))) continue block10;
                    this.adverbPopup.add(new RelationItem(this.getLabel(relation), relation.getType(), list));
                }
            }
        }
    }

    private boolean existInPopup(JPopupMenu jPopupMenu, String string) {
        boolean bl = false;
        for (int i = 0; i < jPopupMenu.getComponents().length; ++i) {
            if (!jPopupMenu.getComponents()[i].getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    void nounButton_actionPerformed(ActionEvent actionEvent) {
        this.nounPopup.show(this.nounButton, 0, this.nounButton.getHeight());
    }

    void verbButton_actionPerformed(ActionEvent actionEvent) {
        this.verbPopup.show(this.verbButton, 0, this.verbButton.getHeight());
    }

    void adjectiveButton_actionPerformed(ActionEvent actionEvent) {
        this.adjectivePopup.show(this.adjectiveButton, 0, this.adjectiveButton.getHeight());
    }

    void adverbButton_actionPerformed(ActionEvent actionEvent) {
        if (this.adverbPopup.getComponentCount() > 0) {
            this.adverbPopup.show(this.adverbButton, 0, this.adverbButton.getHeight());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RelationItem relationItem = (RelationItem)actionEvent.getSource();
        switch (relationItem.getRelationType()) {
            case 10001: {
                this.relAntonymSeeAlso(relationItem.getSenses(), 10001, "=> ");
                break;
            }
            case 10010: {
                this.relAtributeSimilarTo(relationItem.getSenses(), 10010, "=> ");
                break;
            }
            case 10012: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10012, "=> ");
                break;
            }
            case 10018: {
                this.relAntonymSeeAlso(relationItem.getSenses(), 10018, "=> ");
                break;
            }
            case 10011: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10011, "=> ");
                break;
            }
            case 10002: {
                this.relHypernym(relationItem.getSenses());
                break;
            }
            case 10003: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10003, "=> ");
                break;
            }
            case 10004: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10004, "MEMBER OF: ");
                break;
            }
            case 10007: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10007, "HAS MEMBER: ");
                break;
            }
            case 10015: {
                this.relAntonymSeeAlso(relationItem.getSenses(), 10015, "=> ");
                break;
            }
            case 10006: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10006, "PART OF: ");
                break;
            }
            case 10009: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10009, "HAS PART: ");
                break;
            }
            case 10017: {
                break;
            }
            case 10013: {
                this.relAntonymSeeAlso(relationItem.getSenses(), 10013, "=> ");
                break;
            }
            case 10016: {
                this.relAtributeSimilarTo(relationItem.getSenses(), 10016, "=> ");
                break;
            }
            case 10005: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10005, " SUBSTANCE OF: ");
                break;
            }
            case 10008: {
                this.relHoloMeroHypo(relationItem.getSenses(), 10008, "HAS SUBSTANCE: ");
                break;
            }
            case 10014: {
                this.relAtributeSimilarTo(relationItem.getSenses(), 10014, "=> ");
                break;
            }
            case 33001: {
                this.sentenceFrames(relationItem.getSenses());
            }
        }
    }

    private void relHypernym(List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append("\n");
            stringBuffer.append("Sense ");
            stringBuffer.append(i + 1);
            stringBuffer.append("\n");
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            this.recursiveHypernym(synset, stringBuffer, "  =>");
        }
        this.resultPane.setText(stringBuffer.toString());
    }

    private void recursiveHypernym(Synset synset, StringBuffer stringBuffer, String string) {
        List list = synset.getWordSenses();
        String string2 = this.getWords(list);
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        stringBuffer.append(" -- ");
        stringBuffer.append(synset.getGloss());
        stringBuffer.append("\n");
        List list2 = null;
        try {
            list2 = synset.getSemanticRelations(10002);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list2 != null && list2.size() > 0) {
            SemanticRelation semanticRelation = (SemanticRelation)list2.get(0);
            string = "    " + string;
            this.recursiveHypernym(semanticRelation.getTarget(), stringBuffer, string);
        }
    }

    private void relHoloMeroHypo(List list, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            try {
                if (synset.getSemanticRelations(n).size() <= 0) continue;
                stringBuffer.append("\n");
                stringBuffer.append("Sense ");
                stringBuffer.append(i + 1);
                stringBuffer.append("\n");
                this.recursiveHoloMeroHypo(synset, stringBuffer, "  ", false, n, string);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.resultPane.setText(stringBuffer.toString());
    }

    private void recursiveHoloMeroHypo(Synset synset, StringBuffer stringBuffer, String string, boolean bl, int n, String string2) {
        List list = synset.getWordSenses();
        String string3 = this.getWords(list);
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string3);
        stringBuffer.append(" -- ");
        stringBuffer.append(synset.getGloss());
        stringBuffer.append("\n");
        List list2 = null;
        try {
            list2 = synset.getSemanticRelations(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list2 != null && list2.size() > 0) {
            for (int i = 0; i < list2.size(); ++i) {
                SemanticRelation semanticRelation = (SemanticRelation)list2.get(i);
                string = "    " + string;
                this.recursiveHoloMeroHypo(semanticRelation.getTarget(), stringBuffer, string, true, n, string2);
                string = string.substring(4, string.length());
            }
        }
    }

    private void relAntonymSeeAlso(List list, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            try {
                List list2 = wordSense.getLexicalRelations(n);
                if (list2 == null || list2.size() <= 0) continue;
                bl = false;
                stringBuffer.append("\n");
                stringBuffer.append("Sense ");
                stringBuffer.append(i + 1);
                stringBuffer.append("\n  ");
                stringBuffer.append(this.getWords(synset.getWordSenses()));
                stringBuffer.append(" -- ");
                stringBuffer.append(synset.getGloss());
                stringBuffer.append("\n");
                for (int j = 0; j < list2.size(); ++j) {
                    LexicalRelation lexicalRelation = (LexicalRelation)list2.get(j);
                    WordSense wordSense2 = lexicalRelation.getTarget();
                    stringBuffer.append("      ");
                    stringBuffer.append(string);
                    stringBuffer.append(wordSense2.getWord().getLemma());
                    stringBuffer.append(" -- ");
                    stringBuffer.append(wordSense2.getSynset().getGloss());
                    stringBuffer.append("\n");
                }
                stringBuffer.append("\n");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.resultPane.setText(stringBuffer.toString());
        if (bl) {
            this.relAtributeSimilarTo(list, 10013, "=> ");
        }
    }

    private void relAtributeSimilarTo(List list, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            try {
                List list2 = synset.getSemanticRelations(n);
                if (list2 == null || list2.size() <= 0) continue;
                stringBuffer.append("\n");
                stringBuffer.append("Sense ");
                stringBuffer.append(i + 1);
                stringBuffer.append("\n  ");
                stringBuffer.append(this.getWords(synset.getWordSenses()));
                stringBuffer.append(" -- ");
                stringBuffer.append(synset.getGloss());
                stringBuffer.append("\n");
                for (int j = 0; j < list2.size(); ++j) {
                    SemanticRelation semanticRelation = (SemanticRelation)list2.get(j);
                    Synset synset2 = semanticRelation.getTarget();
                    stringBuffer.append("     ");
                    stringBuffer.append(string);
                    stringBuffer.append(this.getWords(synset2.getWordSenses()));
                    stringBuffer.append(" -- ");
                    stringBuffer.append(synset2.getGloss());
                    stringBuffer.append("\n");
                }
                stringBuffer.append("\n");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.resultPane.setText(stringBuffer.toString());
    }

    private String getWords(List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            stringBuffer.append(wordSense.getWord().getLemma().replace('_', ' '));
            if (i >= list.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void sentenceFrames(List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < list.size(); ++i) {
            WordSense wordSense = (WordSense)list.get(i);
            Synset synset = wordSense.getSynset();
            Verb verb = (Verb)wordSense;
            List list2 = verb.getVerbFrames();
            stringBuffer.append("\nSense ");
            stringBuffer.append(i + 1);
            stringBuffer.append("\n  ");
            stringBuffer.append(this.getWords(synset.getWordSenses()));
            stringBuffer.append(" -- ");
            stringBuffer.append(synset.getGloss());
            stringBuffer.append("\n");
            for (int j = 0; j < list2.size(); ++j) {
                stringBuffer.append("        *> ");
                stringBuffer.append(((VerbFrame)list2.get(j)).getFrame());
                stringBuffer.append("\n");
            }
        }
        this.resultPane.setText(stringBuffer.toString());
    }

    public String getLabel(Relation relation) {
        String string = "";
        switch (relation.getType()) {
            case 10001: {
                string = "Antonym";
                break;
            }
            case 10010: {
                string = "Attribute";
                break;
            }
            case 10012: {
                string = "Cause";
                break;
            }
            case 10018: {
                string = "Derived From Adjective";
                break;
            }
            case 10011: {
                string = "Entailment";
                break;
            }
            case 10002: {
                string = "Hypernym";
                break;
            }
            case 10003: {
                string = "Hyponym";
                break;
            }
            case 10004: {
                string = "Member Holonym";
                break;
            }
            case 10007: {
                string = "Member Meronym";
                break;
            }
            case 10015: {
                string = "Participle Of Verb";
                break;
            }
            case 10006: {
                string = "Holonym";
                break;
            }
            case 10009: {
                string = "Meronym";
                break;
            }
            case 10017: {
                string = "Pertainym";
                break;
            }
            case 10013: {
                string = "See Also";
                break;
            }
            case 10016: {
                string = "Similar To";
                break;
            }
            case 10005: {
                string = "Substance Holonym";
                break;
            }
            case 10008: {
                string = "Substance Meronym";
                break;
            }
            case 10014: {
                string = "Verb Group";
            }
        }
        return string;
    }

    public String getDescription(int n) {
        String string = "";
        switch (n) {
            case 10001: {
                string = "Antonyms:";
                break;
            }
            case 10010: {
                string = "Attributes:";
                break;
            }
            case 10012: {
                string = "Cause:";
                break;
            }
            case 10018: {
                string = "Derived From Adjective:";
                break;
            }
            case 10011: {
                string = "Entailments:";
                break;
            }
            case 10002: {
                string = "Hypernyms:";
                break;
            }
            case 10003: {
                string = "Hyponyms:";
                break;
            }
            case 10004: {
                string = "Member Holonyms:";
                break;
            }
            case 10007: {
                string = "Member Meronyms:";
                break;
            }
            case 10015: {
                string = "Participle Of Verb:";
                break;
            }
            case 10006: {
                string = "Holonyms:";
                break;
            }
            case 10009: {
                string = "Meronyms:";
                break;
            }
            case 10017: {
                string = "Pertainyms:";
                break;
            }
            case 10013: {
                string = "See Also:";
                break;
            }
            case 10016: {
                string = "Similar To:";
                break;
            }
            case 10005: {
                string = "Substance Holonyms:";
                break;
            }
            case 10008: {
                string = "Substance Meronyms:";
                break;
            }
            case 10014: {
                string = "Verb Group:";
            }
        }
        return string;
    }

    public void setTarget(Object object) {
        if (!(object instanceof WordNet)) {
            throw new IllegalArgumentException();
        }
        this.wnMain = (WordNet)object;
    }

    private class RelationItem
    extends JMenuItem {
        int relType;
        List senses;

        public RelationItem(String string, int n, List list) {
            super(string);
            this.addActionListener(WordNetViewer.this);
            this.relType = n;
            this.senses = list;
            this.setName(string);
        }

        public int getRelationType() {
            return this.relType;
        }

        public List getSenses() {
            return this.senses;
        }
    }
}

