/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.teamware;

import gate.Controller;
import gate.gui.teamware.AnnotationSetNameCellRenderer;
import gate.gui.teamware.AnnotationSetNameComboEditor;
import gate.gui.teamware.TeamwareUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InputOutputAnnotationSetsDialog {
    private Controller controller;
    private JPanel panel;
    private AnnotationSetsList inputList;
    private Set<String> inputSetNames;
    private AnnotationSetsList outputList;
    private Set<String> outputSetNames;
    private static final Comparator<String> NATURAL_COMPARATOR = new NaturalComparator();

    public InputOutputAnnotationSetsDialog(Controller controller) {
        this.controller = controller;
        this.initGuiComponents();
    }

    protected void initGuiComponents() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 2, 5, 5));
        this.inputSetNames = TeamwareUtils.getInputAnnotationSets(this.controller);
        this.outputSetNames = TeamwareUtils.getOutputAnnotationSets(this.controller);
        Set<String> set = TeamwareUtils.getLikelyInputAnnotationSets(this.controller);
        Set<String> set2 = TeamwareUtils.getLikelyOutputAnnotationSets(this.controller);
        this.inputList = new AnnotationSetsList(set, this.inputSetNames);
        this.outputList = new AnnotationSetsList(set2, this.outputSetNames);
        this.inputList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input annotation sets"));
        this.outputList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output annotation sets"));
        this.panel.add(this.inputList);
        this.panel.add(this.outputList);
    }

    public boolean showDialog(Component component) {
        int n = JOptionPane.showConfirmDialog(component, this.panel, "Select input and output annotation sets", 2, -1);
        if (n == 0) {
            int n2;
            this.inputSetNames.clear();
            for (n2 = 0; n2 < this.inputList.listModel.size(); ++n2) {
                this.inputSetNames.add((String)this.inputList.listModel.get(n2));
            }
            this.outputSetNames.clear();
            for (n2 = 0; n2 < this.outputList.listModel.size(); ++n2) {
                this.outputSetNames.add((String)this.outputList.listModel.get(n2));
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NaturalComparator
    implements Comparator<String> {
        protected NaturalComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationSetsList
    extends JPanel {
        private JList annotationSetsList;
        private DefaultListModel listModel;
        private JComboBox combo;
        private JButton addButton;
        private JButton removeButton;

        AnnotationSetsList(Collection<String> collection, Collection<String> collection2) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipady = 2;
            gridBagConstraints.weightx = 1.0;
            String[] stringArray = collection.toArray(new String[collection.size()]);
            Arrays.sort(stringArray, NATURAL_COMPARATOR);
            this.combo = new JComboBox<String>(stringArray);
            this.combo.setEditable(true);
            this.combo.setEditor(new AnnotationSetNameComboEditor(this.combo.getEditor()));
            this.combo.setRenderer(new AnnotationSetNameCellRenderer());
            gridBagConstraints.fill = 2;
            this.add((Component)this.combo, gridBagConstraints);
            AddAction addAction = new AddAction();
            RemoveAction removeAction = new RemoveAction();
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            this.addButton = new JButton(addAction);
            box.add(this.addButton);
            box.add(Box.createHorizontalStrut(5));
            this.removeButton = new JButton(removeAction);
            box.add(this.removeButton);
            box.add(Box.createHorizontalGlue());
            this.add((Component)box, gridBagConstraints);
            this.listModel = new DefaultListModel();
            String[] stringArray2 = collection2.toArray(new String[collection2.size()]);
            Arrays.sort(stringArray2, NATURAL_COMPARATOR);
            for (String string : stringArray2) {
                this.listModel.addElement(string);
            }
            this.annotationSetsList = new JList(this.listModel);
            this.annotationSetsList.setCellRenderer(new AnnotationSetNameCellRenderer());
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JScrollPane(this.annotationSetsList), gridBagConstraints);
        }

        protected class RemoveAction
        extends AbstractAction {
            RemoveAction() {
                super("Remove");
                this.putValue("ShortDescription", "Remove the selected value(s) from the list");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = AnnotationSetsList.this.annotationSetsList.getSelectedIndices();
                Arrays.sort(nArray);
                for (int i = nArray.length - 1; i >= 0; --i) {
                    AnnotationSetsList.this.listModel.remove(nArray[i]);
                }
            }
        }

        protected class AddAction
        extends AbstractAction {
            AddAction() {
                super("Add");
                this.putValue("ShortDescription", "Add the edited value to the list");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string = (String)AnnotationSetsList.this.combo.getSelectedItem();
                for (n = 0; n < AnnotationSetsList.this.listModel.size() && NATURAL_COMPARATOR.compare((String)AnnotationSetsList.this.listModel.get(n), string) < 0; ++n) {
                }
                if (n == AnnotationSetsList.this.listModel.size()) {
                    AnnotationSetsList.this.listModel.addElement(string);
                } else if (NATURAL_COMPARATOR.compare((String)AnnotationSetsList.this.listModel.get(n), string) != 0) {
                    AnnotationSetsList.this.listModel.add(n, string);
                }
            }
        }
    }
}

