/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.ontology;

import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.DatatypeProperty;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.RDFProperty;
import gate.creole.ontology.Restriction;
import gate.creole.ontology.SymmetricProperty;
import gate.creole.ontology.TransitiveProperty;
import gate.gui.MainFrame;
import gate.gui.ontology.DetailsGroup;
import gate.gui.ontology.KeyValuePair;
import gate.gui.ontology.PropertyValue;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DetailsTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 3257572784619337525L;

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.setText(null);
        this.setToolTipText(null);
        this.setIcon(null);
        this.setEnabled(true);
        if (n2 == 0) {
            if (object != null) {
                if (object.equals("empty")) {
                    this.setEnabled(false);
                    this.setIcon(MainFrame.getIcon("closed"));
                } else {
                    this.setEnabled(true);
                    this.setIcon(MainFrame.getIcon((String)object));
                }
            }
        } else if (n2 == 1) {
            if (object instanceof DetailsGroup) {
                DetailsGroup detailsGroup = (DetailsGroup)object;
                this.setText(detailsGroup.getName());
                this.setEnabled(detailsGroup.getSize() > 0);
            } else if (object instanceof KeyValuePair) {
                KeyValuePair keyValuePair = (KeyValuePair)object;
                this.setIcon(MainFrame.getIcon("empty"));
                this.setText(keyValuePair.getKey());
            } else if (object instanceof Restriction) {
                OClass oClass = (OClass)object;
                this.setIcon(MainFrame.getIcon("ontology-restriction"));
                this.setText(oClass.getName());
                this.setToolTipText(oClass.getURI().toString());
            } else if (object instanceof OClass) {
                OClass oClass = (OClass)object;
                this.setIcon(MainFrame.getIcon("ontology-class"));
                this.setText(oClass.getName());
                this.setToolTipText(oClass.getURI().toString());
            } else if (object instanceof OInstance) {
                OInstance oInstance = (OInstance)object;
                this.setIcon(MainFrame.getIcon("ontology-instance"));
                this.setText(oInstance.getName());
                this.setToolTipText(oInstance.getURI().toString());
            } else if (object instanceof RDFProperty) {
                RDFProperty rDFProperty = (RDFProperty)object;
                String string = "RDF";
                if (rDFProperty instanceof SymmetricProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-symmetric-property"));
                    string = "Symmetric";
                } else if (rDFProperty instanceof AnnotationProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-annotation-property"));
                    string = "Annotation";
                } else if (rDFProperty instanceof TransitiveProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-transitive-property"));
                    string = "Transitive";
                } else if (rDFProperty instanceof ObjectProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-object-property"));
                    string = "Object";
                } else if (rDFProperty instanceof DatatypeProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-datatype-property"));
                    string = "Datatype";
                } else {
                    this.setIcon(MainFrame.getIcon("ontology-rdf-property"));
                }
                String string2 = rDFProperty.getName();
                this.setText(string2);
                this.setToolTipText("<HTML><b>" + string + " Property</b><br>" + rDFProperty.getURI() + "</html>");
            } else if (object instanceof PropertyValue) {
                PropertyValue propertyValue = (PropertyValue)object;
                String string = "RDF";
                if (propertyValue.getProperty() instanceof SymmetricProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-symmetric-property"));
                    string = "Symmetric";
                } else if (propertyValue.getProperty() instanceof AnnotationProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-annotation-property"));
                    string = "Annotation";
                } else if (propertyValue.getProperty() instanceof TransitiveProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-transitive-property"));
                    string = "Transitive";
                } else if (propertyValue.getProperty() instanceof ObjectProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-object-property"));
                    string = "Object";
                } else if (propertyValue.getProperty() instanceof DatatypeProperty) {
                    this.setIcon(MainFrame.getIcon("ontology-datatype-property"));
                    string = "Datatype";
                } else {
                    this.setIcon(MainFrame.getIcon("ontology-rdf-property"));
                }
                String string3 = propertyValue.getProperty().getName();
                this.setText(string3);
                this.setToolTipText("<HTML><b>" + string + " Property Value</b><br>" + propertyValue.getProperty().getURI() + "</html>");
            }
        } else if (n2 == 2) {
            if (object == null || object.equals("")) {
                return this;
            }
            this.setText(object.toString());
            Object object2 = jTable.getValueAt(n, 1);
            if (object2 instanceof PropertyValue) {
                this.setToolTipText("Double-click to edit the value");
            } else if (object2 instanceof RDFProperty) {
                this.setToolTipText("Double-click to add a property value");
            }
        } else if (n2 == 3) {
            if (object instanceof PropertyValue) {
                this.setIcon(MainFrame.getIcon("delete"));
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
        return this;
    }
}

