/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.docview;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.creole.ontology.AnnotationProperty;
import gate.creole.ontology.InvalidValueException;
import gate.creole.ontology.Literal;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OConstants;
import gate.creole.ontology.OInstance;
import gate.creole.ontology.ONodeID;
import gate.creole.ontology.OResource;
import gate.creole.ontology.OURI;
import gate.creole.ontology.ObjectProperty;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.RDFProperty;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.docview.AbstractDocumentView;
import gate.gui.docview.DocumentView;
import gate.gui.docview.OntologyClassView;
import gate.gui.docview.TextualDocumentView;
import gate.gui.ontology.OntologyEditor;
import gate.swing.XJTable;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import gate.util.Out;
import gate.util.Strings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.text.Collator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class OntologyInstanceView
extends AbstractDocumentView {
    protected Ontology selectedOntology;
    protected TextualDocumentView textView;
    protected OntologyClassView classView;
    protected JPanel mainPanel;
    protected JTextField filterTextField;
    protected JButton clearFilterButton;
    protected JLabel hiddenInstancesLabel;
    protected JButton newInstanceButton;
    protected JButton addLabelButton;
    protected XJTable instanceTable;
    protected XJTable propertyTable;
    protected OClass selectedClass;
    protected OInstance selectedInstance;
    protected Set<OInstance> instances = new HashSet<OInstance>();
    protected Set<ObjectProperty> setProperties = new HashSet<ObjectProperty>();
    protected Set<ObjectProperty> properties = new HashSet<ObjectProperty>();
    protected Map<String, Set<OClass>> classesByPropertyMap = new HashMap<String, Set<OClass>>();
    protected static final String ONTOLOGY = "ontology";
    protected static final String CLASS = "class";
    protected static final String INSTANCE = "inst";
    protected static final String ANNOTATION_TYPE = "Mention";

    protected void initGUI() {
        Serializable serializable;
        Object object;
        Iterator<DocumentView> iterator = this.owner.getCentralViews().iterator();
        while (this.textView == null && iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof TextualDocumentView)) continue;
            this.textView = (TextualDocumentView)object;
        }
        object = this.owner.getVerticalViews().iterator();
        while (this.classView == null && object.hasNext()) {
            serializable = (DocumentView)object.next();
            if (!(serializable instanceof OntologyClassView)) continue;
            this.classView = (OntologyClassView)serializable;
        }
        this.classView.setOwner(this.owner);
        this.mainPanel = new JPanel(new BorderLayout());
        serializable = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Filter: ");
        ((Container)serializable).add(jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.filterTextField = new JTextField(20);
        ((Container)serializable).add(this.filterTextField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.filterTextField.setToolTipText("Filter the instance table on labels");
        this.clearFilterButton = new JButton();
        this.clearFilterButton.setBorder(BorderFactory.createEmptyBorder());
        ((Container)serializable).add(this.clearFilterButton, gridBagConstraints);
        this.hiddenInstancesLabel = new JLabel(" 0 hidden ");
        ((Container)serializable).add(this.hiddenInstancesLabel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        this.newInstanceButton = new JButton("New Inst.");
        this.newInstanceButton.setEnabled(false);
        this.newInstanceButton.setToolTipText("New instance from the selection");
        this.newInstanceButton.setMnemonic(78);
        jPanel.add(this.newInstanceButton);
        this.addLabelButton = new JButton("Add to Selected Inst.");
        this.addLabelButton.setEnabled(false);
        this.addLabelButton.setToolTipText("Add label from selection to the selected instance");
        this.addLabelButton.setMnemonic(65);
        jPanel.add(this.addLabelButton);
        ((Container)serializable).add(jPanel, gridBagConstraints);
        this.mainPanel.add((Component)serializable, "North");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.instanceTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Instance");
        defaultTableModel.addColumn("Labels");
        this.instanceTable.setModel(defaultTableModel);
        jPanel2.add(new JScrollPane(this.instanceTable));
        this.propertyTable = new XJTable(){

            public boolean isCellEditable(int n, int n2) {
                return this.convertColumnIndexToModel(n2) == 1;
            }
        };
        defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Property");
        defaultTableModel.addColumn("Value");
        this.propertyTable.setModel(defaultTableModel);
        jPanel2.add(new JScrollPane(this.propertyTable));
        this.mainPanel.add((Component)jPanel2, "Center");
        this.initListeners();
    }

    protected void initListeners() {
        this.clearFilterButton.setAction(new AbstractAction("", MainFrame.getIcon("exit.gif")){
            {
                this.putValue("MnemonicKey", 8);
                this.putValue("ShortDescription", "Clear text field");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyInstanceView.this.filterTextField.setText("");
                OntologyInstanceView.this.filterTextField.requestFocusInWindow();
            }
        });
        this.instanceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                OntologyInstanceView.this.updatePropertyTable();
                OntologyInstanceView.this.addLabelButton.setEnabled(OntologyInstanceView.this.newInstanceButton.isEnabled() && OntologyInstanceView.this.selectedInstance != null);
            }
        });
        this.instanceTable.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() != '\t' && keyEvent.getKeyChar() != ' ' && keyEvent.getKeyChar() != '\b' && keyEvent.getKeyChar() != '\u007f') {
                    OntologyInstanceView.this.filterTextField.requestFocusInWindow();
                    OntologyInstanceView.this.filterTextField.setText(String.valueOf(keyEvent.getKeyChar()));
                }
            }
        });
        this.instanceTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !jTable.isRowSelected(n)) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (jTable.getSelectedRowCount() == 1) {
                        jPopupMenu.add(new ShowInstanceInOntologyEditorAction());
                        jPopupMenu.addSeparator();
                    }
                    if (jTable.getSelectedRowCount() > 0) {
                        jPopupMenu.add(new DeleteSelectedInstanceAction());
                    }
                    if (jPopupMenu.getComponentCount() > 0) {
                        jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.propertyTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !jTable.isRowSelected(n)) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (jTable.getSelectedRowCount() > 0) {
                        jPopupMenu.add(new DeleteSelectedPropertyAction());
                    }
                    if (jPopupMenu.getComponentCount() > 0) {
                        jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer = new Timer("Instance view table rows filter", true);
            private TimerTask timerTask;

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                Date date = new Date(System.currentTimeMillis() + 300L);
                this.timerTask = new TimerTask(){

                    public void run() {
                        OntologyInstanceView.this.updateInstanceTable(OntologyInstanceView.this.selectedClass);
                    }
                };
                this.timer.schedule(this.timerTask, date);
            }
        });
        this.filterTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34) {
                    OntologyInstanceView.this.instanceTable.dispatchEvent(keyEvent);
                }
            }
        });
    }

    protected void registerHooks() {
        if (!this.classView.isActive()) {
            this.owner.setRightView(this.owner.verticalViews.indexOf(this.classView));
        }
    }

    protected void unregisterHooks() {
        if (this.classView.isActive()) {
            this.owner.setRightView(-1);
        }
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public int getType() {
        return 2;
    }

    public void updateInstanceTable(OClass oClass) {
        this.selectedClass = oClass;
        this.instances.clear();
        HashSet<OInstance> hashSet = new HashSet<OInstance>();
        final DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Instance");
        defaultTableModel.addColumn("Labels");
        if (oClass != null) {
            this.selectedOntology = oClass.getOntology();
            hashSet.addAll(this.selectedOntology.getOInstances(oClass, OConstants.Closure.TRANSITIVE_CLOSURE));
            String string = this.filterTextField.getText().trim().toLowerCase(Locale.ENGLISH);
            for (OInstance oInstance : hashSet) {
                Set<AnnotationProperty> set = oInstance.getSetAnnotationProperties();
                boolean bl = false;
                this.instances.add(oInstance);
                for (AnnotationProperty annotationProperty : set) {
                    if (!annotationProperty.getName().equals("label")) continue;
                    bl = true;
                    List<Literal> list = oInstance.getAnnotationPropertyValues(annotationProperty);
                    HashSet<String> hashSet2 = new HashSet<String>();
                    boolean bl2 = false;
                    for (Literal literal : list) {
                        hashSet2.add(literal.getValue());
                        if (literal.getValue().toLowerCase().indexOf(string) == -1) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        defaultTableModel.addRow(new Object[]{oInstance.getName(), Strings.toString(hashSet2)});
                        continue;
                    }
                    this.instances.remove(oInstance);
                }
                if (bl) continue;
                defaultTableModel.addRow(new Object[]{oInstance.getName(), ""});
            }
        }
        final int n = hashSet.size() - this.instances.size();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OntologyInstanceView.this.hiddenInstancesLabel.setText(" " + n + " hidden ");
                OntologyInstanceView.this.instanceTable.setModel(defaultTableModel);
                if (OntologyInstanceView.this.instanceTable.getRowCount() > 0) {
                    OntologyInstanceView.this.instanceTable.setRowSelectionInterval(0, 0);
                }
            }
        });
    }

    protected void updatePropertyTable() {
        this.selectedInstance = null;
        final DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Property");
        defaultTableModel.addColumn("Value");
        if (this.instanceTable.getSelectedRow() != -1) {
            String string = (String)this.instanceTable.getValueAt(this.instanceTable.getSelectedRow(), this.instanceTable.convertColumnIndexToView(0));
            for (OInstance oInstance : this.instances) {
                if (!oInstance.getName().equals(string)) continue;
                this.selectedInstance = oInstance;
                this.setProperties.clear();
                this.properties.clear();
                Set<OClass> set = oInstance.getOClasses(OConstants.Closure.DIRECT_CLOSURE);
                for (OClass oResource : set) {
                    for (RDFProperty rDFProperty : oResource.getPropertiesWithResourceAsDomain()) {
                        if (!(rDFProperty instanceof ObjectProperty)) continue;
                        this.properties.add((ObjectProperty)rDFProperty);
                        HashSet<String> hashSet = new HashSet<String>();
                        HashSet<OClass> hashSet2 = new HashSet<OClass>();
                        for (OResource oResource2 : ((ObjectProperty)rDFProperty).getRange()) {
                            hashSet.add(oResource2.getName());
                            hashSet2.add((OClass)oResource2);
                        }
                        if (hashSet.isEmpty()) {
                            hashSet.add("All classes");
                        }
                        this.classesByPropertyMap.put(rDFProperty.getName(), hashSet2);
                        defaultTableModel.addRow(new Object[]{rDFProperty.getName(), Strings.toString(hashSet)});
                    }
                }
                for (ObjectProperty objectProperty : oInstance.getSetObjectProperties()) {
                    this.setProperties.add(objectProperty);
                    for (OInstance oInstance2 : oInstance.getObjectPropertyValues(objectProperty)) {
                        defaultTableModel.addRow(new Object[]{objectProperty.getName(), oInstance2.getONodeID().getResourceName()});
                    }
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OntologyInstanceView.this.propertyTable.setModel(defaultTableModel);
                OntologyInstanceView.this.propertyTable.getColumnModel().getColumn(1).setCellEditor(new PropertyValueCellEditor());
                OntologyInstanceView.this.propertyTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        this.setBackground(jTable.getBackground());
                        Object object2 = jTable.getModel().getValueAt(n, 1);
                        if (object2 != null && ((String)object2).startsWith("[")) {
                            this.setBackground(new Color(252, 252, 176));
                        }
                        return this;
                    }
                });
                OntologyInstanceView.this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        this.setBackground(jTable.getBackground());
                        if (object != null && ((String)object).startsWith("[")) {
                            this.setBackground(new Color(252, 252, 176));
                        }
                        return this;
                    }
                });
            }
        });
    }

    protected void addSelectionToFilter(final String string, final String string2, final int n, final int n2) {
        this.newInstanceButton.setAction(new AbstractAction(this.newInstanceButton.getText()){
            {
                super(string4);
                this.putValue("MnemonicKey", 78);
                this.putValue("ShortDescription", OntologyInstanceView.this.newInstanceButton.getToolTipText());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyInstanceView.this.createFromSelection(string, string2, n, n2, true);
                OntologyInstanceView.this.filterTextField.setText("");
            }
        });
        this.newInstanceButton.setEnabled(true);
        this.addLabelButton.setAction(new AbstractAction(this.addLabelButton.getText()){
            {
                super(string4);
                this.putValue("MnemonicKey", 65);
                this.putValue("ShortDescription", OntologyInstanceView.this.addLabelButton.getToolTipText());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                OntologyInstanceView.this.createFromSelection(string, string2, n, n2, false);
                OntologyInstanceView.this.filterTextField.setText("");
            }
        });
        this.filterTextField.setText(string2);
        this.filterTextField.selectAll();
        this.filterTextField.requestFocusInWindow();
        this.addLabelButton.setEnabled(this.selectedInstance != null);
    }

    protected void createFromSelection(String string, String string2, int n, int n2, boolean bl) {
        Comparable<ONodeID> comparable;
        Object object;
        AnnotationProperty annotationProperty;
        this.newInstanceButton.setEnabled(false);
        this.addLabelButton.setEnabled(false);
        RDFProperty rDFProperty = this.selectedOntology.getProperty(this.selectedOntology.createOURIForName("label"));
        if (rDFProperty == null) {
            annotationProperty = this.selectedOntology.addAnnotationProperty(this.selectedOntology.createOURIForName("label"));
        } else if (rDFProperty instanceof AnnotationProperty) {
            annotationProperty = (AnnotationProperty)rDFProperty;
        } else {
            Out.prln("There is already a property 'label' that is not an annotation property!");
            return;
        }
        OInstance oInstance = this.selectedInstance;
        if (bl) {
            object = string2.replaceAll("\\s+", "_");
            if (((String)(object = ((String)object).replaceAll("<>\"&", "_"))).length() > 100) {
                object = ((String)object).substring(0, 100);
            }
            comparable = this.selectedOntology.createOURIForName((String)object);
            for (int i = 0; this.selectedOntology.containsOInstance((OURI)comparable) && i < Integer.MAX_VALUE; ++i) {
                comparable = this.selectedOntology.createOURIForName((String)object + '_' + i);
            }
            oInstance = this.selectedOntology.addOInstance((OURI)comparable, this.selectedClass);
        }
        oInstance.addAnnotationPropertyValue(annotationProperty, new Literal(string2));
        object = this.document.getAnnotations(string);
        try {
            String string3 = this.selectedOntology.getDefaultNameSpace();
            string3 = string3.substring(0, string3.length() - 1);
            this.features = Factory.newFeatureMap();
            this.features.put(ONTOLOGY, string3);
            this.features.put(CLASS, ((Object)this.selectedClass.getONodeID()).toString());
            this.features.put(INSTANCE, ((Object)oInstance.getONodeID()).toString());
            comparable = object.add(Long.valueOf(n), Long.valueOf(n2), ANNOTATION_TYPE, this.features);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            throw new LuckyException(invalidOffsetException);
        }
        this.classView.setClassHighlighted(this.selectedClass, false);
        this.classView.setClassHighlighted(this.selectedClass, true);
        this.updateInstanceTable(this.selectedClass);
    }

    public void selectInstance(OInstance oInstance) {
        for (int i = 0; i < this.instanceTable.getRowCount(); ++i) {
            if (!((Object)oInstance.getONodeID()).toString().endsWith((String)this.instanceTable.getValueAt(i, 0))) continue;
            int n = this.instanceTable.rowViewToModel(i);
            this.instanceTable.getSelectionModel().setSelectionInterval(n, n);
            break;
        }
    }

    protected class DeleteSelectedPropertyAction
    extends AbstractAction {
        public DeleteSelectedPropertyAction() {
            super(OntologyInstanceView.this.propertyTable.getSelectedRowCount() > 1 ? "Delete properties" : "Delete property");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift DELETE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (ObjectProperty objectProperty : OntologyInstanceView.this.setProperties) {
                block1: for (int n : OntologyInstanceView.this.propertyTable.getSelectedRows()) {
                    if (!objectProperty.getName().equals(OntologyInstanceView.this.propertyTable.getModel().getValueAt(n, 0))) continue;
                    for (OInstance oInstance : OntologyInstanceView.this.selectedInstance.getObjectPropertyValues(objectProperty)) {
                        String string = oInstance.getONodeID().getResourceName();
                        if (!string.equals(OntologyInstanceView.this.propertyTable.getModel().getValueAt(n, 1))) continue;
                        OntologyInstanceView.this.selectedInstance.removeObjectPropertyValue(objectProperty, oInstance);
                        continue block1;
                    }
                }
            }
            OntologyInstanceView.this.updatePropertyTable();
        }
    }

    protected class DeleteSelectedInstanceAction
    extends AbstractAction {
        public DeleteSelectedInstanceAction() {
            super(OntologyInstanceView.this.instanceTable.getSelectedRowCount() > 1 ? "Delete instances" : "Delete instance");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift DELETE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = OntologyInstanceView.this.selectedOntology.getDefaultNameSpace();
            string = string.substring(0, string.length() - 1);
            for (OInstance oInstance : OntologyInstanceView.this.instances) {
                for (int n : OntologyInstanceView.this.instanceTable.getSelectedRows()) {
                    if (!oInstance.getName().equals(OntologyInstanceView.this.instanceTable.getModel().getValueAt(n, 0))) continue;
                    OntologyInstanceView.this.selectedOntology.removeOInstance(oInstance);
                    AnnotationSet annotationSet = OntologyInstanceView.this.document.getAnnotations(OntologyInstanceView.this.classView.getSelectedSet());
                    for (Annotation annotation : annotationSet.get(OntologyInstanceView.ANNOTATION_TYPE)) {
                        if (!annotation.getFeatures().containsKey(OntologyInstanceView.ONTOLOGY) || !annotation.getFeatures().get(OntologyInstanceView.ONTOLOGY).equals(string) || !annotation.getFeatures().containsKey(OntologyInstanceView.CLASS) || !annotation.getFeatures().get(OntologyInstanceView.CLASS).equals(((Object)OntologyInstanceView.this.selectedClass.getONodeID()).toString()) || !annotation.getFeatures().containsKey(OntologyInstanceView.INSTANCE) || !annotation.getFeatures().get(OntologyInstanceView.INSTANCE).equals(((Object)oInstance.getONodeID()).toString())) continue;
                        annotationSet.remove(annotation);
                    }
                }
            }
            OntologyInstanceView.this.classView.setClassHighlighted(OntologyInstanceView.this.selectedClass, false);
            OntologyInstanceView.this.classView.setClassHighlighted(OntologyInstanceView.this.selectedClass, true);
            OntologyInstanceView.this.updateInstanceTable(OntologyInstanceView.this.selectedClass);
        }
    }

    protected class ShowInstanceInOntologyEditorAction
    extends AbstractAction {
        public ShowInstanceInOntologyEditorAction() {
            super("Show In Ontology Editor");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    final Handle handle = MainFrame.getInstance().select(OntologyInstanceView.this.selectedOntology);
                    if (handle == null) {
                        return;
                    }
                    Date date = new Date(System.currentTimeMillis() + 1000L);
                    Timer timer = new Timer("Ontology Instance View Timer", true);
                    timer.schedule(new TimerTask(){

                        public void run() {
                            String string = (String)OntologyInstanceView.this.instanceTable.getModel().getValueAt(OntologyInstanceView.this.instanceTable.getSelectedRow(), 0);
                            for (OInstance oInstance : OntologyInstanceView.this.instances) {
                                if (!oInstance.getName().equals(string)) continue;
                                JComponent jComponent = handle.getLargeView();
                                if (jComponent == null || !(jComponent instanceof JTabbedPane) || ((JTabbedPane)jComponent).getSelectedComponent() == null) break;
                                ((OntologyEditor)((JTabbedPane)jComponent).getSelectedComponent()).selectResourceInClassTree(oInstance);
                                break;
                            }
                        }
                    }, date);
                }
            });
        }
    }

    protected class PropertyValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox valueComboBox = new JComboBox();
        private Collator comparator;
        private String oldValue;
        private Map<String, OInstance> nameInstanceMap;
        private Pattern instanceLabelsPattern;

        private PropertyValueCellEditor() {
            this.valueComboBox.setMaximumRowCount(10);
            this.valueComboBox.addActionListener(this);
            this.comparator = Collator.getInstance();
            this.comparator.setStrength(2);
            this.nameInstanceMap = new HashMap<String, OInstance>();
            this.instanceLabelsPattern = Pattern.compile("^(.+) \\[.*\\]$");
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.oldValue = (String)object;
            TreeSet<Object> treeSet = new TreeSet<Object>(this.comparator);
            Set<OClass> set = OntologyInstanceView.this.classesByPropertyMap.get((String)OntologyInstanceView.this.propertyTable.getModel().getValueAt(n, 0));
            if (set.isEmpty()) {
                set = OntologyInstanceView.this.selectedOntology.getOClasses(false);
            }
            for (OClass oClass : set) {
                Set<OInstance> set2 = OntologyInstanceView.this.selectedOntology.getOInstances(oClass, OConstants.Closure.TRANSITIVE_CLOSURE);
                for (OInstance oInstance : set2) {
                    HashSet<String> hashSet = new HashSet<String>();
                    Set<AnnotationProperty> set3 = oInstance.getSetAnnotationProperties();
                    for (AnnotationProperty annotationProperty : set3) {
                        if (!annotationProperty.getName().equals("label")) continue;
                        List<Literal> list = oInstance.getAnnotationPropertyValues(annotationProperty);
                        for (Literal literal : list) {
                            hashSet.add(literal.getValue());
                        }
                    }
                    treeSet.add(oInstance.getName() + " " + Strings.toString(hashSet));
                    this.nameInstanceMap.put(oInstance.getName(), oInstance);
                }
            }
            DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(treeSet.toArray());
            this.valueComboBox.setModel(defaultComboBoxModel);
            this.valueComboBox.setSelectedItem(OntologyInstanceView.this.propertyTable.getValueAt(n, n2));
            return this.valueComboBox;
        }

        public Object getCellEditorValue() {
            return this.valueComboBox.getSelectedItem();
        }

        protected void fireEditingStopped() {
            String string = (String)this.getCellEditorValue();
            if (string == null) {
                this.fireEditingCanceled();
                return;
            }
            Matcher matcher = this.instanceLabelsPattern.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(1);
            }
            super.fireEditingStopped();
            String string2 = (String)OntologyInstanceView.this.propertyTable.getModel().getValueAt(OntologyInstanceView.this.propertyTable.getSelectedRow(), 0);
            for (ObjectProperty objectProperty : OntologyInstanceView.this.setProperties) {
                if (!objectProperty.getName().equals(string2)) continue;
                for (OInstance oInstance : OntologyInstanceView.this.selectedInstance.getObjectPropertyValues(objectProperty)) {
                    String string3 = oInstance.getONodeID().getResourceName();
                    if (!string3.equals(this.oldValue)) continue;
                    OntologyInstanceView.this.selectedInstance.removeObjectPropertyValue(objectProperty, oInstance);
                    try {
                        OntologyInstanceView.this.selectedInstance.addObjectPropertyValue(objectProperty, this.nameInstanceMap.get(string));
                    }
                    catch (InvalidValueException invalidValueException) {
                        invalidValueException.printStackTrace();
                    }
                    OntologyInstanceView.this.updatePropertyTable();
                    return;
                }
            }
            for (ObjectProperty objectProperty : OntologyInstanceView.this.properties) {
                if (!objectProperty.getName().equals(string2)) continue;
                try {
                    OntologyInstanceView.this.selectedInstance.addObjectPropertyValue(objectProperty, this.nameInstanceMap.get(string));
                }
                catch (InvalidValueException invalidValueException) {
                    invalidValueException.printStackTrace();
                }
                OntologyInstanceView.this.updatePropertyTable();
                return;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.getCellEditorValue() == null) {
                this.fireEditingCanceled();
            } else {
                this.fireEditingStopped();
            }
        }
    }
}

