/*
 * Decompiled with CFR 0.152.
 */
package gate.gui.annedit;

import gate.gui.MainFrame;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JNullableTextField
extends JPanel {
    private static final long serialVersionUID = -1530694436281692216L;
    protected JButton nullifyButton;
    protected JTextField textField;
    protected Color normalBgColor;
    protected Color nullBgColor = new Color(200, 250, 255);
    protected Set<DocumentListener> documentListeners;
    protected String text = null;

    public JNullableTextField() {
        this.initGui();
        this.initListeners();
    }

    public void setText(String string) {
        this.textField.setText(string);
        this.text = string;
        this.fireInsertUpdate(null);
    }

    public String getText() {
        return this.text;
    }

    public void setColumns(int n) {
        this.textField.setColumns(n);
    }

    protected void initGui() {
        this.setLayout(new BoxLayout(this, 2));
        this.textField = new JTextField();
        this.add(this.textField);
        this.add(Box.createHorizontalStrut(2));
        this.nullifyButton = new JButton(new NullifyTextAction());
        this.add(this.nullifyButton);
        this.normalBgColor = this.textField.getBackground();
    }

    protected void initListeners() {
        this.documentListeners = Collections.synchronizedSet(new HashSet());
        final DocumentListener documentListener = new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                JNullableTextField.this.text = JNullableTextField.this.textField.getText();
                JNullableTextField.this.fireRemoveUpdate(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                JNullableTextField.this.text = JNullableTextField.this.textField.getText();
                JNullableTextField.this.fireInsertUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                JNullableTextField.this.fireChangedUpdate(documentEvent);
            }
        };
        this.textField.getDocument().addDocumentListener(documentListener);
        this.textField.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JNullableTextField.this.textField.getDocument().addDocumentListener(documentListener);
            }
        });
        this.addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                this.valueChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.valueChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            private void valueChanged() {
                if (JNullableTextField.this.getText() == null) {
                    JNullableTextField.this.textField.setBackground(JNullableTextField.this.nullBgColor);
                } else {
                    JNullableTextField.this.textField.setBackground(JNullableTextField.this.normalBgColor);
                }
            }
        });
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.documentListeners.add(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.documentListeners.remove(documentListener);
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        for (DocumentListener documentListener : this.documentListeners) {
            documentListener.changedUpdate(documentEvent);
        }
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        for (DocumentListener documentListener : this.documentListeners) {
            documentListener.insertUpdate(documentEvent);
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        for (DocumentListener documentListener : this.documentListeners) {
            documentListener.removeUpdate(documentEvent);
        }
    }

    protected class NullifyTextAction
    extends AbstractAction {
        private static final long serialVersionUID = -7807829141939910776L;

        public NullifyTextAction() {
            super(null, MainFrame.getIcon("delete"));
            this.putValue("ShortDescription", "Removes this feature completely");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JNullableTextField.this.textField.setText(null);
            JNullableTextField.this.text = null;
            JNullableTextField.this.fireRemoveUpdate(null);
        }
    }
}

