/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.DataStoreRegister;
import gate.Factory;
import gate.Gate;
import gate.gui.OkCancelDialog;
import gate.gui.UserPasswordDialog;
import gate.persist.PersistenceException;
import gate.security.AccessController;
import gate.security.Group;
import gate.security.SecurityException;
import gate.security.Session;
import gate.security.User;
import gate.util.GateRuntimeException;
import gate.util.Out;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import junit.framework.Assert;

public class UserGroupEditor
extends JComponent {
    protected JPanel jPanel1 = new JPanel();
    protected JPanel jPanel2 = new JPanel();
    protected JList firstList = new JList();
    protected JList secondList = new JList();
    protected CardLayout cardLayout1 = new CardLayout();
    protected JRadioButton displayUsersFirst = new JRadioButton();
    protected JRadioButton displayGroupsFirst = new JRadioButton();
    protected Session session;
    protected AccessController controller;
    protected boolean usersFirst = true;
    protected JButton exitButton = new JButton();
    protected JPopupMenu userMenu = new JPopupMenu();
    protected JPopupMenu groupMenu = new JPopupMenu();

    public UserGroupEditor(AccessController accessController, Session session) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.session = session;
        this.controller = accessController;
        this.showUsersFirst();
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        String string2;
        Gate.init();
        JFrame jFrame = new JFrame();
        ArrayList arrayList = new ArrayList();
        DataStoreRegister dataStoreRegister = Gate.getDataStoreRegister();
        for (String string2 : DataStoreRegister.getConfigData().keySet()) {
            if (!string2.startsWith("url")) continue;
            arrayList.add(DataStoreRegister.getConfigData().get(string2));
        }
        if (arrayList.isEmpty()) {
            throw new GateRuntimeException("Oracle URL not configured in gate.xml");
        }
        string2 = (String)arrayList.get(0);
        if (arrayList.size() > 1) {
            object2 = arrayList.toArray();
            object = JOptionPane.showInputDialog(jFrame, "Select a database", "GATE", 3, null, (Object[])object2, object2[0]);
            if (object != null) {
                string2 = (String)object;
            } else {
                return;
            }
        }
        object2 = Factory.createAccessController(string2);
        Assert.assertNotNull((Object)object2);
        object2.open();
        object = null;
        try {
            object = UserGroupEditor.login((AccessController)object2, jFrame.getContentPane());
        }
        catch (SecurityException securityException) {
            JOptionPane.showMessageDialog(jFrame, "To use this tool you must login as a user with administrative rights!", "Login error", 0);
            object2.close();
            System.exit(-1);
        }
        if (!object2.isValidSession((Session)object)) {
            JOptionPane.showMessageDialog(jFrame, "Incorrect session obtained. Probably there is a problem with the database!", "Login error", 0);
            object2.close();
            System.exit(-1);
        }
        if (!object.isPrivilegedSession()) {
            JOptionPane.showMessageDialog(jFrame, "Insufficient priviliges to edit/view groups and users!", "Login error", 0);
            object2.close();
            System.exit(-1);
        }
        jFrame.setEnabled(true);
        jFrame.setTitle("GATE User/Group Administration Tool");
        jFrame.setDefaultCloseOperation(0);
        UserGroupEditor userGroupEditor = new UserGroupEditor((AccessController)object2, (Session)object);
        jFrame.getContentPane().add((Component)userGroupEditor, "Center");
        jFrame.pack();
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }

    public static Session login(AccessController accessController, Component component) throws PersistenceException, SecurityException {
        String string = "";
        String string2 = "";
        String string3 = "";
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(new JLabel("User name: "));
        jPanel2.add(new JLabel("Password: "));
        jPanel2.add(new JLabel("Group: "));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JTextField jTextField = new JTextField(30);
        jPanel3.add(jTextField);
        JPasswordField jPasswordField = new JPasswordField(30);
        jPanel3.add(jPasswordField);
        JTextField jTextField2 = new JTextField(30);
        jPanel3.add(jTextField2);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(jPanel3);
        if (OkCancelDialog.showDialog(component, jPanel, "Please enter login details")) {
            string = jTextField.getText();
            string2 = new String(jPasswordField.getPassword());
            string3 = jTextField2.getText();
            if (string.equals("") || string2.equals("") || string3.equals("")) {
                JOptionPane.showMessageDialog(component, "You must provide non-empty user name, password and group!", "Login error", 0);
                System.exit(-1);
            }
        }
        return accessController.login(string, string2, accessController.findGroup(string3).getID());
    }

    private void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.displayUsersFirst.setText("Show all users");
        this.displayUsersFirst.setToolTipText("");
        this.displayUsersFirst.setActionCommand("usersFirst");
        this.displayUsersFirst.setSelected(true);
        this.displayUsersFirst.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                UserGroupEditor.this.displayUsersFirst_itemStateChanged(itemEvent);
            }
        });
        this.displayGroupsFirst.setText("Show all groups");
        this.displayGroupsFirst.setActionCommand("groupsFirst");
        this.add((Component)this.jPanel1, null);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.displayUsersFirst);
        buttonGroup.add(this.displayGroupsFirst);
        this.add(this.jPanel1);
        this.jPanel1.add(this.displayUsersFirst);
        this.jPanel1.add(Box.createHorizontalStrut(50));
        this.jPanel1.add(this.displayGroupsFirst);
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)new JScrollPane(this.firstList), "West");
        this.jPanel2.add(Box.createHorizontalStrut(50));
        this.jPanel2.add((Component)new JScrollPane(this.secondList), "East");
        this.firstList.setSelectionMode(0);
        this.firstList.setModel(new DefaultListModel());
        this.firstList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UserGroupEditor.this.listRightMouseClick(mouseEvent);
            }
        });
        this.firstList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UserGroupEditor.this.firstListItemSelected(listSelectionEvent);
            }
        });
        this.secondList.setSelectionMode(0);
        this.secondList.setModel(new DefaultListModel());
        this.secondList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UserGroupEditor.this.listRightMouseClick(mouseEvent);
            }
        });
        this.add(Box.createVerticalGlue());
        this.add(this.exitButton);
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UserGroupEditor.this.controller.close();
                }
                catch (PersistenceException persistenceException) {
                    Out.prln(persistenceException.getMessage());
                }
                System.exit(0);
            }
        });
        this.add(Box.createVerticalStrut(50));
    }

    private void showUsersFirst() {
        DefaultListModel defaultListModel = (DefaultListModel)this.firstList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.secondList.getModel();
        defaultListModel.clear();
        defaultListModel2.clear();
        this.readUsers(defaultListModel, this.firstList);
    }

    private void readUsers(DefaultListModel defaultListModel, JList jList) {
        try {
            List list = this.controller.listUsers();
            for (int i = 0; i < list.size(); ++i) {
                defaultListModel.addElement(list.get(i));
            }
            jList.setModel(defaultListModel);
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException("Cannot read users!");
        }
    }

    private void showGroupsFirst() {
        DefaultListModel defaultListModel = (DefaultListModel)this.firstList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.secondList.getModel();
        defaultListModel.clear();
        defaultListModel2.clear();
        this.readGroups(defaultListModel, this.firstList);
    }

    private void readGroups(DefaultListModel defaultListModel, JList jList) {
        try {
            List list = this.controller.listGroups();
            for (int i = 0; i < list.size(); ++i) {
                defaultListModel.addElement(list.get(i));
            }
            jList.setModel(defaultListModel);
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException("Cannot read groups!");
        }
    }

    void displayUsersFirst_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            if (!this.usersFirst) {
                return;
            }
            this.displayGroupsFirst.setSelected(true);
            if (this.usersFirst) {
                this.showGroupsFirst();
            }
            this.usersFirst = false;
        } else {
            if (this.usersFirst) {
                return;
            }
            this.displayGroupsFirst.setSelected(false);
            if (!this.usersFirst) {
                this.showUsersFirst();
            }
            this.usersFirst = true;
        }
    }

    void listRightMouseClick(MouseEvent mouseEvent) {
        if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        JList jList = (JList)mouseEvent.getSource();
        if (jList.getSelectedIndex() == -1) {
            int n = jList.locationToIndex(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            jList.setSelectedIndex(n);
        } else if (jList.locationToIndex(mouseEvent.getPoint()) != jList.getSelectedIndex()) {
            return;
        }
        if (jList.equals(this.firstList)) {
            if (this.usersFirst) {
                this.showUsersMenu(jList, (int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
            } else {
                this.showGroupsMenu(jList, (int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
            }
        } else if (this.usersFirst) {
            this.showGroupsMenu(jList, (int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
        } else {
            this.showUsersMenu(jList, (int)mouseEvent.getPoint().getX(), (int)mouseEvent.getPoint().getY());
        }
    }

    private void showUsersMenu(JList jList, int n, int n2) {
        this.userMenu.removeAll();
        this.userMenu.add(new CreateUserAction(jList));
        this.userMenu.add(new DeleteUserAction(jList));
        this.userMenu.addSeparator();
        this.userMenu.add(new Add2GroupAction(jList));
        this.userMenu.add(new RemoveFromGroupAction(jList));
        this.userMenu.addSeparator();
        this.userMenu.add(new ChangePasswordAction(jList));
        this.userMenu.add(new RenameUserAction(jList));
        this.userMenu.show(jList, n, n2);
    }

    private void showGroupsMenu(JList jList, int n, int n2) {
        this.groupMenu.removeAll();
        this.groupMenu.add(new AddGroupAction(jList));
        this.groupMenu.add(new DeleteGroupAction(jList));
        this.groupMenu.addSeparator();
        this.groupMenu.add(new AddUserAction(jList));
        this.groupMenu.add(new RemoveUserAction(jList));
        this.groupMenu.addSeparator();
        this.groupMenu.add(new RenameGroupAction(jList));
        this.groupMenu.show(jList, n, n2);
    }

    void firstListItemSelected(ListSelectionEvent listSelectionEvent) {
        int n = this.firstList.getSelectedIndex();
        String string = (String)this.firstList.getModel().getElementAt(n);
        if (this.usersFirst) {
            this.showGroupsForUser(string);
        } else {
            this.showUsersForGroup(string);
        }
    }

    protected void showGroupsForUser(String string) {
        User user = null;
        try {
            user = this.controller.findUser(string);
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException("Cannot locate the user with name: " + string);
        }
        catch (SecurityException securityException) {
            throw new GateRuntimeException(securityException.getMessage());
        }
        if (user == null) {
            return;
        }
        List list = user.getGroups();
        if (list == null) {
            return;
        }
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Group group = (Group)list.get(i);
                defaultListModel.addElement(group.getName());
                continue;
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception.getMessage());
            }
        }
        this.secondList.setModel(defaultListModel);
    }

    protected void showUsersForGroup(String string) {
        Group group = null;
        try {
            group = this.controller.findGroup(string);
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException("Cannot locate the group with name: " + string);
        }
        catch (SecurityException securityException) {
            throw new GateRuntimeException(securityException.getMessage());
        }
        if (group == null) {
            return;
        }
        List list = group.getUsers();
        if (list == null) {
            return;
        }
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                User user = (User)list.get(i);
                defaultListModel.addElement(user.getName());
                continue;
            }
            catch (Exception exception) {
                throw new GateRuntimeException(exception.getMessage());
            }
        }
        this.secondList.setModel(defaultListModel);
    }

    protected class RenameGroupAction
    extends AbstractAction {
        private JList source;

        public RenameGroupAction(JList jList) {
            super("Rename group");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            String string = JOptionPane.showInputDialog(UserGroupEditor.this, (Object)"Please enter the user's new name");
            if (string == null || string.equals("")) {
                return;
            }
            try {
                Group group = UserGroupEditor.this.controller.findGroup((String)defaultListModel.get(n));
                group.setName(string, UserGroupEditor.this.session);
                if (!UserGroupEditor.this.usersFirst) {
                    UserGroupEditor.this.showGroupsFirst();
                } else {
                    UserGroupEditor.this.showGroupsForUser((String)UserGroupEditor.this.firstList.getSelectedValue());
                }
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException(persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error renaming user!", 0);
            }
        }
    }

    protected class RemoveUserAction
    extends AbstractAction {
        private JList source;

        public RemoveUserAction(JList jList) {
            super("Remove user");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            String string = (String)this.source.getSelectedValue();
            JList jList = new JList();
            jList.setSelectionMode(0);
            DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
            Group group = null;
            try {
                group = UserGroupEditor.this.controller.findGroup(string);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException("Cannot locate group: " + string);
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException(securityException.getMessage());
            }
            if (group == null) {
                return;
            }
            List list = group.getUsers();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                try {
                    User user = (User)list.get(i);
                    defaultListModel2.addElement(user.getName());
                    continue;
                }
                catch (Exception exception) {
                    throw new GateRuntimeException(exception.getMessage());
                }
            }
            jList.setModel(defaultListModel2);
            if (OkCancelDialog.showDialog(UserGroupEditor.this, new JScrollPane(jList), "Choose the user you want removed from this group")) {
                try {
                    User user = UserGroupEditor.this.controller.findUser((String)jList.getSelectedValue());
                    group.removeUser(user, UserGroupEditor.this.session);
                    if (!UserGroupEditor.this.usersFirst) {
                        UserGroupEditor.this.showUsersForGroup(group.getName());
                    } else {
                        UserGroupEditor.this.showGroupsForUser(user.getName());
                    }
                }
                catch (PersistenceException persistenceException) {
                    throw new GateRuntimeException(persistenceException.getMessage());
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error removing user from group!", 0);
                }
            }
        }
    }

    protected class AddUserAction
    extends AbstractAction {
        private JList source;

        public AddUserAction(JList jList) {
            super("Add user");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            JList jList = new JList();
            jList.setSelectionMode(0);
            DefaultListModel defaultListModel2 = new DefaultListModel();
            UserGroupEditor.this.readUsers(defaultListModel2, jList);
            if (OkCancelDialog.showDialog(UserGroupEditor.this, new JScrollPane(jList), "Choose a user to add")) {
                String string = (String)jList.getSelectedValue();
                try {
                    Group group = UserGroupEditor.this.controller.findGroup((String)defaultListModel.get(n));
                    User user = UserGroupEditor.this.controller.findUser(string);
                    group.addUser(user, UserGroupEditor.this.session);
                    if (!UserGroupEditor.this.usersFirst) {
                        UserGroupEditor.this.showUsersForGroup(group.getName());
                    }
                }
                catch (PersistenceException persistenceException) {
                    throw new GateRuntimeException(persistenceException.getMessage());
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error adding user to group!", 0);
                }
            }
        }
    }

    protected class DeleteGroupAction
    extends AbstractAction {
        private JList source;

        public DeleteGroupAction(JList jList) {
            super("Delete group");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            try {
                Group group = UserGroupEditor.this.controller.findGroup((String)defaultListModel.get(n));
                UserGroupEditor.this.controller.deleteGroup(group, UserGroupEditor.this.session);
                defaultListModel.remove(n);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException(persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException(securityException.getMessage());
            }
        }
    }

    protected class AddGroupAction
    extends AbstractAction {
        private JList source;

        public AddGroupAction(JList jList) {
            super("Create new group");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            String string = JOptionPane.showInputDialog(UserGroupEditor.this, (Object)"Please enter the name of the new group");
            if (string == null || string.equals("")) {
                return;
            }
            try {
                UserGroupEditor.this.controller.createGroup(string, UserGroupEditor.this.session);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException(persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException(securityException.getMessage());
            }
            if (!UserGroupEditor.this.usersFirst) {
                DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
                defaultListModel.clear();
                UserGroupEditor.this.readGroups(defaultListModel, this.source);
            }
        }
    }

    protected class RenameUserAction
    extends AbstractAction {
        private JList source;

        public RenameUserAction(JList jList) {
            super("Rename user");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            String string = JOptionPane.showInputDialog(UserGroupEditor.this, (Object)"Please enter the user's new name");
            if (string == null || string.equals("")) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            try {
                User user = UserGroupEditor.this.controller.findUser((String)defaultListModel.get(n));
                user.setName(string, UserGroupEditor.this.session);
                defaultListModel.setElementAt(string, n);
                this.source.setSelectedIndex(n);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException(persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error renaming user!", 0);
            }
        }
    }

    protected class ChangePasswordAction
    extends AbstractAction {
        private JList source;

        public ChangePasswordAction(JList jList) {
            super("Change password");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.add(new JLabel("Please enter new password: "));
            jPanel2.add(new JLabel("Please re-enter new password: "));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            JPasswordField jPasswordField = new JPasswordField(30);
            jPanel3.add(jPasswordField);
            JPasswordField jPasswordField2 = new JPasswordField(30);
            jPanel3.add(jPasswordField2);
            jPanel.add(jPanel2);
            jPanel.add(Box.createHorizontalStrut(20));
            jPanel.add(jPanel3);
            if (OkCancelDialog.showDialog(UserGroupEditor.this, jPanel, "Choose a new password")) {
                String string;
                String string2 = new String(jPasswordField.getPassword());
                if (!string2.equals(string = new String(jPasswordField2.getPassword()))) {
                    JOptionPane.showMessageDialog(UserGroupEditor.this, "Cannot change password because you entered two different values for new password", "Error changing user password!", 0);
                    return;
                }
                try {
                    User user = UserGroupEditor.this.controller.findUser((String)defaultListModel.get(n));
                    user.setPassword(string2, UserGroupEditor.this.session);
                }
                catch (PersistenceException persistenceException) {
                    throw new GateRuntimeException(persistenceException.getMessage());
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error adding user to group!", 0);
                }
            }
        }
    }

    protected class RemoveFromGroupAction
    extends AbstractAction {
        private JList source;

        public RemoveFromGroupAction(JList jList) {
            super("Remove from group");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            JList jList = new JList();
            jList.setSelectionMode(0);
            DefaultListModel defaultListModel2 = new DefaultListModel();
            UserGroupEditor.this.readGroups(defaultListModel2, jList);
            if (OkCancelDialog.showDialog(UserGroupEditor.this, new JScrollPane(jList), "Choose the group from which to remove the user")) {
                String string = (String)jList.getSelectedValue();
                try {
                    User user = UserGroupEditor.this.controller.findUser((String)defaultListModel.get(n));
                    Group group = UserGroupEditor.this.controller.findGroup(string);
                    group.removeUser(user, UserGroupEditor.this.session);
                    if (UserGroupEditor.this.usersFirst) {
                        UserGroupEditor.this.showGroupsForUser(user.getName());
                    }
                }
                catch (PersistenceException persistenceException) {
                    throw new GateRuntimeException(persistenceException.getMessage());
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error removing user from group!", 0);
                }
            }
        }
    }

    protected class Add2GroupAction
    extends AbstractAction {
        private JList source;

        public Add2GroupAction(JList jList) {
            super("Add to group");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            JList jList = new JList();
            jList.setSelectionMode(0);
            DefaultListModel defaultListModel2 = new DefaultListModel();
            UserGroupEditor.this.readGroups(defaultListModel2, jList);
            if (OkCancelDialog.showDialog(UserGroupEditor.this, new JScrollPane(jList), "Choose a new group")) {
                String string = (String)jList.getSelectedValue();
                try {
                    User user = UserGroupEditor.this.controller.findUser((String)defaultListModel.get(n));
                    Group group = UserGroupEditor.this.controller.findGroup(string);
                    group.addUser(user, UserGroupEditor.this.session);
                    if (UserGroupEditor.this.usersFirst) {
                        UserGroupEditor.this.showGroupsForUser(user.getName());
                    }
                }
                catch (PersistenceException persistenceException) {
                    throw new GateRuntimeException(persistenceException.getMessage());
                }
                catch (SecurityException securityException) {
                    JOptionPane.showMessageDialog(UserGroupEditor.this, securityException.getMessage(), "Error adding user to group!", 0);
                }
            }
        }
    }

    protected class DeleteUserAction
    extends AbstractAction {
        private JList source;

        public DeleteUserAction(JList jList) {
            super("Delete user");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.source.getSelectedIndex();
            if (n == -1) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            try {
                User user = UserGroupEditor.this.controller.findUser((String)defaultListModel.get(n));
                UserGroupEditor.this.controller.deleteUser(user, UserGroupEditor.this.session);
                defaultListModel.remove(n);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException(persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException(securityException.getMessage());
            }
        }
    }

    protected class CreateUserAction
    extends AbstractAction {
        private JList source;

        public CreateUserAction(JList jList) {
            super("Create new user");
            this.source = jList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            UserPasswordDialog userPasswordDialog = new UserPasswordDialog();
            boolean bl = userPasswordDialog.showPasswordDialog("Please enter user name and password", UserGroupEditor.this);
            if (!bl) {
                return;
            }
            try {
                UserGroupEditor.this.controller.createUser(userPasswordDialog.getUserName(), userPasswordDialog.getPassword(), UserGroupEditor.this.session);
            }
            catch (PersistenceException persistenceException) {
                throw new GateRuntimeException(persistenceException.getMessage());
            }
            catch (SecurityException securityException) {
                throw new GateRuntimeException(securityException.getMessage());
            }
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            defaultListModel.clear();
            UserGroupEditor.this.readUsers(defaultListModel, this.source);
        }
    }
}

