/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.CreoleRegister;
import gate.DataStore;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.VisualResource;
import gate.creole.AbstractResource;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.gui.Handle;
import gate.gui.MainFrame;
import gate.gui.NameBearerHandle;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.Strings;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

@CreoleResource(name="JDBC Datastore Viewer", guiType=GuiType.LARGE, resourceDisplayed="gate.persist.JDBCDataStore", mainViewer=true)
public class OracleDatastoreViewer
extends JTree
implements VisualResource,
DatastoreListener {
    DefaultMutableTreeNode treeRoot;
    DefaultTreeModel treeModel;
    DataStore datastore;
    NameBearerHandle myHandle;
    protected FeatureMap features;
    private transient Vector progressListeners;
    private transient Vector statusListeners;

    public void cleanup() {
        this.myHandle = null;
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public Object getParameterValue(String string) throws ResourceInstantiationException {
        return AbstractResource.getParameterValue(this, string);
    }

    public void setParameterValue(String string, Object object) throws ResourceInstantiationException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass(), Object.class);
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException("Couldn't get bean info for resource " + this.getClass().getName() + Strings.getNl() + "Introspector exception was: " + exception);
        }
        AbstractResource.setParameterValue(this, beanInfo, string, object);
    }

    public void setParameterValues(FeatureMap featureMap) throws ResourceInstantiationException {
        AbstractResource.setParameterValues(this, featureMap);
    }

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    public void clear() {
    }

    public void setTarget(Object object) {
        if (!(object instanceof DataStore)) {
            throw new IllegalArgumentException("SerialDatastoreViewers can only be used with GATE serial datastores!\n" + object.getClass().toString() + " is not a GATE serial datastore!");
        }
        this.datastore = (DataStore)object;
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
    }

    public void setHandle(Handle handle) {
        if (handle instanceof NameBearerHandle) {
            this.myHandle = (NameBearerHandle)handle;
        }
    }

    protected void fireProgressChanged(int n) {
        this.myHandle.fireProgressChanged(n);
    }

    protected void fireProcessFinished() {
        this.myHandle.fireProcessFinished();
    }

    protected void fireStatusChanged(String string) {
        this.myHandle.fireStatusChanged(string);
    }

    protected void initLocalData() {
    }

    protected void initGuiComponents() {
        Object object;
        this.treeRoot = new DefaultMutableTreeNode(this.datastore.getName(), true);
        this.treeModel = new DefaultTreeModel(this.treeRoot, true);
        this.setModel(this.treeModel);
        this.setExpandsSelectedPaths(true);
        this.expandPath(new TreePath(this.treeRoot));
        try {
            object = this.datastore.getLrTypes().iterator();
            CreoleRegister creoleRegister = Gate.getCreoleRegister();
            while (object.hasNext()) {
                String string = (String)object.next();
                ResourceData resourceData = (ResourceData)creoleRegister.get(string);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(resourceData.getName());
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.treeRoot, this.treeRoot.getChildCount());
                this.expandPath(new TreePath(new Object[]{this.treeRoot, defaultMutableTreeNode}));
                for (Object e : this.datastore.getLrIds(string)) {
                    DSEntry dSEntry = new DSEntry(this.datastore.getLrName(e), e, string);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(dSEntry, false);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException(persistenceException.toString());
        }
        object = new DefaultTreeSelectionModel();
        ((DefaultTreeSelectionModel)object).setSelectionMode(1);
        this.setSelectionModel((TreeSelectionModel)object);
    }

    protected void initListeners() {
        this.datastore.addDatastoreListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = OracleDatastoreViewer.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Object object = null;
                if (treePath != null) {
                    object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (object != null && object instanceof DSEntry) {
                        JPopupMenu jPopupMenu = ((DSEntry)object).getPopup();
                        jPopupMenu.show(OracleDatastoreViewer.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && object != null && object instanceof DSEntry) {
                    new LoadAction((DSEntry)object).actionPerformed(null);
                }
            }
        });
    }

    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        Object object;
        Object object2 = datastoreEvent.getResourceID();
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Enumeration<TreeNode> enumeration = this.treeRoot.depthFirstEnumeration();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            object = defaultMutableTreeNode.getUserObject();
            bl = object instanceof DSEntry && ((DSEntry)object).id.equals(object2);
        }
        if (bl) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            if (((DefaultMutableTreeNode)object).getChildCount() == 0) {
                this.treeModel.removeNodeFromParent((MutableTreeNode)object);
            }
        }
    }

    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Resource resource = datastoreEvent.getResource();
        Object object = datastoreEvent.getResourceID();
        String string = ((ResourceData)Gate.getCreoleRegister().get(resource.getClass().getName())).getName();
        DefaultMutableTreeNode defaultMutableTreeNode = this.treeRoot;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            bl = defaultMutableTreeNode2.getUserObject().equals(string);
        }
        if (!bl) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
        this.expandPath(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2}));
        defaultMutableTreeNode = defaultMutableTreeNode2;
        enumeration = defaultMutableTreeNode.children();
        bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            bl = ((DSEntry)defaultMutableTreeNode2.getUserObject()).id.equals(object);
        }
        if (!bl) {
            try {
                DSEntry dSEntry = new DSEntry(this.datastore.getLrName(object), object, resource.getClass().getName());
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(dSEntry, false);
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            }
            catch (PersistenceException persistenceException) {
                persistenceException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class DSEntry {
        String name;
        String type;
        Object id;
        JPopupMenu popup;

        DSEntry(String string, Object object, String string2) {
            this.name = string;
            this.type = string2;
            this.id = object;
            this.popup = new JPopupMenu();
            this.popup.add(new LoadAction(this));
            this.popup.add(new DeleteAction(this));
        }

        public String toString() {
            return this.name;
        }

        public JPopupMenu getPopup() {
            return this.popup;
        }
    }

    class DeleteAction
    extends AbstractAction {
        DSEntry entry;

        DeleteAction(DSEntry dSEntry) {
            super("Delete");
            this.entry = dSEntry;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                OracleDatastoreViewer.this.datastore.delete(this.entry.type, this.entry.id);
            }
            catch (PersistenceException persistenceException) {
                JOptionPane.showMessageDialog(OracleDatastoreViewer.this, "Error!\n" + persistenceException.toString(), "GATE", 0);
                persistenceException.printStackTrace(Err.getPrintWriter());
            }
            catch (SecurityException securityException) {
                JOptionPane.showMessageDialog(OracleDatastoreViewer.this, "Error!\n" + securityException.toString(), "GATE", 0);
                securityException.printStackTrace(Err.getPrintWriter());
            }
        }
    }

    class LoadAction
    extends AbstractAction {
        DSEntry entry;

        LoadAction(DSEntry dSEntry) {
            super("Load");
            this.entry = dSEntry;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            MainFrame.lockGUI("Loading " + LoadAction.this.entry.name);
                            long l = System.currentTimeMillis();
                            OracleDatastoreViewer.this.fireStatusChanged("Loading " + LoadAction.this.entry.name);
                            OracleDatastoreViewer.this.fireProgressChanged(0);
                            FeatureMap featureMap = Factory.newFeatureMap();
                            featureMap.put("DataStore", OracleDatastoreViewer.this.datastore);
                            featureMap.put("LRPersistenceId", LoadAction.this.entry.id);
                            FeatureMap featureMap2 = Factory.newFeatureMap();
                            Resource resource = Factory.createResource(LoadAction.this.entry.type, featureMap, featureMap2, LoadAction.this.entry.name);
                            OracleDatastoreViewer.this.fireProgressChanged(0);
                            OracleDatastoreViewer.this.fireProcessFinished();
                            long l2 = System.currentTimeMillis();
                            OracleDatastoreViewer.this.fireStatusChanged(LoadAction.this.entry.name + " loaded in " + NumberFormat.getInstance().format((double)(l2 - l) / 1000.0) + " seconds");
                        }
                        catch (ResourceInstantiationException resourceInstantiationException) {
                            MainFrame.unlockGUI();
                            JOptionPane.showMessageDialog(OracleDatastoreViewer.this, "Error!\n" + resourceInstantiationException.toString(), "GATE", 0);
                            resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                            OracleDatastoreViewer.this.fireProgressChanged(0);
                            OracleDatastoreViewer.this.fireProcessFinished();
                            Object var9_8 = null;
                            MainFrame.unlockGUI();
                            return;
                        }
                        Object var9_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        MainFrame.unlockGUI();
                        throw throwable;
                    }
                    MainFrame.unlockGUI();
                }
            };
            Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable, "Loader from DS");
            thread.setPriority(1);
            thread.start();
        }
    }
}

