/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.MainFrame;
import gate.swing.JFontChooser;
import gate.util.GateRuntimeException;
import gate.util.OptionsMap;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class OptionsDialog
extends JDialog {
    public static String[] menuKeys = new String[]{"CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font"};
    public static String[] componentsKeys = new String[]{"Button.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "InternalFrame.titleFont", "Label.font", "List.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "ScrollPane.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"};
    public static String[] textComponentsKeys = new String[]{"EditorPane.font", "TextArea.font", "TextPane.font"};
    protected JTabbedPane mainTabbedPane;
    protected JRadioButton textBtn;
    protected JButton okButton;
    protected JButton cancelButton;
    protected String selectedFontBtn = null;
    protected JRadioButton menuBtn;
    protected JRadioButton otherCompsBtn;
    protected ButtonGroup fontBG;
    protected JFontChooser fontChooser;
    protected JCheckBox saveOptionsChk;
    protected JCheckBox saveSessionChk;
    protected JCheckBox includeFeaturesOnPreserveFormatChk;
    protected JCheckBox addSpaceOnMarkupUnpackChk;
    protected String lookAndFeelClassName;
    protected Font menusFont;
    protected Font textComponentsFont;
    protected Font componentsFont;
    protected boolean dirtyGUI;
    protected JComboBox lnfCombo;
    protected JComboBox browserComboBox;
    protected JTextField browserCommandLineTextField;
    protected JCheckBox treeSelectViewChk;
    protected JCheckBox viewSelectTreeChk;
    protected static OptionsMap userConfig = Gate.getUserConfig();

    public OptionsDialog(Frame frame) {
        super(frame, "GATE Options", true);
        MainFrame.getGuiRoots().add(this);
    }

    protected void initLocalData() {
        this.lookAndFeelClassName = userConfig.getString("Look_and_Feel");
        this.textComponentsFont = userConfig.getFont("Text_components_font");
        this.menusFont = userConfig.getFont("Menus_font");
        this.componentsFont = userConfig.getFont("Other_components_font");
        this.dirtyGUI = false;
    }

    protected void initGuiComponents() {
        this.getContentPane().removeAll();
        this.mainTabbedPane = new JTabbedPane(1);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.mainTabbedPane);
        ArrayList<LNFData> arrayList = new ArrayList<LNFData>();
        LNFData lNFData = null;
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (UIManager.LookAndFeelInfo object2 : lookAndFeelInfoArray) {
            try {
                Class<?> exception = Class.forName(object2.getClassName());
                if (!((LookAndFeel)exception.newInstance()).isSupportedLookAndFeel()) continue;
                if (object2.getName().equals(UIManager.getLookAndFeel().getName())) {
                    lNFData = new LNFData(object2.getClassName(), object2.getName());
                    arrayList.add(lNFData);
                    continue;
                }
                arrayList.add(new LNFData(object2.getClassName(), object2.getName()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.lnfCombo = new JComboBox<Object>(arrayList.toArray());
        this.lnfCombo.setSelectedItem(lNFData);
        this.lnfCombo.setToolTipText("Be aware that only 'Metal' is fully tested.");
        this.fontBG = new ButtonGroup();
        this.textBtn = new JRadioButton("Text components font");
        this.textBtn.setActionCommand("text");
        this.fontBG.add(this.textBtn);
        this.menuBtn = new JRadioButton("Menu components font");
        this.menuBtn.setActionCommand("menu");
        this.fontBG.add(this.menuBtn);
        this.otherCompsBtn = new JRadioButton("Other components font");
        this.otherCompsBtn.setActionCommand("other");
        this.fontBG.add(this.otherCompsBtn);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(Box.createVerticalStrut(5));
        Box box = Box.createVerticalBox();
        box.setBackground(this.getContentPane().getBackground());
        box.setBorder(BorderFactory.createTitledBorder(" Look and Feel "));
        box.add(Box.createVerticalStrut(5));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.lnfCombo);
        box2.add(Box.createHorizontalStrut(5));
        box.add(box2);
        box.add(Box.createVerticalStrut(5));
        jPanel.add(box);
        jPanel.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createTitledBorder(" Font options "));
        box2.add(Box.createHorizontalStrut(5));
        box = Box.createVerticalBox();
        box.add(this.textBtn);
        box.add(Box.createVerticalStrut(5));
        box.add(this.menuBtn);
        box.add(Box.createVerticalStrut(5));
        box.add(this.otherCompsBtn);
        box.add(Box.createVerticalStrut(5));
        box.add(Box.createVerticalGlue());
        box2.add(Box.createHorizontalStrut(5));
        box2.add(box);
        this.fontChooser = new JFontChooser();
        box2.add(this.fontChooser);
        box2.add(Box.createHorizontalStrut(5));
        jPanel.add(box2);
        this.mainTabbedPane.add("Appearance", jPanel);
        this.saveOptionsChk = new JCheckBox("Save options on exit", (boolean)userConfig.getBoolean("Save_options_on_exit"));
        this.saveOptionsChk.setToolTipText("Remembers the options set in this dialogue.");
        this.saveSessionChk = new JCheckBox("Save session on exit", (boolean)userConfig.getBoolean("Save_session_on_exit"));
        this.saveSessionChk.setToolTipText("Reloads the same resources in the tree on next start.");
        this.includeFeaturesOnPreserveFormatChk = new JCheckBox("Include annotation features for \"Save preserving format\"", (boolean)userConfig.getBoolean("Save_features_when_preserving_format"));
        this.addSpaceOnMarkupUnpackChk = new JCheckBox("Add space on markup unpack if needed", true);
        this.addSpaceOnMarkupUnpackChk.setToolTipText("Adds a space instead of concatenate words separated by a XML tag");
        if (userConfig.get("Document_add_space_on_unpack") != null && !userConfig.getBoolean("Document_add_space_on_unpack").booleanValue()) {
            this.addSpaceOnMarkupUnpackChk.setSelected(false);
        }
        this.browserComboBox = new JComboBox<String>(new String[]{"Default browser", "Java", "Custom"});
        this.browserComboBox.setPrototypeDisplayValue("Default browser");
        this.browserComboBox.setToolTipText("Use Java or Custom only if Default doesn't work.");
        this.browserCommandLineTextField = new JTextField(15);
        String string = userConfig.getString(MainFrame.class.getName() + ".browsercommandline");
        if (string == null || string.trim().length() == 0 || string.equals("Set dynamically when you display help.")) {
            this.browserComboBox.setSelectedItem("Default browser");
            this.browserCommandLineTextField.setEnabled(false);
        } else if (string.equals("Internal Java browser.")) {
            this.browserComboBox.setSelectedItem("Java");
            this.browserCommandLineTextField.setEnabled(false);
        } else {
            this.browserComboBox.setSelectedItem("Custom");
        }
        this.browserCommandLineTextField.setText(string == null ? "" : string);
        this.treeSelectViewChk = new JCheckBox("Tree select view", (boolean)userConfig.getBoolean(MainFrame.class.getName() + ".treeselectview"));
        this.treeSelectViewChk.setToolTipText("Selection in left resources tree select the main view");
        this.viewSelectTreeChk = new JCheckBox("View select in tree", (boolean)userConfig.getBoolean(MainFrame.class.getName() + ".viewselecttree"));
        this.viewSelectTreeChk.setToolTipText("Selection of the main view select item in left resources tree");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createTitledBorder(" Advanced features "));
        box2.add(Box.createHorizontalStrut(5));
        box = Box.createVerticalBox();
        box.add(this.includeFeaturesOnPreserveFormatChk);
        box.add(Box.createVerticalStrut(5));
        box.add(this.addSpaceOnMarkupUnpackChk);
        box.add(Box.createVerticalStrut(5));
        box2.add(box);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(Box.createHorizontalGlue());
        jPanel2.add(box2);
        jPanel2.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createTitledBorder(" Session persistence "));
        box2.add(Box.createHorizontalStrut(5));
        Box box3 = Box.createHorizontalBox();
        box3.add(this.saveOptionsChk);
        box3.add(Box.createVerticalStrut(5));
        box3.add(this.saveSessionChk);
        box3.add(Box.createVerticalStrut(5));
        box2.add(box3);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(Box.createHorizontalGlue());
        jPanel2.add(box2);
        jPanel2.add(Box.createVerticalStrut(5));
        box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createTitledBorder(" Help browser "));
        box2.add(Box.createHorizontalStrut(5));
        box = Box.createVerticalBox();
        box.add(this.browserComboBox);
        box.add(Box.createVerticalStrut(5));
        box.add(this.browserCommandLineTextField);
        box.add(Box.createVerticalStrut(5));
        box2.add(box);
        box2.add(Box.createHorizontalStrut(5));
        jPanel2.add(box2);
        box2 = Box.createHorizontalBox();
        box2.setBorder(BorderFactory.createTitledBorder(" Link resources tree selection and the main view "));
        box2.add(Box.createHorizontalStrut(5));
        box3 = Box.createHorizontalBox();
        box3.add(this.treeSelectViewChk);
        box3.add(Box.createVerticalStrut(5));
        box3.add(this.viewSelectTreeChk);
        box3.add(Box.createVerticalStrut(5));
        box2.add(box3);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(Box.createHorizontalGlue());
        jPanel2.add(box2);
        this.mainTabbedPane.add("Advanced", jPanel2);
        Box box4 = Box.createHorizontalBox();
        this.okButton = new JButton(new OKAction());
        box4.add(this.okButton);
        box4.add(Box.createHorizontalStrut(10));
        this.cancelButton = new JButton(new CancelAction());
        box4.add(this.cancelButton);
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getContentPane().add(box4);
        this.getContentPane().add(Box.createVerticalStrut(10));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    protected void initListeners() {
        this.lnfCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!OptionsDialog.this.lookAndFeelClassName.equals(((LNFData)OptionsDialog.this.lnfCombo.getSelectedItem()).className)) {
                    OptionsDialog.this.dirtyGUI = true;
                    OptionsDialog.this.lookAndFeelClassName = ((LNFData)OptionsDialog.this.lnfCombo.getSelectedItem()).className;
                }
            }
        });
        this.fontChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fontValue")) {
                    String string = OptionsDialog.this.fontBG.getSelection().getActionCommand();
                    if (string.equals("text")) {
                        OptionsDialog.this.textComponentsFont = (Font)propertyChangeEvent.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    } else if (string.equals("menu")) {
                        OptionsDialog.this.menusFont = (Font)propertyChangeEvent.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    } else if (string.equals("other")) {
                        OptionsDialog.this.componentsFont = (Font)propertyChangeEvent.getNewValue();
                        OptionsDialog.this.dirtyGUI = true;
                    }
                }
            }
        });
        this.textBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.textBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "text";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.textComponentsFont);
            }
        });
        this.menuBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.menuBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "menu";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.menusFont);
            }
        });
        this.otherCompsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.otherCompsBtn.isSelected()) {
                    OptionsDialog.this.selectedFontChanged();
                }
                OptionsDialog.this.selectedFontBtn = "other";
                OptionsDialog.this.fontChooser.setFontValue(OptionsDialog.this.componentsFont);
            }
        });
        this.textBtn.setSelected(true);
        this.browserComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (OptionsDialog.this.browserComboBox.getSelectedItem() == null) {
                    return;
                }
                String string = (String)OptionsDialog.this.browserComboBox.getSelectedItem();
                OptionsDialog.this.browserCommandLineTextField.setEnabled(string.equals("Custom"));
                if (string.equals("Default browser")) {
                    OptionsDialog.this.browserCommandLineTextField.setText("Set dynamically when you display help.");
                } else if (string.equals("Java")) {
                    OptionsDialog.this.browserCommandLineTextField.setText("Internal Java browser.");
                } else if (string.equals("Custom")) {
                    OptionsDialog.this.browserCommandLineTextField.setText("firefox %file");
                }
            }
        });
        InputMap inputMap = ((JComponent)this.getContentPane()).getInputMap(2);
        ActionMap actionMap = ((JComponent)this.getContentPane()).getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Apply");
        actionMap.put("Apply", new OKAction());
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Cancel");
        actionMap.put("Cancel", new CancelAction());
    }

    protected void selectedFontChanged() {
        if (this.selectedFontBtn != null) {
            if (this.selectedFontBtn.equals("text")) {
                this.textComponentsFont = this.fontChooser.getFontValue();
            } else if (this.selectedFontBtn.equals("menu")) {
                this.menusFont = this.fontChooser.getFontValue();
            } else if (this.selectedFontBtn.equals("other")) {
                this.componentsFont = this.fontChooser.getFontValue();
            }
        }
    }

    public void showDialog() {
        this.initLocalData();
        this.initGuiComponents();
        this.initListeners();
        this.textBtn.doClick();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        this.selectedFontBtn = null;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        final JFrame jFrame = new JFrame("Foo frame");
        jFrame.setDefaultCloseOperation(2);
        JButton jButton = new JButton("Show dialog");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDialog optionsDialog = new OptionsDialog(jFrame);
                optionsDialog.pack();
                optionsDialog.showDialog();
            }
        });
        jFrame.getContentPane().add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
        System.out.println("Font: " + UIManager.getFont("Button.font"));
    }

    protected static void setUIDefaults(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            UIManager.put(objectArray[i], object);
        }
    }

    public static void setTextComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(textComponentsKeys, new FontUIResource(font));
        userConfig.put((Object)"Text_components_font", font);
    }

    public static void setMenuComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(menuKeys, new FontUIResource(font));
        userConfig.put((Object)"Menus_font", font);
    }

    public static void setComponentsFont(Font font) {
        OptionsDialog.setUIDefaults(componentsKeys, new FontUIResource(font));
        userConfig.put((Object)"Other_components_font", font);
    }

    protected static class LNFData {
        String className;
        String name;

        public LNFData(String string, String string2) {
            this.className = string;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            super("OK");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OptionsDialog.this.dirtyGUI) {
                OptionsDialog.setMenuComponentsFont(OptionsDialog.this.menusFont);
                OptionsDialog.setComponentsFont(OptionsDialog.this.componentsFont);
                OptionsDialog.setTextComponentsFont(OptionsDialog.this.textComponentsFont);
                userConfig.put((Object)"Look_and_Feel", OptionsDialog.this.lookAndFeelClassName);
                try {
                    UIManager.setLookAndFeel(OptionsDialog.this.lookAndFeelClassName);
                }
                catch (Exception exception) {
                    throw new GateRuntimeException("Error while setting the look and feel", exception);
                }
                Iterator<Component> iterator = MainFrame.getGuiRoots().iterator();
                while (iterator.hasNext()) {
                    try {
                        SwingUtilities.updateComponentTreeUI(iterator.next());
                    }
                    catch (Exception exception) {
                        throw new GateRuntimeException("Error while updating the graphical interface", exception);
                    }
                }
            }
            userConfig.put((Object)"Save_options_on_exit", (Object)OptionsDialog.this.saveOptionsChk.isSelected());
            userConfig.put((Object)"Save_session_on_exit", (Object)OptionsDialog.this.saveSessionChk.isSelected());
            userConfig.put((Object)"Save_features_when_preserving_format", (Object)OptionsDialog.this.includeFeaturesOnPreserveFormatChk.isSelected());
            userConfig.put((Object)"Document_add_space_on_unpack", (Object)OptionsDialog.this.addSpaceOnMarkupUnpackChk.isSelected());
            userConfig.put((Object)(MainFrame.class.getName() + ".browsercommandline"), OptionsDialog.this.browserCommandLineTextField.getText());
            userConfig.put((Object)(MainFrame.class.getName() + ".treeselectview"), (Object)OptionsDialog.this.treeSelectViewChk.isSelected());
            userConfig.put((Object)(MainFrame.class.getName() + ".viewselecttree"), (Object)OptionsDialog.this.viewSelectTreeChk.isSelected());
            OptionsDialog.this.setVisible(false);
        }
    }
}

