/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Factory;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.GazetteerEvent;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.GazetteerListener;
import gate.creole.gazetteer.GazetteerNode;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.LinearNode;
import gate.gui.ActionsPublisher;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import gate.swing.XJTable;
import gate.util.Err;
import gate.util.ExtensionFileFilter;
import gate.util.Files;
import gate.util.GateRuntimeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class GazetteerEditor
extends AbstractVisualResource
implements GazetteerListener,
ActionsPublisher {
    protected Gazetteer gazetteer;
    protected LinearDefinition linearDefinition;
    protected LinearNode selectedLinearNode;
    protected Collator collator;
    protected List<Action> actions;
    protected XJTable definitionTable;
    protected DefaultTableModel definitionTableModel = new DefaultTableModel();
    protected XJTable listTable;
    protected ListTableModel listTableModel;
    protected JComboBox newListComboBox;
    protected JButton newListButton;
    protected JTextField newEntryTextField;
    protected JButton addColumnsButton;
    protected JTextField listFilterTextField;
    protected JCheckBox regexCheckBox;
    protected JCheckBox caseInsensitiveCheckBox;
    protected JCheckBox onlyValueCheckBox;
    protected JLabel listCountLabel;

    public GazetteerEditor() {
        this.definitionTableModel.addColumn("List name");
        this.definitionTableModel.addColumn("Major");
        this.definitionTableModel.addColumn("Minor");
        this.definitionTableModel.addColumn("Language");
        this.listTableModel = new ListTableModel();
        this.actions = new ArrayList<Action>();
        this.actions.add(new SaveAndReinitialiseGazetteerAction());
        this.actions.add(new SaveAsGazetteerAction());
    }

    public Resource init() throws ResourceInstantiationException {
        this.initGUI();
        this.initListeners();
        return this;
    }

    protected void initGUI() {
        this.collator = Collator.getInstance(Locale.ENGLISH);
        this.collator.setStrength(2);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.newListComboBox = new JComboBox();
        this.newListComboBox.setEditable(true);
        this.newListComboBox.setPrototypeDisplayValue("123456789012345");
        this.newListComboBox.setToolTipText("Lists available in the gazetteer directory");
        this.newListButton = new JButton("New List");
        JTextField jTextField = (JTextField)this.newListComboBox.getEditor().getEditorComponent();
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void update(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                try {
                    String string = document.getText(0, document.getLength());
                    if (string.trim().length() == 0) {
                        GazetteerEditor.this.newListButton.setEnabled(false);
                        GazetteerEditor.this.newListButton.setText("New List");
                    } else if (string.contains(":")) {
                        GazetteerEditor.this.newListButton.setEnabled(false);
                        GazetteerEditor.this.newListButton.setText("No colon");
                    } else if (GazetteerEditor.this.linearDefinition.getLists().contains(string)) {
                        GazetteerEditor.this.newListButton.setEnabled(false);
                        GazetteerEditor.this.newListButton.setText("Existing");
                    } else {
                        GazetteerEditor.this.newListButton.setEnabled(true);
                        GazetteerEditor.this.newListButton.setText("New List");
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        this.newListComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GazetteerEditor.this.newListButton.doClick();
                }
            }
        });
        this.newListButton.setToolTipText("New list in the gazetteer");
        this.newListButton.setMargin(new Insets(2, 2, 2, 2));
        this.newListButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)GazetteerEditor.this.newListComboBox.getEditor().getItem();
                GazetteerEditor.this.newListComboBox.removeItem(string);
                GazetteerEditor.this.definitionTableModel.addRow(new Object[]{string, "", "", ""});
                GazetteerEditor.this.linearDefinition.add(new LinearNode(string, "", "", ""));
                final int n = GazetteerEditor.this.definitionTable.rowModelToView(GazetteerEditor.this.definitionTable.getRowCount() - 1);
                final int n2 = GazetteerEditor.this.definitionTable.convertColumnIndexToView(0);
                GazetteerEditor.this.definitionTable.setRowSelectionInterval(n, n);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GazetteerEditor.this.definitionTable.scrollRectToVisible(GazetteerEditor.this.definitionTable.getCellRect(n, n2, true));
                        GazetteerEditor.this.definitionTable.requestFocusInWindow();
                    }
                });
            }
        });
        jPanel2.add(this.newListComboBox);
        jPanel2.add(this.newListButton);
        jPanel.add((Component)jPanel2, "North");
        this.definitionTable = new XJTable(){

            protected void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 && (keyEvent.getModifiersEx() & 0x40) != 0) {
                    new DeleteSelectedLinearNodeAction().actionPerformed(null);
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        };
        this.definitionTable.setSelectionMode(0);
        this.definitionTable.setRowSelectionAllowed(true);
        this.definitionTable.setColumnSelectionAllowed(false);
        this.definitionTable.setEnableHidingColumns(true);
        this.definitionTable.setAutoResizeMode(0);
        this.definitionTable.setModel(this.definitionTableModel);
        this.definitionTable.setSortable(true);
        this.definitionTable.setSortedColumn(0);
        this.definitionTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                GazetteerList gazetteerList;
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setForeground(jTable.getForeground());
                LinearNode linearNode = (LinearNode)GazetteerEditor.this.linearDefinition.getNodesByListNames().get(object);
                if (linearNode != null && (gazetteerList = (GazetteerList)GazetteerEditor.this.linearDefinition.getListsByNode().get(linearNode)) != null && gazetteerList.isModified()) {
                    this.setForeground(Color.RED);
                }
                return this;
            }
        });
        jPanel.add((Component)new JScrollPane(this.definitionTable), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        this.newEntryTextField = new JTextField(10);
        this.newEntryTextField.setEnabled(false);
        final JButton jButton = new JButton("New Entry ");
        jButton.setToolTipText("New entry in the list");
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setEnabled(false);
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GazetteerNode gazetteerNode = new GazetteerNode(GazetteerEditor.this.newEntryTextField.getText(), Factory.newFeatureMap());
                GazetteerEditor.this.listTableModel.addRow(gazetteerNode);
                GazetteerEditor.this.listTableModel.setFilterText("");
                GazetteerEditor.this.listFilterTextField.setText("");
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
                final int n = GazetteerEditor.this.listTable.rowModelToView(GazetteerEditor.this.listTable.getRowCount() - 1);
                final int n2 = GazetteerEditor.this.listTable.convertColumnIndexToView(0);
                GazetteerEditor.this.newEntryTextField.setText("");
                GazetteerEditor.this.newEntryTextField.requestFocusInWindow();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GazetteerEditor.this.listTable.scrollRectToVisible(GazetteerEditor.this.listTable.getCellRect(n, n2, true));
                        GazetteerEditor.this.listTable.setRowSelectionInterval(n, n);
                        GazetteerEditor.this.listTable.setColumnSelectionInterval(n2, n2);
                        GazetteerList gazetteerList = (GazetteerList)GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
                        gazetteerList.setModified(true);
                        GazetteerEditor.this.definitionTable.repaint();
                    }
                });
            }
        });
        this.newEntryTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    jButton.doClick();
                }
            }
        });
        this.newEntryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void update(DocumentEvent documentEvent) {
                Document document = documentEvent.getDocument();
                try {
                    String string = document.getText(0, document.getLength());
                    if (string.trim().length() == 0) {
                        jButton.setEnabled(false);
                        jButton.setText("New Entry");
                    } else if (GazetteerEditor.this.linearDefinition.getSeparator() != null && GazetteerEditor.this.linearDefinition.getSeparator().length() > 0 && string.contains(GazetteerEditor.this.linearDefinition.getSeparator())) {
                        jButton.setEnabled(false);
                        jButton.setText("No char " + GazetteerEditor.this.linearDefinition.getSeparator());
                    } else {
                        GazetteerList gazetteerList = (GazetteerList)GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
                        boolean bl = false;
                        for (Object e : gazetteerList) {
                            GazetteerNode gazetteerNode = (GazetteerNode)e;
                            if (!gazetteerNode.getEntry().equals(string)) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            jButton.setEnabled(false);
                            jButton.setText("Existing ");
                        } else {
                            jButton.setEnabled(true);
                            jButton.setText("New Entry");
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
        this.addColumnsButton = new JButton("Add Cols");
        this.addColumnsButton.setToolTipText("Add a couple of columns Feature and Value");
        this.addColumnsButton.setMargin(new Insets(2, 2, 2, 2));
        this.addColumnsButton.setEnabled(false);
        this.addColumnsButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GazetteerEditor.this.linearDefinition.getSeparator() == null || GazetteerEditor.this.linearDefinition.getSeparator().length() == 0) {
                    String string = JOptionPane.showInputDialog(MainFrame.getInstance(), "Type a character separator to separate\nfeatures in the gazetteers lists.", "Feature Separator", 3);
                    if (string == null || string.equals("")) {
                        return;
                    }
                    GazetteerEditor.this.linearDefinition.setSeparator(string);
                }
                GazetteerEditor.this.listTableModel.addEmptyFeatureColumns();
                GazetteerEditor.this.listFilterTextField.setText("");
                GazetteerEditor.this.listTableModel.setFilterText("");
                GazetteerEditor.this.listTableModel.fireTableStructureChanged();
            }
        });
        jPanel4.add(this.newEntryTextField);
        jPanel4.add(jButton);
        jPanel4.add(this.addColumnsButton);
        jPanel3.add((Component)jPanel4, "North");
        this.listTable = new XJTable(){

            protected void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 && (keyEvent.getModifiersEx() & 0x40) != 0) {
                    new DeleteSelectedGazetteerNodeAction().actionPerformed(null);
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        };
        this.listTable.setSelectionMode(1);
        this.listTable.setRowSelectionAllowed(true);
        this.listTable.setColumnSelectionAllowed(true);
        this.listTable.setEnableHidingColumns(true);
        this.listTable.setAutoResizeMode(0);
        this.listTable.setModel(this.listTableModel);
        this.listTable.setSortable(true);
        this.listTable.setSortedColumn(0);
        jPanel3.add((Component)new JScrollPane(this.listTable), "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        this.listFilterTextField = new JTextField(15);
        this.listFilterTextField.setToolTipText("Filter rows on all column values");
        this.listFilterTextField.setEnabled(false);
        this.listFilterTextField.getDocument().addDocumentListener(new DocumentListener(){
            private Timer timer = new Timer("Gazetteer list filter timer", true);
            private TimerTask timerTask;

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update();
            }

            private void update() {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                Date date = new Date(System.currentTimeMillis() + 300L);
                this.timerTask = new TimerTask(){

                    public void run() {
                        String string = GazetteerEditor.this.listFilterTextField.getText().trim();
                        GazetteerEditor.this.listTableModel.setFilterText(string);
                        GazetteerEditor.this.listTableModel.fireTableDataChanged();
                    }
                };
                this.timer.schedule(this.timerTask, date);
            }
        });
        jPanel6.add(new JLabel("Filter: "));
        jPanel6.add(this.listFilterTextField);
        this.caseInsensitiveCheckBox = new JCheckBox("Case Ins.");
        jPanel6.add(this.caseInsensitiveCheckBox);
        this.caseInsensitiveCheckBox.setSelected(true);
        this.caseInsensitiveCheckBox.setToolTipText("Case Insensitive");
        this.caseInsensitiveCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GazetteerEditor.this.listFilterTextField.setText(GazetteerEditor.this.listFilterTextField.getText());
            }
        });
        this.regexCheckBox = new JCheckBox("Regex");
        jPanel6.add(this.regexCheckBox);
        this.regexCheckBox.setToolTipText("Regular Expression");
        this.regexCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GazetteerEditor.this.listFilterTextField.setText(GazetteerEditor.this.listFilterTextField.getText());
            }
        });
        this.onlyValueCheckBox = new JCheckBox("Value");
        jPanel6.add(this.onlyValueCheckBox);
        this.onlyValueCheckBox.setToolTipText("Filter only Value column");
        this.onlyValueCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GazetteerEditor.this.listFilterTextField.setText(GazetteerEditor.this.listFilterTextField.getText());
            }
        });
        jPanel5.add((Component)jPanel6, "West");
        this.listCountLabel = new JLabel();
        jPanel5.add((Component)this.listCountLabel, "East");
        jPanel3.add((Component)jPanel5, "South");
        JSplitPane jSplitPane = new JSplitPane(1, true);
        jSplitPane.add(jPanel);
        jSplitPane.add(jPanel3);
        jSplitPane.setResizeWeight(0.33);
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane, "Center");
    }

    protected void initListeners() {
        this.definitionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting() || GazetteerEditor.this.definitionTable.isEditing()) {
                    return;
                }
                if (GazetteerEditor.this.definitionTable.getSelectedRow() == -1) {
                    GazetteerEditor.this.listTableModel.setGazetteerList(new GazetteerList());
                    GazetteerEditor.this.selectedLinearNode = null;
                    GazetteerEditor.this.newEntryTextField.setEnabled(false);
                    GazetteerEditor.this.addColumnsButton.setEnabled(false);
                    GazetteerEditor.this.listFilterTextField.setEnabled(false);
                } else {
                    String string = (String)GazetteerEditor.this.definitionTable.getValueAt(GazetteerEditor.this.definitionTable.getSelectedRow(), GazetteerEditor.this.definitionTable.convertColumnIndexToView(0));
                    GazetteerEditor.this.selectedLinearNode = (LinearNode)GazetteerEditor.this.linearDefinition.getNodesByListNames().get(string);
                    if (GazetteerEditor.this.selectedLinearNode != null) {
                        GazetteerEditor.this.listTableModel.setGazetteerList((GazetteerList)GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode));
                    }
                    GazetteerEditor.this.newEntryTextField.setEnabled(true);
                    GazetteerEditor.this.addColumnsButton.setEnabled(true);
                    GazetteerEditor.this.listFilterTextField.setEnabled(true);
                }
                if (!GazetteerEditor.this.listFilterTextField.getText().equals("")) {
                    GazetteerEditor.this.listFilterTextField.setText("");
                }
                if (!GazetteerEditor.this.newEntryTextField.getText().equals("")) {
                    GazetteerEditor.this.newEntryTextField.setText("");
                }
                GazetteerEditor.this.listTableModel.setFilterText("");
                GazetteerEditor.this.listTableModel.fireTableStructureChanged();
                if (GazetteerEditor.this.definitionTable.getSelectedRow() != -1 && GazetteerEditor.this.selectedLinearNode != null) {
                    for (int i = 0; i < GazetteerEditor.this.listTable.getColumnCount(); ++i) {
                        GazetteerEditor.this.listTable.setComparator(i, GazetteerEditor.this.collator);
                    }
                    GazetteerEditor.this.listTableModel.fireTableDataChanged();
                }
            }
        });
        this.definitionTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                switch (tableModelEvent.getType()) {
                    case 0: {
                        int n2 = tableModelEvent.getColumn();
                        if (n == -1 || n2 == -1) {
                            return;
                        }
                        String string = (String)GazetteerEditor.this.definitionTableModel.getValueAt(n, n2);
                        if (n2 == 0) {
                            String string2 = GazetteerEditor.this.selectedLinearNode.getList();
                            if (string2 != null && string2.equals(string)) {
                                return;
                            }
                            try {
                                GazetteerList gazetteerList = (GazetteerList)GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
                                gazetteerList.store();
                                MainFrame.getInstance().statusChanged("Previous list saved in " + gazetteerList.getURL().getPath());
                                File file = Files.fileFromURL(gazetteerList.getURL());
                                File file2 = new File(file.getParentFile(), string);
                                gazetteerList.setURL(file2.toURI().toURL());
                                gazetteerList.setModified(false);
                                GazetteerEditor.this.linearDefinition.getNodesByListNames().remove(GazetteerEditor.this.selectedLinearNode.getList());
                                GazetteerEditor.this.linearDefinition.getNodesByListNames().put(string, GazetteerEditor.this.selectedLinearNode);
                                GazetteerEditor.this.linearDefinition.setModified(true);
                            }
                            catch (Exception exception) {
                                MainFrame.getInstance().statusChanged("Unable to save the list.");
                                Err.prln("Unable to save the list.\n" + exception.getMessage());
                            }
                            GazetteerEditor.this.selectedLinearNode.setList(string);
                            break;
                        }
                        if (n2 == 1) {
                            String string3 = GazetteerEditor.this.selectedLinearNode.getMajorType();
                            if (string3 != null && string3.equals(string)) {
                                return;
                            }
                            GazetteerEditor.this.selectedLinearNode.setMajorType(string);
                            GazetteerEditor.this.linearDefinition.setModified(true);
                            break;
                        }
                        if (n2 == 2) {
                            String string4 = GazetteerEditor.this.selectedLinearNode.getMinorType();
                            if (string4 != null && string4.equals(string)) {
                                return;
                            }
                            GazetteerEditor.this.selectedLinearNode.setMinorType(string);
                            GazetteerEditor.this.linearDefinition.setModified(true);
                            break;
                        }
                        String string5 = GazetteerEditor.this.selectedLinearNode.getLanguage();
                        if (string5 != null && string5.equals(string)) {
                            return;
                        }
                        GazetteerEditor.this.selectedLinearNode.setLanguage(string);
                        GazetteerEditor.this.linearDefinition.setModified(true);
                    }
                }
            }
        });
        this.definitionTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !jTable.isRowSelected(n)) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                XJTable xJTable = (XJTable)mouseEvent.getSource();
                if (mouseEvent.isPopupTrigger() && xJTable.getSelectedRowCount() > 0) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(new ReloadGazetteerListAction());
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new DeleteSelectedLinearNodeAction());
                    jPopupMenu.show(xJTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.listTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.processMouseEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (mouseEvent.isPopupTrigger() && !jTable.isRowSelected(n)) {
                    jTable.getSelectionModel().setSelectionInterval(n, n);
                }
                this.processMouseEvent(mouseEvent);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                XJTable xJTable = (XJTable)mouseEvent.getSource();
                if (mouseEvent.isPopupTrigger() && xJTable.getSelectedRowCount() > 0) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(new CopySelectionAction());
                    jPopupMenu.add(new PasteSelectionAction());
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new FillDownSelectionAction());
                    jPopupMenu.add(new ClearSelectionAction());
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new DeleteSelectedGazetteerNodeAction());
                    jPopupMenu.show(xJTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.listTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                GazetteerEditor.this.listCountLabel.setText(String.valueOf(GazetteerEditor.this.listTableModel.getRowCount()) + " entries ");
            }
        });
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control S"), "save");
        actionMap.put("save", this.actions.get(0));
        inputMap.put(KeyStroke.getKeyStroke("control shift S"), "save as");
        actionMap.put("save as", this.actions.get(1));
        inputMap.put(KeyStroke.getKeyStroke("control R"), "reload list");
        actionMap.put("reload list", new ReloadGazetteerListAction());
        inputMap = this.listTable.getInputMap(2);
        actionMap = this.listTable.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("control V"), "paste table selection");
        actionMap.put("paste table selection", new PasteSelectionAction());
    }

    public void setTarget(Object object) {
        if (null == object) {
            throw new GateRuntimeException("The resource set is null.");
        }
        if (!(object instanceof Gazetteer)) {
            throw new GateRuntimeException("The resource set must be of type gate.creole.gazetteer.Gazetteer\nand not " + object.getClass());
        }
        ((Gazetteer)object).addGazetteerListener(this);
        this.processGazetteerEvent(new GazetteerEvent(object, 1));
    }

    public void processGazetteerEvent(GazetteerEvent gazetteerEvent) {
        this.gazetteer = (Gazetteer)gazetteerEvent.getSource();
        if (gazetteerEvent.getType() == 1) {
            String[] stringArray;
            Object object22;
            this.linearDefinition = this.gazetteer.getLinearDefinition();
            if (null == this.linearDefinition) {
                throw new GateRuntimeException("Linear definition of a gazetteer should not be null.");
            }
            try {
                if (this.linearDefinition.getSeparator() != null && this.linearDefinition.getSeparator().length() > 0) {
                    this.linearDefinition.loadLists(true);
                }
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace();
                return;
            }
            this.definitionTableModel.setRowCount(0);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object object22 : this.linearDefinition.getNodes()) {
                stringArray = (String[])object22;
                arrayList.add(stringArray.getList() == null ? "" : stringArray.getList());
                arrayList.add(stringArray.getMajorType() == null ? "" : stringArray.getMajorType());
                arrayList.add(stringArray.getMinorType() == null ? "" : stringArray.getMinorType());
                arrayList.add(stringArray.getLanguage() == null ? "" : stringArray.getLanguage());
                this.definitionTableModel.addRow(arrayList.toArray());
                arrayList.clear();
            }
            for (int i = 0; i < this.definitionTable.getColumnCount(); ++i) {
                this.definitionTable.setComparator(i, this.collator);
            }
            File file = new File(Files.fileFromURL(this.gazetteer.getListsURL()).getParent());
            object22 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".lst") && !GazetteerEditor.this.linearDefinition.getLists().contains(string);
                }
            });
            stringArray = new String[((E)object22).length];
            int n = 0;
            for (Object e : object22) {
                stringArray[n++] = ((File)e).getName();
            }
            Arrays.sort(stringArray, this.collator);
            this.newListComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
            if (stringArray.length == 0) {
                this.newListButton.setEnabled(false);
            }
        }
    }

    public List getActions() {
        return this.actions;
    }

    protected class ClearSelectionAction
    extends AbstractAction {
        public ClearSelectionAction() {
            super("Clear Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control DELETE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = GazetteerEditor.this.listTable.getSelectedRows();
            int[] nArray2 = GazetteerEditor.this.listTable.getSelectedColumns();
            GazetteerEditor.this.listTable.clearSelection();
            for (int n : nArray2) {
                for (int n2 : nArray) {
                    GazetteerEditor.this.listTableModel.setValueAt("", GazetteerEditor.this.listTable.rowViewToModel(n2), GazetteerEditor.this.listTable.convertColumnIndexToModel(n));
                }
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        }
    }

    protected class PasteSelectionAction
    extends AbstractAction {
        public PasteSelectionAction() {
            super("Paste Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = GazetteerEditor.this.listTable.getSelectedRow();
            int n2 = GazetteerEditor.this.listTable.getSelectedColumn();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String string = null;
            try {
                if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    string = (String)clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string == null) {
                return;
            }
            int n3 = n;
            for (String string2 : string.split("\n")) {
                int n4 = n2;
                for (String string3 : string2.split("\t")) {
                    GazetteerEditor.this.listTableModel.setValueAt(string3, GazetteerEditor.this.listTable.rowViewToModel(n3), GazetteerEditor.this.listTable.convertColumnIndexToModel(n4));
                    if (n4 + 1 > GazetteerEditor.this.listTable.getColumnCount()) break;
                    ++n4;
                }
                if (n3 + 1 > GazetteerEditor.this.listTable.getRowCount()) break;
                ++n3;
            }
            GazetteerEditor.this.listTableModel.fireTableDataChanged();
        }
    }

    protected class CopySelectionAction
    extends AbstractAction {
        public CopySelectionAction() {
            super("Copy Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GazetteerEditor.this.listTable.getActionMap().get("copy").actionPerformed(new ActionEvent(GazetteerEditor.this.listTable, 1001, null));
        }
    }

    protected class FillDownSelectionAction
    extends AbstractAction {
        public FillDownSelectionAction() {
            super("Fill Down Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control D"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = GazetteerEditor.this.listTable.getSelectedRows();
            int[] nArray2 = GazetteerEditor.this.listTable.getSelectedColumns();
            GazetteerEditor.this.listTable.clearSelection();
            for (int n : nArray2) {
                String string = (String)GazetteerEditor.this.listTable.getValueAt(nArray[0], n);
                for (int n2 : nArray) {
                    GazetteerEditor.this.listTableModel.setValueAt(string, GazetteerEditor.this.listTable.rowViewToModel(n2), GazetteerEditor.this.listTable.convertColumnIndexToModel(n));
                }
                GazetteerEditor.this.listTableModel.fireTableDataChanged();
            }
        }
    }

    protected class DeleteSelectedGazetteerNodeAction
    extends AbstractAction {
        public DeleteSelectedGazetteerNodeAction() {
            super(GazetteerEditor.this.listTable.getSelectedRowCount() > 1 ? "Delete Rows" : "Delete Row");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift DELETE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = GazetteerEditor.this.listTable.getSelectedRows();
            GazetteerEditor.this.listTable.clearSelection();
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = GazetteerEditor.this.listTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                GazetteerEditor.this.listTableModel.removeRow(nArray[n]);
            }
            GazetteerEditor.this.listTableModel.fireTableDataChanged();
        }
    }

    protected class DeleteSelectedLinearNodeAction
    extends AbstractAction {
        public DeleteSelectedLinearNodeAction() {
            super(GazetteerEditor.this.definitionTable.getSelectedRowCount() > 1 ? "Delete Rows" : "Delete Row");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift DELETE"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int[] nArray = GazetteerEditor.this.definitionTable.getSelectedRows();
            GazetteerEditor.this.definitionTable.clearSelection();
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = GazetteerEditor.this.definitionTable.rowViewToModel(nArray[n]);
            }
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                GazetteerEditor.this.definitionTableModel.removeRow(nArray[n]);
                GazetteerEditor.this.linearDefinition.remove(nArray[n]);
            }
        }
    }

    protected class SaveAsGazetteerAction
    extends AbstractAction {
        public SaveAsGazetteerAction() {
            super("Save as...");
            this.putValue("ShortDescription", "Save the definition and all the lists");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift S"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("Gazetteer files", "def");
            xJFileChooser.addChoosableFileFilter(extensionFileFilter);
            xJFileChooser.setMultiSelectionEnabled(false);
            xJFileChooser.setFileSelectionMode(0);
            xJFileChooser.setDialogTitle("Select a file name...");
            xJFileChooser.setResource(GazetteerEditor.class.getName());
            int n = xJFileChooser.showSaveDialog(GazetteerEditor.this);
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                try {
                    URL uRL = GazetteerEditor.this.linearDefinition.getURL();
                    GazetteerEditor.this.linearDefinition.setURL(file.toURI().toURL());
                    GazetteerEditor.this.linearDefinition.store();
                    GazetteerEditor.this.linearDefinition.setURL(uRL);
                    for (Object v : GazetteerEditor.this.linearDefinition.getListsByNode().values()) {
                        GazetteerList gazetteerList = (GazetteerList)v;
                        uRL = gazetteerList.getURL();
                        gazetteerList.setURL(new File(file.getParentFile(), Files.fileFromURL(gazetteerList.getURL()).getName()).toURI().toURL());
                        gazetteerList.store();
                        gazetteerList.setURL(uRL);
                        gazetteerList.setModified(false);
                    }
                    MainFrame.getInstance().statusChanged("Gazetteer saved in " + file.getAbsolutePath());
                    GazetteerEditor.this.definitionTable.repaint();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    MainFrame.getInstance().statusChanged("Unable to save the Gazetteer.");
                    Err.prln("Unable to save the Gazetteer.\n" + resourceInstantiationException.getMessage());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        }
    }

    protected class SaveAndReinitialiseGazetteerAction
    extends AbstractAction {
        public SaveAndReinitialiseGazetteerAction() {
            super("Save and Reinitialise");
            this.putValue("ShortDescription", "Save the definition and all the lists then reinitialise");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (GazetteerEditor.this.linearDefinition.isModified()) {
                    GazetteerEditor.this.linearDefinition.store();
                }
                for (Object v : GazetteerEditor.this.linearDefinition.getListsByNode().values()) {
                    GazetteerList gazetteerList = (GazetteerList)v;
                    if (!gazetteerList.isModified()) continue;
                    gazetteerList.store();
                }
                GazetteerEditor.this.gazetteer.reInit();
                MainFrame.getInstance().statusChanged("Gazetteer saved in " + GazetteerEditor.this.linearDefinition.getURL().getPath());
                GazetteerEditor.this.definitionTable.repaint();
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                MainFrame.getInstance().statusChanged("Unable to save the Gazetteer.");
                Err.prln("Unable to save the Gazetteer.\n" + resourceInstantiationException.getMessage());
            }
        }
    }

    protected class ReloadGazetteerListAction
    extends AbstractAction {
        public ReloadGazetteerListAction() {
            super("Reload List");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control R"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GazetteerList gazetteerList = (GazetteerList)GazetteerEditor.this.linearDefinition.getListsByNode().get(GazetteerEditor.this.selectedLinearNode);
            gazetteerList.clear();
            try {
                gazetteerList.load(true);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                resourceInstantiationException.printStackTrace();
                return;
            }
            int n = GazetteerEditor.this.definitionTable.getSelectedRow();
            GazetteerEditor.this.definitionTable.clearSelection();
            GazetteerEditor.this.definitionTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    protected class ListTableModel
    extends AbstractTableModel {
        private int columnCount = -1;
        private String filter = "";
        private GazetteerList gazetteerList;
        private GazetteerList gazetteerListFiltered = new GazetteerList();

        public int getRowCount() {
            return this.gazetteerListFiltered.size();
        }

        public int getColumnCount() {
            if (this.columnCount > -1) {
                return this.columnCount;
            }
            if (this.gazetteerListFiltered == null) {
                return 0;
            }
            this.columnCount = 1;
            for (Object e : this.gazetteerListFiltered) {
                GazetteerNode gazetteerNode = (GazetteerNode)e;
                Map map = gazetteerNode.getFeatureMap();
                if (map == null || this.columnCount >= 2 * map.size() + 1) continue;
                this.columnCount = 2 * map.size() + 1;
            }
            return this.columnCount;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Value";
            }
            int n2 = (n + n % 2) / 2;
            if (n % 2 == 1) {
                return "Feature " + n2;
            }
            return "Value " + n2;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Object getValueAt(int n, int n2) {
            GazetteerNode gazetteerNode = (GazetteerNode)this.gazetteerListFiltered.get(n);
            if (n2 == 0) {
                return gazetteerNode.getEntry();
            }
            Map map = gazetteerNode.getFeatureMap();
            if (map == null || map.size() * 2 < n2) {
                return "";
            }
            ArrayList arrayList = new ArrayList(map.keySet());
            int n3 = (n2 + n2 % 2) / 2;
            if (n2 % 2 == 1) {
                return arrayList.get(n3 - 1);
            }
            return map.get(arrayList.get(n3 - 1));
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            Object object3;
            if (n == -1 || n2 == -1) {
                return;
            }
            if (GazetteerEditor.this.linearDefinition.getSeparator() != null && GazetteerEditor.this.linearDefinition.getSeparator().length() > 0 && ((String)object).contains(GazetteerEditor.this.linearDefinition.getSeparator())) {
                object3 = GazetteerEditor.this.listTable.getCellRect(GazetteerEditor.this.listTable.getSelectedRow(), GazetteerEditor.this.listTable.getSelectedColumn(), true).getLocation();
                ((Point)object3).translate(GazetteerEditor.this.listTable.getLocationOnScreen().x, GazetteerEditor.this.listTable.getLocationOnScreen().y);
                object2 = new Timer("GazetteerEditor tooltip timer", true);
                SwingUtilities.invokeLater(new Runnable((Point)object3, (Timer)object2){
                    final /* synthetic */ Point val$point;
                    final /* synthetic */ Timer val$timer;
                    {
                        this.val$point = point;
                        this.val$timer = timer;
                    }

                    public void run() {
                        if (!GazetteerEditor.this.listTable.isShowing()) {
                            return;
                        }
                        JToolTip jToolTip = GazetteerEditor.this.listTable.createToolTip();
                        jToolTip.setTipText("No separator character allowed: [" + GazetteerEditor.this.linearDefinition.getSeparator() + "]");
                        PopupFactory popupFactory = PopupFactory.getSharedInstance();
                        final Popup popup = popupFactory.getPopup(GazetteerEditor.this.listTable, jToolTip, this.val$point.x, this.val$point.y - 20);
                        popup.show();
                        Date date = new Date(System.currentTimeMillis() + 3000L);
                        this.val$timer.schedule(new TimerTask(){

                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        popup.hide();
                                    }
                                });
                            }
                        }, date);
                    }
                });
                object = ((String)object).replaceAll("\\Q" + GazetteerEditor.this.linearDefinition.getSeparator() + "\\E", "");
            }
            object3 = (GazetteerNode)this.gazetteerListFiltered.get(n);
            if (n2 == 0) {
                ((GazetteerNode)object3).setEntry((String)object);
            } else {
                object2 = new LinkedHashMap<String, String>();
                int n3 = 1;
                while (n3 + 1 < this.getColumnCount()) {
                    String string = (String)(n3 == n2 ? object : this.getValueAt(n, n3));
                    String string2 = (String)(n3 + 1 == n2 ? object : (String)this.getValueAt(n, n3 + 1));
                    object2.put(string, string2);
                    n3 += 2;
                }
                ((GazetteerNode)object3).setFeatureMap((Map)object2);
                this.fireTableRowsUpdated(n, n);
            }
            this.gazetteerList.setModified(true);
            GazetteerEditor.this.definitionTable.repaint();
        }

        public void fireTableStructureChanged() {
            this.columnCount = -1;
            super.fireTableStructureChanged();
        }

        public void fireTableChanged(TableModelEvent tableModelEvent) {
            if (this.gazetteerList == null) {
                return;
            }
            if (this.filter.length() < 2) {
                this.gazetteerListFiltered.clear();
                this.gazetteerListFiltered.addAll((Collection)this.gazetteerList);
                super.fireTableChanged(tableModelEvent);
            } else {
                this.filterRows();
                super.fireTableChanged(new TableModelEvent(this));
            }
        }

        public void setFilterText(String string) {
            this.filter = string;
        }

        protected void filterRows() {
            Pattern pattern;
            String string = this.filter;
            String string2 = GazetteerEditor.this.regexCheckBox.isSelected() ? "" : "\\Q";
            String string3 = GazetteerEditor.this.regexCheckBox.isSelected() ? "" : "\\E";
            string = string2 + string + string3;
            try {
                pattern = GazetteerEditor.this.caseInsensitiveCheckBox.isSelected() ? Pattern.compile(string, 2) : Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return;
            }
            this.gazetteerListFiltered.clear();
            for (Object e : this.gazetteerList) {
                GazetteerNode gazetteerNode = (GazetteerNode)e;
                boolean bl = false;
                Map map = gazetteerNode.getFeatureMap();
                if (map != null && !GazetteerEditor.this.onlyValueCheckBox.isSelected()) {
                    for (Object k : map.keySet()) {
                        if (!pattern.matcher((String)k).find() && !pattern.matcher((String)map.get(k)).find()) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl && !pattern.matcher(gazetteerNode.getEntry()).find()) continue;
                this.gazetteerListFiltered.add(gazetteerNode);
            }
        }

        public void addEmptyFeatureColumns() {
            GazetteerNode gazetteerNode;
            if (this.getColumnCount() == 1) {
                GazetteerNode gazetteerNode2 = (GazetteerNode)this.gazetteerListFiltered.get(0);
                HashMap hashMap = new HashMap();
                hashMap.put("", "");
                gazetteerNode2.setFeatureMap(hashMap);
            } else {
                for (HashMap hashMap : this.gazetteerListFiltered) {
                    gazetteerNode = (GazetteerNode)((Object)hashMap);
                    Map map = gazetteerNode.getFeatureMap();
                    if (map == null || 2 * map.size() + 1 != this.getColumnCount()) continue;
                    map.put("", "");
                    break;
                }
            }
            for (HashMap hashMap : this.gazetteerList) {
                gazetteerNode = (GazetteerNode)((Object)hashMap);
                gazetteerNode.setSeparator(GazetteerEditor.this.linearDefinition.getSeparator());
            }
        }

        public void addRow(GazetteerNode gazetteerNode) {
            this.gazetteerList.add(gazetteerNode);
        }

        public void removeRow(int n) {
            this.gazetteerList.remove(this.gazetteerListFiltered.get(n));
        }

        public void setGazetteerList(GazetteerList gazetteerList) {
            this.gazetteerList = gazetteerList;
        }
    }
}

