/*
 * Decompiled with CFR 0.152.
 */
package gate.gui;

import gate.Gate;
import gate.gui.ListEditorDialog;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class CorpusFillerComponent
extends JPanel {
    JTextField urlTextField;
    JButton filerBtn;
    JTextField extensionsTextField;
    JButton listEditBtn;
    JCheckBox recurseCheckBox;
    JTextField encodingTextField;
    JTextField mimeTypeTextField;
    private List extensions;

    public CorpusFillerComponent() {
        this.initLocalData();
        this.initGUIComponents();
        this.initListeners();
    }

    protected void initLocalData() {
        this.extensions = new ArrayList();
    }

    protected void initGUIComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Directory URL:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.urlTextField = new JTextField(40);
        this.add((Component)this.urlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        this.filerBtn = new JButton(MainFrame.getIcon("open-file"));
        this.add((Component)this.filerBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Extensions:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.extensionsTextField = new JTextField(40);
        this.add((Component)this.extensionsTextField, gridBagConstraints);
        this.extensionsTextField.setEditable(false);
        this.extensionsTextField.setText(this.extensions.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        this.listEditBtn = new JButton(MainFrame.getIcon("edit-list"));
        this.add((Component)this.listEditBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Encoding:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.encodingTextField = new JTextField(15);
        this.add((Component)this.encodingTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)new JLabel("Mime Type:"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.mimeTypeTextField = new JTextField(15);
        this.add((Component)this.mimeTypeTextField, gridBagConstraints);
        this.recurseCheckBox = new JCheckBox("Recurse directories");
        this.recurseCheckBox.setSelected(true);
        this.recurseCheckBox.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.recurseCheckBox, gridBagConstraints);
    }

    protected void initListeners() {
        this.filerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                xJFileChooser.setFileSelectionMode(1);
                xJFileChooser.setDialogTitle("Select a directory");
                xJFileChooser.resetChoosableFileFilters();
                xJFileChooser.setAcceptAllFileFilterUsed(true);
                xJFileChooser.setFileFilter(xJFileChooser.getAcceptAllFileFilter());
                int n = xJFileChooser.showOpenDialog(CorpusFillerComponent.this);
                if (n == 0) {
                    try {
                        CorpusFillerComponent.this.urlTextField.setText(xJFileChooser.getSelectedFile().toURI().toURL().toExternalForm());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.listEditBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListEditorDialog listEditorDialog = new ListEditorDialog(CorpusFillerComponent.this, CorpusFillerComponent.this.extensions, String.class.getName());
                List list = listEditorDialog.showDialog();
                if (list != null) {
                    CorpusFillerComponent.this.extensions.clear();
                    CorpusFillerComponent.this.extensions.addAll(list);
                    CorpusFillerComponent.this.extensionsTextField.setText(CorpusFillerComponent.this.extensions.toString());
                }
            }
        });
    }

    public void setUrlString(String string) {
        this.urlTextField.setText(string);
    }

    public String getUrlString() {
        return this.urlTextField.getText();
    }

    public String getEncoding() {
        return this.encodingTextField.getText();
    }

    public void setEncoding(String string) {
        this.encodingTextField.setText(string);
    }

    public String getMimeType() {
        return this.mimeTypeTextField.getText();
    }

    public void setMimeType(String string) {
        this.mimeTypeTextField.setText(string);
    }

    public void setExtensions(List list) {
        this.extensions = list;
        this.extensionsTextField.setText(list.toString());
    }

    public List getExtensions() {
        return this.extensions;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Gate.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Foo");
        CorpusFillerComponent corpusFillerComponent = new CorpusFillerComponent();
        jFrame.getContentPane().add(corpusFillerComponent);
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.setVisible(true);
    }

    public void setRecurseDirectories(boolean bl) {
        this.recurseCheckBox.setSelected(bl);
    }

    public boolean isRecurseDirectories() {
        return this.recurseCheckBox.isSelected();
    }
}

