/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.AbstractOntoGazetteer;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.InvalidFormatException;
import gate.creole.gazetteer.Lookup;
import gate.creole.gazetteer.MappingDefinition;
import java.util.Set;

public class OntoGazetteerImpl
extends AbstractOntoGazetteer {
    public Set lookup(String string) {
        return this.gaz.lookup(string);
    }

    public Resource init() throws ResourceInstantiationException {
        try {
            this.checkParameters();
            Class<?> clazz = Class.forName(this.gazetteerName, true, Gate.getClassLoader());
            FeatureMap featureMap = Factory.newFeatureMap();
            this.mappingDefinition = new MappingDefinition();
            this.mappingDefinition.setURL(this.mappingURL);
            this.mappingDefinition.load();
            featureMap.put("caseSensitive", this.caseSensitive);
            featureMap.put("listsURL", this.listsURL);
            featureMap.put("encoding", this.encoding);
            featureMap.put("mappingDefinition", this.mappingDefinition);
            this.gaz = (Gazetteer)Factory.createResource(clazz.getName(), featureMap);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("ClassNotFoundException : " + classNotFoundException.getMessage());
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new ResourceInstantiationException(invalidFormatException);
        }
        return this;
    }

    public void execute() throws ExecutionException {
        if (null == this.gaz) {
            throw new ExecutionException("gazetteer not initialized (null).");
        }
        this.gaz.setDocument(this.document);
        this.gaz.setAnnotationSetName(this.annotationSetName);
        this.gaz.setEncoding(this.encoding);
        this.gaz.setCorpus(this.corpus);
        this.gaz.execute();
    }

    private void checkParameters() throws ResourceInstantiationException {
        boolean bl = null != this.gazetteerName;
        bl &= null != this.listsURL;
        if (!(bl &= null != this.mappingURL)) {
            throw new ResourceInstantiationException("some parameters are not set (e.g.gazetteerName,listURL,mappingDefinition, document");
        }
    }

    public boolean remove(String string) {
        return this.gaz.remove(string);
    }

    public boolean add(String string, Lookup lookup) {
        return this.gaz.add(string, lookup);
    }
}

