/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.PhrasePositions;
import gate.creole.annic.apache.lucene.search.PhraseScorer;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;

final class SloppyPhraseScorer
extends PhraseScorer {
    private int slop;

    SloppyPhraseScorer(Weight weight, TermPositions[] termPositionsArray, Similarity similarity, int n, byte[] byArray) throws IOException {
        super(weight, termPositionsArray, similarity, byArray);
        this.slop = n;
    }

    protected final float phraseFreq() throws IOException {
        this.pq.clear();
        int n = 0;
        PhrasePositions phrasePositions = this.first;
        while (phrasePositions != null) {
            phrasePositions.firstPosition();
            if (phrasePositions.position > n) {
                n = phrasePositions.position;
            }
            this.pq.put(phrasePositions);
            phrasePositions = phrasePositions.next;
        }
        float f = 0.0f;
        boolean bl = false;
        do {
            PhrasePositions phrasePositions2 = (PhrasePositions)this.pq.pop();
            int n2 = phrasePositions2.position;
            int n3 = ((PhrasePositions)this.pq.top()).position;
            int n4 = n2;
            while (n4 <= n3) {
                n2 = n4;
                if (!phrasePositions2.nextPosition()) {
                    bl = true;
                    break;
                }
                n4 = phrasePositions2.position;
            }
            if ((n4 = n - n2) <= this.slop) {
                f += this.getSimilarity().sloppyFreq(n4);
            }
            if (phrasePositions2.position > n) {
                n = phrasePositions2.position;
            }
            this.pq.put(phrasePositions2);
        } while (!bl);
        return f;
    }
}

