/*
 * Decompiled with CFR 0.152.
 */
package gate.creole;

import gate.Factory;
import gate.FeatureMap;
import gate.LanguageAnalyser;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractController;
import gate.creole.AbstractResource;
import gate.creole.AnalyserRunningStrategy;
import gate.creole.ConditionalController;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.RunningStrategy;
import gate.creole.SerialController;
import gate.creole.metadata.CreoleResource;
import gate.event.ControllerEvent;
import gate.util.Benchmark;
import gate.util.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@CreoleResource(name="Conditional Pipeline", comment="A simple serial controller for conditionally run PRs.", helpURL="http://gate.ac.uk/userguide/sec:developer:cond")
public class ConditionalSerialController
extends SerialController
implements ConditionalController {
    protected List strategiesList = new ArrayList();

    public Collection getRunningStrategies() {
        return Collections.unmodifiableList(this.strategiesList);
    }

    public void add(int n, ProcessingResource processingResource) {
        if (processingResource instanceof LanguageAnalyser) {
            this.strategiesList.add(n, new AnalyserRunningStrategy((LanguageAnalyser)processingResource, 1, null, null));
        } else {
            this.strategiesList.add(n, new RunningStrategy.UnconditionalRunningStrategy(processingResource, true));
        }
        super.add(n, processingResource);
    }

    public void add(ProcessingResource processingResource) {
        if (processingResource instanceof LanguageAnalyser) {
            this.strategiesList.add(new AnalyserRunningStrategy((LanguageAnalyser)processingResource, 1, null, null));
        } else {
            this.strategiesList.add(new RunningStrategy.UnconditionalRunningStrategy(processingResource, true));
        }
        super.add(processingResource);
    }

    public ProcessingResource remove(int n) {
        ProcessingResource processingResource = super.remove(n);
        this.strategiesList.remove(n);
        this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
        return processingResource;
    }

    public boolean remove(ProcessingResource processingResource) {
        int n = this.prList.indexOf(processingResource);
        if (n != -1) {
            this.prList.remove(n);
            this.strategiesList.remove(n);
            this.fireResourceRemoved(new ControllerEvent(this, 1, processingResource));
            return true;
        }
        return false;
    }

    public void setRunningStrategy(int n, AnalyserRunningStrategy analyserRunningStrategy) {
        this.strategiesList.set(n, analyserRunningStrategy);
    }

    public void setRunningStrategies(Collection collection) {
        this.strategiesList.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.strategiesList.add(iterator.next());
        }
    }

    protected void runComponent(int n) throws ExecutionException {
        ProcessingResource processingResource = (ProcessingResource)this.prList.get(n);
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("gate.event.StatusListener", this.sListener);
        int n2 = 100 / this.prList.size();
        featureMap.put("gate.event.ProgressListener", new AbstractController.IntervalProgressListener(n * n2, (n + 1) * n2));
        try {
            AbstractResource.setResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            Err.prln("Could not set listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over.");
        }
        if (((RunningStrategy)this.strategiesList.get(n)).shouldRun()) {
            this.benchmarkFeatures.put("prName", processingResource.getName());
            long l = System.currentTimeMillis();
            Benchmark.executeWithBenchmarking(processingResource, Benchmark.createBenchmarkId("pr_" + processingResource.getName(), this.getBenchmarkId()), this, this.benchmarkFeatures);
            this.benchmarkFeatures.remove("prName");
        }
        try {
            AbstractResource.removeResourceListeners(processingResource, featureMap);
        }
        catch (Exception exception) {
            Err.prln("Could not clear listeners for " + processingResource.getClass().getName() + "\n" + exception.toString() + "\n...nothing to lose any sleep over.");
        }
    }

    public void cleanup() {
        super.cleanup();
        this.strategiesList.clear();
    }

    public Resource duplicate(Factory.DuplicationContext duplicationContext) throws ResourceInstantiationException {
        ConditionalController conditionalController = (ConditionalController)super.duplicate(duplicationContext);
        Collection collection = conditionalController.getPRs();
        ArrayList<RunningStrategy> arrayList = new ArrayList<RunningStrategy>(this.strategiesList.size());
        Iterator iterator = this.getRunningStrategies().iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            RunningStrategy runningStrategy = (RunningStrategy)iterator.next();
            ProcessingResource processingResource = (ProcessingResource)iterator2.next();
            if (runningStrategy instanceof AnalyserRunningStrategy) {
                arrayList.add(new AnalyserRunningStrategy((LanguageAnalyser)processingResource, ((AnalyserRunningStrategy)runningStrategy).getRunMode(), ((AnalyserRunningStrategy)runningStrategy).getFeatureName(), ((AnalyserRunningStrategy)runningStrategy).getFeatureValue()));
                continue;
            }
            boolean bl = true;
            if (runningStrategy instanceof RunningStrategy.UnconditionalRunningStrategy) {
                bl = runningStrategy.shouldRun();
            }
            arrayList.add(new RunningStrategy.UnconditionalRunningStrategy(processingResource, bl));
        }
        conditionalController.setRunningStrategies(arrayList);
        return conditionalController;
    }
}

