/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Resource;
import gate.TextualDocument;
import gate.corpora.DocumentImpl;
import gate.corpora.DocumentStaxUtils;
import gate.corpora.MimeType;
import gate.corpora.RepositioningInfo;
import gate.corpora.TextualDocumentFormat;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.event.StatusListener;
import gate.util.DocumentFormatException;
import gate.util.Out;
import gate.xml.XmlDocumentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@CreoleResource(name="GATE XML Document Format", isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class XmlDocumentFormat
extends TextualDocumentFormat {
    private static final boolean DEBUG = false;
    private static XMLInputFactory staxFactory;

    public Boolean supportsRepositioning() {
        return new Boolean(true);
    }

    public void unpackMarkup(Document document) throws DocumentFormatException {
        this.unpackMarkup(document, null, null);
    }

    public void unpackMarkup(Document document, RepositioningInfo repositioningInfo, RepositioningInfo repositioningInfo2) throws DocumentFormatException {
        boolean bl;
        if (document == null || document.getSourceUrl() == null && document.getContent() == null) {
            throw new DocumentFormatException("GATE document is null or no content found. Nothing to parse!");
        }
        StatusListener statusListener = new StatusListener(){

            public void statusChanged(String string) {
                XmlDocumentFormat.this.fireStatusChanged(string);
            }
        };
        String string = document.getContent().toString();
        if (string.length() > 2048) {
            string = string.substring(0, 2048);
        }
        if (bl = XmlDocumentFormat.isGateXmlFormat(string)) {
            this.unpackGateFormatMarkup(document, statusListener);
        } else {
            this.unpackGeneralXmlMarkup(document, repositioningInfo, repositioningInfo2, statusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackGateFormatMarkup(Document document, StatusListener statusListener) throws DocumentFormatException {
        boolean bl = XmlDocumentFormat.hasContentButNoValidUrl(document);
        try {
            Reader reader = null;
            InputStream inputStream = null;
            XMLStreamReader xMLStreamReader = null;
            if (bl) {
                reader = new StringReader(document.getContent().toString());
                xMLStreamReader = XmlDocumentFormat.getInputFactory().createXMLStreamReader(reader);
            } else if (document instanceof TextualDocument) {
                String string = ((TextualDocument)document).getEncoding();
                reader = new InputStreamReader(document.getSourceUrl().openStream(), string);
                xMLStreamReader = XmlDocumentFormat.getInputFactory().createXMLStreamReader(document.getSourceUrl().toExternalForm(), reader);
            } else {
                inputStream = document.getSourceUrl().openStream();
                xMLStreamReader = XmlDocumentFormat.getInputFactory().createXMLStreamReader(document.getSourceUrl().toExternalForm(), inputStream);
            }
            xMLStreamReader.nextTag();
            try {
                DocumentStaxUtils.readGateXmlDocument(xMLStreamReader, document, statusListener);
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                xMLStreamReader.close();
                if (inputStream != null) {
                    inputStream.close();
                }
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            xMLStreamReader.close();
            if (inputStream != null) {
                inputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            document.getFeatures().put("parsingError", Boolean.TRUE);
            Boolean bl2 = (Boolean)document.getFeatures().get("throwExceptionOnFormatError");
            if (bl2 != null && bl2.booleanValue()) {
                throw new DocumentFormatException(xMLStreamException);
            }
            Out.println("Warning: Document remains unparsed. \n\n  Stack Dump: ");
            xMLStreamException.printStackTrace(Out.getPrintWriter());
        }
        catch (IOException iOException) {
            throw new DocumentFormatException("I/O exception for " + document.getSourceUrl().toString(), iOException);
        }
    }

    private static XMLInputFactory getInputFactory() throws XMLStreamException {
        if (staxFactory == null) {
            staxFactory = XMLInputFactory.newInstance();
            staxFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            staxFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            staxFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            staxFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        }
        return staxFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unpackGeneralXmlMarkup(Document document, RepositioningInfo repositioningInfo, RepositioningInfo repositioningInfo2, StatusListener statusListener) throws DocumentFormatException {
        boolean bl = XmlDocumentFormat.hasContentButNoValidUrl(document);
        XmlDocumentHandler xmlDocumentHandler = null;
        try {
            try {
                block13: {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setValidating(false);
                    sAXParserFactory.setNamespaceAware(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    xmlDocumentHandler = new XmlDocumentHandler(document, this.markupElementsMap, this.element2StringMap);
                    xmlDocumentHandler.addStatusListener(statusListener);
                    xmlDocumentHandler.setRepositioningInfo(repositioningInfo);
                    xmlDocumentHandler.setAmpCodingInfo(repositioningInfo2);
                    XMLReader xMLReader = sAXParser.getXMLReader();
                    xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                    xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
                    xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                    xMLReader.setContentHandler(xmlDocumentHandler);
                    xMLReader.setErrorHandler(xmlDocumentHandler);
                    xMLReader.setDTDHandler(xmlDocumentHandler);
                    xMLReader.setEntityResolver(xmlDocumentHandler);
                    Reader reader = null;
                    try {
                        InputSource inputSource;
                        if (bl) {
                            inputSource = new InputSource(new StringReader(document.getContent().toString()));
                        } else if (document instanceof TextualDocument) {
                            String string = ((TextualDocument)document).getEncoding();
                            reader = new InputStreamReader(document.getSourceUrl().openStream(), string);
                            inputSource = new InputSource(reader);
                            inputSource.setSystemId(document.getSourceUrl().toString());
                        } else {
                            inputSource = new InputSource(document.getSourceUrl().toString());
                        }
                        xMLReader.parse(inputSource);
                        Object var14_17 = null;
                        if (reader == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                }
                ((DocumentImpl)document).setNextAnnotationId(xmlDocumentHandler.getCustomObjectsId());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new DocumentFormatException("XML parser configuration exception ", parserConfigurationException);
            }
            catch (SAXException sAXException) {
                document.getFeatures().put("parsingError", Boolean.TRUE);
                Boolean bl2 = (Boolean)document.getFeatures().get("throwExceptionOnFormatError");
                if (bl2 != null && bl2.booleanValue()) {
                    throw new DocumentFormatException(sAXException);
                }
                Out.println("Warning: Document remains unparsed. \n\n  Stack Dump: ");
                sAXException.printStackTrace(Out.getPrintWriter());
                Object var16_21 = null;
                if (xmlDocumentHandler == null) return;
                xmlDocumentHandler.removeStatusListener(statusListener);
                return;
            }
            catch (IOException iOException) {
                throw new DocumentFormatException("I/O exception for " + document.getSourceUrl().toString(), iOException);
            }
            Object var16_20 = null;
            if (xmlDocumentHandler == null) return;
            xmlDocumentHandler.removeStatusListener(statusListener);
            return;
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            if (xmlDocumentHandler == null) throw throwable;
            xmlDocumentHandler.removeStatusListener(statusListener);
            throw throwable;
        }
    }

    protected static boolean isGateXmlFormat(String string) {
        return string.indexOf("<GateDocument") != -1 || string.indexOf(" GateDocument") != -1;
    }

    public Resource init() throws ResourceInstantiationException {
        MimeType mimeType = new MimeType("text", "xml");
        mimeString2ClassHandlerMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), this);
        mimeString2mimeTypeMap.put(mimeType.getType() + "/" + mimeType.getSubtype(), mimeType);
        mimeString2mimeTypeMap.put("application/xml", mimeType);
        suffixes2mimeTypeMap.put("xml", mimeType);
        suffixes2mimeTypeMap.put("xhtm", mimeType);
        suffixes2mimeTypeMap.put("xhtml", mimeType);
        magic2mimeTypeMap.put("<?xml", mimeType);
        this.setMimeType(mimeType);
        return this;
    }
}

