/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.DocumentContent;
import gate.FeatureMap;
import gate.LanguageResource;
import gate.Resource;
import gate.annotation.AnnotationSetImpl;
import gate.annotation.DatabaseAnnotationSetImpl;
import gate.corpora.DocumentContentImpl;
import gate.corpora.DocumentImpl;
import gate.corpora.EventAwareDocument;
import gate.corpora.SynchronisationException;
import gate.creole.ResourceInstantiationException;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.event.DocumentEvent;
import gate.event.FeatureMapListener;
import gate.persist.DBHelper;
import gate.persist.DatabaseDataStore;
import gate.persist.OracleDataStore;
import gate.persist.PersistenceException;
import gate.util.Err;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.MethodNotImplementedException;
import gate.util.SimpleFeatureMapImpl;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import junit.framework.Assert;
import oracle.jdbc.driver.OraclePreparedStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDocumentImpl
extends DocumentImpl
implements EventAwareDocument {
    private static final boolean DEBUG = false;
    private boolean isContentRead;
    private Object contentLock = new Object();
    private Connection jdbcConn;
    private String jdbcSchema;
    protected int dbType;
    private boolean contentChanged;
    private boolean featuresChanged;
    private boolean nameChanged;
    private boolean documentChanged;
    private Collection removedAnotationSets;
    private Collection addedAnotationSets;
    private Document parentDocument;
    private int maxAnnotationId;
    protected EventsHandler eventHandler;

    public DatabaseDocumentImpl() {
        this.namedAnnotSets = new HashMap();
        this.isContentRead = false;
        this.contentChanged = false;
        this.featuresChanged = false;
        this.nameChanged = false;
        this.documentChanged = false;
        this.removedAnotationSets = new Vector();
        this.addedAnotationSets = new Vector();
        this.parentDocument = null;
    }

    private void setDatabaseInfo(Connection connection) throws PersistenceException {
        String string = null;
        try {
            string = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException("cannot get jdbc metadata: [" + sQLException.getMessage() + "]");
        }
        this.jdbcSchema = DBHelper.getSchemaPrefix(string);
        this.dbType = DBHelper.getDatabaseType(string);
        Assert.assertNotNull((Object)this.jdbcSchema);
        Assert.assertTrue((this.dbType == 101 || this.dbType == 102 ? 1 : 0) != 0);
    }

    public DatabaseDocumentImpl(Connection connection) throws PersistenceException {
        this.namedAnnotSets = new HashMap();
        this.isContentRead = false;
        this.jdbcConn = connection;
        this.setDatabaseInfo(this.jdbcConn);
        this.contentChanged = false;
        this.featuresChanged = false;
        this.nameChanged = false;
        this.documentChanged = false;
        this.removedAnotationSets = new Vector();
        this.addedAnotationSets = new Vector();
        this.parentDocument = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContent getContent() {
        if (null != this.parentDocument) {
            return this.parentDocument.getContent();
        }
        Object object = this.contentLock;
        synchronized (object) {
            if (!this.isContentRead) {
                this._readContent();
                this.isContentRead = true;
            }
        }
        return super.getContent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _readContent() {
        if (null == this.getLRPersistenceId()) {
            throw new GateRuntimeException("can't construct a DatabaseDocument - not associated  with any data store");
        }
        if (!(this.getLRPersistenceId() instanceof Long)) {
            throw new GateRuntimeException("can't construct a DatabaseDocument -   invalid persistence ID");
        }
        Long l = (Long)this.getLRPersistenceId();
        Assert.assertNotNull((Object)l);
        Assert.assertTrue((false == this.isContentRead ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.content);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            block16: {
                try {
                    String string = " select v1.enc_name,         v1.dc_character_content,         v1.dc_binary_content,         v1.dc_content_type  from  " + this.jdbcSchema + "v_content v1 " + " where  v1.lr_id = ? ";
                    preparedStatement = this.jdbcConn.prepareStatement(string);
                    preparedStatement.setLong(1, l);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                    if (!resultSet.next()) {
                        throw new SynchronisationException("empty reault set");
                    }
                    if (this.dbType == 101) {
                        String string2 = resultSet.getString("enc_name");
                        if (string2.equals("-!-")) {
                            string2 = "";
                        }
                        Clob clob = resultSet.getClob("dc_character_content");
                        Blob blob = resultSet.getBlob("dc_binary_content");
                        long l2 = resultSet.getLong("dc_content_type");
                        Assert.assertTrue((1L == l2 || 3L == l2 ? 1 : 0) != 0);
                        StringBuffer stringBuffer = new StringBuffer();
                        OracleDataStore.readCLOB(clob, stringBuffer);
                        this.encoding = string2;
                        this.content = null != stringBuffer ? new DocumentContentImpl(stringBuffer.toString()) : new DocumentContentImpl();
                        break block16;
                    }
                    if (this.dbType == 102) {
                        String string3 = resultSet.getString("enc_name");
                        if (string3.equals("-!-")) {
                            string3 = "";
                        }
                        String string4 = resultSet.getString("dc_character_content");
                        long l3 = resultSet.getLong("dc_content_type");
                        Assert.assertTrue((1L == l3 || 3L == l3 ? 1 : 0) != 0);
                        this.encoding = string3;
                        this.content = null != string4 ? new DocumentContentImpl(string4) : new DocumentContentImpl();
                    } else {
                        Assert.fail();
                    }
                }
                catch (SQLException sQLException) {
                    throw new SynchronisationException("can't read content from DB: [" + sQLException.getMessage() + "]");
                }
                catch (IOException iOException) {
                    throw new SynchronisationException(iOException);
                }
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            try {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            catch (PersistenceException persistenceException) {
                throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
            }
        }
        try {}
        catch (PersistenceException persistenceException) {
            throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncoding() {
        Object object = this.contentLock;
        synchronized (object) {
            if (!this.isContentRead) {
                this._readContent();
                this.isContentRead = true;
            }
        }
        return super.getEncoding();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, AnnotationSet> getNamedAnnotationSets() {
        Vector<String> vector = new Vector<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                String string = " select as_name  from  " + this.jdbcSchema + "v_annotation_set " + " where  lr_id = ? " + "  and as_name is not null";
                preparedStatement = this.jdbcConn.prepareStatement(string);
                preparedStatement.setLong(1, (Long)this.lrPersistentId);
                preparedStatement.execute();
                resultSet = preparedStatement.getResultSet();
                while (resultSet.next()) {
                    vector.add(resultSet.getString("as_name"));
                }
                Object var6_7 = null;
            }
            catch (SQLException sQLException) {
                throw new SynchronisationException("can't get named annotatios: [" + sQLException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            catch (PersistenceException persistenceException) {
                throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
            }
        }
        try {}
        catch (PersistenceException persistenceException) {
            throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        int i = 0;
        while (i < vector.size()) {
            this.getAnnotations((String)vector.elementAt(i));
            ++i;
        }
        return super.getNamedAnnotationSets();
    }

    @Override
    public AnnotationSet getAnnotations() {
        this._getAnnotations(null);
        if (null == this.defaultAnnots) {
            DatabaseAnnotationSetImpl databaseAnnotationSetImpl = new DatabaseAnnotationSetImpl(this);
            this.defaultAnnots = databaseAnnotationSetImpl;
            this.fireAnnotationSetAdded(new DocumentEvent(this, 101, null));
        }
        return super.getAnnotations();
    }

    @Override
    public AnnotationSet getAnnotations(String string) {
        if (string == null || "".equals(string)) {
            return this.getAnnotations();
        }
        Assert.assertNotNull((Object)string);
        this._getAnnotations(string);
        if (!this.namedAnnotSets.keySet().contains(string)) {
            DatabaseAnnotationSetImpl databaseAnnotationSetImpl = new DatabaseAnnotationSetImpl((Document)this, string);
            this.namedAnnotSets.put(string, databaseAnnotationSetImpl);
            this.addedAnotationSets.add(string);
            DocumentEvent documentEvent = new DocumentEvent(this, 101, string);
            this.fireAnnotationSetAdded(documentEvent);
        }
        return super.getAnnotations(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _getAnnotations(String string) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        DatabaseAnnotationSetImpl databaseAnnotationSetImpl;
        block19: {
            block18: {
                databaseAnnotationSetImpl = null;
                if (null == this.getLRPersistenceId()) {
                    throw new GateRuntimeException("can't construct a DatabaseDocument - not associated  with any data store");
                }
                if (!(this.getLRPersistenceId() instanceof Long)) {
                    throw new GateRuntimeException("can't construct a DatabaseDocument -   invalid persistence ID");
                }
                if (null == string ? this.defaultAnnots != null : this.namedAnnotSets.containsKey(string)) {
                    return;
                }
                Long l = (Long)this.getLRPersistenceId();
                Long l2 = null;
                Assert.assertNotNull((Object)l);
                preparedStatement = null;
                resultSet = null;
                try {
                    try {
                        String string2;
                        AnnotationSetImpl annotationSetImpl;
                        HashMap hashMap;
                        block23: {
                            block21: {
                                block22: {
                                    block20: {
                                        String string3 = " select as_id  from  " + this.jdbcSchema + "v_annotation_set " + " where  lr_id = ? ";
                                        String string4 = null;
                                        string4 = null != string ? "        and as_name = ? " : "        and as_name is null ";
                                        string3 = string3 + string4;
                                        preparedStatement = this.jdbcConn.prepareStatement(string3);
                                        preparedStatement.setLong(1, l);
                                        if (null != string) {
                                            preparedStatement.setString(2, string);
                                        }
                                        preparedStatement.execute();
                                        resultSet = preparedStatement.getResultSet();
                                        if (!resultSet.next()) break block20;
                                        l2 = new Long(resultSet.getLong(1));
                                        DBHelper.cleanup(resultSet);
                                        DBHelper.cleanup(preparedStatement);
                                        hashMap = this._readFeatures(l2);
                                        annotationSetImpl = new AnnotationSetImpl(this);
                                        if (this.dbType != 101) break block21;
                                        break block22;
                                    }
                                    Object var19_12 = null;
                                    break block18;
                                }
                                string2 = "/*+ use_nl(v.t_annotation v.t_as_annotation)      use_nl(v.t_annotation_type v.t_annotation)  */";
                                break block23;
                            }
                            string2 = "";
                        }
                        String string5 = " select " + string2 + "        ann_local_id, " + "        at_name, " + "        start_offset, " + "        end_offset " + " from  " + this.jdbcSchema + "v_annotation  v" + " where  asann_as_id = ? ";
                        preparedStatement = this.jdbcConn.prepareStatement(string5);
                        preparedStatement.setLong(1, l2);
                        if (this.dbType == 101) {
                            ((OraclePreparedStatement)preparedStatement).setRowPrefetch(100);
                        }
                        preparedStatement.execute();
                        resultSet = preparedStatement.getResultSet();
                        while (resultSet.next()) {
                            Integer n = new Integer(resultSet.getInt(1));
                            String string6 = resultSet.getString(2);
                            Long l3 = new Long(resultSet.getLong(3));
                            Long l4 = new Long(resultSet.getLong(4));
                            FeatureMap featureMap = (FeatureMap)hashMap.get(n);
                            if (null == featureMap) {
                                featureMap = new SimpleFeatureMapImpl();
                            }
                            annotationSetImpl.add(n, l3, l4, string6, featureMap);
                        }
                        databaseAnnotationSetImpl = null == string ? new DatabaseAnnotationSetImpl((Document)this, annotationSetImpl) : new DatabaseAnnotationSetImpl(this, string, annotationSetImpl);
                        break block19;
                    }
                    catch (SQLException sQLException) {
                        throw new SynchronisationException("can't read annotations from DB: [" + sQLException.getMessage() + "]");
                    }
                    catch (InvalidOffsetException invalidOffsetException) {
                        throw new SynchronisationException(invalidOffsetException);
                    }
                    catch (PersistenceException persistenceException) {
                        throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
                    }
                }
                catch (Throwable throwable) {
                    Object var19_14 = null;
                    try {
                        DBHelper.cleanup(resultSet);
                        DBHelper.cleanup(preparedStatement);
                        throw throwable;
                    }
                    catch (PersistenceException persistenceException) {
                        throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
                    }
                }
            }
            try {}
            catch (PersistenceException persistenceException) {
                throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
            }
            DBHelper.cleanup(resultSet);
            DBHelper.cleanup(preparedStatement);
            return;
        }
        Object var19_13 = null;
        try {}
        catch (PersistenceException persistenceException) {
            throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        if (string == null) {
            this.defaultAnnots = databaseAnnotationSetImpl;
            return;
        }
        this.namedAnnotSets.put(string, databaseAnnotationSetImpl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap _readFeatures(Long l) {
        Object object;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "--NO--SUCH--KEY--";
        String string2 = null;
        Integer n = null;
        Integer n2 = null;
        Object object2 = null;
        Vector vector = new Vector();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        SimpleFeatureMapImpl simpleFeatureMapImpl = null;
        HashMap<Integer, SimpleFeatureMapImpl> hashMap2 = new HashMap<Integer, SimpleFeatureMapImpl>();
        try {
            try {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (this.dbType == 101) {
                    object6 = " select /*+ use_nl(v.t_annotation v.t_as_annotation)             use_nl(v.t_feature v.t_annotation)             index(v.t_feature xt_feature_01)             use_nl(v.t_feature_key v.t_feature)            full(v.t_feature_key)                   */                                                                                      ann_local_id,         key,         ft_value_type,         ft_number_value,         ft_character_value,         ft_long_character_value,         ft_binary_value  from  " + this.jdbcSchema + "v_annotation_features v" + " where  set_id = ? " + " order by ann_local_id,key ";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object6);
                    preparedStatement.setLong(1, l);
                    ((OraclePreparedStatement)preparedStatement).setRowPrefetch(100);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                } else if (this.dbType == 102) {
                    object6 = " select         ann_local_id,         key,         ft_value_type,         ft_int_value,         ft_float_value,         ft_character_value,         ft_binary_value  from  " + this.jdbcSchema + "v_annotation_features " + " where  set_id = ? " + " order by ann_local_id,key ";
                    preparedStatement = this.jdbcConn.prepareStatement((String)object6);
                    preparedStatement.setLong(1, l);
                    preparedStatement.execute();
                    resultSet = preparedStatement.getResultSet();
                } else {
                    Assert.fail();
                }
                while (resultSet.next()) {
                    Serializable serializable;
                    n = n2;
                    n2 = new Integer(resultSet.getInt("ann_local_id"));
                    if (!n2.equals(n) && n != null) {
                        simpleFeatureMapImpl = new SimpleFeatureMapImpl();
                        object6 = hashMap.entrySet();
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            object = (Map.Entry)object5.next();
                            object4 = (String)object.getKey();
                            object3 = (Vector)object.getValue();
                            Assert.assertTrue((((Vector)object3).size() >= 1 ? 1 : 0) != 0);
                            if (((Vector)object3).size() == 1) {
                                simpleFeatureMapImpl.put(object4, ((Vector)object3).firstElement());
                                continue;
                            }
                            simpleFeatureMapImpl.put(object4, object3);
                        }
                        hashMap2.put(n, simpleFeatureMapImpl);
                        hashMap.clear();
                        n = n2;
                    }
                    string2 = resultSet.getString("key");
                    object6 = new Long(resultSet.getLong("ft_value_type"));
                    object5 = null;
                    switch (((Long)object6).intValue()) {
                        case 103: {
                            if (this.dbType == 101) {
                                object5 = new Boolean(resultSet.getBoolean("ft_number_value"));
                                break;
                            }
                            if (this.dbType == 102) {
                                object5 = new Boolean(resultSet.getBoolean("ft_int_value"));
                                break;
                            }
                            Assert.fail();
                            break;
                        }
                        case 106: {
                            if (this.dbType == 101) {
                                object5 = new Float(resultSet.getFloat("ft_number_value"));
                                break;
                            }
                            if (this.dbType == 102) {
                                object5 = new Float(resultSet.getFloat("ft_float_value"));
                                break;
                            }
                            Assert.fail();
                            break;
                        }
                        case 101: {
                            if (this.dbType == 101) {
                                object5 = new Integer(resultSet.getInt("ft_number_value"));
                                break;
                            }
                            if (this.dbType == 102) {
                                object5 = new Integer(resultSet.getInt("ft_int_value"));
                                break;
                            }
                            Assert.fail();
                            break;
                        }
                        case 102: {
                            if (this.dbType == 101) {
                                object5 = new Long(resultSet.getLong("ft_number_value"));
                                break;
                            }
                            if (this.dbType == 102) {
                                object5 = new Long(resultSet.getLong("ft_int_value"));
                                break;
                            }
                            Assert.fail();
                            break;
                        }
                    }
                    object = resultSet.getString("ft_character_value");
                    object4 = null;
                    object3 = null;
                    if (this.dbType == 101) {
                        object4 = resultSet.getClob("ft_long_character_value");
                        object3 = resultSet.getBlob("ft_binary_value");
                    }
                    switch (((Long)object6).intValue()) {
                        case 100: {
                            object2 = null;
                            break;
                        }
                        case 105: {
                            throw new MethodNotImplementedException();
                        }
                        case 101: 
                        case 102: 
                        case 103: 
                        case 106: {
                            object2 = object5;
                            break;
                        }
                        case 104: {
                            if (this.dbType == 101 && null == object) {
                                serializable = new StringBuffer();
                                OracleDataStore.readCLOB((Clob)object4, (StringBuffer)serializable);
                                object2 = ((StringBuffer)serializable).toString();
                                break;
                            }
                            object2 = object;
                            break;
                        }
                        default: {
                            throw new SynchronisationException("Invalid feature type found in DB, value is [" + object6 + "]");
                        }
                    }
                    if (!hashMap.containsKey(string2)) {
                        serializable = new Vector();
                        ((Vector)serializable).add(object2);
                        hashMap.put(string2, serializable);
                    } else {
                        ((Vector)hashMap.get(string2)).add(object2);
                    }
                    string = string2;
                }
                simpleFeatureMapImpl = new SimpleFeatureMapImpl();
                object6 = hashMap.entrySet();
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object = (Map.Entry)object5.next();
                    object4 = (String)object.getKey();
                    object3 = (Vector)object.getValue();
                    Assert.assertTrue((((Vector)object3).size() >= 1 ? 1 : 0) != 0);
                    if (((Vector)object3).size() == 1) {
                        simpleFeatureMapImpl.put(object4, ((Vector)object3).firstElement());
                        continue;
                    }
                    simpleFeatureMapImpl.put(object4, object3);
                }
                if (null != n2) {
                    hashMap2.put(n2, simpleFeatureMapImpl);
                }
                object = hashMap2;
                Object var20_21 = null;
            }
            catch (SQLException sQLException) {
                throw new SynchronisationException("can't read content from DB: [" + sQLException.getMessage() + "]");
            }
            catch (IOException iOException) {
                throw new SynchronisationException("can't read content from DB: [" + iOException.getMessage() + "]");
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            try {
                DBHelper.cleanup(resultSet);
                DBHelper.cleanup(preparedStatement);
                throw throwable;
            }
            catch (PersistenceException persistenceException) {
                throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
            }
        }
        try {}
        catch (PersistenceException persistenceException) {
            throw new SynchronisationException("JDBC error: [" + persistenceException.getMessage() + "]");
        }
        DBHelper.cleanup(resultSet);
        DBHelper.cleanup(preparedStatement);
        return object;
    }

    @Override
    public void setContent(DocumentContent documentContent) {
        if (null != this.parentDocument) {
            Err.prln("content of document [" + this.name + "] cannot be changed!");
            return;
        }
        super.setContent(documentContent);
        this.contentChanged = true;
    }

    @Override
    public void setFeatures(FeatureMap featureMap) {
        FeatureMap featureMap2 = this.features;
        super.setFeatures(featureMap);
        this.featuresChanged = true;
        if (this.eventHandler != null) {
            featureMap2.removeFeatureMapListener(this.eventHandler);
        } else {
            this.eventHandler = new EventsHandler();
        }
        this.features.addFeatureMapListener(this.eventHandler);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.nameChanged = true;
    }

    private List getAnnotationsForOffset(AnnotationSet annotationSet, Long l) {
        throw new MethodNotImplementedException();
    }

    public void setNextNodeId(int n) {
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        this.nextNodeId = n;
    }

    @Override
    public boolean isResourceChanged(int n) {
        switch (n) {
            case 1002: {
                return this.contentChanged;
            }
            case 1003: {
                return this.featuresChanged;
            }
            case 1001: {
                return this.nameChanged;
            }
            case 1004: {
                return this.documentChanged;
            }
        }
        throw new IllegalArgumentException();
    }

    private void _setAnnotations(String string, Collection collection) throws InvalidOffsetException {
        DatabaseAnnotationSetImpl databaseAnnotationSetImpl = null;
        if (null == string) {
            Assert.assertTrue((null == this.defaultAnnots ? 1 : 0) != 0);
            databaseAnnotationSetImpl = new DatabaseAnnotationSetImpl(this);
            this.defaultAnnots = databaseAnnotationSetImpl;
        } else {
            Assert.assertTrue((false == this.namedAnnotSets.containsKey(string) ? 1 : 0) != 0);
            databaseAnnotationSetImpl = new DatabaseAnnotationSetImpl((Document)this, string);
            this.namedAnnotSets.put(string, databaseAnnotationSetImpl);
        }
        for (Annotation annotation : collection) {
            databaseAnnotationSetImpl.add(annotation.getId(), annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset(), annotation.getType(), annotation.getFeatures());
            this.maxAnnotationId = annotation.getId() >= this.maxAnnotationId ? annotation.getId() : this.maxAnnotationId;
        }
    }

    @Override
    public void setSourceUrl(URL uRL) {
        this.documentChanged = true;
        super.setSourceUrl(uRL);
    }

    @Override
    public void setSourceUrlEndOffset(Long l) {
        this.documentChanged = true;
        super.setSourceUrlEndOffset(l);
    }

    @Override
    public void setSourceUrlStartOffset(Long l) {
        this.documentChanged = true;
        super.setSourceUrlStartOffset(l);
    }

    @Override
    public void setMarkupAware(Boolean bl) {
        this.documentChanged = true;
        super.setMarkupAware(bl);
    }

    @Override
    public void cleanup() {
        if (this.eventHandler != null) {
            this.features.removeFeatureMapListener(this.eventHandler);
        }
        this.getDataStore().removeDatastoreListener(this);
        if (null != this.defaultAnnots) {
            this.getDataStore().removeDatastoreListener((DatastoreListener)((Object)this.defaultAnnots));
        }
        Set set = this.namedAnnotSets.entrySet();
        for (Map.Entry entry : set) {
            AnnotationSet annotationSet = (AnnotationSet)entry.getValue();
            this.getDataStore().removeDatastoreListener((DatastoreListener)((Object)annotationSet));
        }
        super.cleanup();
    }

    @Override
    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)datastoreEvent);
        Assert.assertNotNull((Object)datastoreEvent.getResourceID());
        if (datastoreEvent.getResourceID().equals(this.getLRPersistenceId())) {
            this.getDataStore().removeDatastoreListener(this);
            if (null != this.defaultAnnots) {
                this.getDataStore().removeDatastoreListener((DatastoreListener)((Object)this.defaultAnnots));
            }
            Set set = this.namedAnnotSets.entrySet();
            for (Map.Entry entry : set) {
                AnnotationSet annotationSet = (AnnotationSet)entry.getValue();
                this.getDataStore().removeDatastoreListener((DatastoreListener)((Object)annotationSet));
            }
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)datastoreEvent);
        Assert.assertNotNull((Object)datastoreEvent.getResourceID());
        if (datastoreEvent.getResourceID().equals(this.getLRPersistenceId())) {
            this.nameChanged = false;
            this.featuresChanged = false;
            this.documentChanged = false;
            this.contentChanged = false;
            this.removedAnotationSets.clear();
            this.addedAnotationSets.clear();
        }
    }

    @Override
    public Collection getLoadedAnnotationSets() {
        Assert.assertNotNull((Object)this.namedAnnotSets);
        Vector vector = new Vector(this.namedAnnotSets.values());
        if (null != this.defaultAnnots) {
            vector.add(this.defaultAnnots);
        }
        return vector;
    }

    @Override
    public Collection getRemovedAnnotationSets() {
        return new Vector(this.removedAnotationSets);
    }

    @Override
    public Collection getAddedAnnotationSets() {
        return new Vector(this.addedAnotationSets);
    }

    @Override
    public void removeAnnotationSet(String string) {
        this.removedAnotationSets.add(string);
        if (this.namedAnnotSets.keySet().contains(string)) {
            AnnotationSet annotationSet = (AnnotationSet)this.namedAnnotSets.get(string);
            Assert.assertNotNull((Object)annotationSet);
            Assert.assertTrue((boolean)(annotationSet instanceof DatabaseAnnotationSetImpl));
            this.dataStore.removeDatastoreListener((DatastoreListener)((Object)annotationSet));
        }
        super.removeAnnotationSet(string);
    }

    @Override
    public boolean isModified() {
        return this.isResourceChanged(1002) || this.isResourceChanged(1003) || this.isResourceChanged(1001) || this.isResourceChanged(1004);
    }

    @Override
    public LanguageResource getParent() throws PersistenceException, SecurityException {
        return this.parentDocument;
    }

    @Override
    public void setParent(LanguageResource languageResource) throws PersistenceException, SecurityException {
        Assert.assertNotNull((Object)languageResource);
        if (!(languageResource instanceof DatabaseDocumentImpl)) {
            throw new IllegalArgumentException("invalid parent resource set");
        }
        this.parentDocument = (Document)languageResource;
    }

    public void setInitData__$$__(Object object) throws PersistenceException, InvalidOffsetException {
        Map map;
        Integer n;
        Integer n2;
        HashMap hashMap = (HashMap)object;
        this.jdbcConn = (Connection)hashMap.get("JDBC_CONN");
        this.setDatabaseInfo(this.jdbcConn);
        this.dataStore = (DatabaseDataStore)hashMap.get("DS");
        this.lrPersistentId = (Long)hashMap.get("LR_ID");
        this.name = (String)hashMap.get("DOC_NAME");
        this.content = (DocumentContent)hashMap.get("DOC_CONTENT");
        this.isContentRead = true;
        this.features = (FeatureMap)hashMap.get("DOC_FEATURES");
        this.markupAware = (Boolean)hashMap.get("DOC_MARKUP_AWARE");
        this.sourceUrl = (URL)hashMap.get("DOC_SOURCE_URL");
        this.sourceUrlStartOffset = (Long)hashMap.get("DOC_SOURCE_URL_START");
        this.sourceUrlEndOffset = (Long)hashMap.get("DOC_SOURCE_URL_END");
        if (hashMap.containsKey("DOC_STRING_CONTENT")) {
            this.setStringContent((String)hashMap.get("DOC_STRING_CONTENT"));
        }
        if (null != (n2 = (Integer)hashMap.get("DOC_NEXT_NODE_ID"))) {
            this.setNextNodeId(n2);
        }
        if (null != (n = (Integer)hashMap.get("DOC_NEXT_ANN_ID"))) {
            this.setNextAnnotationId(n);
        }
        this.parentDocument = (Document)hashMap.get("PARENT_LR");
        AnnotationSet annotationSet = (AnnotationSet)hashMap.get("DOC_DEFAULT_ANNOTATIONS");
        if (null != annotationSet) {
            this._setAnnotations(null, annotationSet);
        }
        if (null != (map = (Map)hashMap.get("DOC_NAMED_ANNOTATION_SETS"))) {
            for (AnnotationSet annotationSet2 : map.values()) {
                if (annotationSet2.getName().equals("Original markups")) continue;
                this._setAnnotations(annotationSet2.getName(), annotationSet2);
            }
        }
        if (null != this.features) {
            if (this.eventHandler == null) {
                this.eventHandler = new EventsHandler();
            }
            this.features.addFeatureMapListener(this.eventHandler);
        }
        if (null != this.dataStore) {
            this.dataStore.addDatastoreListener(this);
        }
    }

    public Object getInitData__$$__(Object object) {
        return null;
    }

    @Override
    public Resource init() throws ResourceInstantiationException {
        Resource resource = super.init();
        if (this.nextAnnotationId <= this.maxAnnotationId) {
            this.nextAnnotationId = this.maxAnnotationId + 1;
        }
        return resource;
    }

    class EventsHandler
    implements FeatureMapListener {
        EventsHandler() {
        }

        public void featureMapUpdated() {
            DatabaseDocumentImpl.this.featuresChanged = true;
        }
    }
}

