/*
 * Decompiled with CFR 0.152.
 */
package gate.corpora;

import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.LanguageResource;
import gate.Resource;
import gate.corpora.CorpusImpl;
import gate.corpora.DatabaseDocumentImpl;
import gate.corpora.DocumentData;
import gate.corpora.EventAwareCorpus;
import gate.creole.ResourceInstantiationException;
import gate.event.CorpusEvent;
import gate.event.CreoleEvent;
import gate.event.DatastoreEvent;
import gate.event.DatastoreListener;
import gate.event.FeatureMapListener;
import gate.persist.DatabaseDataStore;
import gate.persist.PersistenceException;
import gate.security.SecurityException;
import gate.security.SecurityInfo;
import gate.util.Err;
import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseCorpusImpl
extends CorpusImpl
implements DatastoreListener,
EventAwareCorpus {
    private static final boolean DEBUG = false;
    private boolean featuresChanged;
    private boolean nameChanged;
    protected EventsHandler eventHandler;
    protected List documentData;
    protected List removedDocuments;
    protected List addedDocuments;

    public DatabaseCorpusImpl() {
    }

    public DatabaseCorpusImpl(String string, DatabaseDataStore databaseDataStore, Long l, FeatureMap featureMap, Vector vector) {
        this.name = string;
        this.dataStore = databaseDataStore;
        this.lrPersistentId = l;
        this.features = featureMap;
        this.documentData = vector;
        this.supportList = new ArrayList(this.documentData.size());
        this.removedDocuments = new ArrayList();
        this.addedDocuments = new ArrayList();
        for (int i = 0; i < this.documentData.size(); ++i) {
            this.supportList.add(null);
        }
        this.featuresChanged = false;
        this.nameChanged = false;
        if (this.eventHandler == null) {
            this.eventHandler = new EventsHandler();
        }
        this.features.addFeatureMapListener(this.eventHandler);
        this.dataStore.addDatastoreListener(this);
    }

    @Override
    public boolean add(Object object) {
        Assert.assertNotNull((Object)object);
        boolean bl = false;
        if (!(object instanceof Document)) {
            throw new IllegalArgumentException();
        }
        Document document = (Document)object;
        if (!this.isValidForAdoption(document)) {
            return false;
        }
        bl = super.add(document);
        DocumentData documentData = new DocumentData(document.getName(), document.getLRPersistenceId());
        this.documentData.add(documentData);
        if (null != document.getLRPersistenceId()) {
            this.addedDocuments.add(document.getLRPersistenceId());
        }
        if (bl) {
            this.fireDocumentAdded(new CorpusEvent(this, document, this.supportList.size() - 1, document.getLRPersistenceId(), 401));
        }
        return bl;
    }

    @Override
    public void add(int n, Object object) {
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        long l = this.supportList.size();
        if (!(object instanceof Document)) {
            throw new IllegalArgumentException();
        }
        Document document = (Document)object;
        if (this.isValidForAdoption(document)) {
            super.add(n, document);
            DocumentData documentData = new DocumentData(document.getName(), null);
            this.documentData.add(n, documentData);
            if (null != document.getLRPersistenceId()) {
                this.addedDocuments.add(document.getLRPersistenceId());
            }
            if ((long)this.supportList.size() > l) {
                this.fireDocumentAdded(new CorpusEvent(this, document, n, document.getLRPersistenceId(), 401));
            }
        }
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean bl = false;
        for (Document document : collection) {
            if (!this.isValidForAdoption(document)) continue;
            bl |= this.add(document);
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        boolean bl = false;
        int n2 = this.supportList.size();
        int n3 = n;
        for (Document document : collection) {
            if (!this.isValidForAdoption(document)) continue;
            this.add(n3++, document);
        }
        return this.supportList.size() > n2;
    }

    private boolean isValidForAdoption(LanguageResource languageResource) {
        Long l = (Long)languageResource.getLRPersistenceId();
        return null == l || this.getDataStore() != null && languageResource.getDataStore().equals(this.getDataStore());
    }

    @Override
    public void resourceAdopted(DatastoreEvent datastoreEvent) {
    }

    @Override
    public void resourceDeleted(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)datastoreEvent);
        Long l = (Long)datastoreEvent.getResourceID();
        Assert.assertNotNull((Object)l);
        if (l.equals(this.getLRPersistenceId())) {
            this.supportList.clear();
            this.getDataStore().removeDatastoreListener(this);
        }
        for (Document document : this.supportList) {
            if (!document.getLRPersistenceId().equals(l)) continue;
            this.supportList.remove(document);
            break;
        }
    }

    @Override
    public void resourceWritten(DatastoreEvent datastoreEvent) {
        Assert.assertNotNull((Object)datastoreEvent);
        Assert.assertNotNull((Object)datastoreEvent.getResourceID());
        if (datastoreEvent.getResourceID().equals(this.getLRPersistenceId())) {
            this.nameChanged = false;
            this.featuresChanged = false;
            this.removedDocuments.clear();
            this.addedDocuments.clear();
        }
    }

    @Override
    public void resourceUnloaded(CreoleEvent creoleEvent) {
        Assert.assertNotNull((Object)creoleEvent);
        Assert.assertNotNull((Object)creoleEvent.getResource());
        Resource resource = creoleEvent.getResource();
        if (resource instanceof Document) {
            Document document = (Document)resource;
            if (null == document.getLRPersistenceId()) {
                super.remove(document);
            } else {
                int n = this.findDocument(document);
                if (n == -1) {
                    return;
                }
                this.supportList.set(n, null);
            }
        }
    }

    @Override
    public boolean isResourceChanged(int n) {
        switch (n) {
            case 1003: {
                return this.featuresChanged;
            }
            case 1001: {
                return this.nameChanged;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isModified() {
        return this.isResourceChanged(1003) || this.isResourceChanged(1001);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.nameChanged = true;
    }

    @Override
    public void setFeatures(FeatureMap featureMap) {
        FeatureMap featureMap2 = this.features;
        super.setFeatures(featureMap);
        this.featuresChanged = true;
        if (this.eventHandler != null) {
            featureMap2.removeFeatureMapListener(this.eventHandler);
        } else {
            this.eventHandler = new EventsHandler();
        }
        this.features.addFeatureMapListener(this.eventHandler);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.eventHandler != null) {
            this.features.removeFeatureMapListener(this.eventHandler);
        }
    }

    public void setInitData__$$__(Object object) {
        HashMap hashMap = (HashMap)object;
        this.name = (String)hashMap.get("CORP_NAME");
        this.dataStore = (DatabaseDataStore)hashMap.get("DS");
        this.lrPersistentId = (Long)hashMap.get("LR_ID");
        this.features = (FeatureMap)hashMap.get("CORP_FEATURES");
        this.supportList = new ArrayList((List)hashMap.get("CORP_SUPPORT_LIST"));
        this.documentData = new ArrayList(this.supportList.size());
        this.removedDocuments = new ArrayList();
        this.addedDocuments = new ArrayList();
        for (int i = 0; i < this.supportList.size(); ++i) {
            Document document = (Document)this.supportList.get(i);
            DocumentData documentData = new DocumentData(document.getName(), document.getLRPersistenceId());
            this.documentData.add(documentData);
        }
        this.featuresChanged = false;
        this.nameChanged = false;
        if (this.eventHandler == null) {
            this.eventHandler = new EventsHandler();
        }
        this.features.addFeatureMapListener(this.eventHandler);
        this.dataStore.addDatastoreListener(this);
    }

    public Object getInitData__$$__(Object object) {
        return null;
    }

    @Override
    public List<String> getDocumentNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.documentData == null) {
            return arrayList;
        }
        for (Object e : this.documentData) {
            DocumentData documentData = (DocumentData)e;
            arrayList.add(documentData.getDocumentName());
        }
        return arrayList;
    }

    @Override
    public String getDocumentName(int n) {
        if (n >= this.documentData.size()) {
            return "No such document";
        }
        return ((DocumentData)this.documentData.get(n)).getDocumentName();
    }

    @Override
    public Object get(int n) {
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((n < this.documentData.size() ? 1 : 0) != 0);
        Assert.assertTrue((n < this.supportList.size() ? 1 : 0) != 0);
        Assert.assertTrue((this.documentData.size() == this.supportList.size() ? 1 : 0) != 0);
        if (n >= this.documentData.size()) {
            return null;
        }
        Object object = this.supportList.get(n);
        if (null == object) {
            Long l = (Long)((DocumentData)this.documentData.get(n)).getPersistentID();
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("DataStore", this.getDataStore());
            featureMap.put("LRPersistenceId", l);
            try {
                Document document = (Document)Factory.createResource("gate.corpora.DatabaseDocumentImpl", featureMap);
                object = document;
                Assert.assertNull(this.supportList.get(n));
                this.supportList.set(n, document);
            }
            catch (ResourceInstantiationException resourceInstantiationException) {
                Err.prln("Error reading document inside a serialised corpus.");
                throw new GateRuntimeException(resourceInstantiationException.getMessage());
            }
        }
        return object;
    }

    @Override
    public Object remove(int n) {
        DocumentData documentData = (DocumentData)this.documentData.get(n);
        Long l = (Long)documentData.getPersistentID();
        if (null != l && !this.addedDocuments.contains(l)) {
            this.removedDocuments.add(l);
        }
        this.documentData.remove(n);
        Document document = (Document)this.supportList.remove(n);
        if (this.addedDocuments.contains(l)) {
            this.addedDocuments.remove(l);
        }
        this.fireDocumentRemoved(new CorpusEvent(this, document, n, l, 402));
        return document;
    }

    @Override
    public boolean remove(Object object) {
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof DatabaseDocumentImpl));
        if (!(object instanceof Document)) {
            return false;
        }
        Document document = (Document)object;
        int n = this.findDocument(document);
        if (n == -1) {
            return false;
        }
        if (n < this.documentData.size()) {
            DocumentData documentData = (DocumentData)this.documentData.get(n);
            Long l = (Long)documentData.getPersistentID();
            if (null != l && !this.addedDocuments.contains(l)) {
                this.removedDocuments.add(l);
            }
            this.documentData.remove(n);
            Document document2 = (Document)this.supportList.remove(n);
            if (this.addedDocuments.contains(l)) {
                this.addedDocuments.remove(l);
            }
            this.fireDocumentRemoved(new CorpusEvent(this, document2, n, l, 402));
        }
        return true;
    }

    public int findDocument(Document document) {
        boolean bl = false;
        DocumentData documentData = null;
        int n = this.supportList.indexOf(document);
        if (n > -1 && n < this.documentData.size()) {
            return n;
        }
        Iterator iterator = this.documentData.iterator();
        n = 0;
        while (iterator.hasNext()) {
            documentData = (DocumentData)iterator.next();
            if (documentData.getDocumentName().equals(document.getName()) && documentData.getPersistentID().equals(document.getLRPersistenceId())) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl && n < this.documentData.size()) {
            return n;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof Document)) {
            return false;
        }
        int n = this.findDocument((Document)object);
        return n >= 0;
    }

    @Override
    public Iterator iterator() {
        return new DatabaseCorpusIterator(this.documentData);
    }

    @Override
    public List getLoadedDocuments() {
        return new ArrayList(this.supportList);
    }

    @Override
    public List getRemovedDocuments() {
        return new ArrayList(this.removedDocuments);
    }

    @Override
    public List getAddedDocuments() {
        return new ArrayList(this.addedDocuments);
    }

    public void unloadDocument(int n) {
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        if (!this.isDocumentLoaded(n) && this.isPersistentDocument(n)) {
            return;
        }
        Document document = (Document)this.supportList.get(n);
        Assert.assertNotNull((Object)document);
        try {
            if (document.getLRPersistenceId() == null) {
                SecurityInfo securityInfo = this.getDataStore().getSecurityInfo(this);
                Document document2 = (Document)this.getDataStore().adopt(document, securityInfo);
            } else {
                this.getDataStore().sync(document);
            }
            this.supportList.set(n, null);
        }
        catch (PersistenceException persistenceException) {
            throw new GateRuntimeException("Error unloading document from corpusbecause document sync failed: " + persistenceException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new GateRuntimeException("Error unloading document from corpusbecause of document access error: " + securityException.getMessage());
        }
    }

    @Override
    public void unloadDocument(Document document) {
        Assert.assertNotNull((Object)document);
        int n = this.findDocument(document);
        if (n == -1) {
            return;
        }
        this.unloadDocument(n);
    }

    @Override
    public boolean isDocumentLoaded(int n) {
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        if (this.supportList == null || this.supportList.isEmpty()) {
            return false;
        }
        return this.supportList.get(n) != null;
    }

    public boolean isPersistentDocument(int n) {
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        if (this.supportList == null || this.supportList.isEmpty()) {
            return false;
        }
        return ((DocumentData)this.documentData.get(n)).getPersistentID() != null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DatabaseCorpusImpl)) {
            return false;
        }
        DatabaseCorpusImpl databaseCorpusImpl = (DatabaseCorpusImpl)object;
        if (this.getDataStore() != null && this.getDataStore() != databaseCorpusImpl.getDataStore()) {
            return false;
        }
        if (this.getLRPersistenceId() != null && this.getLRPersistenceId() != databaseCorpusImpl.getLRPersistenceId()) {
            return false;
        }
        return ((Object)this.supportList).equals(object);
    }

    @Override
    public Resource duplicate(Factory.DuplicationContext duplicationContext) throws ResourceInstantiationException {
        throw new ResourceInstantiationException("Duplication of " + this.getClass().getName() + " not permitted");
    }

    private class DatabaseCorpusIterator
    implements Iterator {
        private Iterator docDataIter;
        private List docDataList;

        public DatabaseCorpusIterator(List list) {
            this.docDataList = list;
            this.docDataIter = this.docDataList.iterator();
        }

        public boolean hasNext() {
            return this.docDataIter.hasNext();
        }

        public Object next() {
            DocumentData documentData = (DocumentData)this.docDataIter.next();
            int n = this.docDataList.indexOf(documentData);
            return DatabaseCorpusImpl.this.get(n);
        }

        public void remove() {
            throw new UnsupportedOperationException("DatabaseCorpusImpl does not support remove in the iterators");
        }
    }

    class EventsHandler
    implements FeatureMapListener {
        EventsHandler() {
        }

        public void featureMapUpdated() {
            DatabaseCorpusImpl.this.featuresChanged = true;
        }
    }
}

