/*
 * Decompiled with CFR 0.152.
 */
package gate.annotation;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Node;
import gate.annotation.AnnotationImpl;
import gate.annotation.AnnotationSetImpl;
import gate.annotation.NodeImpl;
import gate.util.InvalidOffsetException;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestAnnotation
extends TestCase {
    private static final boolean DEBUG = false;
    protected Document doc1;
    protected AnnotationSet basicAS;
    protected FeatureMap emptyFeatureMap;

    public TestAnnotation(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        Gate.setNetConnected(false);
        if (Gate.getGateHome() == null) {
            Gate.init();
        }
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        this.doc1 = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        this.emptyFeatureMap = new SimpleFeatureMapImpl();
        this.basicAS = new AnnotationSetImpl(this.doc1);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        this.basicAS.get("T");
        this.basicAS.get(new Long(0L));
        this.basicAS.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(10L), new Long(20L), "T2", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(10L), new Long(20L), "T3", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("pos", "NN");
        simpleFeatureMapImpl.put("author", "hamish");
        simpleFeatureMapImpl.put("version", new Integer(1));
        this.basicAS.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T3", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
        simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("pos", "JJ");
        simpleFeatureMapImpl.put("author", "the devil himself");
        simpleFeatureMapImpl.put("version", new Long(44L));
        simpleFeatureMapImpl.put("created", "monday");
        this.basicAS.add(new Long(15L), new Long(40L), "T3", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(new Long(15L), new Long(40L), "T1", (FeatureMap)simpleFeatureMapImpl);
    }

    public void testOffsetIndex() throws InvalidOffsetException {
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(this.doc1);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        Integer n = annotationSetImpl.add(new Long(10L), new Long(20L), "T", (FeatureMap)simpleFeatureMapImpl);
        TestAnnotation.assertEquals((int)n, (int)11);
        Annotation annotation = annotationSetImpl.get(n);
        Node node = annotation.getStartNode();
        Node node2 = annotation.getEndNode();
        TestAnnotation.assertEquals((int)node.getId(), (int)4);
        TestAnnotation.assertEquals((int)node2.getId(), (int)5);
        TestAnnotation.assertEquals((long)node.getOffset(), (long)10L);
        TestAnnotation.assertEquals((long)node2.getOffset(), (long)20L);
        n = annotationSetImpl.add(new Long(10L), new Long(30L), "T", (FeatureMap)simpleFeatureMapImpl);
        TestAnnotation.assertEquals((int)n, (int)12);
        annotation = annotationSetImpl.get(n);
        node = annotation.getStartNode();
        node2 = annotation.getEndNode();
        TestAnnotation.assertEquals((int)node.getId(), (int)4);
        TestAnnotation.assertEquals((int)node2.getId(), (int)6);
        TestAnnotation.assertEquals((long)node.getOffset(), (long)10L);
        TestAnnotation.assertEquals((long)node2.getOffset(), (long)30L);
        AnnotationSet annotationSet = annotationSetImpl.get(new Long(10L));
        TestAnnotation.assertEquals((int)annotationSet.size(), (int)2);
    }

    public void testImmutability() {
        Long l = new Long(0L);
        Long l2 = new Long(20L);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        AnnotationSet annotationSet = this.basicAS.get();
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        annotationSet = this.basicAS.get(l);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        annotationSet = this.basicAS.get(l, l2);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        annotationSet = this.basicAS.get("T1");
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("T1");
        hashSet.add("T2");
        annotationSet = this.basicAS.get(hashSet);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, l);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        annotationSet = this.basicAS.get("T1", l, l2);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("pos");
        annotationSet = this.basicAS.get("T3", hashSet2);
        TestAnnotation.assertTrue((boolean)this._subtestImmutability(annotationSet));
    }

    private final boolean _subtestImmutability(AnnotationSet annotationSet) {
        boolean bl = false;
        Node node = null;
        try {
            annotationSet.add(null, null, null, null, null);
        }
        catch (InvalidOffsetException invalidOffsetException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.add(node, null, null, null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.add(new Long(0L), null, null, null);
        }
        catch (InvalidOffsetException invalidOffsetException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.add(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.removeAll(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.addAll(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.remove(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.retainAll(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            annotationSet.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            bl = true;
        }
        return bl;
    }

    public void testExceptions() {
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(this.doc1);
        boolean bl = false;
        try {
            annotationSetImpl.add(new Long(-1L), new Long(1L), "T", this.emptyFeatureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            bl = true;
        }
        if (!bl) {
            TestAnnotation.fail((String)"Should have thrown InvalidOffsetException");
        }
        bl = false;
        try {
            annotationSetImpl.add(new Long(1L), new Long(-1L), "T", this.emptyFeatureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            bl = true;
        }
        if (!bl) {
            TestAnnotation.fail((String)"Should have thrown InvalidOffsetException");
        }
        bl = false;
        try {
            annotationSetImpl.add(new Long(1L), new Long(0L), "T", this.emptyFeatureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            bl = true;
        }
        if (!bl) {
            TestAnnotation.fail((String)"Should have thrown InvalidOffsetException");
        }
        bl = false;
        try {
            annotationSetImpl.add(null, new Long(1L), "T", this.emptyFeatureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            bl = true;
        }
        if (!bl) {
            TestAnnotation.fail((String)"Should have thrown InvalidOffsetException");
        }
        bl = false;
        try {
            annotationSetImpl.add(new Long(1L), null, "T", this.emptyFeatureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            bl = true;
        }
        if (!bl) {
            TestAnnotation.fail((String)"Should have thrown InvalidOffsetException");
        }
        bl = false;
        try {
            annotationSetImpl.add(new Long(999999L), new Long(100000000L), "T", this.emptyFeatureMap);
        }
        catch (InvalidOffsetException invalidOffsetException) {
            bl = true;
        }
        bl = false;
    }

    public void testTypeIndex() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(document);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        annotationSetImpl.get("T");
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T2", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T3", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T3", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T3", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        AnnotationSet annotationSet = annotationSetImpl.get("T");
        TestAnnotation.assertEquals((int)0, (int)annotationSet.size());
        annotationSet = annotationSetImpl.get("T1");
        TestAnnotation.assertEquals((int)7, (int)annotationSet.size());
        annotationSet = annotationSetImpl.get("T2");
        TestAnnotation.assertEquals((int)1, (int)annotationSet.size());
        annotationSet = annotationSetImpl.get("T3");
        TestAnnotation.assertEquals((int)3, (int)annotationSet.size());
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(annotationSetImpl);
        int n = 0;
        for (Annotation annotation : treeSet) {
            TestAnnotation.assertEquals((int)n++, (int)annotation.getId());
            Node node = annotation.getStartNode();
            Node node2 = annotation.getEndNode();
            TestAnnotation.assertEquals((int)0, (int)node.getId());
            TestAnnotation.assertEquals((long)10L, (long)node.getOffset());
            TestAnnotation.assertEquals((int)1, (int)node2.getId());
            TestAnnotation.assertEquals((long)20L, (long)node2.getOffset());
        }
    }

    public void testAddWithNodes() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(document);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        annotationSetImpl.get("T");
        Integer n = annotationSetImpl.add(new Long(10L), new Long(20L), "T1", (FeatureMap)simpleFeatureMapImpl);
        Annotation annotation2 = annotationSetImpl.get(n);
        Node node = annotation2.getStartNode();
        Node node2 = annotation2.getEndNode();
        annotationSetImpl.add(node, node2, "T2", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T3", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T3", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T3", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T1", (FeatureMap)simpleFeatureMapImpl);
        annotationSetImpl.add(node, node2, "T1", (FeatureMap)simpleFeatureMapImpl);
        AnnotationSet annotationSet = annotationSetImpl.get("T");
        TestAnnotation.assertEquals((int)0, (int)annotationSet.size());
        annotationSet = annotationSetImpl.get("T1");
        TestAnnotation.assertEquals((int)7, (int)annotationSet.size());
        annotationSet = annotationSetImpl.get("T2");
        TestAnnotation.assertEquals((int)1, (int)annotationSet.size());
        annotationSet = annotationSetImpl.get("T3");
        TestAnnotation.assertEquals((int)3, (int)annotationSet.size());
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(annotationSetImpl);
        int n2 = 0;
        for (Annotation annotation2 : treeSet) {
            TestAnnotation.assertEquals((int)n2++, (int)annotation2.getId());
            node = annotation2.getStartNode();
            node2 = annotation2.getEndNode();
            TestAnnotation.assertEquals((int)0, (int)node.getId());
            TestAnnotation.assertEquals((long)10L, (long)node.getOffset());
            TestAnnotation.assertEquals((int)1, (int)node2.getId());
            TestAnnotation.assertEquals((long)20L, (long)node2.getOffset());
        }
    }

    public void testGetFeatureMapOffset() throws InvalidOffsetException {
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("pos", "NN");
        AnnotationSet annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl);
        TestAnnotation.assertEquals((int)3, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T3", simpleFeatureMapImpl);
        TestAnnotation.assertEquals((int)1, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(12L));
        TestAnnotation.assertEquals((int)2, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(10L));
        TestAnnotation.assertEquals((int)1, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(11L));
        TestAnnotation.assertEquals((int)2, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(9L));
        TestAnnotation.assertEquals((int)1, (int)annotationSet.size());
        simpleFeatureMapImpl.put("pos", "JJ");
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(0L));
        TestAnnotation.assertEquals((int)0, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(14L));
        TestAnnotation.assertEquals((int)2, (int)annotationSet.size());
        simpleFeatureMapImpl.put("author", "valentin");
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(14L));
        TestAnnotation.assertEquals((int)0, (int)annotationSet.size());
        simpleFeatureMapImpl.put("author", "the devil himself");
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(14L));
        TestAnnotation.assertEquals((int)2, (int)annotationSet.size());
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(5L));
        TestAnnotation.assertEquals((int)0, (int)annotationSet.size());
        simpleFeatureMapImpl.put("this feature isn't", "there at all");
        annotationSet = this.basicAS.get("T1", simpleFeatureMapImpl, new Long(14L));
        TestAnnotation.assertEquals((int)0, (int)annotationSet.size());
    }

    public void testGetStringLongLong() throws InvalidOffsetException {
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        this.basicAS.add(21L, 25L, "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(22L, 25L, "T1", (FeatureMap)simpleFeatureMapImpl);
        this.basicAS.add(45L, 50L, "T3", (FeatureMap)simpleFeatureMapImpl);
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.get(0L, 5L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.get("T1", 0L, (Long)5L).size());
        TestAnnotation.assertEquals((int)5, (int)this.basicAS.get(10L, 12L).size());
        TestAnnotation.assertEquals((int)3, (int)this.basicAS.get("T1", 10L, (Long)12L).size());
        TestAnnotation.assertEquals((int)11, (int)this.basicAS.get(10L, 16L).size());
        TestAnnotation.assertEquals((int)7, (int)this.basicAS.get("T1", 10L, (Long)16L).size());
        TestAnnotation.assertEquals((int)11, (int)this.basicAS.get(10L, 20L).size());
        TestAnnotation.assertEquals((int)7, (int)this.basicAS.get("T1", 10L, (Long)20L).size());
        TestAnnotation.assertEquals((int)6, (int)this.basicAS.get(20L, 21L).size());
        TestAnnotation.assertEquals((int)4, (int)this.basicAS.get("T1", 20L, (Long)21L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.get(41L, 42L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.get("T1", 41L, (Long)42L).size());
    }

    public void testGetCovering() throws InvalidOffsetException {
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.getCovering(null, 0L, 5L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.getCovering("T1", 0L, 5L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.getCovering(null, 9L, 12L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.getCovering("  ", 9L, 12L).size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.getCovering("T1", 9L, 12L).size());
        TestAnnotation.assertEquals((int)5, (int)this.basicAS.getCovering(null, 10L, 20L).size());
        TestAnnotation.assertEquals((int)5, (int)this.basicAS.getCovering("  ", 10L, 20L).size());
        TestAnnotation.assertEquals((int)3, (int)this.basicAS.getCovering("T1", 10L, 20L).size());
        TestAnnotation.assertEquals((int)11, (int)this.basicAS.getCovering(null, 16L, 20L).size());
        TestAnnotation.assertEquals((int)7, (int)this.basicAS.getCovering("T1", 16L, 20L).size());
        TestAnnotation.assertEquals((int)6, (int)this.basicAS.getCovering(null, 16L, 21L).size());
        TestAnnotation.assertEquals((int)4, (int)this.basicAS.getCovering("T1", 16L, 21L).size());
    }

    public void testRemove() {
        AnnotationSet annotationSet = this.basicAS.get("T1");
        TestAnnotation.assertEquals((int)7, (int)annotationSet.size());
        annotationSet = this.basicAS.get(new Long(9L));
        TestAnnotation.assertEquals((int)5, (int)annotationSet.size());
        this.basicAS.remove(this.basicAS.get(new Integer(0)));
        TestAnnotation.assertEquals((int)10, (int)this.basicAS.size());
        TestAnnotation.assertEquals((int)10, (int)((AnnotationSetImpl)this.basicAS).annotsById.size());
        annotationSet = this.basicAS.get("T1");
        TestAnnotation.assertEquals((int)6, (int)annotationSet.size());
        annotationSet = this.basicAS.get(new Long(9L));
        TestAnnotation.assertEquals((int)4, (int)annotationSet.size());
        TestAnnotation.assertEquals(null, (Object)this.basicAS.get(new Integer(0)));
        this.basicAS.remove(this.basicAS.get(new Integer(8)));
        TestAnnotation.assertEquals((int)9, (int)this.basicAS.size());
        this.basicAS.removeAll(this.basicAS);
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.get().size());
        TestAnnotation.assertEquals((int)0, (int)this.basicAS.get("T1").size());
        TestAnnotation.assertEquals(null, (Object)this.basicAS.get(new Integer(0)));
    }

    public void testRemoveInexistant() throws Exception {
        this.basicAS.add(new Long(0L), new Long(10L), "Foo", this.emptyFeatureMap);
        Annotation annotation = this.basicAS.get("Foo").iterator().next();
        this.basicAS.remove(annotation);
        this.basicAS.remove(annotation);
    }

    public void testIterator() {
        Serializable serializable;
        Iterator<Annotation> iterator = this.basicAS.iterator();
        Annotation[] annotationArray = new Annotation[this.basicAS.size()];
        int n = 0;
        while (iterator.hasNext()) {
            serializable = iterator.next();
            annotationArray[n++] = serializable;
            TestAnnotation.assertTrue((boolean)this.basicAS.contains(serializable));
            iterator.remove();
            TestAnnotation.assertTrue((!this.basicAS.contains(serializable) ? 1 : 0) != 0);
        }
        n = 0;
        while (n < annotationArray.length) {
            this.basicAS.add(annotationArray[n++]);
            TestAnnotation.assertEquals((int)n, (int)this.basicAS.size());
        }
        serializable = this.basicAS.get("T1");
        TestAnnotation.assertEquals((int)7, (int)serializable.size());
        serializable = this.basicAS.get(new Long(9L));
        TestAnnotation.assertEquals((int)5, (int)serializable.size());
    }

    public void testSetMethods() {
        Annotation annotation = this.basicAS.get(new Integer(6));
        TestAnnotation.assertTrue((boolean)this.basicAS.contains(annotation));
        Annotation[] annotationArray = this.basicAS.toArray(new Annotation[0]);
        Object[] objectArray = this.basicAS.toArray();
        TestAnnotation.assertEquals((int)11, (int)annotationArray.length);
        TestAnnotation.assertEquals((int)11, (int)objectArray.length);
        TreeSet<Annotation> treeSet = new TreeSet<Annotation>(this.basicAS);
        annotationArray = treeSet.toArray(new Annotation[0]);
        for (int i = 0; i < 11; ++i) {
            TestAnnotation.assertTrue((boolean)annotationArray[i].getId().equals(new Integer(i)));
        }
        Annotation annotation2 = this.basicAS.get(new Integer(3));
        Annotation annotation3 = this.basicAS.get(new Integer(4));
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.add(annotation2);
        hashSet.add(annotation3);
        TestAnnotation.assertTrue((boolean)this.basicAS.contains(annotation2));
        TestAnnotation.assertTrue((boolean)this.basicAS.containsAll(hashSet));
        this.basicAS.removeAll(hashSet);
        TestAnnotation.assertEquals((int)9, (int)this.basicAS.size());
        TestAnnotation.assertTrue((!this.basicAS.contains(annotation2) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((!this.basicAS.containsAll(hashSet) ? 1 : 0) != 0);
        this.basicAS.clear();
        TestAnnotation.assertTrue((boolean)this.basicAS.isEmpty());
    }

    public void testAnnotationSet() throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", Gate.getUrl("tests/doc0.html"));
        featureMap.put("markupAware", "false");
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        AnnotationSetImpl annotationSetImpl = new AnnotationSetImpl(document);
        TestAnnotation.assertEquals((int)annotationSetImpl.size(), (int)0);
        FeatureMap featureMap2 = Factory.newFeatureMap();
        featureMap2.put("test", "my-value");
        FeatureMap featureMap3 = Factory.newFeatureMap();
        featureMap3.put("test", "my-value-different");
        FeatureMap featureMap4 = Factory.newFeatureMap();
        featureMap4.put("another test", "different my-value");
        Integer n = annotationSetImpl.add(new Long(0L), new Long(10L), "Token", featureMap2);
        TestAnnotation.assertEquals((int)n, (int)0);
        n = annotationSetImpl.add(new Long(11L), new Long(12L), "Token", featureMap3);
        TestAnnotation.assertEquals((int)n, (int)1);
        TestAnnotation.assertEquals((int)annotationSetImpl.size(), (int)2);
        TestAnnotation.assertTrue((!annotationSetImpl.isEmpty() ? 1 : 0) != 0);
        n = annotationSetImpl.add(new Long(15L), new Long(22L), "Syntax", featureMap2);
        Annotation annotation2 = annotationSetImpl.get(new Integer(1));
        annotationSetImpl.remove(annotation2);
        TestAnnotation.assertEquals((int)annotationSetImpl.size(), (int)2);
        annotationSetImpl.add(annotation2);
        TestAnnotation.assertEquals((int)annotationSetImpl.size(), (int)3);
        for (Annotation annotation2 : annotationSetImpl) {
            if (annotation2.getId() != 2) {
                TestAnnotation.assertEquals((String)annotation2.getType(), (String)"Token");
            }
            TestAnnotation.assertEquals((int)annotation2.getFeatures().size(), (int)1);
        }
        n = annotationSetImpl.add(new Long(0L), new Long(12L), "Syntax", featureMap4);
        TestAnnotation.assertEquals((int)n, (int)3);
        n = annotationSetImpl.add(new Long(14L), new Long(22L), "Syntax", featureMap2);
        TestAnnotation.assertEquals((int)n, (int)4);
        TestAnnotation.assertEquals((int)annotationSetImpl.size(), (int)5);
        n = annotationSetImpl.add(new Long(15L), new Long(22L), "Syntax", (FeatureMap)new SimpleFeatureMapImpl());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("test");
        AnnotationSet annotationSet = annotationSetImpl.get("Token", hashSet);
        TestAnnotation.assertEquals((int)annotationSet.size(), (int)2);
        annotationSet = annotationSetImpl.get(null, hashSet);
        TestAnnotation.assertEquals((int)annotationSet.size(), (int)4);
        annotationSetImpl.indexByType();
        AnnotationSet annotationSet2 = annotationSetImpl.get("Token");
        TestAnnotation.assertEquals((int)annotationSet2.size(), (int)2);
        AnnotationSet annotationSet3 = annotationSetImpl.get(new Long(15L));
        if (annotationSet3 == null) {
            TestAnnotation.fail((String)"no annots found after offset 10");
        }
        TestAnnotation.assertEquals((int)annotationSet3.size(), (int)2);
    }

    public static Test suite() {
        return new TestSuite(TestAnnotation.class);
    }

    public void _testGap() throws InvalidOffsetException {
        Object object;
        AnnotationSet annotationSet = this.basicAS;
        annotationSet.clear();
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("A", "B");
        annotationSet.add(new Long(0L), new Long(10L), "foo", featureMap);
        annotationSet.add(new Long(11L), new Long(20L), "foo", featureMap);
        annotationSet.add(new Long(10L), new Long(11L), "space", featureMap);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("foo");
        hashSet.add("foofoo");
        AnnotationSet annotationSet2 = null;
        if (hashSet.isEmpty()) {
            annotationSet2 = annotationSet;
        } else {
            object = hashSet.iterator();
            AnnotationSet annotationSet3 = null;
            while (object.hasNext()) {
                annotationSet3 = annotationSet.get((String)object.next());
                if (annotationSet3 == null) continue;
                if (annotationSet2 == null) {
                    annotationSet2 = annotationSet3;
                    continue;
                }
                annotationSet2.addAll(annotationSet3);
            }
        }
        object = annotationSet2.get("foo", Factory.newFeatureMap(), new Long(10L));
        TestAnnotation.assertTrue((!object.isEmpty() ? 1 : 0) != 0);
    }

    public void testOverlapsAndCoextensive() throws InvalidOffsetException {
        NodeImpl nodeImpl = new NodeImpl(new Integer(1), new Long(10L));
        NodeImpl nodeImpl2 = new NodeImpl(new Integer(2), new Long(20L));
        NodeImpl nodeImpl3 = new NodeImpl(new Integer(4), new Long(15L));
        NodeImpl nodeImpl4 = new NodeImpl(new Integer(5), new Long(20L));
        NodeImpl nodeImpl5 = new NodeImpl(new Integer(6), new Long(30L));
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("color", "red");
        simpleFeatureMapImpl.put("Age", new Long(25L));
        simpleFeatureMapImpl.put(new Long(23L), "Cristian");
        SimpleFeatureMapImpl simpleFeatureMapImpl2 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl2.put("color", "red");
        simpleFeatureMapImpl2.put("Age", new Long(25L));
        simpleFeatureMapImpl2.put(new Long(23L), "Cristian");
        SimpleFeatureMapImpl simpleFeatureMapImpl3 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl3.put("color", "red");
        simpleFeatureMapImpl3.put("Age", new Long(26L));
        simpleFeatureMapImpl3.put(new Long(23L), "Cristian");
        SimpleFeatureMapImpl simpleFeatureMapImpl4 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl4.put("color", "red");
        simpleFeatureMapImpl4.put("Age", new Long(25L));
        simpleFeatureMapImpl4.put(new Long(23L), "Cristian");
        simpleFeatureMapImpl4.put("best", new Boolean(true));
        Annotation annotation = this.createAnnotation(new Integer(1), nodeImpl, nodeImpl2, "pos", null);
        Annotation annotation2 = this.createAnnotation(new Integer(2), nodeImpl2, nodeImpl5, "pos", null);
        Annotation annotation3 = this.createAnnotation(new Integer(3), nodeImpl4, nodeImpl5, "pos", null);
        Annotation annotation4 = this.createAnnotation(new Integer(4), nodeImpl2, nodeImpl4, "pos", null);
        Annotation annotation5 = this.createAnnotation(new Integer(5), nodeImpl, nodeImpl5, "pos", null);
        Annotation annotation6 = this.createAnnotation(new Integer(6), nodeImpl, nodeImpl3, "pos", null);
        Annotation annotation7 = this.createAnnotation(new Integer(7), null, null, "pos", null);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation.overlaps(annotation3) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation.overlaps(annotation2) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation2.overlaps(annotation) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation3.overlaps(annotation) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation4.overlaps(annotation6) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation6.overlaps(annotation4) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation6.overlaps(null) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does not overlap!", (!annotation.overlaps(annotation7) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations does overlap!", (boolean)annotation4.overlaps(annotation5));
        TestAnnotation.assertTrue((String)"Those annotations does overlap!", (boolean)annotation5.overlaps(annotation4));
        TestAnnotation.assertTrue((String)"Those annotations does overlap!", (boolean)annotation.overlaps(annotation6));
        TestAnnotation.assertTrue((String)"Those annotations does overlap!", (boolean)annotation6.overlaps(annotation));
        TestAnnotation.assertTrue((String)"Those annotations does overlap!", (boolean)annotation2.overlaps(annotation5));
        TestAnnotation.assertTrue((String)"Those annotations does overlap!", (boolean)annotation5.overlaps(annotation2));
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation.coextensive(annotation2) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation2.coextensive(annotation) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation4.coextensive(annotation3) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation3.coextensive(annotation4) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation4.coextensive(annotation7) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation5.coextensive(annotation6) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are not coextensive!", (!annotation6.coextensive(annotation5) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)"Those annotations are coextensive!", (boolean)annotation2.coextensive(annotation2));
        TestAnnotation.assertTrue((String)"Those annotations are coextensive!", (boolean)annotation2.coextensive(annotation3));
        TestAnnotation.assertTrue((String)"Those annotations are coextensive!", (boolean)annotation3.coextensive(annotation2));
    }

    public void testIsPartiallyCompatibleAndCompatible() throws InvalidOffsetException {
        NodeImpl nodeImpl = new NodeImpl(new Integer(1), new Long(10L));
        NodeImpl nodeImpl2 = new NodeImpl(new Integer(2), new Long(20L));
        NodeImpl nodeImpl3 = new NodeImpl(new Integer(4), new Long(15L));
        NodeImpl nodeImpl4 = new NodeImpl(new Integer(5), new Long(20L));
        NodeImpl nodeImpl5 = new NodeImpl(new Integer(6), new Long(30L));
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("color", "red");
        simpleFeatureMapImpl.put("Age", new Long(25L));
        simpleFeatureMapImpl.put(new Long(23L), "Cristian");
        SimpleFeatureMapImpl simpleFeatureMapImpl2 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl2.put("color", "red");
        simpleFeatureMapImpl2.put("Age", new Long(25L));
        simpleFeatureMapImpl2.put(new Long(23L), "Cristian");
        SimpleFeatureMapImpl simpleFeatureMapImpl3 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl3.put("color", "red");
        simpleFeatureMapImpl3.put("Age", new Long(26L));
        simpleFeatureMapImpl3.put(new Long(23L), "Cristian");
        SimpleFeatureMapImpl simpleFeatureMapImpl4 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl4.put("color", "red");
        simpleFeatureMapImpl4.put("Age", new Long(25L));
        simpleFeatureMapImpl4.put(new Long(23L), "Cristian");
        simpleFeatureMapImpl4.put("best", new Boolean(true));
        Annotation annotation = this.createAnnotation(new Integer(1), nodeImpl, nodeImpl2, "pos", simpleFeatureMapImpl);
        Annotation annotation2 = this.createAnnotation(new Integer(2), nodeImpl2, nodeImpl5, "pos", simpleFeatureMapImpl2);
        Annotation annotation3 = this.createAnnotation(new Integer(3), nodeImpl4, nodeImpl5, "pos", simpleFeatureMapImpl4);
        Annotation annotation4 = this.createAnnotation(new Integer(4), nodeImpl2, nodeImpl4, "pos", simpleFeatureMapImpl3);
        Annotation annotation5 = this.createAnnotation(new Integer(5), nodeImpl, nodeImpl5, "pos", simpleFeatureMapImpl4);
        Annotation annotation6 = this.createAnnotation(new Integer(6), nodeImpl, nodeImpl3, "pos", simpleFeatureMapImpl);
        TestAnnotation.assertTrue((String)"Those annotations are not compatible!", (!annotation3.isCompatible(annotation2) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation + " & " + annotation2 + ") are not partially compatible!"), (!annotation.isPartiallyCompatible(annotation2) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation + " & " + annotation3 + ") are not partially compatible!"), (!annotation.isPartiallyCompatible(annotation3) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation + " & " + annotation4 + ") are not partially compatible!"), (!annotation.isPartiallyCompatible(annotation4) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation4 + " & " + annotation5 + ") are not partially compatible!"), (!annotation4.isPartiallyCompatible(annotation5) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation3 + " & " + annotation6 + ") are not partially compatible!"), (!annotation3.isPartiallyCompatible(annotation6, null) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation5 + " & " + annotation2 + ") are not partially compatible!"), (!annotation5.isPartiallyCompatible(annotation2, null) ? 1 : 0) != 0);
        HashSet<Object> hashSet = new HashSet<Object>();
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation2 + " & " + annotation4 + ") are not partially compatible!"), (!annotation2.isPartiallyCompatible(annotation4, hashSet) ? 1 : 0) != 0);
        hashSet.add("color");
        hashSet.add("Age");
        hashSet.add("best");
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation5 + " & " + annotation2 + ") are not partially compatible!"), (!annotation5.isPartiallyCompatible(annotation2, hashSet) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation4 + " & " + annotation4 + ") are not partially compatible!"), (!annotation4.isPartiallyCompatible(annotation4) ? 1 : 0) != 0);
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation2 + " & " + annotation3 + ") should be compatible!"), (boolean)annotation2.isCompatible(annotation3));
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation2 + " & " + annotation3 + ") should be compatible!"), (boolean)annotation2.isCompatible(annotation3, null));
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation2 + " & " + annotation3 + ") should be compatible!"), (boolean)annotation2.isCompatible(annotation3, new HashSet()));
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation4 + " & " + annotation4 + ") should be compatible!"), (boolean)annotation4.isCompatible(annotation4));
        hashSet = new HashSet();
        hashSet.add("color");
        hashSet.add(new Long(23L));
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation3 + " & " + annotation2 + ") should be compatible!"), (boolean)annotation3.isCompatible(annotation2, hashSet));
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation2 + " & " + annotation3 + ") should be partially compatible!"), (boolean)annotation2.isPartiallyCompatible(annotation3));
        TestAnnotation.assertTrue((String)("Those annotations(" + annotation2 + " & " + annotation2 + ") should be partially compatible!"), (boolean)annotation2.isPartiallyCompatible(annotation2));
        TestAnnotation.assertTrue((String)"Those annotations are partially compatible!", (boolean)annotation.isPartiallyCompatible(annotation5));
        TestAnnotation.assertTrue((String)"Those annotations are partially compatible!", (boolean)annotation.isPartiallyCompatible(annotation6));
        TestAnnotation.assertTrue((String)"Those annotations are partially compatible!", (boolean)annotation3.isPartiallyCompatible(annotation5));
        TestAnnotation.assertTrue((String)"Those annotations are partially compatible!", (boolean)annotation5.isPartiallyCompatible(annotation3));
        TestAnnotation.assertTrue((String)"Those annotations are partially compatible!", (boolean)annotation6.isPartiallyCompatible(annotation5));
    }

    public void testFeatureSubsumeMethods() {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("k1", "v1");
        featureMap.put("k2", "v2");
        FeatureMap featureMap2 = Factory.newFeatureMap();
        featureMap2.put("k1", "v1");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("k1");
        hashSet.add("k2");
        hashSet.add("k3");
        hashSet.add("k4");
        TestAnnotation.assertTrue((String)(featureMap + " should subsume " + featureMap2 + " using the key set" + hashSet), (boolean)featureMap.subsumes(featureMap2, hashSet));
        TestAnnotation.assertTrue((String)(featureMap + " should subsume " + featureMap2 + " taking all feat into consideration"), (boolean)featureMap.subsumes(featureMap2, null));
        FeatureMap featureMap3 = Factory.newFeatureMap();
        featureMap3.put("k1", "v1");
        featureMap3.put("k2", "v2");
        featureMap3.put("k3", new Integer(3));
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("k1");
        TestAnnotation.assertTrue((String)(featureMap + " should subsume " + featureMap3 + " using the key set" + hashSet2), (boolean)featureMap.subsumes(featureMap3, hashSet2));
        TestAnnotation.assertTrue((String)(featureMap + " should NOT subsume " + featureMap3 + " taking all feats into consideration"), (!featureMap.subsumes(featureMap3, null) ? 1 : 0) != 0);
        FeatureMap featureMap4 = Factory.newFeatureMap();
        featureMap4.put("k1", new Integer(2));
        featureMap4.put("k2", "v2");
        featureMap4.put("k3", "v3");
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add("k2");
        TestAnnotation.assertTrue((String)(featureMap3 + " should subsume " + featureMap4 + " using the key set" + hashSet3), (boolean)featureMap4.subsumes(featureMap3, hashSet3));
        TestAnnotation.assertTrue((String)(featureMap4 + " should NOT subsume " + featureMap3 + " taking all feats into consideration"), (!featureMap4.subsumes(featureMap3, null) ? 1 : 0) != 0);
    }

    protected Annotation createAnnotation(Integer n, Node node, Node node2, String string, FeatureMap featureMap) {
        return new AnnotationImpl(n, node, node2, string, featureMap);
    }

    public static void main(String[] stringArray) {
        try {
            TestAnnotation testAnnotation = new TestAnnotation("");
            testAnnotation.setUp();
            testAnnotation.testIterator();
            testAnnotation._testGap();
            testAnnotation.tearDown();
            testAnnotation.testOverlapsAndCoextensive();
            testAnnotation.testIsPartiallyCompatibleAndCompatible();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

