/*
 * Decompiled with CFR 0.152.
 */
package gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Controller;
import gate.Corpus;
import gate.CreoleProxy;
import gate.CreoleRegister;
import gate.DataStore;
import gate.DataStoreRegister;
import gate.Document;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.SimpleDocument;
import gate.VisualResource;
import gate.annotation.ImmutableAnnotationSetImpl;
import gate.creole.AbstractResource;
import gate.creole.AnnotationSchema;
import gate.creole.CustomDuplication;
import gate.creole.Parameter;
import gate.creole.ParameterException;
import gate.creole.ParameterList;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.event.CreoleEvent;
import gate.event.CreoleListener;
import gate.jape.constraint.ConstraintFactory;
import gate.jape.parser.ParseCpsl;
import gate.persist.PersistenceException;
import gate.persist.SerialDataStore;
import gate.security.AccessController;
import gate.security.AccessControllerImpl;
import gate.security.SecurityException;
import gate.util.BomStrippingInputStreamReader;
import gate.util.SimpleFeatureMapImpl;
import gate.util.Strings;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Factory {
    private static final boolean DEBUG = false;
    private static CreoleRegister reg = Gate.getCreoleRegister();
    private static DataStoreRegister dsReg = Gate.getDataStoreRegister();
    private static CreoleProxy creoleProxy;
    private static HashMap accessControllerPool;
    static Class japeParserClass;
    private static ConstraintFactory japeConstraintFactory;

    public static Resource createResource(String string) throws ResourceInstantiationException {
        ResourceData resourceData = (ResourceData)reg.get(string);
        if (resourceData == null) {
            throw new ResourceInstantiationException("Couldn't get resource data for " + string + ".\n\n" + "You may need first to load the plugin that contains your resource.\n" + "For example, to create a gate.creole.tokeniser.DefaultTokeniser\n" + "you need first to load the ANNIE plugin.\n\n" + "Go to the menu File->Manage CREOLE plugins or use the method\n" + "Gate.getCreoleRegister().registerDirectories(pluginDirectoryURL).");
        }
        ParameterList parameterList = resourceData.getParameterList();
        FeatureMap featureMap = null;
        try {
            featureMap = parameterList.getInitimeDefaults();
        }
        catch (ParameterException parameterException) {
            throw new ResourceInstantiationException("Couldn't get default parameters for " + string + ": " + parameterException);
        }
        return Factory.createResource(string, featureMap);
    }

    public static Resource createResource(String string, FeatureMap featureMap) throws ResourceInstantiationException {
        return Factory.createResource(string, featureMap, null, null);
    }

    public static Resource createResource(String string, FeatureMap featureMap, FeatureMap featureMap2) throws ResourceInstantiationException {
        return Factory.createResource(string, featureMap, featureMap2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource createResource(String string, FeatureMap featureMap, FeatureMap featureMap2, String string2) throws ResourceInstantiationException {
        Object object;
        Object object2;
        DataStore dataStore;
        ResourceData resourceData = (ResourceData)reg.get(string);
        if (resourceData == null) {
            throw new ResourceInstantiationException("Couldn't get resource data for " + string + ".\n\n" + "You may need first to load the plugin that contains your resource.\n" + "For example, to create a gate.creole.tokeniser.DefaultTokeniser\n" + "you need first to load the ANNIE plugin.\n\n" + "Go to the menu File->Manage CREOLE plugins or use the method\n" + "Gate.getCreoleRegister().registerDirectories(pluginDirectoryURL).");
        }
        Class<? extends Resource> clazz = null;
        try {
            clazz = resourceData.getResourceClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceInstantiationException("Couldn't get resource class from the resource data:" + Strings.getNl() + classNotFoundException);
        }
        Resource resource = null;
        if (LanguageResource.class.isAssignableFrom(clazz) && (dataStore = (DataStore)featureMap.get("DataStore")) != null) {
            if (dataStore instanceof SerialDataStore && !Serializable.class.isAssignableFrom(clazz)) {
                throw new ResourceInstantiationException("Resource cannot be (de-)serialized: " + clazz.getName());
            }
            Object v = featureMap.get("LRPersistenceId");
            if (v == null) {
                throw new ResourceInstantiationException("No instance id for " + clazz);
            }
            try {
                resource = dataStore.getLr(clazz.getName(), v);
            }
            catch (PersistenceException persistenceException) {
                throw new ResourceInstantiationException("Bad read from DB: " + persistenceException);
            }
            catch (SecurityException securityException) {
                throw new ResourceInstantiationException("Insufficient permissions: " + securityException);
            }
            resourceData.addInstantiation(resource);
            if (featureMap2 != null) {
                if (resource.getFeatures() == null) {
                    resource.setFeatures(Factory.newFeatureMap());
                }
                resource.getFeatures().putAll(featureMap2);
            }
            if (resource.getName() == null) {
                resource.setName(string2 == null ? resourceData.getName() + "_" + Gate.genSym() : string2);
            }
            creoleProxy.fireResourceLoaded(new CreoleEvent(resource, 1));
            return resource;
        }
        try {
            resource = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ResourceInstantiationException("Couldn't create resource instance, access denied: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ResourceInstantiationException("Couldn't create resource instance due to newInstance() failure: " + instantiationException);
        }
        if (!LanguageResource.class.isAssignableFrom(clazz)) {
            if (ProcessingResource.class.isAssignableFrom(clazz)) {
                try {
                    object2 = Factory.newFeatureMap();
                    object2.putAll(resourceData.getParameterList().getRuntimeDefaults());
                    resource.setParameterValues((FeatureMap)object2);
                }
                catch (ParameterException parameterException) {
                    throw new ResourceInstantiationException("Could not set the runtime parameters to their default values for: " + resource.getClass().getName() + " :\n" + parameterException.toString());
                }
            } else if (VisualResource.class.isAssignableFrom(clazz) || Controller.class.isAssignableFrom(clazz)) {
                // empty if block
            }
        }
        try {
            object2 = Factory.newFeatureMap();
            object2.putAll(resourceData.getParameterList().getInitimeDefaults());
            object2.putAll(featureMap);
            resource.setParameterValues((FeatureMap)object2);
        }
        catch (ParameterException parameterException) {
            throw new ResourceInstantiationException("Could not set the init parameters for: " + resource.getClass().getName() + " :\n" + parameterException.toString());
        }
        if (string2 != null && string2.trim().length() > 0) {
            resource.setName(string2);
        } else if (resource.getName() == null) {
            try {
                block52: {
                    try {
                        String string3;
                        object2 = null;
                        if (resource instanceof SimpleDocument) {
                            object2 = ((SimpleDocument)resource).getSourceUrl();
                        } else if (resource instanceof AnnotationSchema) {
                            object2 = ((AnnotationSchema)resource).getXmlFileUrl();
                        } else if (resource.getClass().getName().startsWith("gate.creole.ontology.owlim.")) {
                            object = clazz.getMethod("getRdfXmlURL", new Class[0]);
                            object2 = (URL)((Method)object).invoke((Object)resource, new Object[0]);
                            if (object2 == null) {
                                object = clazz.getMethod("getN3URL", new Class[0]);
                                object2 = (URL)((Method)object).invoke((Object)resource, new Object[0]);
                            }
                            if (object2 == null) {
                                object = clazz.getMethod("getNtriplesURL", new Class[0]);
                                object2 = (URL)((Method)object).invoke((Object)resource, new Object[0]);
                            }
                            if (object2 == null) {
                                object = clazz.getMethod("getTurtleURL", new Class[0]);
                                object2 = (URL)((Method)object).invoke((Object)resource, new Object[0]);
                            }
                        } else if (resource.getClass().getName().startsWith("gate.creole.ontology.impl.")) {
                            object = clazz.getMethod("getSourceURL", new Class[0]);
                            object2 = (URL)((Method)object).invoke((Object)resource, new Object[0]);
                        }
                        if (object2 == null) break block52;
                        object = ((URL)object2).toURI();
                        string2 = ((URI)object).getPath().trim();
                        if (string2 == null || string2.length() == 0 || string2.equals("/")) {
                            string2 = ((URI)object).toString();
                            break block52;
                        }
                        int n = string2.lastIndexOf(47);
                        if (n < 0 || (string3 = string2.substring(n + 1)).trim().length() <= 0) break block52;
                        string2 = string3;
                    }
                    catch (Exception exception) {
                        Object var13_24 = null;
                        if (string2 == null || string2.trim().length() == 0) {
                            string2 = resourceData.getName();
                        }
                    }
                }
                Object var13_23 = null;
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = resourceData.getName();
                }
            }
            catch (Throwable throwable) {
                Object var13_25 = null;
                if (string2 == null || string2.trim().length() == 0) {
                    string2 = resourceData.getName();
                }
                throw throwable;
            }
            string2 = string2 + "_" + Gate.genSym();
            resource.setName(string2);
        }
        object2 = new HashMap<String, EventListener>(Gate.getListeners());
        if (object2 != null && !object2.isEmpty()) {
            try {
                AbstractResource.setResourceListeners(resource, (Map)object2);
            }
            catch (Exception exception) {
                throw new ResourceInstantiationException("Parameterisation failure" + exception);
            }
        }
        if (resource.getFeatures() == null || resource.getFeatures().isEmpty()) {
            object = Factory.newFeatureMap();
            object.putAll(resourceData.getFeatures());
            resource.setFeatures((FeatureMap)object);
        }
        if (featureMap2 != null) {
            resource.getFeatures().putAll(featureMap2);
        }
        resource = resource.init();
        if (object2 != null && !object2.isEmpty()) {
            try {
                AbstractResource.removeResourceListeners(resource, (Map)object2);
            }
            catch (Exception exception) {
                throw new ResourceInstantiationException("Parameterisation failure" + exception);
            }
        }
        resourceData.addInstantiation(resource);
        creoleProxy.fireResourceLoaded(new CreoleEvent(resource, 1));
        return resource;
    }

    public static void deleteResource(Resource resource) {
        ResourceData resourceData = (ResourceData)reg.get(resource.getClass().getName());
        if (resourceData != null && resourceData.removeInstantiation(resource)) {
            creoleProxy.fireResourceUnloaded(new CreoleEvent(resource, 2));
            resource.cleanup();
        }
    }

    public static Corpus newCorpus(String string) throws ResourceInstantiationException {
        return (Corpus)Factory.createResource("gate.corpora.CorpusImpl", Factory.newFeatureMap(), Factory.newFeatureMap(), string);
    }

    public static Document newDocument(URL uRL) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        return (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
    }

    public static Document newDocument(URL uRL, String string) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("sourceUrl", uRL);
        featureMap.put("encoding", string);
        return (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
    }

    public static Document newDocument(String string) throws ResourceInstantiationException {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.put("stringContent", string);
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        document.setSourceUrl(null);
        return document;
    }

    public static AnnotationSet createImmutableAnnotationSet(Document document, Collection<Annotation> collection) {
        return new ImmutableAnnotationSetImpl(document, (Collection)collection){
            private static final long serialVersionUID = -6703131102439043539L;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource duplicate(Resource resource) throws ResourceInstantiationException {
        DuplicationContext duplicationContext = new DuplicationContext();
        try {
            Resource resource2 = Factory.duplicate(resource, duplicationContext);
            Object var4_3 = null;
            duplicationContext.active = false;
            return resource2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            duplicationContext.active = false;
            throw throwable;
        }
    }

    public static Resource duplicate(Resource resource, DuplicationContext duplicationContext) throws ResourceInstantiationException {
        Factory.checkDuplicationContext(duplicationContext);
        if (resource == null) {
            return null;
        }
        if (duplicationContext.knownResources.containsKey(resource)) {
            return duplicationContext.knownResources.get(resource);
        }
        Resource resource2 = null;
        resource2 = resource instanceof CustomDuplication ? ((CustomDuplication)((Object)resource)).duplicate(duplicationContext) : Factory.defaultDuplicate(resource, duplicationContext);
        duplicationContext.knownResources.put(resource, resource2);
        return resource2;
    }

    public static Resource defaultDuplicate(Resource resource, DuplicationContext duplicationContext) throws ResourceInstantiationException {
        Factory.checkDuplicationContext(duplicationContext);
        String string = resource.getClass().getName();
        String string2 = resource.getName();
        FeatureMap featureMap = Factory.duplicate(resource.getFeatures(), duplicationContext);
        ResourceData resourceData = (ResourceData)Gate.getCreoleRegister().get(string);
        if (resourceData == null) {
            throw new ResourceInstantiationException("Could not find CREOLE data for " + string);
        }
        ParameterList parameterList = resourceData.getParameterList();
        FeatureMap featureMap2 = Factory.newFeatureMap();
        for (List<Parameter> object : parameterList.getInitimeParameters()) {
            for (Parameter parameter : object) {
                featureMap2.put(parameter.getName(), resource.getParameterValue(parameter.getName()));
            }
        }
        Resource resource2 = Factory.createResource(string, featureMap2 = Factory.duplicate(featureMap2, duplicationContext), featureMap, string2);
        if (resource2 instanceof ProcessingResource) {
            FeatureMap featureMap3 = Factory.newFeatureMap();
            for (List list : parameterList.getRuntimeParameters()) {
                for (Parameter parameter : list) {
                    featureMap3.put(parameter.getName(), resource.getParameterValue(parameter.getName()));
                }
            }
            FeatureMap featureMap4 = Factory.duplicate(featureMap3, duplicationContext);
            resource2.setParameterValues(featureMap4);
        }
        return resource2;
    }

    public static FeatureMap duplicate(FeatureMap featureMap, DuplicationContext duplicationContext) throws ResourceInstantiationException {
        Factory.checkDuplicationContext(duplicationContext);
        FeatureMap featureMap2 = Factory.newFeatureMap();
        for (Map.Entry entry : featureMap.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Resource) {
                object = Factory.duplicate((Resource)object, duplicationContext);
            }
            featureMap2.put(entry.getKey(), object);
        }
        return featureMap2;
    }

    protected static void checkDuplicationContext(DuplicationContext duplicationContext) {
        if (duplicationContext == null) {
            throw new NullPointerException("No DuplicationContext provided");
        }
        if (!duplicationContext.active) {
            throw new IllegalStateException(new Throwable().getStackTrace()[1].getMethodName() + " helper method called outside an active duplicate call");
        }
    }

    public static Class getJapeParserClass() {
        return japeParserClass;
    }

    public static void setJapeParserClass(Class clazz) {
        if (!ParseCpsl.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Parser class must inherit from " + ParseCpsl.class);
        }
        japeParserClass = clazz;
    }

    public static ParseCpsl newJapeParser(Reader reader, HashMap hashMap) {
        try {
            Constructor constructor = japeParserClass.getConstructor(Reader.class, hashMap.getClass());
            return (ParseCpsl)constructor.newInstance(reader, hashMap);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static ParseCpsl newJapeParser(URL uRL, String string) throws IOException {
        BomStrippingInputStreamReader bomStrippingInputStreamReader = new BomStrippingInputStreamReader(uRL.openStream(), string);
        ParseCpsl parseCpsl = Factory.newJapeParser(bomStrippingInputStreamReader, new HashMap());
        parseCpsl.setBaseURL(uRL);
        parseCpsl.setEncoding(string);
        return parseCpsl;
    }

    public static ConstraintFactory getConstraintFactory() {
        return japeConstraintFactory;
    }

    public static FeatureMap newFeatureMap() {
        return new SimpleFeatureMapImpl();
    }

    public static DataStore openDataStore(String string, String string2) throws PersistenceException {
        DataStore dataStore = Factory.instantiateDataStore(string, string2);
        dataStore.open();
        if (dsReg.add(dataStore)) {
            creoleProxy.fireDatastoreOpened(new CreoleEvent(dataStore, 4));
        }
        return dataStore;
    }

    public static DataStore createDataStore(String string, String string2) throws PersistenceException, UnsupportedOperationException {
        DataStore dataStore = Factory.instantiateDataStore(string, string2);
        dataStore.create();
        dataStore.open();
        if (dsReg.add(dataStore)) {
            creoleProxy.fireDatastoreCreated(new CreoleEvent(dataStore, 3));
        }
        return dataStore;
    }

    protected static DataStore instantiateDataStore(String string, String string2) throws PersistenceException {
        DataStore dataStore = null;
        try {
            dataStore = (DataStore)Gate.getClassLoader().loadClass(string).newInstance();
        }
        catch (Exception exception) {
            throw new PersistenceException("Couldn't create DS class: " + exception);
        }
        if (dsReg == null) {
            dsReg = Gate.getDataStoreRegister();
        }
        dataStore.setStorageUrl(string2.toString());
        return dataStore;
    }

    public static synchronized void addCreoleListener(CreoleListener creoleListener) {
        creoleProxy.addCreoleListener(creoleListener);
    }

    public static synchronized AccessController createAccessController(String string) throws PersistenceException {
        if (!accessControllerPool.containsKey(string)) {
            AccessControllerImpl accessControllerImpl = new AccessControllerImpl(string);
            accessControllerImpl.open();
            accessControllerPool.put(string, accessControllerImpl);
        }
        return (AccessController)accessControllerPool.get(string);
    }

    static {
        japeParserClass = ParseCpsl.class;
        japeConstraintFactory = new ConstraintFactory();
        creoleProxy = new CreoleProxy();
        accessControllerPool = new HashMap();
    }

    public static class DuplicationContext {
        IdentityHashMap<Resource, Resource> knownResources = new IdentityHashMap();
        boolean active = true;

        DuplicationContext() {
        }
    }
}

