/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.gate.vr;

import com.ontotext.gate.vr.ClassNode;
import com.ontotext.gate.vr.MappingTreeView;
import com.ontotext.gate.vr.OntoTreeModel;
import gate.Factory;
import gate.Resource;
import gate.creole.AbstractVisualResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.GazetteerEvent;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.GazetteerListener;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.LinearNode;
import gate.creole.gazetteer.MappingDefinition;
import gate.creole.gazetteer.MappingNode;
import gate.creole.gazetteer.OntoGazetteer;
import gate.creole.ontology.OClass;
import gate.creole.ontology.OResource;
import gate.creole.ontology.Ontology;
import gate.creole.ontology.OntologyModificationListener;
import gate.creole.ontology.OntologyUtilities;
import gate.creole.ontology.RDFProperty;
import gate.event.GateEvent;
import gate.gui.MainFrame;
import gate.swing.XJFileChooser;
import gate.util.Err;
import gate.util.GateRuntimeException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Gaze
extends AbstractVisualResource
implements GazetteerListener,
OntologyModificationListener {
    public static final int SIZE_X = 700;
    public static final int SIZE_Y = 500;
    public static final int POSITION_X = 300;
    public static final int POSITION_Y = 200;
    private static final int LDA_EDIT = 1;
    private static final int LDA_INSERT = 2;
    private static final int LDA_REMOVE = 3;
    private Gazetteer target = null;
    private boolean isOntoGaz = false;
    private LinearDefinition linear = null;
    private LinearNode linearNode = null;
    private GazetteerList gazList = null;
    private Set listSet = null;
    private MappingDefinition mapping = null;
    private MappingNode mappingNode = null;
    private Ontology ontology = null;
    private Map<Ontology, JTree> ontologyTrees = new HashMap<Ontology, JTree>();
    protected JPopupMenu linearPopup = new JPopupMenu();
    protected JMenuItem linearPopupEdit;
    protected JMenuItem linearPopupInsert;
    protected JMenuItem linearPopupRemove;
    protected JMenuBar mainMenu = new JMenuBar();
    protected JMenu fileMenu = new JMenu();
    protected JMenu viewMenu = new JMenu();
    protected JSplitPane baseSplit = new JSplitPane();
    protected JSplitPane mappingSplit = new JSplitPane();
    protected JSplitPane linearSplit = new JSplitPane();
    protected JPanel linearPanel = new JPanel();
    protected JPanel listPanel = new JPanel();
    protected JPanel mappingPanel = new JPanel();
    protected JPanel ontologyPanel = new JPanel();
    protected JLabel linearLabel = new JLabel();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected JScrollPane linearScroll = new JScrollPane();
    protected JToolBar linearBar = new JToolBar();
    protected JButton btnLinearLoad = new JButton();
    protected JList linearList = new JList();
    protected JButton btnLinearSave = new JButton();
    protected JButton btnLinearSaveAs = new JButton();
    protected JLabel listLabel = new JLabel();
    protected GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected JToolBar listBar = new JToolBar();
    protected JButton btnListLoad = new JButton();
    protected JScrollPane listScroll = new JScrollPane();
    protected JButton btnListSave = new JButton();
    protected JButton btnListSaveAs = new JButton();
    protected GridBagLayout gridBagLayout3 = new GridBagLayout();
    protected JLabel mappingLabel = new JLabel();
    protected JToolBar mappingBar = new JToolBar();
    protected JButton btnMappingLoad = new JButton();
    protected JScrollPane mappingScroll = new JScrollPane();
    protected JList mappingList = new JList();
    protected JButton btnMappingSave = new JButton();
    protected JButton btnMappingSaveAs = new JButton();
    protected JLabel ontologyLabel = new JLabel();
    protected JToolBar ontologyBar = new JToolBar();
    protected JButton btnOntologyLoad = new JButton();
    protected JScrollPane ontologyScroll = new JScrollPane();
    protected GridBagLayout gridBagLayout4 = new GridBagLayout();
    protected JMenu menuHelp = new JMenu();
    protected JMenuItem menuAbout = new JMenuItem();
    protected GridBagLayout thisLayout = new GridBagLayout();
    protected JMenu menuLinear = new JMenu();
    protected JMenuItem menuLinearLoad = new JMenuItem();
    protected JMenuItem menuLinearSave = new JMenuItem();
    protected JMenuItem menuLinearSaveAs = new JMenuItem();
    protected JMenu menuList = new JMenu();
    protected JMenuItem menuListLoad = new JMenuItem();
    protected JMenuItem menuListSave = new JMenuItem();
    protected JMenuItem menuListSaveAs = new JMenuItem();
    protected JMenu menuMapping = new JMenu();
    protected JMenuItem menuMappingLoad = new JMenuItem();
    protected JMenuItem menuMappingSave = new JMenuItem();
    protected JMenuItem menuMappingSaveAs = new JMenuItem();
    protected JMenu menuOntology = new JMenu();
    protected JMenuItem menuOntologyLoad = new JMenuItem();
    protected JMenuItem menuRefresh = new JMenuItem();
    protected JTree oTree = new JTree();
    protected JTextArea listArea = new JTextArea();
    protected JButton btnMappingNew = new JButton();
    protected JButton btnLinearNew = new JButton();
    protected JButton btnListNew = new JButton();
    protected JMenuItem menuLinearNew = new JMenuItem();
    protected JMenuItem menuListNew = new JMenuItem();
    protected JMenuItem menuMappingNew = new JMenuItem();
    protected JButton btnListSaveAll = new JButton();
    protected JMenuItem menuListSaveAll = new JMenuItem();

    public Gaze() {
        try {
            this.jbInit();
            this.mainMenu.setMinimumSize(new Dimension(0, 20));
            this.mainMenu.setMaximumSize(new Dimension(0, 20));
            this.mainMenu.setPreferredSize(new Dimension(0, 20));
            this.add((Component)this.mainMenu, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.oTree.setVisible(false);
            this.createLinearListeneres();
            this.createNonLinearListeners();
            this.createLinearDefBtnListeners();
            this.createGazListBtnListeners();
            this.createMappingDefBtnListeners();
            this.linearList.setCellRenderer(new LinearCR());
            this.listArea.getDocument().addDocumentListener(new GazListDL());
            this.linearPopupEdit = new JMenuItem("edit");
            this.linearPopupInsert = new JMenuItem("insert");
            this.linearPopupRemove = new JMenuItem("remove");
            this.linearPopup.add(this.linearPopupEdit);
            this.linearPopup.add(this.linearPopupInsert);
            this.linearPopup.add(this.linearPopupRemove);
            this.linearList.addMouseListener(new LinearPopupListener());
            this.linearPopupEdit.addActionListener(new LinearPopupEditListener());
            this.linearPopupRemove.addActionListener(new LinearPopupRemoveListener());
            this.linearPopupInsert.addActionListener(new LinearPopupInsertListener());
        }
        catch (Exception exception) {
            exception.printStackTrace(Err.getPrintWriter());
        }
    }

    public void setTarget(Object object) {
        if (null == object) {
            throw new GateRuntimeException("should not set null target.");
        }
        if (!(object instanceof Gazetteer)) {
            throw new GateRuntimeException("the target should impelement \ngate.creole.gazetteer.Gazetteer. \ntarget => " + object.getClass());
        }
        this.target = (Gazetteer)object;
        this.target.addGazetteerListener(this);
        this.isOntoGaz = this.target instanceof OntoGazetteer;
        if (!this.isOntoGaz) {
            this.mappingSplit.setVisible(false);
            this.mappingList.setEnabled(false);
        }
        this.displayLinear(this.target);
        if (this.isOntoGaz) {
            this.displayMapping(this.target);
        }
    }

    public Resource init() throws ResourceInstantiationException {
        return this;
    }

    void updateMappingUI() {
        if (null != this.mappingList) {
            this.mappingList.setListData(this.mapping.toArray());
            this.mappingList.updateUI();
        }
    }

    void displayList(String string) {
        Object v = this.linear.getNodesByListNames().get(string);
        GazetteerList gazetteerList = null;
        if (v != null && null != (gazetteerList = (GazetteerList)this.linear.getListsByNode().get(v))) {
            boolean bl;
            if (null != this.listArea && null != this.gazList) {
                this.gazList.setMode(1);
                bl = this.gazList.isModified();
                this.gazList.updateContent(this.listArea.getText());
                this.gazList.setModified(bl);
            }
            this.gazList = gazetteerList;
            if (null != this.gazList) {
                this.gazList.setMode(1);
                bl = this.gazList.isModified();
                this.listArea.setText(this.gazList.toString());
                this.gazList.setModified(bl);
            } else {
                this.listArea.setText("");
            }
        }
    }

    List getLists() {
        return this.linear.getLists();
    }

    List getClasses() {
        ArrayList<Object> arrayList = null;
        arrayList = null == this.ontology ? new ArrayList() : new ArrayList<OClass>(this.ontology.getOClasses(false));
        return arrayList;
    }

    private void displayLinear(Gazetteer gazetteer) {
        this.linear = gazetteer.getLinearDefinition();
        if (null == this.linear) {
            throw new GateRuntimeException("linear definition of a gazetteer should not be null.");
        }
        this.listSet = new HashSet(this.linear.getLists());
        if (null == this.listSet) {
            throw new GateRuntimeException("The set of Gazetteer Lists should not be null.");
        }
        this.linearList.setListData(new Vector(this.linear.getNodes()));
    }

    private void displayMapping(Gazetteer gazetteer) {
        this.mapping = gazetteer.getMappingDefinition();
        if (null == this.mapping) {
            throw new GateRuntimeException("the mapping definition of an onto gazetteer should not be null");
        }
        this.mappingList.setListData(this.mapping.toArray());
        this.listSet.addAll(this.mapping.getLists());
    }

    private void createLinearListeneres() {
        this.linearList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e;
                if (Gaze.this.linearList.getAnchorSelectionIndex() < Gaze.this.linearList.getModel().getSize() && (e = Gaze.this.linearList.getModel().getElementAt(Gaze.this.linearList.getAnchorSelectionIndex())) instanceof LinearNode) {
                    boolean bl;
                    Gaze.this.linearNode = (LinearNode)e;
                    if (null != Gaze.this.listArea && null != Gaze.this.gazList) {
                        GazetteerList gazetteerList = Gaze.this.gazList;
                        Gaze.this.gazList;
                        gazetteerList.setMode(1);
                        bl = Gaze.this.gazList.isModified();
                        Gaze.this.gazList.updateContent(Gaze.this.listArea.getText());
                        Gaze.this.gazList.setModified(bl);
                    }
                    Gaze.this.gazList = (GazetteerList)Gaze.this.linear.getListsByNode().get(Gaze.this.linearNode);
                    if (null != Gaze.this.gazList) {
                        GazetteerList gazetteerList = Gaze.this.gazList;
                        Gaze.this.gazList;
                        gazetteerList.setMode(1);
                        bl = Gaze.this.gazList.isModified();
                        Gaze.this.listArea.setText(Gaze.this.gazList.toString());
                        Gaze.this.gazList.setModified(bl);
                    } else {
                        Gaze.this.listArea.setText("");
                    }
                }
            }
        });
    }

    private void createNonLinearListeners() {
        this.mappingList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e;
                if (0 < Gaze.this.mappingList.getModel().getSize() && (e = Gaze.this.mappingList.getModel().getElementAt(Gaze.this.mappingList.getAnchorSelectionIndex())) instanceof MappingNode) {
                    URL uRL;
                    Gaze.this.mappingNode = (MappingNode)e;
                    try {
                        uRL = new URL(Gaze.this.mappingNode.getOntologyID());
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new GateRuntimeException("Malformed URL:" + Gaze.this.mappingNode.getOntologyID());
                    }
                    try {
                        Gaze.this.ontology = OntologyUtilities.getOntology(uRL);
                        Gaze.this.ontology.addOntologyModificationListener(Gaze.this);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                    }
                    if (null == Gaze.this.ontology) {
                        throw new GateRuntimeException("can not retrieve ontology by url.\nontology is null.\nurl = " + uRL);
                    }
                    if (null != Gaze.this.oTree) {
                        Gaze.this.ontologyScroll.getViewport().remove(Gaze.this.oTree);
                    }
                    Gaze.this.oTree = (JTree)Gaze.this.ontologyTrees.get(Gaze.this.ontology);
                    if (null == Gaze.this.oTree) {
                        HashMap<String, ClassNode> hashMap = new HashMap<String, ClassNode>();
                        ClassNode classNode = ClassNode.createRootNode(Gaze.this.ontology, Gaze.this.mapping, hashMap);
                        OntoTreeModel ontoTreeModel = new OntoTreeModel(classNode);
                        MappingTreeView mappingTreeView = new MappingTreeView(ontoTreeModel, Gaze.this.mapping, Gaze.this);
                        Gaze.this.oTree = mappingTreeView;
                        Gaze.this.ontologyTrees.put(Gaze.this.ontology, Gaze.this.oTree);
                    }
                    Gaze.this.ontologyScroll.getViewport().add((Component)Gaze.this.oTree, null);
                    Gaze.this.oTree.setVisible(true);
                    Gaze.this.displayList(Gaze.this.mappingNode.getList());
                }
            }
        });
    }

    private void createLinearDefBtnListeners() {
        this.btnLinearNew.addActionListener(new LinearNewListener());
        this.menuLinearNew.addActionListener(new LinearNewListener());
        this.btnLinearLoad.addActionListener(new LinearLoadListener());
        this.menuLinearLoad.addActionListener(new LinearLoadListener());
        this.btnLinearSaveAs.addActionListener(new LinearSaveAsListener());
        this.menuLinearSaveAs.addActionListener(new LinearSaveAsListener());
        this.btnLinearSave.addActionListener(new LinearSaveListener());
        this.menuLinearSave.addActionListener(new LinearSaveListener());
    }

    private void createGazListBtnListeners() {
        this.btnListNew.addActionListener(new ListNewListener());
        this.menuListNew.addActionListener(new ListNewListener());
        this.btnListLoad.addActionListener(new ListLoadListener());
        this.menuListLoad.addActionListener(new ListLoadListener());
        this.btnListSaveAs.addActionListener(new ListSaveAsListener());
        this.menuListSaveAs.addActionListener(new ListSaveAsListener());
        this.btnListSave.addActionListener(new ListSaveListener());
        this.menuListSave.addActionListener(new ListSaveListener());
        this.btnListSaveAll.addActionListener(new ListSaveAllListener());
        this.menuListSaveAll.addActionListener(new ListSaveAllListener());
    }

    private void createMappingDefBtnListeners() {
        this.btnMappingNew.addActionListener(new MappingNewListener());
        this.menuMappingNew.addActionListener(new MappingNewListener());
        this.btnMappingLoad.addActionListener(new MappingLoadListener());
        this.menuMappingLoad.addActionListener(new MappingLoadListener());
        this.btnMappingSaveAs.addActionListener(new MappingSaveAsListener());
        this.menuMappingSaveAs.addActionListener(new MappingSaveAsListener());
        this.btnMappingSave.addActionListener(new MappingSaveListener());
        this.menuMappingSave.addActionListener(new MappingSaveListener());
        this.btnOntologyLoad.addActionListener(new OntologyLoadListener());
        this.menuOntologyLoad.addActionListener(new OntologyLoadListener());
    }

    private void performLinearAction(int n, int n2, LinearNode linearNode) {
        switch (n) {
            case 1: {
                Object object = this.linear.get(n2);
                this.linear.remove(n2);
                int n3 = this.linear.size();
                this.linear.add(n2, linearNode);
                if (n3 != this.linear.size()) break;
                JOptionPane.showMessageDialog(this, "The Linear Node can not be added to the Linear Definition \nbecause a node with such a list already exists,\ncannot be opened, or cannot be created if non-existant.\nnode : " + linearNode, "Edit Linear Node Failure", 0);
                this.linear.add(n2, object);
                break;
            }
            case 2: {
                int n4 = this.linear.size();
                if (n2 < 0) {
                    n2 = 0;
                }
                this.linear.add(n2, linearNode);
                if (n4 != this.linear.size()) break;
                JOptionPane.showMessageDialog(this, "The Linear Node can not be added to the Linear Definition \nbecause a node with such a list already exists,\ncannot be opened, or cannot be created if non-existant.\nnode : " + linearNode, "Insert Linear Node Failure", 0);
                break;
            }
            case 3: {
                this.linear.remove(n2);
            }
        }
        this.linearList.setListData(this.linear.toArray());
    }

    private void reinitializeGazetteer() {
        try {
            this.target.setListsURL(this.linear.getURL());
            if (this.isOntoGaz) {
                ((OntoGazetteer)this.target).setMappingURL(this.mapping.getURL());
                Factory.deleteResource(((OntoGazetteer)this.target).getGazetteer());
            }
            this.target = (Gazetteer)this.target.init();
            JOptionPane.showMessageDialog(this, "Gazetteer Reinitialized.", "Reinitialize Gazetteer", 1);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            JOptionPane.showMessageDialog(this, "Gazetteer can not be reinitialized.\ndue to:" + resourceInstantiationException.getClass() + " " + resourceInstantiationException.getMessage(), "Gazsetteer Reinitialize Failure.", 0);
        }
    }

    private void jbInit() throws Exception {
        this.fileMenu.setToolTipText("");
        this.fileMenu.setText("File");
        this.viewMenu.setText("View");
        this.setPreferredSize(new Dimension(600, 300));
        this.setLayout(this.thisLayout);
        this.baseSplit.setPreferredSize(new Dimension(700, 450));
        this.mappingSplit.setOrientation(0);
        this.mappingSplit.setToolTipText("");
        this.linearSplit.setContinuousLayout(true);
        this.linearLabel.setAlignmentY(0.0f);
        this.linearLabel.setToolTipText("");
        this.linearLabel.setHorizontalAlignment(0);
        this.linearLabel.setText("Linear Definition");
        this.linearPanel.setLayout(this.gridBagLayout1);
        this.linearScroll.setPreferredSize(new Dimension(100, 50));
        this.btnLinearLoad.setBorder(BorderFactory.createEtchedBorder());
        this.btnLinearLoad.setToolTipText("Load a linear definition");
        this.btnLinearLoad.setFocusPainted(false);
        this.btnLinearLoad.setMargin(new Insets(2, 2, 2, 2));
        this.btnLinearLoad.setText("Load");
        this.btnLinearSave.setBorder(BorderFactory.createEtchedBorder());
        this.btnLinearSave.setToolTipText("Save the linear definition");
        this.btnLinearSave.setFocusPainted(false);
        this.btnLinearSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnLinearSave.setText("Save");
        this.btnLinearSaveAs.setBorder(BorderFactory.createEtchedBorder());
        this.btnLinearSaveAs.setToolTipText("Save the linear definition changing the location");
        this.btnLinearSaveAs.setFocusPainted(false);
        this.btnLinearSaveAs.setMargin(new Insets(2, 0, 2, 0));
        this.btnLinearSaveAs.setText("Save as...");
        this.listLabel.setAlignmentY(0.0f);
        this.listLabel.setHorizontalAlignment(0);
        this.listLabel.setText("Gazetteer List");
        this.listPanel.setLayout(this.gridBagLayout2);
        this.btnListLoad.setBorder(BorderFactory.createEtchedBorder());
        this.btnListLoad.setToolTipText("Load a gazetteer list");
        this.btnListLoad.setFocusPainted(false);
        this.btnListLoad.setMargin(new Insets(2, 0, 2, 0));
        this.btnListLoad.setText("Load");
        this.listScroll.setAlignmentX(0.0f);
        this.listScroll.setAlignmentY(0.0f);
        this.btnListSave.setBorder(BorderFactory.createEtchedBorder());
        this.btnListSave.setToolTipText("Save the gazetteer list");
        this.btnListSave.setFocusPainted(false);
        this.btnListSave.setMargin(new Insets(2, 0, 2, 0));
        this.btnListSave.setText("Save");
        this.btnListSaveAs.setBorder(BorderFactory.createEtchedBorder());
        this.btnListSaveAs.setToolTipText("Save the gazetteer list to different location");
        this.btnListSaveAs.setFocusPainted(false);
        this.btnListSaveAs.setMargin(new Insets(2, 0, 2, 0));
        this.btnListSaveAs.setText("Save as...");
        this.listBar.setFloatable(false);
        this.mappingPanel.setLayout(this.gridBagLayout3);
        this.mappingLabel.setHorizontalAlignment(0);
        this.mappingLabel.setText("Mapping Definition");
        this.btnMappingLoad.setBorder(BorderFactory.createEtchedBorder());
        this.btnMappingLoad.setToolTipText("Load a mapping definition");
        this.btnMappingLoad.setFocusPainted(false);
        this.btnMappingLoad.setMargin(new Insets(2, 0, 2, 0));
        this.btnMappingLoad.setText("Load");
        this.btnMappingSave.setBorder(BorderFactory.createEtchedBorder());
        this.btnMappingSave.setToolTipText("Save mapping definition");
        this.btnMappingSave.setFocusPainted(false);
        this.btnMappingSave.setMargin(new Insets(2, 0, 2, 0));
        this.btnMappingSave.setText("Save");
        this.btnMappingSaveAs.setBorder(BorderFactory.createEtchedBorder());
        this.btnMappingSaveAs.setToolTipText("Save mapping definition to another location");
        this.btnMappingSaveAs.setFocusPainted(false);
        this.btnMappingSaveAs.setMargin(new Insets(2, 0, 2, 0));
        this.btnMappingSaveAs.setText("Save As...");
        this.ontologyLabel.setHorizontalAlignment(0);
        this.ontologyLabel.setText("Ontology");
        this.btnOntologyLoad.setBorder(BorderFactory.createEtchedBorder());
        this.btnOntologyLoad.setToolTipText("Load an ontology");
        this.btnOntologyLoad.setFocusPainted(false);
        this.btnOntologyLoad.setMargin(new Insets(2, 2, 2, 2));
        this.btnOntologyLoad.setText("Load");
        this.ontologyPanel.setLayout(this.gridBagLayout4);
        this.mappingBar.setFloatable(false);
        this.ontologyBar.setFloatable(false);
        this.linearBar.setFloatable(false);
        this.menuHelp.setText("Help");
        this.menuAbout.setText("About");
        this.menuLinear.setText("Linear Definition");
        this.menuLinearLoad.setText("Load");
        this.menuLinearSave.setText("Save");
        this.menuLinearSaveAs.setText("Save as");
        this.menuList.setText("Gazetteer List");
        this.menuListLoad.setText("Load");
        this.menuListSave.setText("Save");
        this.menuListSaveAs.setText("Save as");
        this.menuMapping.setText("Mapping Definition");
        this.menuMappingLoad.setText("Load");
        this.menuMappingSave.setText("Save");
        this.menuMappingSaveAs.setText("Save as");
        this.menuOntology.setText("Ontology");
        this.menuOntologyLoad.setText("Load");
        this.menuRefresh.setText("Refresh");
        this.mainMenu.setBorder(BorderFactory.createEtchedBorder());
        this.oTree.setToolTipText("");
        this.btnMappingNew.setText("New");
        this.btnMappingNew.setMargin(new Insets(2, 0, 2, 0));
        this.btnMappingNew.setFocusPainted(false);
        this.btnMappingNew.setToolTipText("Create a New Mapping Definition");
        this.btnMappingNew.setBorder(BorderFactory.createEtchedBorder());
        this.btnLinearNew.setText("New");
        this.btnLinearNew.setMargin(new Insets(2, 2, 2, 2));
        this.btnLinearNew.setFocusPainted(false);
        this.btnLinearNew.setToolTipText("Create a New Linear Definition");
        this.btnLinearNew.setBorder(BorderFactory.createEtchedBorder());
        this.btnListNew.setText("New");
        this.btnListNew.setMargin(new Insets(2, 0, 2, 0));
        this.btnListNew.setFocusPainted(false);
        this.btnListNew.setToolTipText("Create a New Gazetteer List");
        this.btnListNew.setBorder(BorderFactory.createEtchedBorder());
        this.menuLinearNew.setText("New");
        this.menuListNew.setText("New");
        this.menuMappingNew.setText("New");
        this.btnListSaveAll.setText("Save All");
        this.btnListSaveAll.setMargin(new Insets(2, 0, 2, 0));
        this.btnListSaveAll.setFocusPainted(false);
        this.btnListSaveAll.setToolTipText("Save all modified gazetteer lists ");
        this.btnListSaveAll.setBorder(BorderFactory.createEtchedBorder());
        this.menuListSaveAll.setToolTipText("Save All Modified Gazetteer Lists");
        this.menuListSaveAll.setText("Save All");
        this.listBar.add((Component)this.btnListNew, null);
        this.linearBar.add((Component)this.btnLinearNew, null);
        this.mainMenu.add(this.fileMenu);
        this.mainMenu.add(this.viewMenu);
        this.mainMenu.add(this.menuHelp);
        this.add((Component)this.baseSplit, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 48, 64));
        this.baseSplit.add((Component)this.mappingSplit, "left");
        this.baseSplit.add((Component)this.linearSplit, "right");
        this.linearSplit.add((Component)this.linearPanel, "top");
        this.linearSplit.add((Component)this.listPanel, "bottom");
        this.listPanel.add((Component)this.listLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mappingSplit.add((Component)this.mappingPanel, "bottom");
        this.mappingSplit.add((Component)this.ontologyPanel, "top");
        this.ontologyPanel.add((Component)this.ontologyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ontologyPanel.add((Component)this.ontologyBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ontologyPanel.add((Component)this.ontologyScroll, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ontologyScroll.getViewport().add((Component)this.oTree, null);
        this.ontologyBar.add((Component)this.btnOntologyLoad, null);
        this.linearPanel.add((Component)this.linearBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.linearBar.add((Component)this.btnLinearLoad, null);
        this.linearBar.add((Component)this.btnLinearSave, null);
        this.linearBar.add((Component)this.btnLinearSaveAs, null);
        this.linearPanel.add((Component)this.linearScroll, new GridBagConstraints(0, 2, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.linearScroll.getViewport().add((Component)this.linearList, null);
        this.linearPanel.add((Component)this.linearLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.listPanel.add((Component)this.listBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.listPanel.add((Component)this.listScroll, new GridBagConstraints(0, 2, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.listScroll.getViewport().add((Component)this.listArea, null);
        this.listBar.add((Component)this.btnListLoad, null);
        this.listBar.add((Component)this.btnListSave, null);
        this.listBar.add((Component)this.btnListSaveAs, null);
        this.listBar.add((Component)this.btnListSaveAll, null);
        this.mappingPanel.add((Component)this.mappingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mappingPanel.add((Component)this.mappingBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mappingPanel.add((Component)this.mappingScroll, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mappingScroll.getViewport().add((Component)this.mappingList, null);
        this.mappingBar.add((Component)this.btnMappingNew, null);
        this.mappingBar.add((Component)this.btnMappingLoad, null);
        this.mappingBar.add((Component)this.btnMappingSave, null);
        this.mappingBar.add((Component)this.btnMappingSaveAs, null);
        this.menuHelp.add(this.menuAbout);
        this.fileMenu.add(this.menuLinear);
        this.fileMenu.add(this.menuList);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.menuMapping);
        this.fileMenu.add(this.menuOntology);
        this.menuLinear.add(this.menuLinearNew);
        this.menuLinear.add(this.menuLinearLoad);
        this.menuLinear.add(this.menuLinearSave);
        this.menuLinear.add(this.menuLinearSaveAs);
        this.menuList.add(this.menuListNew);
        this.menuList.add(this.menuListLoad);
        this.menuList.add(this.menuListSave);
        this.menuList.add(this.menuListSaveAs);
        this.menuList.add(this.menuListSaveAll);
        this.menuMapping.add(this.menuMappingNew);
        this.menuMapping.add(this.menuMappingLoad);
        this.menuMapping.add(this.menuMappingSave);
        this.menuMapping.add(this.menuMappingSaveAs);
        this.menuOntology.add(this.menuOntologyLoad);
        this.viewMenu.add(this.menuRefresh);
        this.mappingSplit.setDividerLocation(200);
        this.linearSplit.setDividerLocation(230);
        this.baseSplit.setDividerLocation(300);
    }

    public void processGazetteerEvent(GazetteerEvent gazetteerEvent) {
        if (1 == gazetteerEvent.getType()) {
            this.displayLinear((Gazetteer)gazetteerEvent.getSource());
            if (this.isOntoGaz) {
                this.displayMapping((Gazetteer)gazetteerEvent.getSource());
                this.ontologyTrees = new HashMap<Ontology, JTree>();
                this.oTree.setVisible(false);
            }
        }
    }

    public void processGateEvent(GateEvent gateEvent) {
    }

    public void resourceAdded(Ontology ontology, OResource oResource) {
        this.ontologyModified(ontology, null, -1);
    }

    public void resourcesRemoved(Ontology ontology, String[] stringArray) {
        this.ontologyModified(ontology, null, -1);
    }

    public void ontologyReset(Ontology ontology) {
        this.ontologyModified(ontology, null, -1);
    }

    public void resourceRelationChanged(Ontology ontology, OResource oResource, OResource oResource2, int n) {
        this.ontologyModified(ontology, oResource, n);
    }

    public void resourcePropertyValueChanged(Ontology ontology, OResource oResource, RDFProperty rDFProperty, Object object, int n) {
        this.ontologyModified(ontology, oResource, n);
    }

    public void ontologyModified(Ontology ontology, OResource oResource, int n) {
        JTree jTree = this.ontologyTrees.get(ontology);
        if (jTree != null) {
            this.ontologyTrees.remove(ontology);
            HashMap<String, ClassNode> hashMap = new HashMap<String, ClassNode>();
            ClassNode classNode = ClassNode.createRootNode(ontology, this.mapping, hashMap);
            OntoTreeModel ontoTreeModel = new OntoTreeModel(classNode);
            MappingTreeView mappingTreeView = new MappingTreeView(ontoTreeModel, this.mapping, this);
            Gaze.synchronizeTreeExpansion(jTree, mappingTreeView);
            if (ontology.equals(ontology)) {
                this.oTree = mappingTreeView;
                this.ontologyScroll.getViewport().add((Component)this.oTree, null);
                this.oTree.setVisible(true);
            }
            this.ontologyTrees.put(ontology, this.oTree);
        }
    }

    public static void synchronizeTreeExpansion(JTree jTree, JTree jTree2) {
        ArrayList<Object> arrayList;
        Object object;
        ArrayList arrayList2;
        int n;
        Object e;
        HashSet<String> hashSet = new HashSet<String>();
        TreeModel treeModel = jTree.getModel();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList arrayList4 = new ArrayList();
        arrayList3.add(treeModel.getRoot());
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        arrayList5.add(treeModel.getRoot());
        arrayList4.add(arrayList5);
        while (arrayList3.size() > 0) {
            e = arrayList3.get(0);
            n = treeModel.getChildCount(e);
            arrayList2 = (ArrayList)arrayList4.get(0);
            for (int i = 0; i < n; ++i) {
                object = treeModel.getChild(e, i);
                arrayList3.add(object);
                arrayList = new ArrayList<Object>(arrayList2);
                arrayList.add(object);
                arrayList4.add(arrayList);
            }
            TreePath treePath = new TreePath(arrayList2.toArray());
            if (jTree.isExpanded(treePath)) {
                hashSet.add(e.toString());
            }
            arrayList3.remove(0);
            arrayList4.remove(0);
        }
        arrayList3 = new ArrayList();
        arrayList4 = new ArrayList();
        treeModel = jTree2.getModel();
        arrayList3.add(treeModel.getRoot());
        arrayList5 = new ArrayList();
        arrayList5.add(treeModel.getRoot());
        arrayList4.add(arrayList5);
        while (arrayList3.size() > 0) {
            e = arrayList3.get(0);
            n = treeModel.getChildCount(e);
            arrayList2 = (ArrayList)arrayList4.get(0);
            for (int i = 0; i < n; ++i) {
                object = treeModel.getChild(e, i);
                arrayList3.add(object);
                arrayList = new ArrayList(arrayList2);
                arrayList.add(object);
                arrayList4.add(arrayList);
            }
            if (hashSet.contains(e.toString())) {
                TreePath treePath = new TreePath(arrayList2.toArray());
                jTree2.expandPath(treePath);
            }
            arrayList3.remove(0);
            arrayList4.remove(0);
        }
    }

    class OntologyLoadListener
    implements ActionListener {
        OntologyLoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = xJFileChooser.showOpenDialog(Gaze.this);
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    try {
                        Gaze.this.ontology = OntologyUtilities.getOntology(uRL);
                        Gaze.this.ontology.addOntologyModificationListener(Gaze.this);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        resourceInstantiationException.printStackTrace(Err.getPrintWriter());
                    }
                    if (null == Gaze.this.ontology) {
                        throw new GateRuntimeException("can not Load ontology by url.\nontology is null.\nurl = " + uRL);
                    }
                    if (null != Gaze.this.oTree) {
                        Gaze.this.ontologyScroll.getViewport().remove(Gaze.this.oTree);
                    }
                    Gaze.this.oTree = (JTree)Gaze.this.ontologyTrees.get(Gaze.this.ontology);
                    if (null == Gaze.this.oTree) {
                        HashMap<String, ClassNode> hashMap = new HashMap<String, ClassNode>();
                        ClassNode classNode = ClassNode.createRootNode(Gaze.this.ontology, Gaze.this.mapping, hashMap);
                        OntoTreeModel ontoTreeModel = new OntoTreeModel(classNode);
                        MappingTreeView mappingTreeView = new MappingTreeView(ontoTreeModel, Gaze.this.mapping, Gaze.this);
                        Gaze.this.oTree = mappingTreeView;
                        Gaze.this.ontologyTrees.put(Gaze.this.ontology, Gaze.this.oTree);
                    }
                    Gaze.this.ontologyScroll.getViewport().add((Component)Gaze.this.oTree, null);
                    Gaze.this.oTree.setVisible(true);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Ontology.\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Ontology Load Failure", 0);
                }
            }
        }
    }

    class MappingSaveListener
    implements ActionListener {
        MappingSaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null == Gaze.this.mapping) {
                JOptionPane.showMessageDialog(Gaze.this, "The Mapping Definition is null and cannot be saved.", "Mapping Definition Save failure.", 0);
            } else {
                try {
                    Gaze.this.mapping.store();
                    JOptionPane.showMessageDialog(Gaze.this, "Mapping Definition saved sucessfuly.", "Mapping Definition Save", -1);
                    Gaze.this.reinitializeGazetteer();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to save the Mapping Definition.\nDue to : " + resourceInstantiationException.getClass() + ":" + resourceInstantiationException.getMessage(), "Mapping Definition Save failure.", 0);
                }
            }
        }
    }

    class MappingSaveAsListener
    implements ActionListener {
        MappingSaveAsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null == Gaze.this.mapping) {
                JOptionPane.showMessageDialog(Gaze.this, "The Mapping Definition is null and cannot be saved.", "Mapping Definition Save As Failure.", 0);
            } else {
                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                xJFileChooser.setFileSelectionMode(2);
                int n = xJFileChooser.showSaveDialog(Gaze.this);
                if (n == 0) {
                    File file = xJFileChooser.getSelectedFile();
                    try {
                        URL uRL = new URL("file:///" + file.getAbsolutePath());
                        Gaze.this.mapping.setURL(uRL);
                        Gaze.this.mapping.store();
                        JOptionPane.showMessageDialog(Gaze.this, "Mapping Definition saved sucessfuly.\n" + uRL, "Mapping Definition Save As", -1);
                        Gaze.this.reinitializeGazetteer();
                    }
                    catch (MalformedURLException malformedURLException) {
                        JOptionPane.showMessageDialog(Gaze.this, "Cannot save Mapping Definition.\nDue to " + malformedURLException.getClass() + ":" + malformedURLException.getMessage(), "Mapping Definition Save As Failure", 0);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        JOptionPane.showMessageDialog(Gaze.this, "Unable to save the Mapping Defintion.\nDue to : " + resourceInstantiationException.getClass() + ":" + resourceInstantiationException.getMessage(), "Mapping Definition Save Failure.", 0);
                    }
                }
            }
        }
    }

    class MappingLoadListener
    implements ActionListener {
        MappingLoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = xJFileChooser.showOpenDialog(Gaze.this);
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    Gaze.this.mapping = new MappingDefinition();
                    Gaze.this.mapping.setURL(uRL);
                    Gaze.this.mapping.load();
                    Gaze.this.mappingList.setListData(Gaze.this.mapping.toArray());
                    Gaze.this.reinitializeGazetteer();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Mapping Definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\nResourceInstantiationException:" + resourceInstantiationException.getMessage(), "Mapping Definition Load Failure", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load linear definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Linear Definition Load Failure", 0);
                }
            }
        }
    }

    class MappingNewListener
    implements ActionListener {
        MappingNewListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = ((JFileChooser)xJFileChooser).showDialog(Gaze.this, "New");
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    if (!file.createNewFile()) {
                        JOptionPane.showMessageDialog(Gaze.this, "Cannot Create Mapping Definition.\n" + file.getAbsolutePath(), "Mapping Definition Create Failure", 0);
                    }
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    Gaze.this.mapping = new MappingDefinition();
                    Gaze.this.mapping.setURL(uRL);
                    Gaze.this.mapping.load();
                    if (null != Gaze.this.oTree) {
                        Gaze.this.ontologyScroll.getViewport().remove(Gaze.this.oTree);
                    }
                    Gaze.this.oTree = new JTree();
                    Gaze.this.ontologyScroll.getViewport().add(Gaze.this.oTree);
                    Gaze.this.oTree.setVisible(false);
                    Gaze.this.oTree.updateUI();
                    Gaze.this.mappingList.setListData(Gaze.this.mapping.toArray());
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Mapping Definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\nResourceInstantiationException:" + resourceInstantiationException.getMessage(), "Mapping Definition Load Failure", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load linear definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Linear Definition Load Failure", 0);
                }
            }
        }
    }

    class LinearNodeInput
    extends JDialog {
        private int action = -1;
        private int position = -1;
        protected JPanel jPanel1 = new JPanel();
        protected JLabel jLabel1 = new JLabel();
        protected JComboBox listCombo = new JComboBox();
        protected JLabel jLabel2 = new JLabel();
        protected JComboBox majorCombo = new JComboBox();
        protected JLabel jLabel3 = new JLabel();
        protected JComboBox minorCombo = new JComboBox();
        protected JLabel jLabel4 = new JLabel();
        protected JComboBox languagesCombo = new JComboBox();
        protected JLabel jLabel5 = new JLabel();
        protected JLabel jLabel6 = new JLabel();
        protected GridBagLayout gridBagLayout1 = new GridBagLayout();
        protected JButton btnOk = new JButton();
        protected JButton btnCancel = new JButton();

        public LinearNodeInput(int n, int n2) {
            try {
                this.action = n;
                this.position = n2;
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public LinearNodeInput(int n, int n2, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
            try {
                this.action = n;
                this.position = n2;
                if (null != vector) {
                    this.listCombo = new JComboBox(vector);
                }
                if (null != vector2) {
                    this.majorCombo = new JComboBox(vector2);
                }
                if (null != vector3) {
                    this.minorCombo = new JComboBox(vector3);
                }
                if (null != vector4) {
                    this.languagesCombo = new JComboBox(vector4);
                }
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public LinearNodeInput(int n, int n2, Vector vector, Vector vector2, Vector vector3, Vector vector4, String string, String string2, String string3, String string4) {
            try {
                this.action = n;
                this.position = n2;
                if (null != vector) {
                    this.listCombo = new JComboBox(vector);
                }
                if (null != vector2) {
                    this.majorCombo = new JComboBox(vector2);
                }
                if (null != vector3) {
                    this.minorCombo = new JComboBox(vector3);
                }
                if (null != vector4) {
                    this.languagesCombo = new JComboBox(vector4);
                }
                if (null != string) {
                    this.listCombo.setSelectedItem(string);
                }
                if (null != string2) {
                    this.majorCombo.setSelectedItem(string2);
                }
                if (null != string3) {
                    this.minorCombo.setSelectedItem(string3);
                } else {
                    this.minorCombo.setSelectedItem("");
                }
                if (null != string4) {
                    this.languagesCombo.setSelectedItem(string4);
                } else {
                    this.languagesCombo.setSelectedItem("");
                }
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.jLabel1.setAlignmentX(0.5f);
            this.jLabel1.setAlignmentY(0.0f);
            this.jLabel1.setText("Gazetteer List*");
            this.jPanel1.setLayout(this.gridBagLayout1);
            this.jLabel2.setText("Major Type*");
            this.jLabel3.setText("Minor Type");
            this.jLabel4.setText("Languages (comma-separated)");
            this.jLabel5.setText("Select, enter or alter the members of the Linear Node");
            this.jLabel6.setToolTipText("");
            this.jLabel6.setText("The members marked with \"*\" are mandatory.");
            this.btnOk.setText("OK");
            this.btnCancel.setText("Cancel");
            this.listCombo.setEditable(true);
            this.majorCombo.setEditable(true);
            this.minorCombo.setEditable(true);
            this.languagesCombo.setEditable(true);
            this.getContentPane().add((Component)this.jPanel1, "Center");
            this.jPanel1.add((Component)this.jLabel5, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 22, 0));
            this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.listCombo, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 60), 0, 0));
            this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.majorCombo, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 60), 0, 0));
            this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 60), 0, 0));
            this.jPanel1.add((Component)this.minorCombo, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 60), 0, 0));
            this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.languagesCombo, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 20, 0, 60), 0, 0));
            this.jPanel1.add((Component)this.jLabel6, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 15, 0), 0, 0));
            this.jPanel1.add((Component)this.btnOk, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 150, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.btnCancel, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 50), 0, 0));
            this.setSize(new Dimension(338, 318));
            this.createListeners();
        }

        private void createListeners() {
            this.btnOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LinearNode linearNode = new LinearNode((String)LinearNodeInput.this.listCombo.getSelectedItem(), (String)LinearNodeInput.this.majorCombo.getSelectedItem(), (String)LinearNodeInput.this.minorCombo.getSelectedItem(), (String)LinearNodeInput.this.languagesCombo.getSelectedItem());
                    if (0 == linearNode.getList().trim().length() || 0 == linearNode.getMajorType().trim().length()) {
                        JOptionPane.showMessageDialog(Gaze.this, "This is not a valid Linear Node.\nList and Major Type are mandatory\nList : " + linearNode.getList() + "\nMajor Type : " + linearNode.getMajorType(), "Invalid Linear Node", 0);
                    } else {
                        Gaze.this.performLinearAction(LinearNodeInput.this.action, LinearNodeInput.this.position, linearNode);
                    }
                    LinearNodeInput.this.dispose();
                }
            });
            this.btnCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LinearNodeInput.this.dispose();
                }
            });
            this.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                }

                public void keyReleased(KeyEvent keyEvent) {
                    if (10 == keyEvent.getKeyCode()) {
                        LinearNode linearNode = new LinearNode((String)LinearNodeInput.this.listCombo.getSelectedItem(), (String)LinearNodeInput.this.majorCombo.getSelectedItem(), (String)LinearNodeInput.this.minorCombo.getSelectedItem(), (String)LinearNodeInput.this.languagesCombo.getSelectedItem());
                        Gaze.this.performLinearAction(LinearNodeInput.this.action, LinearNodeInput.this.position, linearNode);
                        LinearNodeInput.this.dispose();
                    } else if (27 == keyEvent.getKeyCode()) {
                        LinearNodeInput.this.dispose();
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                }
            });
        }
    }

    class LinearPopupRemoveListener
    implements ActionListener {
        LinearPopupRemoveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = Gaze.this.linearList.getSelectedIndices();
            for (int i = nArray.length - 1; i > -1; --i) {
                Gaze.this.linear.remove(nArray[i]);
            }
            Gaze.this.linearList.setListData(Gaze.this.linear.toArray());
        }
    }

    class LinearPopupInsertListener
    implements ActionListener {
        LinearPopupInsertListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector = new Vector(Gaze.this.listSet);
            Vector vector2 = new Vector(Gaze.this.linear.getMajors());
            Vector vector3 = new Vector(Gaze.this.linear.getMinors());
            Vector vector4 = new Vector(Gaze.this.linear.getLanguages());
            Collections.sort(vector);
            Collections.sort(vector2);
            Collections.sort(vector3);
            Collections.sort(vector4);
            LinearNodeInput linearNodeInput = new LinearNodeInput(2, Gaze.this.linearList.getSelectedIndex(), vector, vector2, vector3, vector4);
            linearNodeInput.setTitle("Insert Linear Node");
            linearNodeInput.setLocationRelativeTo(Gaze.this.linearLabel);
            linearNodeInput.setResizable(false);
            linearNodeInput.setVisible(true);
        }
    }

    class LinearPopupEditListener
    implements ActionListener {
        LinearPopupEditListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LinearNode linearNode = (LinearNode)Gaze.this.linearList.getSelectedValue();
            Vector vector = new Vector(Gaze.this.listSet);
            Vector vector2 = new Vector(Gaze.this.linear.getMajors());
            Vector vector3 = new Vector(Gaze.this.linear.getMinors());
            Vector vector4 = new Vector(Gaze.this.linear.getLanguages());
            Collections.sort(vector);
            Collections.sort(vector2);
            Collections.sort(vector3);
            Collections.sort(vector4);
            LinearNodeInput linearNodeInput = new LinearNodeInput(1, Gaze.this.linearList.getSelectedIndex(), vector, vector2, vector3, vector4, linearNode.getList(), linearNode.getMajorType(), linearNode.getMinorType(), linearNode.getLanguage());
            linearNodeInput.setTitle("Edit Linear Node");
            linearNodeInput.setLocationRelativeTo(Gaze.this.linearLabel);
            linearNodeInput.setResizable(false);
            linearNodeInput.setVisible(true);
        }
    }

    class LinearPopupListener
    extends MouseAdapter {
        LinearPopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                Gaze.this.linearPopup.show(Gaze.this.linearList, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class ListSaveAllListener
    implements ActionListener {
        ListSaveAllListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null != Gaze.this.gazList && null != Gaze.this.listArea) {
                boolean bl = Gaze.this.gazList.isModified();
                Gaze.this.gazList.updateContent(Gaze.this.listArea.getText());
                GazetteerList gazetteerList = Gaze.this.gazList;
                Gaze.this.gazList;
                gazetteerList.setMode(0);
                Gaze.this.gazList.setModified(bl);
            }
            GazetteerList gazetteerList = null;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            LinearNode linearNode = null;
            for (int i = 0; i < Gaze.this.linear.size(); ++i) {
                linearNode = (LinearNode)Gaze.this.linear.get(i);
                gazetteerList = (GazetteerList)Gaze.this.linear.getListsByNode().get(linearNode);
                try {
                    if (!gazetteerList.isModified()) continue;
                    bl3 = true;
                    gazetteerList.setMode(0);
                    gazetteerList.store();
                    stringBuffer.append("\nSAVED : " + linearNode.getList());
                    bl2 = false;
                    continue;
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    stringBuffer.append("\nFAILED : ");
                    stringBuffer.append(linearNode.getList());
                    bl = false;
                }
            }
            String string = null;
            string = !bl3 ? "There were no modified Gazetteer Lists to be saved.\n" : (bl2 ? "Not even one modified Gazetteer List was saved.\n" : (bl ? "All Modified Gazetteer Lists saved sucessfuly.\n" : "Some of the Modified Gazetteer Lists were saved sucessfuly.\n"));
            JOptionPane.showMessageDialog(Gaze.this, string + stringBuffer, "Gazetteer List Save All", -1);
            Gaze.this.reinitializeGazetteer();
        }
    }

    class ListSaveListener
    implements ActionListener {
        ListSaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null == Gaze.this.gazList) {
                JOptionPane.showMessageDialog(Gaze.this, "The Gazetteer List is null and cannot be saved.", "Gazetteer List Save failure.", 0);
            } else {
                try {
                    Gaze.this.gazList.updateContent(Gaze.this.listArea.getText());
                    GazetteerList gazetteerList = Gaze.this.gazList;
                    Gaze.this.gazList;
                    gazetteerList.setMode(0);
                    Gaze.this.gazList.store();
                    JOptionPane.showMessageDialog(Gaze.this, "Gazetteer List saved sucessfully.\n" + Gaze.this.gazList.getURL(), "Gazetteer List Save", -1);
                    Gaze.this.reinitializeGazetteer();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to save the Gazetteer List.\nDue to : " + resourceInstantiationException.getClass() + ":" + resourceInstantiationException.getMessage(), "Gazetteer List Save failure.", 0);
                }
            }
        }
    }

    class ListSaveAsListener
    implements ActionListener {
        ListSaveAsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null == Gaze.this.gazList) {
                JOptionPane.showMessageDialog(Gaze.this, "The Gazetteer List is null and cannot be saved.", "Gazetteer List Save failure.", 0);
            } else {
                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                xJFileChooser.setFileSelectionMode(2);
                int n = xJFileChooser.showSaveDialog(Gaze.this);
                if (n == 0) {
                    File file = xJFileChooser.getSelectedFile();
                    try {
                        URL uRL = new URL("file:///" + file.getAbsolutePath());
                        Gaze.this.gazList.setURL(uRL);
                        Gaze.this.gazList.updateContent(Gaze.this.listArea.getText());
                        GazetteerList gazetteerList = Gaze.this.gazList;
                        Gaze.this.gazList;
                        gazetteerList.setMode(0);
                        Gaze.this.gazList.store();
                        JOptionPane.showMessageDialog(Gaze.this, "Gazetteer List saved sucessfuly.\n" + uRL, "Gazetteer List Save As", -1);
                        Gaze.this.reinitializeGazetteer();
                    }
                    catch (MalformedURLException malformedURLException) {
                        JOptionPane.showMessageDialog(Gaze.this, "Cannot save Gazetteer List.\nDue to " + malformedURLException.getClass() + ":" + malformedURLException.getMessage(), "Gazetteer List Save As failure", 0);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        JOptionPane.showMessageDialog(Gaze.this, "Unable to save the Gazetteer List.\nDue to : " + resourceInstantiationException.getClass() + ":" + resourceInstantiationException.getMessage(), "Gazetteer List save failure.", 0);
                    }
                }
            }
        }
    }

    class ListLoadListener
    implements ActionListener {
        ListLoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = xJFileChooser.showOpenDialog(Gaze.this);
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    Gaze.this.gazList = new GazetteerList();
                    Gaze.this.gazList.setURL(uRL);
                    Gaze.this.gazList.load();
                    GazetteerList gazetteerList = Gaze.this.gazList;
                    Gaze.this.gazList;
                    gazetteerList.setMode(1);
                    Gaze.this.listArea.setText(Gaze.this.gazList.toString());
                    Gaze.this.gazList.setModified(false);
                    String string = Gaze.this.gazList.getURL().getFile();
                    int n2 = string.lastIndexOf(47);
                    string = string.substring(n2 + 1);
                    Gaze.this.listSet.add(string);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Gazetteer List (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\nResourceInstantiationException:" + resourceInstantiationException.getMessage(), "Gazetteer List Load Failure", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Gazetteer List (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Gazetteer List Load Failure", 0);
                }
            }
        }
    }

    class ListNewListener
    implements ActionListener {
        ListNewListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = ((JFileChooser)xJFileChooser).showDialog(Gaze.this, "New");
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    if (!file.createNewFile()) {
                        JOptionPane.showMessageDialog(Gaze.this, "Cannot Create Gazetteer List.\n" + file.getAbsolutePath(), "Gazetteer List Create Failure", 0);
                    }
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    Gaze.this.gazList = new GazetteerList();
                    Gaze.this.gazList.setURL(uRL);
                    Gaze.this.gazList.load();
                    GazetteerList gazetteerList = Gaze.this.gazList;
                    Gaze.this.gazList;
                    gazetteerList.setMode(1);
                    Gaze.this.listArea.setText(Gaze.this.gazList.toString());
                    Gaze.this.gazList.setModified(false);
                    String string = Gaze.this.gazList.getURL().getFile();
                    int n2 = string.lastIndexOf(47);
                    string = string.substring(n2 + 1);
                    Gaze.this.listSet.add(string);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Gazetteer List (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\nResourceInstantiationException:" + resourceInstantiationException.getMessage(), "Gazetteer List Load Failure", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load Gazetteer List (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Gazetteer List Load Failure", 0);
                }
            }
        }
    }

    class LinearSaveListener
    implements ActionListener {
        LinearSaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null == Gaze.this.linear) {
                JOptionPane.showMessageDialog(Gaze.this, "The Linear Definition is null and cannot be saved.", "Linear Definition Save failure.", 0);
            } else {
                try {
                    Gaze.this.linear.store();
                    JOptionPane.showMessageDialog(Gaze.this, "Linear Definition saved sucessfuly.\n" + Gaze.this.linear.getURL(), "Linear Definition Save", -1);
                    Gaze.this.reinitializeGazetteer();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to save the Linear Definition.\nDue to : " + resourceInstantiationException.getClass() + ":" + resourceInstantiationException.getMessage(), "Linear Definition Save failure.", 0);
                }
            }
        }
    }

    class LinearSaveAsListener
    implements ActionListener {
        LinearSaveAsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null == Gaze.this.linear) {
                JOptionPane.showMessageDialog(Gaze.this, "The linear definition is null and cannot be saved.", "Linear Definition Save As Failure.", 0);
            } else {
                XJFileChooser xJFileChooser = MainFrame.getFileChooser();
                xJFileChooser.setFileSelectionMode(2);
                int n = xJFileChooser.showSaveDialog(Gaze.this);
                if (n == 0) {
                    File file = xJFileChooser.getSelectedFile();
                    try {
                        URL uRL = new URL("file:///" + file.getAbsolutePath());
                        Gaze.this.linear.setURL(uRL);
                        Gaze.this.linear.store();
                        JOptionPane.showMessageDialog(Gaze.this, "Linear Definition saved sucessfuly.\n" + uRL, "Linear Definition Save As", -1);
                        Gaze.this.reinitializeGazetteer();
                    }
                    catch (MalformedURLException malformedURLException) {
                        JOptionPane.showMessageDialog(Gaze.this, "Cannot save linear definition.\nDue to " + malformedURLException.getClass() + ":" + malformedURLException.getMessage(), "Linear Definition Save As failure", 0);
                    }
                    catch (ResourceInstantiationException resourceInstantiationException) {
                        JOptionPane.showMessageDialog(Gaze.this, "Unable to save the linear defintion.\nDue to : " + resourceInstantiationException.getClass() + ":" + resourceInstantiationException.getMessage(), "Linear Definition Save failure.", 0);
                    }
                }
            }
        }
    }

    class LinearLoadListener
    implements ActionListener {
        LinearLoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = xJFileChooser.showOpenDialog(Gaze.this);
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    Gaze.this.linear = new LinearDefinition();
                    Gaze.this.linear.setURL(uRL);
                    Gaze.this.linear.setEncoding(Gaze.this.target.getEncoding());
                    Gaze.this.linear.load();
                    Gaze.this.listSet = new HashSet(Gaze.this.linear.getLists());
                    if (null == Gaze.this.listSet) {
                        throw new GateRuntimeException("The set of Gazetteer Lists should not be null.");
                    }
                    Gaze.this.linearList.setListData(new Vector(Gaze.this.linear.getNodes()));
                    Gaze.this.reinitializeGazetteer();
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load linear definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\nResourceInstantiationException:" + resourceInstantiationException.getMessage(), "Linear Definition Load Failure", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load linear definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Linear Definition Load Failure", 0);
                }
            }
        }
    }

    class LinearNewListener
    implements ActionListener {
        LinearNewListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJFileChooser xJFileChooser = MainFrame.getFileChooser();
            xJFileChooser.setFileSelectionMode(2);
            int n = ((JFileChooser)xJFileChooser).showDialog(Gaze.this, "New");
            if (n == 0) {
                File file = xJFileChooser.getSelectedFile();
                try {
                    if (!file.createNewFile()) {
                        JOptionPane.showMessageDialog(Gaze.this, "Cannot Create Linear Definition\n" + file.getAbsolutePath(), "Linear Definition Create Failure", 0);
                    }
                    URL uRL = new URL("file:///" + file.getAbsolutePath());
                    Gaze.this.linear = new LinearDefinition();
                    Gaze.this.linear.setURL(uRL);
                    Gaze.this.linear.setEncoding(Gaze.this.target.getEncoding());
                    Gaze.this.linear.load();
                    Gaze.this.listSet = new HashSet(Gaze.this.linear.getLists());
                    if (null == Gaze.this.listSet) {
                        throw new GateRuntimeException("The set of Gazetteer Lists should not be null.");
                    }
                    Gaze.this.linearList.setListData(new Vector(Gaze.this.linear.getNodes()));
                    JOptionPane.showMessageDialog(Gaze.this, "New Linear Definition created successfully \n" + file.getAbsolutePath(), "Create New Linear Definition Successful", 1);
                }
                catch (ResourceInstantiationException resourceInstantiationException) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load linear definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\nResourceInstantiationException:" + resourceInstantiationException.getMessage(), "Linear Definition Load Failure", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Gaze.this, "Unable to load linear definition (corrupted format).\nfile:///" + file.getAbsolutePath() + "\n" + "Due to:\n" + exception.getClass() + ":" + exception.getMessage(), "Linear Definition Load Failure", 0);
                }
            }
        }
    }

    class GazListDL
    implements DocumentListener {
        GazListDL() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Gaze.this.gazList.setModified(true);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Gaze.this.gazList.setModified(true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Gaze.this.gazList.setModified(true);
        }
    }

    class LinearCR
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 3690752878255943737L;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            GazetteerList gazetteerList = (GazetteerList)Gaze.this.linear.getListsByNode().get(object);
            if (null != gazetteerList && gazetteerList.isModified()) {
                this.setBackground(jList.getBackground());
                this.setForeground(Color.red);
            }
            return this;
        }
    }
}

