/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.gate.gazetteer;

import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.AbstractGazetteer;
import gate.creole.gazetteer.GazetteerException;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.GazetteerNode;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.LinearNode;
import gate.creole.gazetteer.Lookup;
import gate.creole.gazetteer.MappingNode;
import gate.util.InvalidOffsetException;
import gate.util.LuckyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashGazetteer
extends AbstractGazetteer {
    private static final long serialVersionUID = -4603155688378104052L;
    private ArrayList<Lookup> categoryList;
    private Map<LinearNode, GazetteerList> listsByNode;
    private Map<String, List<Lookup>>[] mapsList;
    private int mapsListSize;
    private AnnotationSet annotationSet = null;

    @Override
    public Resource init() throws ResourceInstantiationException {
        System.out.println("HashGazetteer is being initialized!");
        if (this.listsURL == null) {
            throw new ResourceInstantiationException("No URL provided for gazetteer creation!");
        }
        try {
            this.mapsList = new HashMap[1000];
            this.definition = new LinearDefinition();
            this.definition.setURL(this.listsURL);
            this.definition.load();
            int n = this.definition.size();
            this.listsByNode = this.definition.loadLists();
            this.mapsListSize = this.mapsList.length;
            this.categoryList = new ArrayList(n + 1);
            Iterator iterator = this.definition.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                LinearNode linearNode = (LinearNode)iterator.next();
                this.fireStatusChanged("Reading " + linearNode.toString());
                this.fireProgressChanged(++n2 * 100 / n);
                this.readList(linearNode);
            }
            this.fireProcessFinished();
        }
        catch (Exception exception) {
            throw new ResourceInstantiationException(exception);
        }
        return this;
    }

    @Override
    public void execute() throws ExecutionException {
        if (this.document == null) {
            throw new ExecutionException("Document is null!");
        }
        this.annotationSet = this.document.getAnnotations(this.annotationSetName);
        String string = this.document.getContent().toString() + " ";
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl5;
            char c = string.charAt(i);
            boolean bl6 = Character.isWhitespace(c);
            if (bl6 && stringBuffer.length() == 0) {
                ++n2;
                bl4 = false;
                bl = false;
                bl2 = false;
                bl3 = false;
                continue;
            }
            if (bl6 && bl && stringBuffer.length() == 1) {
                n2 += 2;
                bl4 = false;
                bl = false;
                bl2 = false;
                bl3 = false;
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            boolean bl7 = Character.isLetter(c);
            boolean bl8 = Character.isDigit(c);
            boolean bl9 = !bl6 && !bl7 && !bl8;
            boolean bl10 = Character.isLowerCase(c);
            if (n3 <= n2 && (bl6 || bl9 || bl4 && !bl10 || !bl3 && bl7)) {
                n3 = i;
            }
            boolean bl11 = bl5 = bl3 && (bl8 || bl9 || bl6) || bl3 && bl7 && bl4 && !bl10 || bl2 && (bl7 || bl9 || bl6) || bl;
            if (i == n - 1) {
                bl5 = true;
            }
            if (bl5) {
                int n6;
                String string3;
                int n7;
                boolean bl12;
                boolean bl13 = bl12 = !bl9 && !bl8;
                if (i == n - 1) {
                    bl12 = true;
                }
                bl12 &= (n7 = (string3 = this.normalizeWhitespace(stringBuffer.toString())).length()) - n5 > 1;
                n5 = n7;
                if (!(n4 == n2 && string3.equals(string2) || (n6 = string3.length()) <= 0)) {
                    boolean bl14 = this.annotate(string3, n2, i, n6);
                    if (bl14) {
                        string2 = string3;
                        n4 = n2;
                    }
                    if (!bl14 && bl12 || n - 1 == i) {
                        if (n3 <= n2) {
                            n3 = i;
                        }
                        n2 = n3;
                        i = n3 - 1;
                        stringBuffer.delete(0, stringBuffer.length());
                        continue;
                    }
                }
            }
            stringBuffer.append(c);
            bl2 = bl8;
            bl3 = bl7;
            bl = bl9;
        }
        this.fireProcessFinished();
        this.fireStatusChanged("Hash Gazetteer processing finished!");
    }

    @Override
    public boolean add(String string, Lookup lookup) {
        String string2;
        if (!this.caseSensitive.booleanValue() && !(string2 = string.toUpperCase()).equals(string)) {
            this.add(string2, lookup);
        }
        if (!(string2 = this.removeTrailingSymbols(string)).equals(string)) {
            this.add(string2, lookup);
        }
        String string3 = string + " ";
        ArrayList<Lookup> arrayList = null;
        int n = 0;
        string3.trim();
        n = string3.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = "";
        Map<Object, Object> map = null;
        for (int i = 0; i < n; ++i) {
            boolean bl4;
            char c = string3.charAt(i);
            boolean bl5 = Character.isWhitespace(c);
            boolean bl6 = Character.isDigit(c);
            boolean bl7 = Character.isLetter(c);
            boolean bl8 = !bl5 && !bl6 && !bl7;
            boolean bl9 = Character.isLowerCase(c);
            boolean bl10 = bl4 = bl && (bl6 || bl8 || bl5) || bl && bl7 && bl3 && !bl9 || bl2 && (bl7 || bl8 || bl5);
            if (i + 1 == n) {
                bl4 = true;
            }
            if (bl4) {
                string4 = this.normalizeWhitespace(string3.substring(0, i));
                int n2 = string4.length();
                if (this.mapsList[n2] == null) {
                    map = new HashMap();
                    this.mapsList[n2] = map;
                } else {
                    map = this.mapsList[n2];
                }
                if (!map.containsKey(string4)) {
                    map.put(string4, null);
                }
            }
            bl2 = bl6;
            bl = bl7;
            bl3 = bl9;
        }
        arrayList = (ArrayList<Lookup>)map.get(string4);
        if (null == arrayList) {
            arrayList = new ArrayList<Lookup>(1);
            arrayList.add(lookup);
        } else if (!arrayList.contains(lookup)) {
            arrayList.add(lookup);
        }
        map.put(string4, arrayList);
        return true;
    }

    @Override
    public Set<Lookup> lookup(String string) {
        Set<Lookup> set = null;
        String string2 = this.normalizeWhitespace(string);
        int n = string2.length();
        if (this.mapsListSize < n) {
            return set;
        }
        HashMap hashMap = (HashMap)this.mapsList[n];
        if (hashMap == null) {
            return set;
        }
        HashSet<Lookup> hashSet = new HashSet<Lookup>((Collection)hashMap.get(string2));
        return hashSet;
    }

    private boolean annotate(String string, int n, int n2, int n3) {
        if (n3 >= this.mapsListSize) {
            return false;
        }
        Map<String, List<Lookup>> map = this.mapsList[n3];
        if (map == null) {
            return false;
        }
        if (!map.containsKey(string)) {
            return false;
        }
        List<Lookup> list = map.get(string);
        if (null != list) {
            for (Lookup lookup : list) {
                FeatureMap featureMap = Factory.newFeatureMap();
                featureMap.put("majorType", lookup.majorType);
                if (null != lookup.oClass && null != lookup.ontology) {
                    featureMap.put("class", lookup.oClass);
                    featureMap.put("ontology", lookup.ontology);
                }
                if (null != lookup.minorType) {
                    featureMap.put("minorType", lookup.minorType);
                    if (null != lookup.languages) {
                        featureMap.put("language", lookup.languages);
                    }
                }
                try {
                    this.annotationSet.add(new Long(n), new Long(n2), "Lookup", featureMap);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    throw new LuckyException(invalidOffsetException.toString());
                }
            }
        }
        return true;
    }

    @Override
    public boolean remove(String string) {
        String string2 = this.a(string, true);
        int n = string2.length();
        if (n > this.mapsListSize) {
            return false;
        }
        Map<String, List<Lookup>> map = this.mapsList[n];
        if (map == null) {
            return false;
        }
        if (map.containsKey(string2)) {
            map.remove(string2);
            return true;
        }
        return false;
    }

    private String removeTrailingSymbols(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || Character.isWhitespace(c)) {
                return string;
            }
            string = string.substring(0, i);
        }
        return string;
    }

    private String normalizeWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        string = string.trim();
        char[] cArray = string.toCharArray();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            boolean bl2 = Character.isWhitespace(c);
            if (bl2 && !bl) {
                stringBuffer.append(' ');
            } else if (!bl2) {
                stringBuffer.append(c);
            }
            bl = bl2;
        }
        return stringBuffer.toString();
    }

    private String a(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        string = string.trim();
        char[] cArray = string.toCharArray();
        int n = string.length();
        if (n <= 1) {
            return string;
        }
        char c = cArray[0];
        stringBuffer.append(c);
        boolean bl3 = true;
        boolean bl4 = Character.isLetter(c);
        boolean bl5 = !Character.isLetterOrDigit(c);
        boolean bl6 = true;
        int n2 = 112;
        for (int i = 1; i < n; ++i) {
            int n3 = cArray[i];
            boolean bl7 = !Character.isLetterOrDigit((char)n3);
            boolean bl8 = Character.isWhitespace((char)n3);
            boolean bl9 = Character.isLetter((char)n3);
            boolean bl10 = Character.isDigit((char)n3);
            if (i > 0 && bl3) {
                if (bl5 && bl8) continue;
                boolean bl11 = bl3 = bl4 && bl7 || bl5 && bl9;
                if (bl7) {
                    if (n2 == 112) {
                        n2 = n3;
                    }
                    bl6 = n2 == n3;
                    bl3 = bl6;
                }
                if (i > 2 && !bl3 && stringBuffer.length() > 0) {
                    char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer.append(Character.toLowerCase(c2));
                }
            }
            if (bl9 || bl10) {
                if (bl && bl9) {
                    bl2 &= Character.isUpperCase((char)n3);
                }
                if (!bl6) {
                    n3 = Character.toLowerCase((char)n3);
                }
                stringBuffer.append((char)n3);
            } else if (!bl3) {
                bl6 = false;
            }
            bl4 = bl9;
            bl5 = bl7;
        }
        String string2 = stringBuffer.toString();
        if (bl && bl2) {
            string2 = string2.toUpperCase();
        }
        return string2;
    }

    private void readList(LinearNode linearNode) throws GazetteerException {
        Object object;
        if (linearNode == null) {
            throw new GazetteerException("LinearNode node is null");
        }
        GazetteerList gazetteerList = this.listsByNode.get(linearNode);
        if (gazetteerList == null) {
            throw new GazetteerException("gazetteer list not found by node");
        }
        String string = linearNode.getList();
        String string2 = linearNode.getMajorType();
        String string3 = linearNode.getMinorType();
        String string4 = linearNode.getLanguage();
        Lookup lookup = new Lookup(string, string2, string3, string4);
        if (this.mappingDefinition != null && null != (object = this.mappingDefinition.getNodeByList(string))) {
            lookup.oClass = ((MappingNode)object).getClassID();
            lookup.ontology = ((MappingNode)object).getOntologyID();
        }
        lookup.list = string;
        this.categoryList.add(lookup);
        object = gazetteerList.iterator();
        String string5 = null;
        while (object.hasNext()) {
            String string6 = ((GazetteerNode)object.next()).toString();
            string6.trim();
            int n = string6.length();
            for (int i = 0; i < n; ++i) {
                if (i + 1 != n && !Character.isWhitespace(string6.charAt(i))) continue;
                if (i + 1 == n) {
                    i = n;
                }
                string5 = string6.substring(0, i).trim();
            }
            this.add(string5, lookup);
        }
    }
}

