/*
 * Decompiled with CFR 0.152.
 */
package gate.xml;

import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.corpora.DocumentContentImpl;
import gate.corpora.RepositioningInfo;
import gate.event.StatusListener;
import gate.util.Err;
import gate.util.GateSaxException;
import gate.util.InvalidOffsetException;
import gate.xml.SimpleErrorHandler;
import gate.xml.XmlPositionCorrectionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlDocumentHandler
extends XmlPositionCorrectionHandler {
    private static final boolean DEBUG = false;
    private RepositioningInfo reposInfo = null;
    private RepositioningInfo ampCodingInfo = null;
    private StringBuffer contentBuffer = new StringBuffer("");
    private boolean readCharacterStatus = false;
    static final int ELEMENTS_RATE = 128;
    private Map markupElementsMap = null;
    private Map element2StringMap = null;
    private SimpleErrorHandler _seh = new SimpleErrorHandler();
    private StringBuffer tmpDocContent = null;
    private Stack stack = null;
    private Document doc = null;
    private AnnotationSet basicAS = null;
    protected List myStatusListeners = new LinkedList();
    private int elements = 0;
    private LinkedList colector = null;
    protected int customObjectsId = 0;

    public void setRepositioningInfo(RepositioningInfo repositioningInfo) {
        this.reposInfo = repositioningInfo;
    }

    public RepositioningInfo getRepositioningInfo() {
        return this.reposInfo;
    }

    public void setAmpCodingInfo(RepositioningInfo repositioningInfo) {
        this.ampCodingInfo = repositioningInfo;
    }

    public RepositioningInfo getAmpCodingInfo() {
        return this.ampCodingInfo;
    }

    public XmlDocumentHandler(Document document, Map map, Map map2) {
        this(document, map, map2, null);
    }

    public XmlDocumentHandler(Document document, Map map, Map map2, AnnotationSet annotationSet) {
        this.stack = new Stack();
        this.tmpDocContent = new StringBuffer(document.getContent().size().intValue());
        this.colector = new LinkedList();
        this.doc = document;
        this.markupElementsMap = map;
        this.element2StringMap = map2;
        this.basicAS = annotationSet;
        this.customObjectsId = 0;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.doc.setContent(new DocumentContentImpl(this.tmpDocContent.toString()));
        this.fireStatusChangedEvent("Total elements: " + this.elements);
        if (this.basicAS == null) {
            this.basicAS = this.doc.getAnnotations("Original markups");
        }
        Collections.sort(this.colector);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (!this.colector.isEmpty()) {
            CustomObject customObject = (CustomObject)this.colector.getFirst();
            if (hashSet.contains(customObject.getId())) {
                throw new GateSaxException("Found two annotations with the same Id(" + customObject.getId() + ").The document is inconsistent.");
            }
            hashSet.add(customObject.getId());
            try {
                if (this.markupElementsMap == null) {
                    this.basicAS.add(customObject.getId(), customObject.getStart(), customObject.getEnd(), customObject.getElemName(), customObject.getFM());
                } else {
                    String string = (String)this.markupElementsMap.get(customObject.getElemName());
                    if (string != null) {
                        this.basicAS.add(customObject.getId(), customObject.getStart(), customObject.getEnd(), string, customObject.getFM());
                    }
                }
            }
            catch (InvalidOffsetException invalidOffsetException) {
                Err.prln("InvalidOffsetException for annot :" + customObject.getElemName() + " with Id =" + customObject.getId() + ". Discarded...");
            }
            this.colector.remove(customObject);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        if (++this.elements % 128 == 0) {
            this.fireStatusChangedEvent("Processed elements : " + this.elements);
        }
        Integer n = null;
        FeatureMap featureMap = Factory.newFeatureMap();
        for (int i = 0; i < attributes.getLength(); ++i) {
            object = attributes.getLocalName(i);
            String string4 = attributes.getValue(i);
            String string5 = attributes.getURI(i);
            if (string5 != null && "http://www.gate.ac.uk".equals(string5)) {
                if ("gateId".equals(object)) {
                    n = new Integer(string4);
                }
                if ("annotMaxId".equals(object)) {
                    this.customObjectsId = new Integer(string4);
                }
                if (!"matches".equals(object)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    arrayList.add(new Integer(string6));
                }
                featureMap.put(object, arrayList);
                continue;
            }
            featureMap.put(attributes.getQName(i), string4);
        }
        Long l = new Long(this.tmpDocContent.length());
        object = new CustomObject(n, string3, featureMap, l, l);
        this.stack.push(object);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.readCharacterStatus) {
            this.readCharacterStatus = false;
            this.charactersAction(new String(this.contentBuffer).toCharArray(), 0, this.contentBuffer.length());
        }
        CustomObject customObject = null;
        if (!this.stack.isEmpty()) {
            customObject = (CustomObject)this.stack.pop();
        }
        if (customObject.getStart().equals(customObject.getEnd())) {
            customObject.getFM().put("isEmptyAndSpan", "true");
        }
        this.colector.add(customObject);
        if (this.element2StringMap != null) {
            String string4 = null;
            string4 = (String)this.element2StringMap.get(string3);
            if (string4 != null) {
                this.tmpDocContent.append(string4);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.readCharacterStatus) {
            this.contentBuffer = new StringBuffer(new String(cArray, n, n2));
        } else {
            this.contentBuffer.append(new String(cArray, n, n2));
        }
        this.readCharacterStatus = true;
    }

    public void charactersAction(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        String string = new String(cArray, n, n2);
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = this.tmpDocContent.length();
        boolean bl = false;
        boolean bl2 = true;
        if (Gate.getUserConfig().get("Document_add_space_on_unpack") != null) {
            bl2 = Gate.getUserConfig().getBoolean("Document_add_space_on_unpack");
        }
        if (n3 != 0 && string.length() != 0 && !Character.isWhitespace(string.charAt(0)) && !Character.isWhitespace(this.tmpDocContent.charAt(n3 - 1)) && (string.length() != 1 || string.charAt(0) != '&' && string.charAt(0) != '<' && string.charAt(0) != '>' && string.charAt(0) != '\"' && string.charAt(0) != '\'') && this.tmpDocContent.charAt(n3 - 1) != '&' && this.tmpDocContent.charAt(n3 - 1) != '<' && this.tmpDocContent.charAt(n3 - 1) != '>' && this.tmpDocContent.charAt(n3 - 1) != '\"' && this.tmpDocContent.charAt(n3 - 1) != '\'' && bl2) {
            stringBuffer.append(" ");
            bl = true;
        }
        if (this.reposInfo != null) {
            if (n != 0 || n2 != 1 || cArray.length > 2) {
                this.reposInfo.addPositionInfo(this.getRealOffset(), string.length(), this.tmpDocContent.length() + stringBuffer.length(), string.length());
            } else {
                Object object;
                long l = 0L;
                if (this.reposInfo.size() > 0) {
                    object = (RepositioningInfo.PositionInfo)this.reposInfo.get(this.reposInfo.size() - 1);
                    l = ((RepositioningInfo.PositionInfo)object).getOriginalPosition();
                }
                for (int i = 0; i < this.ampCodingInfo.size(); ++i) {
                    object = (RepositioningInfo.PositionInfo)this.ampCodingInfo.get(i);
                    if (((RepositioningInfo.PositionInfo)object).getOriginalPosition() <= l) continue;
                    this.reposInfo.addPositionInfo(((RepositioningInfo.PositionInfo)object).getOriginalPosition(), ((RepositioningInfo.PositionInfo)object).getOriginalLength(), this.tmpDocContent.length() + stringBuffer.length(), string.length());
                    break;
                }
            }
        }
        stringBuffer.append(string);
        Long l = new Long(this.tmpDocContent.length() + stringBuffer.length());
        CustomObject customObject2 = null;
        for (CustomObject customObject2 : this.stack) {
            if (bl && customObject2.getStart().equals(customObject2.getEnd())) {
                customObject2.setStart(new Long(customObject2.getStart() + 1L));
            }
            customObject2.setEnd(l);
        }
        this.tmpDocContent.append(stringBuffer.toString());
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (!(this.tmpDocContent.length() == 0 || this.tmpDocContent.charAt(this.tmpDocContent.length() - 1) == '\n' && string.equalsIgnoreCase("\n"))) {
            this.tmpDocContent.append(string);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this._seh.error(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._seh.fatalError(sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._seh.warning(sAXParseException);
    }

    public void comment(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startParsedEntity(String string) throws SAXException {
    }

    public void endParsedEntity(String string, boolean bl) throws SAXException {
    }

    public void addStatusListener(StatusListener statusListener) {
        this.myStatusListeners.add(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.myStatusListeners.remove(statusListener);
    }

    protected void fireStatusChangedEvent(String string) {
        Iterator iterator = this.myStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).statusChanged(string);
        }
    }

    private String getMyLocalName(String string) {
        if (string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() <= 1) {
            return string;
        }
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    private String getMyURI(String string) {
        if (string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() <= 1) {
            return "";
        }
        if ("gate".equalsIgnoreCase(stringTokenizer.nextToken())) {
            return "http://www.gate.ac.uk";
        }
        return "";
    }

    public int getCustomObjectsId() {
        return this.customObjectsId;
    }

    class CustomObject
    implements Comparable {
        private String elemName = null;
        private FeatureMap fm = null;
        private Long start = null;
        private Long end = null;
        private Integer id = null;

        public CustomObject(Integer n, String string, FeatureMap featureMap, Long l, Long l2) {
            this.elemName = string;
            this.fm = featureMap;
            this.start = l;
            this.end = l2;
            if (n == null) {
                this.id = new Integer(XmlDocumentHandler.this.customObjectsId++);
            } else {
                this.id = n;
                if (XmlDocumentHandler.this.customObjectsId <= n) {
                    XmlDocumentHandler.this.customObjectsId = n + 1;
                }
            }
        }

        public int compareTo(Object object) {
            CustomObject customObject = (CustomObject)object;
            return this.id.compareTo(customObject.getId());
        }

        public String getElemName() {
            return this.elemName;
        }

        public FeatureMap getFM() {
            return this.fm;
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.end;
        }

        public Integer getId() {
            return this.id;
        }

        public void setElemName(String string) {
            this.elemName = string;
        }

        public void setFM(FeatureMap featureMap) {
            this.fm = featureMap;
        }

        public void setStart(Long l) {
            this.start = l;
        }

        public void setEnd(Long l) {
            this.end = l;
        }
    }
}

